/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DElement;
import ice.pilots.html4.FramesDivider;
import ice.storm.Viewport;
import java.awt.Container;
import java.util.Vector;

class FramesetInfo {
    int[] colValues;
    int[] colTypes;
    int[] rowValues;
    int[] rowTypes;
    protected static final int HORIZONTAL_ORIENTATION = 2;
    protected static final int VERTICAL_ORIENTATION = 1;
    DElement framesetElem;
    int[] viewportSizes;
    private int orientation;
    FramesetInfo parent;
    private String parentViewportName;
    Vector children;
    Vector framesetDividers;
    private int x;
    private int y;
    private int w;
    private int h;

    private void $init$() {
        this.viewportSizes = null;
        this.children = new Vector();
        this.framesetDividers = new Vector();
    }

    FramesetInfo(DElement framesetElem, int[] colValues, int[] colTypes, int[] rowValues, int[] rowTypes, int orientation) {
        this.$init$();
        this.framesetElem = framesetElem;
        this.colValues = colValues;
        this.colTypes = colTypes;
        this.rowValues = rowValues;
        this.rowTypes = rowTypes;
        this.orientation = orientation;
    }

    void dispose() {
        int i = 0;
        while (i < this.children.size()) {
            Object o = this.children.elementAt(i);
            if (o instanceof FramesetInfo) {
                ((FramesetInfo)o).dispose();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.framesetDividers.size()) {
            Object o = this.framesetDividers.elementAt(i2);
            if (o instanceof FramesDivider) {
                ((FramesDivider)o).dispose();
            }
            ++i2;
        }
    }

    void setParentViewportName(String name) {
        this.parentViewportName = name;
    }

    void upDateSizes(int[] colValues, int[] colTypes, int[] rowValues, int[] rowTypes) {
        if (this.colValues != null && colValues != null && this.rowValues != null && rowValues != null && this.colValues.length == colValues.length && this.rowValues.length == rowValues.length) {
            if (this.framesetDividers != null) {
                int i = 0;
                while (i != this.framesetDividers.size()) {
                    FramesDivider d = (FramesDivider)this.framesetDividers.elementAt(i);
                    d.moved_X = 0;
                    d.moved_Y = 0;
                    ++i;
                }
            }
            this.colValues = colValues;
            this.colTypes = colTypes;
            this.rowValues = rowValues;
            this.rowTypes = rowTypes;
            this.layout();
        }
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int o) {
        this.orientation = o;
    }

    boolean canAddChild() {
        return this.children.size() < this.colValues.length * this.rowValues.length;
    }

    FramesetInfo getParent() {
        return this.parent;
    }

    void addChild(Viewport v, FramesDivider f) {
        this.children.addElement(v);
        this.framesetDividers.addElement(f);
    }

    void addChild(FramesetInfo fi, FramesDivider f) {
        fi.parent = this;
        this.children.addElement(fi);
        this.framesetDividers.addElement(f);
    }

    int dividerMoved(int disiredMove, FramesDivider source) {
        int index = this.framesetDividers.indexOf(source);
        int minSize = 7;
        if (index >= 0) {
            int k = index * 2;
            if (this.orientation == 1) {
                if (disiredMove > this.viewportSizes[k + 3] - minSize) {
                    disiredMove = this.viewportSizes[k + 3] - minSize;
                }
                if (-disiredMove > this.viewportSizes[k + 1] - minSize) {
                    disiredMove = -this.viewportSizes[k + 1] + minSize;
                }
                source.moved_Y += disiredMove;
            } else {
                if (disiredMove > this.viewportSizes[k + 2] - minSize) {
                    disiredMove = this.viewportSizes[k + 2] - minSize;
                }
                if (-disiredMove > this.viewportSizes[k] - minSize) {
                    disiredMove = -this.viewportSizes[k] + minSize;
                }
                source.moved_X += disiredMove;
            }
            this.layout();
        }
        return 1;
    }

    void layout(int new_x, int new_y, int new_w, int new_h) {
        if (this.framesetDividers.size() > 0) {
            FramesDivider fd = (FramesDivider)this.framesetDividers.lastElement();
            fd.x_width = 0;
            fd.y_width = 0;
        }
        int sumDividerX = 0;
        int sumDividerY = 0;
        int i = 0;
        while (i != this.framesetDividers.size()) {
            FramesDivider fd = (FramesDivider)this.framesetDividers.elementAt(i);
            sumDividerX += fd.x_width;
            sumDividerY += fd.y_width;
            ++i;
        }
        if (this.viewportSizes == null) {
            this.viewportSizes = new int[this.children.size() * 2];
        } else {
            int x_ratio = 1000;
            int y_ratio = 1000;
            if (this.w - this.x != 0) {
                x_ratio = (new_w - new_x - sumDividerX) * 1000 / (this.w - this.x);
            }
            if (this.h - this.y != 0) {
                y_ratio = (new_h - new_y - sumDividerY) * 1000 / (this.h - this.y);
            }
            int i2 = 0;
            while (i2 != this.framesetDividers.size()) {
                FramesDivider fd = (FramesDivider)this.framesetDividers.elementAt(i2);
                fd.moved_X = fd.moved_X * x_ratio / 1000;
                fd.moved_Y = fd.moved_Y * y_ratio / 1000;
                ++i2;
            }
        }
        this.x = new_x;
        this.y = new_y;
        this.w = new_w;
        this.h = new_h;
        if (this.orientation == 1) {
            this.h -= sumDividerY;
        } else {
            this.w -= sumDividerX;
        }
        this.layout();
        int k = 0;
        while (k != this.framesetDividers.size()) {
            FramesDivider fd = (FramesDivider)this.framesetDividers.elementAt(k);
            fd.getComponent().invalidate();
            fd.getComponent().repaint();
            ++k;
        }
    }

    void layout() {
        int[] pix_cols = new int[this.colValues.length];
        int[] pix_rows = new int[this.rowValues.length];
        int rest_size = this.w;
        int relCount = 0;
        int percentCount = 0;
        int i = 0;
        while (i < this.colValues.length) {
            if (this.colTypes[i] == 1) {
                percentCount += this.colValues[i];
                pix_cols[i] = 0;
            } else if (this.colTypes[i] == 2) {
                relCount += this.colValues[i];
                pix_cols[i] = 0;
            } else {
                rest_size -= this.colValues[i];
                pix_cols[i] = this.colValues[i];
            }
            ++i;
        }
        if (rest_size > 0 && percentCount > 0) {
            if (percentCount * this.w / 100 > rest_size) {
                i = 0;
                while (i < this.colValues.length) {
                    if (this.colTypes[i] == 1) {
                        pix_cols[i] = rest_size * this.colValues[i] / percentCount;
                        rest_size -= pix_cols[i];
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.colValues.length) {
                    if (this.colTypes[i] == 1) {
                        pix_cols[i] = this.w * this.colValues[i] / 100;
                        rest_size -= pix_cols[i];
                    }
                    ++i;
                }
            }
        }
        if (rest_size > 0 && relCount > 0) {
            i = 0;
            while (i < this.colValues.length) {
                if (this.colTypes[i] == 2) {
                    pix_cols[i] = rest_size * this.colValues[i] / relCount;
                }
                ++i;
            }
        } else if (rest_size != 0 && rest_size != this.w) {
            i = 0;
            while (i < this.colValues.length) {
                int n = i;
                pix_cols[n] = pix_cols[n] + rest_size * pix_cols[i] / (this.w - rest_size);
                ++i;
            }
        }
        rest_size = this.h;
        relCount = 0;
        percentCount = 0;
        i = 0;
        while (i < this.rowValues.length) {
            if (this.rowTypes[i] == 1) {
                percentCount += this.rowValues[i];
                pix_rows[i] = 0;
            } else if (this.rowTypes[i] == 2) {
                relCount += this.rowValues[i];
                pix_rows[i] = 0;
            } else {
                rest_size -= this.rowValues[i];
                pix_rows[i] = this.rowValues[i];
            }
            ++i;
        }
        if (rest_size > 0 && percentCount > 0) {
            if (percentCount * this.h / 100 > rest_size) {
                i = 0;
                while (i < this.rowValues.length) {
                    if (this.rowTypes[i] == 1) {
                        pix_rows[i] = rest_size * this.rowValues[i] / percentCount;
                        rest_size -= pix_rows[i];
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.rowValues.length) {
                    if (this.rowTypes[i] == 1) {
                        pix_rows[i] = this.h * this.rowValues[i] / 100;
                        rest_size -= pix_rows[i];
                    }
                    ++i;
                }
            }
        }
        if (rest_size > 0 && relCount > 0) {
            i = 0;
            while (i < this.rowValues.length) {
                if (this.rowTypes[i] == 2) {
                    pix_rows[i] = rest_size * this.rowValues[i] / relCount;
                }
                ++i;
            }
        } else if (rest_size != 0 && rest_size != this.h) {
            i = 0;
            while (i < this.rowValues.length) {
                int n = i;
                pix_rows[n] = pix_rows[n] + rest_size * pix_rows[i] / (this.h - rest_size);
                ++i;
            }
        }
        int num = this.children.size();
        int col = 0;
        int row = 0;
        int ox = this.x;
        int oy = this.y;
        int k = 0;
        i = 0;
        while (i < num) {
            FramesDivider dividerBefore;
            Object o = this.children.elementAt(i);
            if (i > 0) {
                dividerBefore = (FramesDivider)this.framesetDividers.elementAt(i - 1);
            } else {
                dividerBefore = new FramesDivider(null);
                dividerBefore.setFramesetInfo(this);
            }
            FramesDivider dividerAfter = (FramesDivider)this.framesetDividers.elementAt(i);
            this.viewportSizes[k] = pix_cols[col] - dividerBefore.moved_X + dividerAfter.moved_X;
            this.viewportSizes[k + 1] = pix_rows[row] - dividerBefore.moved_Y + dividerAfter.moved_Y;
            k += 2;
            if (o instanceof Viewport) {
                Viewport v = (Viewport)o;
                v.viewportLayout(ox + dividerBefore.moved_X, oy + dividerBefore.moved_Y, pix_cols[col] - dividerBefore.moved_X + dividerAfter.moved_X, pix_rows[row] - dividerBefore.moved_Y + dividerAfter.moved_Y);
                if (this.orientation == 1) {
                    dividerAfter.getComponent().setBounds(ox, oy + pix_rows[row] + dividerAfter.moved_Y, pix_cols[col], dividerAfter.y_width);
                    oy += dividerAfter.y_width;
                } else {
                    dividerAfter.getComponent().setBounds(ox + pix_cols[col] + dividerAfter.moved_X, oy, dividerAfter.x_width, pix_rows[row]);
                    ox += dividerAfter.x_width;
                }
                while (v.getParent() != null && !v.getName().equals(this.parentViewportName)) {
                    v = v.getParent();
                }
                Container c = v.getContainer();
                if (c != null && !c.isAncestorOf(dividerAfter.getComponent())) {
                    c.add(dividerAfter.getComponent());
                }
            } else if (o instanceof FramesetInfo) {
                Viewport v;
                ((FramesetInfo)o).layout(ox + dividerBefore.moved_X, oy + dividerBefore.moved_Y, pix_cols[col] - dividerBefore.moved_X + dividerAfter.moved_X, pix_rows[row] - dividerBefore.moved_Y + dividerAfter.moved_Y);
                if (this.orientation == 1) {
                    dividerAfter.getComponent().setBounds(ox, oy + pix_rows[row] + dividerAfter.moved_Y, pix_cols[col], dividerAfter.y_width);
                    oy += dividerAfter.y_width;
                } else {
                    dividerAfter.getComponent().setBounds(ox + pix_cols[col] + dividerAfter.moved_X, oy, dividerAfter.x_width, pix_rows[row]);
                    ox += dividerAfter.x_width;
                }
                if (this.children.size() > 0 && (v = this.getViewPort()) != null) {
                    while (v.getParent() != null && !v.getName().equalsIgnoreCase(this.parentViewportName)) {
                        v = v.getParent();
                    }
                    Container c = v.getContainer();
                    if (c != null && !c.isAncestorOf(dividerAfter.getComponent())) {
                        c.add(dividerAfter.getComponent());
                    }
                }
            }
            ox += pix_cols[col];
            if (++col >= pix_cols.length) {
                col = 0;
                ox = this.x;
                oy += pix_rows[row];
                ++row;
            }
            ++i;
        }
    }

    private Viewport getViewPort() {
        FramesetInfo first = null;
        int i = 0;
        while (i != this.children.size()) {
            Object x = this.children.elementAt(i);
            if (x instanceof Viewport) {
                return (Viewport)x;
            }
            if (first == null) {
                first = (FramesetInfo)x;
            }
            ++i;
        }
        return first.getViewPort();
    }
}

