/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

class ImageObjectPainter
implements ObjectPainter,
ImageObserver {
    private ObjectBox box;
    private Image image;
    private Image completedImage;
    private int iwidth;
    private int iheight;
    private boolean flagError;
    private boolean flagDone;
    private int forcedWidth;
    private int forcedHeight;
    private Object imageLockObject;
    private long lastPaintTime;
    private static final long THROTTLE_DELAY = 50L;
    static final int NOTFOUND_WIDTH = 10;
    static final int NOTFOUND_HEIGHT = 10;
    private static boolean doReflow = Defs.sysPropertyBoolean("ice.pilots.html4.doNotReflowOnImages", false) ^ true;

    private void $init$() {
        this.iwidth = -1;
        this.iheight = -1;
        this.flagError = false;
        this.flagDone = false;
        this.forcedWidth = -1;
        this.forcedHeight = -1;
        this.imageLockObject = new Object();
        this.lastPaintTime = System.currentTimeMillis();
    }

    ImageObjectPainter(Image img) {
        this.$init$();
        this.image = img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setImage(Image img) {
        this.image = img;
        Object object = this.imageLockObject;
        synchronized (object) {
            this.completedImage = null;
            boolean flag = ThePilot.prepareImage(img, this);
            if (flag) {
                this.completedImage = img;
            }
        }
        if (this.box != null) {
            this.box.reqRepaint();
        }
    }

    protected Image getImage() {
        return this.image;
    }

    public void dispose() {
    }

    public void setBox(ObjectBox box) {
        this.box = box;
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public void setPainterSize(int w, int h) {
        this.forcedWidth = w;
        this.forcedHeight = h;
    }

    public int getPrefWidth() {
        if (this.image != null && this.iwidth < 0 && this.iwidth != this.image.getWidth(this)) {
            this.iwidth = this.image.getWidth(this);
        }
        if (this.iwidth < 0) {
            return 10;
        }
        return this.iwidth;
    }

    public int getPrefHeight() {
        if (this.image != null && this.iheight < 0) {
            this.iheight = this.image.getHeight(this);
        }
        if (this.iheight < 0) {
            return 10;
        }
        return this.iheight;
    }

    public void setForeground(Color c) {
    }

    public void setBackground(Color c) {
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics g) {
        if (this.image == null || this.flagError) {
            g.setColor(Color.white);
            g.fillRect(0, 0, 9, 9);
            if (this.forcedWidth > 0 && this.forcedHeight > 0) {
                g.setColor(Color.gray);
                g.draw3DRect(0, 0, this.forcedWidth - 1, this.forcedHeight - 1, false);
            }
            g.setColor(Color.red);
            g.drawLine(2, 2, 7, 7);
            g.drawLine(2, 7, 7, 2);
            return;
        }
        if (this.iwidth < 0 && this.iheight < 0) {
            return;
        }
        if (this.forcedWidth == 0 || this.forcedHeight == 0) {
            return;
        }
        Object object = this.imageLockObject;
        synchronized (object) {
            if (this.completedImage != null && this.completedImage != this.image) {
                this.paintImage(g, this.completedImage, null, this.iwidth, this.iheight, this.forcedWidth, this.forcedHeight);
            } else {
                this.paintImage(g, this.image, this, this.iwidth, this.iheight, this.forcedWidth, this.forcedHeight);
            }
        }
    }

    private void paintImage(Graphics g, Image img, ImageObserver observer, int iwidth, int iheight, int forced_width, int forced_height) {
        boolean needsFill = false;
        if (this.box != null) {
            needsFill = this.box.cssLayout.isSelection() && this.box.cssLayout.isInSelection(this.box.getDomNode());
        }
        Color imageColor = null;
        if (needsFill) {
            imageColor = this.box.cssLayout.getImageSelectionColor();
        }
        boolean supportsTranparency = false;
        if (this.box != null) {
            supportsTranparency = this.box.cssLayout.isSupportsTransparency();
        }
        if (forced_width < 0 || forced_height < 0 || forced_width == iwidth && forced_height == iheight) {
            if (imageColor != null && needsFill && !supportsTranparency) {
                g.setXORMode(imageColor);
            }
            g.drawImage(img, 0, 0, observer);
            if (imageColor != null && needsFill && supportsTranparency) {
                g.setColor(imageColor);
                g.fillRect(0, 0, iwidth, iheight);
            }
        } else {
            if (imageColor != null && needsFill && !supportsTranparency) {
                g.setXORMode(imageColor);
            }
            g.drawImage(img, 0, 0, forced_width, forced_height, observer);
            if (imageColor != null && needsFill && supportsTranparency) {
                g.setColor(imageColor);
                g.fillRect(0, 0, forced_width, forced_height);
            }
        }
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {
        block15: {
            try {
                ObjectBox b = this.box;
                if (img != this.image || b == null) {
                    boolean flag;
                    boolean bl = flag = (info & 0xF0) == 0;
                    return bl;
                }
                if ((info & 0xC0) != 0) {
                    this.flagError = true;
                    boolean bl = false;
                    return bl;
                }
                if (!((info & 3) == 0 || this.iwidth >= 0 && this.iheight >= 0 || this.flagDone)) {
                    ((CSSBox)b).invalidate();
                    if (doReflow) {
                        ((CSSBox)b).reqReflow();
                    }
                }
                if ((info & 0x20) != 0) {
                    DNode n = ((CSSBox)b).getDomNode();
                    if (n != null) {
                        n.doc.processEvent(13, n);
                    }
                    if (this.iwidth == -1 || this.iheight == -1) {
                        ((CSSBox)b).invalidate();
                        if (b.cssLayout.doc != null) {
                            b.cssLayout.doc.mutate();
                        }
                        ((CSSBox)b).reqReflow();
                    } else {
                        ((CSSBox)b).reqRepaint();
                    }
                    this.flagDone = true;
                    this.completedImage = this.image;
                }
                if ((info & 0x10) == 0) break block15;
                long dt = System.currentTimeMillis() - this.lastPaintTime;
                if (dt < (long)50) {
                    try {
                        Thread.sleep((long)50 - dt);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.flagDone = true;
                this.completedImage = this.image;
                if (b != null && b.cssLayout != null && b.cssLayout.doImageAnimation) {
                    ((CSSBox)b).reqRepaint();
                }
                this.lastPaintTime = System.currentTimeMillis();
            }
            catch (Exception ex) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        int id = attr.nameId;
        if (id == 102 || id == 119 || id == 45) {
            String url;
            Image img;
            ObjectPool objectPool = elem.getPilot().objectPool;
            String value = attr.getValue();
            if (value != null && (img = objectPool.loadImage(url = elem.doc.resolveUrl(value))) != null) {
                this.setImage(img);
            }
        }
    }

    public int getClientWidth() {
        return this.forcedWidth;
    }

    public int getClientHeight() {
        return this.forcedHeight;
    }
}

