/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;

public class ScrollBox
extends BlockBox {
    private BlockBox block;
    private FloatPainter floatPainter;
    private int scrollX;
    private int scrollY;

    private void $init$() {
        this.floatPainter = new FloatPainter();
    }

    ScrollBox(DElement element, CSSAttribs css, CSSLayout cssLayout, byte dynamic) {
        super(element, css, cssLayout, dynamic);
        this.$init$();
        CSSAttribs a = new CSSAttribs(cssLayout.sdata, css);
        a.display = 41;
        a.stealBackgroundFrom(css);
        this.block = new BlockBox(element, a, cssLayout, dynamic);
        this.block.setParentBox(this);
        if (a.background_image != null) {
            this.block.loadBackgroundImage(cssLayout.doc);
        }
    }

    void dispose() {
        this.block.dispose();
        this.block = null;
        super.dispose();
    }

    CSSBox addChild(CSSBox b) {
        if (b instanceof ObjectBox) {
            super.addChild(b);
        } else {
            this.block = (BlockBox)this.block.addChild(b);
        }
        return this;
    }

    CSSBox getBoxAt(int x, int y, Point rv) {
        CSSBox b = this.block.getBoxAt(x + this.scrollX, y + this.scrollY, rv);
        if (b == null || b == this.block) {
            b = this;
        }
        return b;
    }

    public void setScrollPosition(int sx, int sy) {
        this.scrollX = sx;
        this.scrollY = sy;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    void findAbsolutePosition_int(Point p) {
    }

    void calcMinMaxWidths() {
        this.block.calcMinMaxWidths();
        this.minWidth = this.block.minWidth;
        this.maxWidth = this.block.maxWidth;
    }

    public void paint(Graphics g) {
        ObjectPainter objPainter;
        ObjectBox objBox = this.getObjectBox();
        if (objBox != null && (objPainter = objBox.getObjectPainter()) != null && objPainter instanceof Panel) {
            Panel scrollerPanel = (Panel)((Object)objPainter);
            scrollerPanel.repaint();
        }
    }

    public int getScrollableWidth() {
        return this.block.width;
    }

    public int getScrollableHeight() {
        return this.block.height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void layoutScrollable(int parentContentWidth, int parentContentHeight) {
        this.floatPainter.clear();
        int w = parentContentWidth;
        if (w < this.block.minWidth) {
            w = this.block.minWidth;
        }
        FloatManager m2 = new FloatManager(0, w);
        this.block.layout(w, parentContentHeight, m2);
        this.block.height += m2.skipTill(w);
        CSSBox b = m2.getFirstFloater();
        if (b != null) {
            this.floatPainter.add(b);
        }
    }

    public void paintScrollable(Graphics g) {
        this.block.paint(g);
    }

    public ScrollBox getAncestorScrollBox() {
        CSSBox b = this.parentBox;
        while (b != null) {
            if (b instanceof ScrollBox) {
                return (ScrollBox)b;
            }
            b = b.parentBox;
        }
        return null;
    }

    public ObjectBox getObjectBox() {
        CSSBox b = this.first;
        if (b != null && b instanceof ObjectBox) {
            return (ObjectBox)b;
        }
        return null;
    }
}

