/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.AttributeSelector;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.Names;
import ice.util.alg.CharKit;
import java.util.Vector;

class SimpleSelector {
    private static final int S_PSEUDO_LINK = 1;
    private static final int S_PSEUDO_VISITED = 2;
    private static final int S_PSEUDO_FIRST_LETTER = 4;
    private static final int S_PSEUDO_FIRST_LINE = 8;
    private static final int S_PSEUDO_FIRST_CHILD = 16;
    private static final int S_PSEUDO_LAST_CHILD = 32;
    private static final int S_PSEUDO_IGNORE = 64;
    Names names;
    int elementNameId;
    String idString;
    private Vector attributeSelectors;
    private String universalClassKey;
    private int pseudoCount;
    byte pseudo;
    private boolean isFirstChild;
    private boolean isLastChild;
    private byte special;
    int combinator;

    private void $init$() {
        this.idString = null;
        this.attributeSelectors = new Vector();
        this.pseudoCount = 0;
        this.pseudo = 0;
        this.isFirstChild = false;
        this.isLastChild = false;
        this.special = 0;
        this.combinator = -1;
    }

    SimpleSelector(Names names, int elementNameId) {
        this.$init$();
        this.names = names;
        this.elementNameId = elementNameId;
    }

    void addPseudoSelector(String name) {
        if ((name = CharKit.toLowerCase(name)).equals("hover")) {
            this.pseudo = (byte)(this.pseudo | 1);
        } else if (name.equals("active")) {
            this.pseudo = (byte)(this.pseudo | 2);
        } else if (name.equals("focus")) {
            this.pseudo = (byte)(this.pseudo | 4);
        } else if (name.equals("before")) {
            this.pseudo = (byte)(this.pseudo | 8);
        } else if (name.equals("after")) {
            this.pseudo = (byte)(this.pseudo | 0x10);
        } else if (name.equals("first-child")) {
            this.isFirstChild = true;
        } else if (name.equals("last-child")) {
            this.isLastChild = true;
        } else {
            this.special = name.equals("link") ? (byte)(this.special | 1) : (name.equals("visited") ? (byte)(this.special | 2) : (name.equals("first-letter") ? (byte)(this.special | 4) : (name.equals("first-line") ? (byte)(this.special | 8) : (byte)(this.special | 0x40))));
        }
        ++this.pseudoCount;
    }

    String getUniversalClassKey() {
        return this.universalClassKey;
    }

    void addAttributeSelector(AttributeSelector s) {
        if (this.elementNameId == 0) {
            this.universalClassKey = s.getClassKey();
        }
        this.attributeSelectors.addElement(s);
    }

    void setIDSelector(String idString) {
        this.idString = idString;
    }

    int computeWeight() {
        int w = 0;
        if (this.elementNameId > 0) {
            ++w;
        }
        w += (this.attributeSelectors.size() + this.pseudoCount) * 10;
        if (this.idString != null) {
            w += 100;
        }
        return w;
    }

    boolean match(DElement e) {
        if (this.elementNameId > 0 && this.elementNameId != e.tagId) {
            return false;
        }
        if (this.elementNameId < 0) {
            return false;
        }
        if (this.isFirstChild) {
            DNode n = e.getParentDNode();
            if (n == null) {
                return false;
            }
            n = n.getFirstDChild();
            while (n != null) {
                if (n == e) break;
                if (n instanceof DElement && n.getNameId() != 70) {
                    return false;
                }
                n = n.next;
            }
            if (n != e) {
                return false;
            }
        }
        if (this.isLastChild) {
            DNode p = (DNode)e.getParentNode();
            if (p == null) {
                return false;
            }
            DNode n = (DNode)p.getLastChild();
            while (n != null) {
                if (n == e) break;
                if (n instanceof DElement) {
                    return false;
                }
                n = n.prev;
            }
            if (n != e) {
                return false;
            }
        }
        if (this.special != 0) {
            if ((this.special & 0x40) != 0) {
                return false;
            }
            if ((this.special & 3) == 0) {
                return false;
            }
            if ((this.special & 1) != 0) {
                if (e.tagId != 1) {
                    return false;
                }
                if (e.getAttribute(46) == null) {
                    return false;
                }
                if (!(e instanceof DAnchorElement)) {
                    return false;
                }
                if (((DAnchorElement)e).getVisited()) {
                    return false;
                }
            }
            if ((this.special & 2) != 0) {
                if (!(e instanceof DAnchorElement)) {
                    return false;
                }
                if (!((DAnchorElement)e).getVisited()) {
                    return false;
                }
            }
        }
        if (this.idString != null) {
            String s = e.getId();
            if (s == null) {
                return false;
            }
            if (!DDocument.STRICT) {
                this.idString = CharKit.toLowerCase(this.idString);
                s = CharKit.toLowerCase(s);
            }
            if (!s.equals(this.idString)) {
                return false;
            }
        }
        int i = 0;
        while (i < this.attributeSelectors.size()) {
            AttributeSelector s = (AttributeSelector)this.attributeSelectors.elementAt(i);
            if (!s.match(e)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String tagName = "*";
        if (this.elementNameId > 0) {
            tagName = Names.getTagName(this.elementNameId);
        }
        sb.append(tagName);
        int n = this.attributeSelectors.size();
        int i = 0;
        while (i < n) {
            sb.append(this.attributeSelectors.elementAt(i).toString());
            ++i;
        }
        if (this.idString != null) {
            sb.append("#");
            sb.append(this.idString);
        }
        if ((this.pseudo & 1) != 0) {
            sb.append(":hover");
        }
        if ((this.pseudo & 2) != 0) {
            sb.append(":active");
        }
        if ((this.pseudo & 4) != 0) {
            sb.append(":focus");
        }
        if ((this.pseudo & 8) != 0) {
            sb.append(":before");
        }
        if ((this.pseudo & 0x10) != 0) {
            sb.append(":after");
        }
        if (this.isFirstChild) {
            sb.append(":first-child");
        }
        if (this.isLastChild) {
            sb.append(":last-child");
        }
        if ((this.special & 1) != 0) {
            sb.append(":link");
        }
        if ((this.special & 2) != 0) {
            sb.append(":visited");
        }
        if (this.combinator >= 0) {
            sb.append((char)this.combinator);
        }
        return sb.toString();
    }
}

