/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableColBox;
import ice.pilots.html4.TableRowBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.TextBox;
import ice.util.Defs;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class TableBox
extends CSSBox {
    private BlockBox caption;
    private CSSBox firstRowGroup;
    private CSSBox lastRowGroup;
    private CSSBox firstCol;
    private CSSBox lastCol;
    private TableRowGroupBox anonRowGroup;
    int[] colMinWidth;
    int[] colMaxWidth;
    int[] colWidth;
    int[] colCoord;
    boolean[] colPreset;
    int[] colPercent;
    int percentTotal;
    int numCols;
    int realNumCols;
    boolean childOfBody;

    private void $init$() {
        this.percentTotal = 0;
        this.numCols = 0;
        this.realNumCols = 0;
        this.childOfBody = false;
    }

    TableBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        super(e, css, cssLayout);
        DNode n;
        this.$init$();
        if (e != null && (n = e.getParentDNode()) != null && n.getNameId() == 13) {
            this.childOfBody = true;
        }
    }

    void propagateVisibility(short b, boolean self) {
        boolean propagate;
        boolean bl = propagate = !self || this.setVisibility(b);
        if (propagate) {
            CSSBox bb = this.firstRowGroup;
            while (bb != null) {
                bb.propagateVisibility(b, true);
                bb = bb.next;
            }
        }
    }

    void dispose() {
        if (this.caption != null) {
            this.caption.dispose();
        }
        this.caption = null;
        CSSBox b = this.firstRowGroup;
        while (b != null) {
            CSSBox bn = b.next;
            b.dispose();
            b = bn;
        }
        this.lastRowGroup = null;
        this.firstRowGroup = null;
        this.anonRowGroup = null;
        b = this.firstCol;
        while (b != null) {
            CSSBox bn = b.next;
            b.dispose();
            b = bn;
        }
        this.lastCol = null;
        this.firstCol = null;
        super.dispose();
        this.element = null;
    }

    int getType() {
        return 1;
    }

    CSSBox getFirstChild() {
        return this.firstRowGroup;
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        int x1 = this.css.border_left_width + this.css.padding_left;
        int x2 = this.css.border_right_width + this.css.padding_right;
        x2 = this.width - x1 - x2;
        if (ex >= x1 && ex < x2) {
            if (this.caption != null) {
                CSSBox b = this.caption;
                if (ey >= b.oy && ey < b.oy + b.height && (b = ((CSSBox)b).getBoxAt(ex, ey - b.oy, rv)) != null) {
                    return b;
                }
            }
            CSSBox b = this.firstRowGroup;
            while (b != null) {
                if (ey >= b.oy && ey < b.oy + b.height) {
                    return b.getBoxAt(ex, ey - b.oy, rv);
                }
                b = b.next;
            }
        }
        rv.x = ex;
        rv.y = ey;
        return this;
    }

    DNode getDomNode() {
        return this.element;
    }

    private boolean countCols() {
        int num = 0;
        int realNum = 0;
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        while (group != null) {
            if (group.numUsedCols > num) {
                num = group.numUsedCols;
            }
            if (group.realNumCols > realNum) {
                realNum = group.realNumCols;
            }
            group = (TableRowGroupBox)group.next;
        }
        if (realNum != this.realNumCols) {
            this.realNumCols = realNum;
        }
        if (num != this.numCols) {
            this.numCols = num;
            this.colMinWidth = new int[num];
            this.colMaxWidth = new int[num];
            this.colWidth = new int[num];
            this.colCoord = new int[num];
            this.colPreset = new boolean[num];
            this.colPercent = new int[num];
            return true;
        }
        return false;
    }

    CSSBox getfirstRowGroup() {
        return this.firstRowGroup;
    }

    void calcMinMaxWidths() {
        this.countCols();
        this.maxWidth = 0;
        this.minWidth = 0;
        if (this.caption != null) {
            this.caption.calcMinMaxWidths();
        }
        int i = 0;
        while (i < this.numCols) {
            this.colMaxWidth[i] = 0;
            this.colMinWidth[i] = 0;
            this.colPercent[i] = 0;
            ++i;
        }
        CSSBox b = this.firstRowGroup;
        while (b != null) {
            CSSBox row = ((TableRowGroupBox)b).firstRow;
            while (row != null) {
                ((TableRowBox)row).calcMinMaxWidthsUnspanned();
                row = row.next;
            }
            b = b.next;
        }
        b = this.firstRowGroup;
        while (b != null) {
            CSSBox row = ((TableRowGroupBox)b).firstRow;
            while (row != null) {
                ((TableRowBox)row).calcMinMaxWidthsSpanned();
                row = row.next;
            }
            b = b.next;
        }
        boolean percentageOnly = true;
        boolean emptyCells = false;
        this.percentTotal = 0;
        int i2 = 0;
        while (i2 < this.numCols) {
            this.minWidth += this.colMinWidth[i2];
            this.maxWidth += this.colMaxWidth[i2];
            if (this.colMaxWidth[i2] == 1) {
                emptyCells = true;
            }
            if (this.colPercent[i2] > 0) {
                if (this.colPercent[i2] + this.percentTotal > 100) {
                    this.colPercent[i2] = this.percentTotal == 0 ? 100 : 0;
                }
                this.percentTotal += this.colPercent[i2];
            }
            if (this.colPercent[i2] == 0) {
                percentageOnly = false;
            }
            ++i2;
        }
        if (percentageOnly && this.percentTotal < 100 && this.numCols > 0) {
            int newTotal = 0;
            int i3 = 0;
            while (i3 < this.numCols) {
                if (this.colPercent[i3] > 0) {
                    int percentShare;
                    this.colPercent[i3] = percentShare = this.colPercent[i3] * 100 / this.percentTotal;
                    newTotal += this.colPercent[i3];
                }
                ++i3;
            }
            if (newTotal != 100) {
                int i4 = 0;
                while (i4 < this.numCols) {
                    if (this.colPercent[i4] > 0) {
                        int toAdd = 100 - newTotal;
                        int n = i4;
                        this.colPercent[n] = this.colPercent[n] + toAdd;
                        newTotal += toAdd;
                        break;
                    }
                    ++i4;
                }
            }
            this.percentTotal = newTotal;
        }
        if (percentageOnly && emptyCells) {
            this.maxWidth = 0;
            int i5 = 0;
            while (i5 < this.numCols) {
                if (this.colMaxWidth[i5] > 1) {
                    this.maxWidth = Math.max(100 * this.colMaxWidth[i5] / this.colPercent[i5], this.maxWidth);
                }
                ++i5;
            }
        }
        int t = (this.numCols + 1) * this.css.border_spacing_x;
        this.maxWidth += t;
        this.minWidth += t;
        int presetWidth = 0;
        if (this.css.width != -123456 && (this.css.percentage_flag & 0x100000) == 0) {
            presetWidth = this.css.width;
        }
        if (presetWidth > this.minWidth) {
            if (this.percentTotal > 0) {
                int actualPresetWidth = presetWidth - t;
                int[] newWidths = new int[this.numCols];
                int plainWidth = 0;
                int percentWidth = 0;
                int percentPlainWidth = 0;
                int i6 = 0;
                while (i6 < this.numCols) {
                    newWidths[i6] = 0;
                    if (this.colPercent[i6] > 0) {
                        int actual = actualPresetWidth * this.colPercent[i6] / 100;
                        if (actual >= this.colMinWidth[i6]) {
                            percentWidth += actual;
                            newWidths[i6] = actual;
                        } else {
                            percentPlainWidth += this.colMinWidth[i6];
                        }
                    } else {
                        plainWidth += this.colMinWidth[i6];
                    }
                    ++i6;
                }
                int test = percentWidth + percentPlainWidth + plainWidth - actualPresetWidth;
                if (test > 0) {
                    int i7 = 0;
                    while (test > 0) {
                        if (this.colPercent[i7] > 0 && newWidths[i7] > 0) {
                            int n = i7;
                            newWidths[n] = newWidths[n] - 1;
                            --percentWidth;
                            --test;
                        }
                        if (++i7 < this.numCols) continue;
                        i7 = 0;
                    }
                }
                if (test <= 0) {
                    int leftToShare = actualPresetWidth - percentWidth - percentPlainWidth;
                    int i8 = 0;
                    while (i8 < this.numCols) {
                        if (this.colPercent[i8] > 0) {
                            if (newWidths[i8] == 0) {
                                newWidths[i8] = this.colMinWidth[i8];
                            }
                        } else {
                            newWidths[i8] = plainWidth == 0 ? this.colMinWidth[i8] : leftToShare * this.colMinWidth[i8] / plainWidth;
                        }
                        this.colMaxWidth[i8] = this.colMinWidth[i8] = newWidths[i8];
                        ++i8;
                    }
                } else {
                    int absoluteMinimum = 0;
                    int i9 = 0;
                    while (i9 < this.numCols) {
                        absoluteMinimum += this.colMinWidth[i9];
                        ++i9;
                    }
                    if (absoluteMinimum > actualPresetWidth) {
                        if (Debug.trace) {
                            Debug.trace("WARNING: potential bug, please report this");
                        }
                    } else {
                        int i10 = 0;
                        while (i10 < this.numCols) {
                            newWidths[i10] = this.colMinWidth[i10] * actualPresetWidth / absoluteMinimum;
                            this.colMaxWidth[i10] = this.colMinWidth[i10] = newWidths[i10];
                            ++i10;
                        }
                    }
                }
            } else if (presetWidth >= this.maxWidth) {
                int W = presetWidth - t;
                int D = this.maxWidth - t;
                int i11 = 0;
                while (i11 < this.numCols) {
                    int w = this.colMaxWidth[i11];
                    if (D > 0) {
                        this.colMaxWidth[i11] = w * W / D;
                        this.colMinWidth[i11] = this.colMaxWidth[i11];
                    }
                    W -= this.colMaxWidth[i11];
                    D -= w;
                    ++i11;
                }
            } else {
                int W = presetWidth - this.minWidth;
                int D = this.maxWidth - this.minWidth;
                int i12 = 0;
                while (i12 < this.numCols) {
                    int minWidth = this.colMinWidth[i12];
                    int maxWidth = this.colMaxWidth[i12];
                    if (D > 0) {
                        int n = i12;
                        this.colMinWidth[n] = this.colMinWidth[n] + (maxWidth - minWidth) * W / D;
                        this.colMaxWidth[i12] = this.colMinWidth[i12];
                    }
                    D += -maxWidth + minWidth;
                    W += -this.colMaxWidth[i12] + minWidth;
                    ++i12;
                }
            }
            this.minWidth = this.maxWidth = presetWidth;
        } else if (presetWidth != 0) {
            this.maxWidth = this.minWidth;
            System.arraycopy(this.colMinWidth, 0, this.colMaxWidth, 0, this.numCols);
        }
        t = this.css.border_left_width + this.css.padding_left + this.css.border_right_width + this.css.padding_right;
        this.maxWidth += t;
        this.minWidth += t;
    }

    void layout(int parentContentWidth, int parentContentHeight, FloatManager m) {
        int i;
        if (parentContentWidth < this.minWidth) {
            parentContentWidth = this.minWidth;
        }
        int contentHeight = parentContentHeight;
        int fixedHeight = -1;
        int leftX = this.css.border_left_width + this.css.padding_left;
        int rightX = this.css.border_right_width + this.css.padding_right;
        if ((this.css.percentage_flag & 8) != 0) {
            fixedHeight = contentHeight = parentContentHeight * this.css.height / 100;
        } else if (this.css.height > 0) {
            contentHeight = this.css.height;
            fixedHeight = this.css.height;
        }
        int m1 = 0;
        int m2 = 0;
        if (this.css.width == -123456) {
            if (this.css.margin_left != -123456) {
                m1 = this.css.margin_left;
            }
            if (this.css.margin_right != -123456) {
                m2 = this.css.margin_right;
            }
            this.width = parentContentWidth - m1 - m2;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            if (this.width > this.maxWidth) {
                this.width = this.maxWidth;
            }
        } else if ((this.css.percentage_flag & 0x100000) != 0) {
            if (this.cssLayout.inPrintMode && this.css.width > 100 && Defs.sysPropertyBoolean("ice.pilots.html4.printResizeTables")) {
                this.css.width = 100;
            }
            this.width = leftX + rightX + this.css.width * (parentContentWidth - leftX - rightX) / 100;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            m1 = this.css.margin_left == -123456 || this.css.margin_right == -123456 ? (parentContentWidth - this.width) / 2 : this.css.margin_left;
        } else {
            this.width = this.css.width + leftX + rightX;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            if (this.css.margin_left == -123456 || this.css.margin_right == -123456) {
                if (this.width > parentContentWidth) {
                    m1 = (parentContentWidth - this.width) / 2;
                }
            } else {
                m1 = this.css.margin_left;
            }
        }
        this.ox += m1;
        int topY = this.css.border_top_width + this.css.padding_top;
        int bottomY = this.css.border_bottom_width + this.css.padding_bottom;
        contentHeight -= topY + bottomY;
        int ax = m.getAvailableX();
        int aw = m.getAvailableWidth();
        if (ax > 0) {
            this.ox += ax;
        }
        if (m.hasActiveFloaters() && aw > 0 && aw < this.width) {
            this.width = aw;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
        }
        int prefWidth = this.width;
        int overhead = leftX + rightX + this.css.border_spacing_x * (this.numCols + 1);
        if (prefWidth >= this.maxWidth && this.percentTotal == 0) {
            if (this.css.width == 0 || prefWidth == this.maxWidth) {
                i = 0;
                while (i < this.numCols) {
                    this.colWidth[i] = this.colMaxWidth[i];
                    ++i;
                }
            } else {
                int W = prefWidth - overhead;
                int D = this.maxWidth - overhead;
                i = 0;
                while (i < this.numCols) {
                    if (D <= 0 || this.colPreset[i]) {
                        this.colWidth[i] = this.colMaxWidth[i];
                        W -= this.colWidth[i];
                        D -= this.colWidth[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < this.numCols) {
                    if (D > 0 && !this.colPreset[i]) {
                        this.colWidth[i] = this.colMaxWidth[i] * W / D;
                        W -= this.colWidth[i];
                        D -= this.colMaxWidth[i];
                    }
                    ++i;
                }
            }
        } else if (prefWidth <= this.minWidth) {
            i = 0;
            while (i < this.numCols) {
                this.colWidth[i] = this.colMinWidth[i];
                ++i;
            }
        } else if (this.percentTotal != 0) {
            int tmpMaxWidth = overhead;
            i = 0;
            while (i < this.numCols) {
                if (this.colPercent[i] > 0) {
                    int a = this.colPercent[i] * (prefWidth - overhead) / 100;
                    if (a < this.colMinWidth[i]) {
                        a = this.colMinWidth[i];
                    }
                    tmpMaxWidth += a;
                } else {
                    tmpMaxWidth += this.colMaxWidth[i];
                }
                ++i;
            }
            if (prefWidth >= tmpMaxWidth) {
                int W = prefWidth - overhead;
                int need = 0;
                i = 0;
                while (i < this.numCols) {
                    if (this.colPercent[i] > 0) {
                        int a;
                        int n = a = this.realNumCols == 1 ? prefWidth - overhead : this.colPercent[i] * (prefWidth - overhead) / 100;
                        if (a < this.colMinWidth[i]) {
                            a = this.colMinWidth[i];
                        }
                        this.colWidth[i] = a;
                        W -= a;
                    } else {
                        need += this.colMinWidth[i];
                    }
                    ++i;
                }
                if (need > 0) {
                    i = 0;
                    while (i < this.numCols) {
                        if (this.colPercent[i] == 0) {
                            this.colWidth[i] = this.colMinWidth[i] * W / need;
                        }
                        ++i;
                    }
                }
            } else {
                int colAskedForWidth = 0;
                int colRatioWidth = 0;
                int cdx = 0;
                while (cdx < this.numCols) {
                    if (this.colPercent[cdx] > 0) {
                        int tempI = this.colPercent[cdx] * (prefWidth - overhead) / 100;
                        colAskedForWidth += tempI < this.colMinWidth[cdx] ? this.colMinWidth[cdx] : tempI;
                    } else {
                        colAskedForWidth += this.colMinWidth[cdx];
                        colRatioWidth += this.colMinWidth[cdx];
                    }
                    ++cdx;
                }
                if (colAskedForWidth < prefWidth) {
                    int leftOver = prefWidth - overhead - colAskedForWidth;
                    int cdx2 = 0;
                    while (cdx2 < this.numCols) {
                        if (this.colPercent[cdx2] > 0) {
                            this.colWidth[cdx2] = this.colPercent[cdx2] * prefWidth / 100;
                            if (this.colWidth[cdx2] < this.colMinWidth[cdx2]) {
                                this.colWidth[cdx2] = this.colMinWidth[cdx2];
                            }
                        } else {
                            if (colRatioWidth == 0) {
                                colRatioWidth = this.colMinWidth[cdx2];
                            }
                            float ratio = (float)this.colMinWidth[cdx2] / (float)colRatioWidth;
                            this.colWidth[cdx2] = this.colMinWidth[cdx2] + (int)((float)leftOver * ratio);
                        }
                        ++cdx2;
                    }
                } else {
                    int sumOfColsMins = 0;
                    int cdx3 = 0;
                    while (cdx3 < this.numCols) {
                        if (this.colPercent[cdx3] == 0) {
                            this.colWidth[cdx3] = this.colMinWidth[cdx3];
                        }
                        sumOfColsMins += this.colMinWidth[cdx3];
                        ++cdx3;
                    }
                    boolean minimizeTheRest = false;
                    int cdx4 = 0;
                    while (cdx4 < this.numCols) {
                        int otherColsMins = sumOfColsMins - this.colMinWidth[cdx4];
                        int spaceLeft = prefWidth - overhead - otherColsMins;
                        if (this.colPercent[cdx4] > 0) {
                            int colPref = this.colPercent[cdx4] * prefWidth / 100;
                            if (colPref < this.colMinWidth[cdx4]) {
                                this.colWidth[cdx4] = this.colMinWidth[cdx4];
                            } else if (minimizeTheRest) {
                                this.colWidth[cdx4] = this.colMinWidth[cdx4];
                            } else if (colPref < spaceLeft) {
                                this.colWidth[cdx4] = colPref;
                                spaceLeft -= colPref;
                            } else {
                                this.colWidth[cdx4] = spaceLeft;
                                minimizeTheRest = true;
                            }
                        }
                        ++cdx4;
                    }
                }
            }
        } else {
            int W = prefWidth - this.minWidth;
            int D = this.maxWidth - this.minWidth;
            i = 0;
            while (i < this.numCols) {
                int minWidth = this.colMinWidth[i];
                int maxWidth = this.colMaxWidth[i];
                this.colWidth[i] = D > 0 ? minWidth + (maxWidth - minWidth) * W / D : this.colMinWidth[i];
                D += -maxWidth + minWidth;
                W += -this.colWidth[i] + minWidth;
                ++i;
            }
        }
        int w = leftX + this.css.border_spacing_x;
        i = 0;
        while (i < this.numCols) {
            this.colCoord[i] = w;
            w += this.colWidth[i] + this.css.border_spacing_x;
            ++i;
        }
        w += rightX;
        this.height = topY + this.css.border_spacing_y;
        if (this.caption != null) {
            this.caption.oy = 0;
            this.caption.ox = leftX;
            ((TableCellBox)this.caption).layout(w - leftX - rightX, -1);
            this.height += this.caption.height;
        }
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        while (group != null) {
            group.ox = leftX + this.css.border_spacing_x;
            group.width = this.width - leftX - rightX - 2 * this.css.border_spacing_x;
            group.oy = this.height;
            group.layout(fixedHeight);
            this.height += group.height;
            group = (TableRowGroupBox)group.next;
        }
        if (this.firstRowGroup != null) {
            contentHeight -= this.css.border_spacing_y * (((TableRowGroupBox)this.firstRowGroup).numRows + 1);
        }
        if (fixedHeight > this.height) {
            this.height = fixedHeight;
            this.adjustHeight(contentHeight);
        } else {
            this.height += bottomY + this.css.border_spacing_y;
        }
        m.advance(this.height);
    }

    private void adjustHeight(int aHeight) {
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        if (group != null && group.next == null) {
            group.height = aHeight;
            group.adjustHeight();
        }
    }

    void paint(Graphics g) {
        if ((this.css.misc & 1) != 0) {
            Rectangle r = g.getClipBounds();
            int skipTop = 0;
            if (this.caption != null) {
                skipTop = this.caption.height;
            }
            if (r != null) {
                this.paintBackground(g, r, this.css.border_left_width, this.css.border_top_width, this.width, this.height - skipTop - (this.css.border_top_width + this.css.border_bottom_width), 0);
            }
            this.paintBorders(g, r, 0, skipTop, this.width, this.height - skipTop, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8, this.css.border_right_width > 0 && this.css.border_right_style != 8);
        }
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        while (group != null) {
            group.paint(g);
            group = (TableRowGroupBox)group.next;
        }
        if (this.caption != null) {
            this.cssLayout.outlinePainter.drawBox(g, this.caption, this.caption.ox, this.caption.oy);
        }
    }

    CSSBox addChild(CSSBox b) {
        if (b instanceof TableRowGroupBox) {
            if (this.firstRowGroup == null) {
                this.firstRowGroup = this.lastRowGroup = b;
                b.next = null;
            } else if (this.lastRowGroup.css.display == 50 && b.css.display != 50) {
                if (this.firstRowGroup == this.lastRowGroup) {
                    this.firstRowGroup = b;
                    b.next = this.lastRowGroup;
                } else {
                    CSSBox t = this.firstRowGroup;
                    while (t.next != null) {
                        if (t.next.css.display == 50) break;
                        t = t.next;
                    }
                    b.next = t.next;
                    t.next = b;
                }
            } else {
                this.lastRowGroup.next = b;
                b.next = null;
                this.lastRowGroup = b;
            }
            b.setParentBox(this);
            this.anonRowGroup = null;
        } else if (b instanceof TableColBox) {
            if (this.firstCol == null) {
                this.firstCol = this.lastCol = b;
                b.next = null;
            } else {
                this.lastCol.next = b;
                b.next = null;
                this.lastCol = b;
            }
        } else if (b instanceof BlockBox && b.css.display == 55) {
            this.caption = (BlockBox)b;
            b.setParentBox(this);
        } else {
            if (b instanceof TextBox && ((TextBox)b).isEmpty()) {
                return this;
            }
            TableRowGroupBox rg = this.anonRowGroup;
            if (rg == null) {
                CSSAttribs a = new CSSAttribs(this.cssLayout.sdata, this.css);
                a.display = 48;
                rg = new TableRowGroupBox(null, a, this.cssLayout);
                this.addChild(rg);
                this.anonRowGroup = rg;
            }
            rg.addChild(b);
        }
        return this;
    }

    TableColBox getCellColBox(int col) {
        CSSBox b = this.firstCol;
        while (b != null) {
            TableColBox c = (TableColBox)b;
            if (c.span > col) {
                b = c.firstCol;
                if (b != null) continue;
                return c;
            }
            col -= c.span;
            b = b.next;
        }
        return null;
    }

    public String toString() {
        return "table" + super.toString();
    }

    void findBoundingBox(Rectangle r) {
        Point pp = new Point();
        pp.y = 0;
        pp.x = 0;
        this.findAbsolutePosition(pp);
        r.x = pp.x;
        r.y = pp.y;
        r.width = this.width;
        r.height = this.height;
    }

    int getCount(int aType, Point p) {
        int returnVal = 0;
        CSSBox box = this.firstRowGroup;
        while (box != null) {
            returnVal += box.getCount(aType, p);
            box = box.next;
        }
        return returnVal;
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        CSSBox box = this.firstRowGroup;
        while (box != null) {
            CSSBox returnVal = box.findChildByIndex_r(aType, aIndex, aPoint);
            if (returnVal != null) {
                return returnVal;
            }
            box = box.next;
        }
        return null;
    }
}

