/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableColBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.TextBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class TableRowBox
extends CSSBox {
    CSSBox firstCell;
    CSSBox lastCell;
    int numCells;
    int numCols;
    private TableCellBox anonCell;
    int numCellRows;

    private void $init$() {
        this.numCells = 0;
        this.numCols = 0;
        this.numCellRows = 1;
    }

    TableRowBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        super(e, css, cssLayout);
        this.$init$();
    }

    void propagateVisibility(short b, boolean self) {
        boolean propagate;
        boolean bl = propagate = !self || this.setVisibility(b);
        if (propagate) {
            CSSBox bb = this.firstCell;
            while (bb != null) {
                bb.propagateVisibility(b, true);
                bb = bb.next;
            }
        }
    }

    void adjustHeight(int dh) {
        CSSBox cell = this.firstCell;
        while (cell != null) {
            ((TableCellBox)cell).adjustHeight(dh);
            cell = cell.next;
        }
    }

    void dispose() {
        CSSBox b = this.firstCell;
        while (b != null) {
            CSSBox bn = b.next;
            b.dispose();
            b = bn;
        }
        this.lastCell = null;
        this.firstCell = null;
        this.anonCell = null;
        super.dispose();
        this.element = null;
    }

    CSSBox getFirstChild() {
        return this.firstCell;
    }

    CSSBox getLastChild() {
        return this.lastCell;
    }

    void findAbsolutePosition(Point p) {
        p.y += this.oy;
        this.parentBox.findAbsolutePosition(p);
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        CSSBox b = this.firstCell;
        while (b != null) {
            if (ex >= b.ox && ex < b.ox + b.width && ey >= b.oy && ey < b.oy + b.height) {
                return b.getBoxAt(ex - b.ox, ey, rv);
            }
            b = b.next;
        }
        rv.x = ex;
        rv.y = ey;
        return this;
    }

    DNode getDomNode() {
        return this.element;
    }

    void calcMinMaxWidthsUnspanned() {
        TableBox tableBox = (TableBox)this.parentBox.parentBox;
        int col = 0;
        int[] colMinWidth = tableBox.colMinWidth;
        int[] colMaxWidth = tableBox.colMaxWidth;
        boolean[] colPreset = tableBox.colPreset;
        int[] colPercent = tableBox.colPercent;
        TableCellBox cell = (TableCellBox)this.firstCell;
        while (cell != null) {
            if (cell.colspan <= 1) {
                cell.calcMinMaxWidths();
                col = cell.col;
                if (cell.maxWidth > colMaxWidth[col]) {
                    colMaxWidth[col] = cell.maxWidth;
                }
                if (cell.minWidth > colMinWidth[col]) {
                    colMinWidth[col] = cell.minWidth;
                }
                if (cell.css.width != -123456) {
                    if ((cell.css.percentage_flag & 0x100000) == 0) {
                        if (cell.css.width > 0) {
                            colPreset[col] = true;
                        }
                    } else if (cell.css.width > colPercent[col]) {
                        colPercent[col] = cell.css.width;
                    }
                } else {
                    TableColBox b = cell.cellColBox;
                    if (b != null && b.css.width != -123456 && (b.css.percentage_flag & 0x100000) != 0) {
                        colPercent[col] = b.css.width;
                    }
                }
            }
            cell = (TableCellBox)cell.next;
        }
    }

    void calcMinMaxWidthsSpanned() {
        TableBox tableBox = (TableBox)this.parentBox.parentBox;
        int[] colMinWidth = tableBox.colMinWidth;
        int[] colMaxWidth = tableBox.colMaxWidth;
        TableCellBox cell = (TableCellBox)this.firstCell;
        while (cell != null) {
            if (cell.colspan != 1) {
                cell.calcMinMaxWidths();
                int overhead = tableBox.css.border_spacing_x * (cell.colspan - 1);
                int thisCellsMinWidth = cell.minWidth - overhead;
                int thisCellsMaxWidth = cell.maxWidth - overhead;
                int curMinWidth = 0;
                int curMaxWidth = 0;
                boolean completelyConstrained = true;
                boolean completelyAllocated = false;
                int sumOfNonconstrainedWidths = 0;
                int j = 0;
                while (j < cell.colspan) {
                    curMinWidth += colMinWidth[cell.col + j];
                    curMaxWidth += colMaxWidth[cell.col + j];
                    if (tableBox.colPercent[j] == 0) {
                        completelyConstrained = false;
                        sumOfNonconstrainedWidths += colMinWidth[j];
                    } else if (tableBox.colPercent[j] == 100) {
                        completelyAllocated = true;
                    }
                    ++j;
                }
                if (curMinWidth < thisCellsMinWidth) {
                    if (curMinWidth > 0) {
                        if (curMaxWidth >= thisCellsMinWidth) {
                            int W = thisCellsMinWidth - curMinWidth;
                            int D = curMaxWidth - curMinWidth;
                            j = 0;
                            while (j < cell.colspan) {
                                int a = colMinWidth[cell.col + j];
                                int b = colMaxWidth[cell.col + j];
                                if (D > 0) {
                                    int n = cell.col + j;
                                    colMinWidth[n] = colMinWidth[n] + (b - a) * W / D;
                                }
                                D += -b + a;
                                W += -colMinWidth[cell.col + j] + a;
                                ++j;
                            }
                        } else {
                            int toGrant = thisCellsMinWidth - curMinWidth;
                            if (completelyConstrained) {
                                j = 0;
                                while (j < cell.colspan) {
                                    colMinWidth[cell.col + j] = colMaxWidth[cell.col + j] * thisCellsMinWidth / curMaxWidth;
                                    ++j;
                                }
                            } else if (completelyAllocated) {
                                j = 0;
                                while (j < cell.colspan) {
                                    if (tableBox.colPercent[j] == 100) {
                                        int n = cell.col + j;
                                        colMinWidth[n] = colMinWidth[n] + toGrant;
                                    }
                                    ++j;
                                }
                            } else {
                                sumOfNonconstrainedWidths = sumOfNonconstrainedWidths == 0 ? 1 : sumOfNonconstrainedWidths;
                                j = 0;
                                while (j < cell.colspan) {
                                    if (tableBox.colPercent[j] == 0) {
                                        int n = cell.col + j;
                                        colMinWidth[n] = colMinWidth[n] + toGrant * colMinWidth[j] / sumOfNonconstrainedWidths;
                                    }
                                    ++j;
                                }
                            }
                        }
                    } else {
                        thisCellsMinWidth /= cell.colspan;
                        j = 0;
                        while (j < cell.colspan) {
                            colMinWidth[cell.col + j] = thisCellsMinWidth;
                            ++j;
                        }
                    }
                }
                if (curMaxWidth < thisCellsMaxWidth) {
                    if (curMaxWidth > 0) {
                        j = 0;
                        while (j < cell.colspan) {
                            int n = cell.col + j;
                            colMaxWidth[n] = colMaxWidth[n] + (thisCellsMaxWidth - curMaxWidth) * colMaxWidth[cell.col + j] / curMaxWidth;
                            ++j;
                        }
                    } else {
                        thisCellsMaxWidth /= cell.colspan;
                        j = 0;
                        while (j < cell.colspan) {
                            colMaxWidth[cell.col + j] = thisCellsMaxWidth;
                            ++j;
                        }
                    }
                }
            }
            cell = (TableCellBox)cell.next;
        }
    }

    void layout(int parentHeight) {
        TableBox tableBox = (TableBox)this.parentBox.parentBox;
        TableCellBox cell = (TableCellBox)this.firstCell;
        while (cell != null) {
            cell.ox = tableBox.colCoord[cell.col];
            int cell_width = (cell.colspan - 1) * tableBox.css.border_spacing_x;
            int j = 0;
            while (j < cell.colspan) {
                cell_width += tableBox.colWidth[cell.col + j];
                ++j;
            }
            cell.width = cell_width;
            cell.layout(cell_width, parentHeight);
            cell = (TableCellBox)cell.next;
        }
    }

    void paint(Graphics g) {
        Rectangle r = g.getClipBounds();
        this.ox = this.parentBox.ox;
        this.width = this.parentBox.width;
        TableCellBox b = (TableCellBox)this.firstCell;
        while (b != null) {
            if (this.css.background_image != null && b.css.background_image == null) {
                b.css.background_image = this.css.background_image;
                b.css.background_image_url = this.css.background_image_url;
                b.css.background_params = this.css.background_params;
                b.css.background_position_x = this.css.background_position_x;
                b.css.background_position_y = this.css.background_position_y;
            }
            b = (TableCellBox)b.next;
        }
        TableCellBox cell = (TableCellBox)this.firstCell;
        while (cell != null) {
            if (cell.css.position != 125 && cell.ox + cell.width > r.x && cell.ox < r.x + r.width) {
                this.cssLayout.outlinePainter.drawBox(g, cell, cell.ox, 0);
            }
            cell = (TableCellBox)cell.next;
        }
    }

    private void do_add(TableCellBox cell) {
        if (cell.rowspan > this.numCellRows) {
            this.numCellRows = cell.rowspan;
        }
        if (this.firstCell == null) {
            this.firstCell = this.lastCell = cell;
            cell.next = null;
            cell.col = this.findNextFreeCol(cell, 0);
        } else {
            TableCellBox t = (TableCellBox)this.lastCell;
            cell.col = this.findNextFreeCol(cell, t.col + t.colspan);
            this.lastCell.next = cell;
            cell.next = null;
            this.lastCell = cell;
        }
        cell.setParentBox(this);
        TableBox tableBox = (TableBox)this.parentBox.parentBox;
        cell.setCellColBox(tableBox.getCellColBox(cell.col));
        this.anonCell = null;
    }

    void reverseCells(int totNumCols) {
        int diff = totNumCols - this.numCols;
        CSSBox bb = this.firstCell;
        Vector<CSSBox> v = new Vector<CSSBox>();
        while (bb != null) {
            v.addElement(bb);
            bb = bb.next;
        }
        int i = 0;
        while (i < diff) {
            CSSAttribs a = new CSSAttribs(this.cssLayout.sdata, this.css);
            a.display = 54;
            v.addElement(new TableCellBox(null, a, this.cssLayout));
            ++i;
        }
        this.numCellRows = 0;
        this.lastCell = null;
        this.firstCell = null;
        ((TableRowGroupBox)this.parentBox).resetColInfo();
        int i2 = v.size() - 1;
        while (i2 >= 0) {
            this.do_add((TableCellBox)v.elementAt(i2));
            --i2;
        }
    }

    CSSBox addChild(CSSBox b) {
        if (b instanceof TableCellBox) {
            TableCellBox cell = (TableCellBox)b;
            this.do_add(cell);
            this.numCols += cell.colspan;
            ++this.numCells;
            TableRowGroupBox rowGroup = (TableRowGroupBox)this.parentBox;
            if (this.numCells > rowGroup.realNumCols) {
                rowGroup.realNumCols = this.numCells;
            }
        } else {
            if (b instanceof TextBox && ((TextBox)b).isEmpty()) {
                return this;
            }
            TableCellBox c = this.anonCell;
            if (c == null) {
                CSSAttribs a = new CSSAttribs(this.cssLayout.sdata, this.css);
                a.display = 54;
                c = new TableCellBox(null, a, this.cssLayout);
                this.addChild(c);
                this.anonCell = c;
            }
            c.addChild(b);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private int findNextFreeCol(TableCellBox cell, int col) {
        block16: {
            block15: {
                block17: {
                    rowGroup = (TableRowGroupBox)this.parentBox;
                    if (rowGroup.usedCols == null) {
                        return col;
                    }
                    firstCol = -1;
                    firstColSpan = -1;
                    break block15;
                    while (rowGroup.usedCols[col] != 0) {
                        ++col;
lbl9:
                        // 2 sources

                        ** while (col >= rowGroup.numUsedCols)
lbl10:
                        // 1 sources

                    }
lbl11:
                    // 2 sources

                    i = 0;
                    while (col + i < rowGroup.numUsedCols && (cell.colspan == 0 || i < cell.colspan)) {
                        if (rowGroup.usedCols[col + i] > 0) break;
                        ++i;
                    }
                    if (i > 0 && i == cell.colspan) break block16;
                    if (i <= 0) break block17;
                    firstCol = col;
                    firstColSpan = i;
                    if (cell.colspan == 0 || !DDocument.STRICT) break block16;
                }
                if (col + i == rowGroup.numUsedCols) break block16;
                col += i;
            }
            if (col < rowGroup.numUsedCols) ** GOTO lbl9
        }
        if (col < rowGroup.numUsedCols) {
            if (cell.colspan == 0) {
                cell.colspan = rowGroup.numUsedCols - col;
            }
        } else if (firstCol >= 0) {
            col = firstCol;
            cell.colspan = firstColSpan;
        } else if (cell.colspan == 0) {
            cell.colspan = 1;
        }
        if (col + cell.colspan > rowGroup.usedCols.length) {
            t = rowGroup.usedCols.length << 1;
            while (col + cell.colspan > t) {
                t <<= 1;
            }
            tmp = new int[t];
            System.arraycopy(rowGroup.usedCols, 0, tmp, 0, rowGroup.usedCols.length);
            rowGroup.usedCols = tmp;
        }
        if (col + cell.colspan > rowGroup.numUsedCols) {
            rowGroup.numUsedCols = col + cell.colspan;
        }
        i = 0;
        while (i < cell.colspan) {
            if (cell.rowspan > rowGroup.usedCols[col + i]) {
                rowGroup.usedCols[col + i] = cell.rowspan;
            }
            ++i;
        }
        return col;
    }

    void findBoundingBox(Rectangle r) {
        Point pp = new Point();
        pp.y = 0;
        pp.x = 0;
        this.findAbsolutePosition(pp);
        r.x = pp.x;
        r.y = pp.y;
        r.width = this.width;
        r.height = this.height;
    }

    int getCount(int aType, Point p) {
        int returnVal = 0;
        CSSBox box = this.firstCell;
        while (box != null) {
            returnVal += box.getCount(aType, p);
            box = box.next;
        }
        return returnVal;
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        CSSBox box = this.firstCell;
        while (box != null) {
            CSSBox returnVal = box.findChildByIndex_r(aType, aIndex, aPoint);
            if (returnVal != null) {
                return returnVal;
            }
            box = box.next;
        }
        return null;
    }

    public String toString() {
        return "tablerow " + super.toString();
    }
}

