/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ExternalCSSBoxAssist;
import ice.pilots.html4.HighlightRange;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.UnsupportedOperationException;
import ice.util.alg.Bidi;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.BreakIterator;
import java.util.Vector;

class TextBox
extends CSSBox {
    private Font renderingFont;
    private static final boolean checkGlyph;
    private DTextNode textNode;
    private int[] breakOffsetInPixels;
    private int spaceWidthInPixels;
    private int textDescent;
    private int textAscent;
    private int lineHeight;
    private Vector highlightRanges;
    private static ExternalCSSBoxAssist runtimeExtension;
    private static boolean fontsReportCorrectly;
    private boolean isJavaBidi;
    private static boolean ignoreEmptyTextboxes;
    private BreakIterator sentenceInstance;
    private BreakIterator wordInstance;
    private int sentenceCount;
    private int wordCount;

    private void $init$() {
        this.renderingFont = null;
        this.spaceWidthInPixels = 0;
        this.isJavaBidi = JavaVersion.isV12orGreater();
    }

    static {
        boolean check = Defs.sysPropertyBoolean("ice.pilots.html4.testallglyphs", true);
        if (!JavaVersion.isV12orGreater()) {
            check = false;
        }
        checkGlyph = check;
        String sTemp = Defs.property("ice.pilots.html4.GraphicExtension");
        if (sTemp != null) {
            try {
                Class<?> addon = Class.forName(sTemp);
                runtimeExtension = (ExternalCSSBoxAssist)addon.newInstance();
            }
            catch (Exception e) {
                Debug.p("Exception occured loading graphic extension class:" + e);
            }
        }
        fontsReportCorrectly = Defs.sysPropertyBoolean("ice.pilots.html4.fontsReportCorrectly");
        ignoreEmptyTextboxes = Defs.sysPropertyBoolean("ice.pilots.html4.ignoreEmptyTextboxes", false);
    }

    TextBox(DTextNode textNode, CSSLayout cssLayout) {
        super(cssLayout);
        this.$init$();
        this.textNode = textNode;
    }

    void dispose() {
        super.dispose();
        this.breakOffsetInPixels = null;
    }

    boolean isEmpty() {
        return this.textNode.isEmpty();
    }

    DNode getDomNode() {
        return this.textNode;
    }

    int calcBreaks() {
        if (this.spaceWidthInPixels == 0) {
            this.initBreaks();
        }
        return this.numBreaks;
    }

    int getBreaks(int[] breaks, int idx) {
        System.arraycopy(this.breakOffsetInPixels, 0, breaks, idx, this.numBreaks);
        return this.numBreaks;
    }

    public void highlightArea(int startPosition, int endPosition) {
        if (this.highlightRanges == null) {
            this.highlightRanges = new Vector();
        }
        HighlightRange hr = new HighlightRange(startPosition, endPosition);
        this.highlightRanges.addElement(hr);
    }

    public void clearHighlights() {
        if (this.highlightRanges != null) {
            this.highlightRanges.removeAllElements();
        }
    }

    long getChunkDescentAscent(int x, int w, LineBox aLineMetrics) {
        if (!this.textNode.isPre && this.isEmpty()) {
            return 0L;
        }
        return TextBox.wrapDescentAscent(this.textDescent, this.textAscent, this.lineHeight);
    }

    private final void initBreaks() {
        DElement tmpe = this.parentBox.element;
        if (tmpe != null && tmpe.tagId == 10 && this.parentBox.css.directionFlag == 1) {
            this.textNode.reverseText();
        }
        this.css = this.parentBox.css;
        this.renderingFont = this.css.getFont();
        FontMetrics fm = this.css.getFontMetrics();
        if (checkGlyph) {
            this.renderingFont = this.css.getTestedFont(this.textNode.text, 0, this.textNode.text.length);
            fm = this.css.getFontMetrics();
        }
        this.numBreaks = (this.css.misc & 4) != 0 ? 0 : this.textNode.numBreaks;
        this.breakOffsetInPixels = new int[this.numBreaks];
        char[] text = this.textNode.text;
        int[] breakOffset = this.textNode.breakOffset;
        this.textDescent = fm.getDescent();
        this.textAscent = fm.getAscent();
        long val = TextBox.calculateCompressedFontSize(this.textAscent, this.textDescent, this.css);
        this.textDescent = TextBox.unwrapDescent(val);
        this.textAscent = TextBox.unwrapAscent(val);
        this.lineHeight = TextBox.calculateLineHeight(this.css);
        this.spaceWidthInPixels = fm.charWidth(' ');
        int ww = 0;
        if (this.textNode.isPre) {
            int[] charWidth = this.css.getFontCharWidths();
            int i = 0;
            int bi = 0;
            while (bi < this.numBreaks) {
                int epos = breakOffset[bi];
                if (epos < 0) {
                    epos = -epos;
                }
                while (i < epos) {
                    ww = text[i] >= charWidth.length ? (ww += fm.charWidth(text[i])) : (text[i] == '\n' ? ++ww : (ww += charWidth[text[i]]));
                    ++i;
                }
                this.breakOffsetInPixels[bi] = breakOffset[bi] < 0 ? -ww : ww;
                ++bi;
            }
            while (i < text.length) {
                ww = text[i] >= charWidth.length ? (ww += fm.charWidth(text[i])) : (ww += charWidth[text[i]]);
                ++i;
            }
            this.totalWidth = ww;
        } else {
            int spos = 0;
            int bi = 0;
            while (bi < this.numBreaks) {
                int epos = breakOffset[bi];
                if (epos < 0) {
                    epos = -epos;
                }
                this.breakOffsetInPixels[bi] = breakOffset[bi] < 0 ? -ww : (ww += fm.charsWidth(text, spos, epos - spos));
                spos = epos;
                ++bi;
            }
            if (this.isEmpty() && ignoreEmptyTextboxes) {
                this.totalWidth = 0;
                this.numBreaks = 0;
            } else {
                this.totalWidth = fm.charsWidth(text, 0, text.length);
            }
        }
    }

    static final long calculateCompressedFontSize(int aAscent, int aDescent, CSSAttribs aCss) {
        if (!fontsReportCorrectly) {
            float ratio = (float)aAscent / (float)aDescent;
            int descent = Math.round((float)aCss.font_size / (1.0f + ratio));
            int ascent = aCss.font_size - descent;
            return TextBox.wrapDescentAscent(++descent, ++ascent, 0);
        }
        return TextBox.wrapDescentAscent(aDescent, aAscent, 0);
    }

    static int calculateLineHeight(CSSAttribs aCss) {
        int returnVal = 0;
        returnVal = (aCss.percentage_flag & 0x200000) > 0 ? aCss.line_height * aCss.font_size / 100 : aCss.line_height;
        return returnVal;
    }

    public int getCount(int aType, Point p) {
        switch (aType) {
            case 1: {
                this._startingCharOffset = p.x;
                p.x += this.textNode.text.length;
                return this.textNode.text.length;
            }
            case 2: {
                this._startingWordOffset = p.x;
                if (this.wordInstance == null) {
                    BreakIterator bi = this.textNode.doc.getWordIterator();
                    this.wordInstance = bi != null ? (BreakIterator)bi.clone() : BreakIterator.getWordInstance();
                    String text = new String(this.textNode.text);
                    this.wordInstance.setText(text);
                    this.wordInstance.first();
                    this.wordCount = this.countWords(this.wordInstance, this.textNode.text);
                }
                p.x += this.wordCount;
                return this.wordCount;
            }
            case 3: {
                this._startingSentenceOffset = p.x;
                if (this.sentenceInstance == null) {
                    String text = new String(this.textNode.text);
                    this.sentenceInstance = BreakIterator.getSentenceInstance();
                    this.sentenceInstance.setText(text);
                    this.sentenceInstance.first();
                    while (this.sentenceInstance.next() != -1) {
                        ++this.sentenceCount;
                    }
                    if (this.wordCount == 0) {
                        this.sentenceCount = 0;
                    }
                }
                p.x += this.sentenceCount;
                return this.sentenceCount;
            }
        }
        throw new UnsupportedOperationException("Unsupported Access type: " + aType);
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        switch (aType) {
            case 1: {
                this._startingCharOffset = aPoint.x;
                aPoint.x += this.textNode.text.length;
                if (this._startingCharOffset > aIndex || aIndex >= aPoint.x) break;
                return this;
            }
            case 2: {
                this._startingWordOffset = aPoint.x;
                aPoint.x += this.wordCount;
                if (this._startingWordOffset > aIndex || aIndex >= aPoint.x) break;
                return this;
            }
            case 3: {
                this._startingSentenceOffset = aPoint.x;
                aPoint.x += this.sentenceCount;
                if (this._startingSentenceOffset > aIndex || aIndex >= aPoint.x) break;
                return this;
            }
        }
        return null;
    }

    String getText(int aType, int aIndex, AccessPosition aPosition) {
        int spos = 0;
        int epos = this.textNode.text.length;
        switch (aType) {
            case 1: {
                aPosition._characterInDoc = aIndex;
                int cdx = aIndex - this._startingCharOffset;
                aPosition._wordInDoc = this.getWordFromCharIdx(cdx) + this._startingWordOffset;
                aPosition._sentenceInDoc = this._startingSentenceOffset + this.getSentenceFromCharIdx(cdx);
                return String.valueOf(this.textNode.text[cdx]);
            }
            case 2: {
                int wdx = aIndex - this._startingWordOffset;
                if (wdx > this.wordCount) {
                    return null;
                }
                spos = this.locateWord(wdx);
                epos = this.locateWord(wdx + 1);
                aPosition._wordInDoc = aIndex;
                aPosition._characterInDoc = spos + this._startingCharOffset;
                aPosition._sentenceInDoc = this._startingSentenceOffset + this.getSentenceFromCharIdx(spos);
                return String.valueOf(this.textNode.text, spos, epos - spos);
            }
            case 3: {
                if (this.sentenceInstance == null) {
                    String text = new String(this.textNode.text);
                    this.sentenceInstance = BreakIterator.getSentenceInstance();
                    this.sentenceInstance.setText(text);
                }
                int sdx = aIndex - this._startingSentenceOffset;
                this.sentenceInstance.first();
                spos = this.sentenceInstance.next(sdx);
                this.sentenceInstance.first();
                epos = this.sentenceInstance.next(sdx + 1);
                aPosition._characterInDoc = spos + this._startingCharOffset;
                aPosition._sentenceInDoc = aIndex;
                aPosition._wordInDoc = this.getWordFromCharIdx(spos) + this._startingWordOffset;
                return String.valueOf(this.textNode.text, spos, epos - spos);
            }
        }
        throw new UnsupportedOperationException("Unsupported Access type: " + aType);
    }

    int getStartingCharacterOffset() {
        return this._startingCharOffset;
    }

    private int locateWord(int wordOffset) {
        if (wordOffset == this.wordCount) {
            return this.textNode.text.length;
        }
        int spos = 0;
        this.wordInstance.first();
        int idx = 0;
        while (idx < wordOffset) {
            spos = this.wordInstance.next();
            char c = this.textNode.text[spos];
            while (c == ' ' || c == ',' || c == '.' || c == '?' || c == '!') {
                spos = this.wordInstance.next();
                c = this.textNode.text[spos];
            }
            ++idx;
        }
        return spos;
    }

    private int countWords(BreakIterator wordIterator, char[] underlyingText) {
        int pos = 0;
        int wordCount = 0;
        while ((pos = wordIterator.next()) != -1) {
            if (pos < underlyingText.length) {
                char c = underlyingText[pos];
                while (c == ' ' || c == ',' || c == '.' || c == '?' || c == '!') {
                    pos = wordIterator.next();
                    if (pos >= underlyingText.length) break;
                    c = underlyingText[pos];
                }
            }
            ++wordCount;
        }
        return wordCount;
    }

    public int getCharIndexOfWordRelative(int wordIndex) {
        if (wordIndex == 0) {
            return 0;
        }
        if (wordIndex < this.wordCount) {
            return this.locateWord(wordIndex);
        }
        return -1;
    }

    public int getCharIndexOfWordAbsolute(int absoluteWordIndex) {
        return this.getCharIndexOfWordRelative(absoluteWordIndex - this._startingWordOffset);
    }

    int getWordFromCharIdx(int aCharIdx) {
        int epos = 0;
        int idx = 0;
        while (idx < this.wordCount) {
            epos = this.locateWord(idx);
            if (epos > aCharIdx) {
                return idx - 1;
            }
            ++idx;
        }
        if (aCharIdx <= this.textNode.text.length) {
            return this.wordCount - 1;
        }
        Debug.trace("Char index out of range searching for word? " + aCharIdx);
        return -1;
    }

    int getSentenceFromCharIdx(int aCharIndex) {
        if (this.sentenceInstance == null) {
            Point p = new Point();
            this.getCount(3, p);
        }
        if (this.sentenceCount == 1) {
            return 0;
        }
        int spos = 0;
        int epos = this.textNode.text.length;
        int sdx = 0;
        while (sdx < this.sentenceCount) {
            this.sentenceInstance.first();
            spos = this.sentenceInstance.next(sdx);
            epos = sdx < this.sentenceCount - 1 ? this.sentenceInstance.next(sdx + 1) : this.textNode.text.length;
            if (aCharIndex >= spos && aCharIndex < epos) {
                return sdx;
            }
            ++sdx;
        }
        if (aCharIndex >= epos) {
            Debug.trace("Char index out of range searching for sentence? " + aCharIndex);
        }
        return 0;
    }

    void paintChunk(Graphics g, int x, int w, LineBox aLineMetrics, int aBoxId) {
        int pxBreakEnd;
        this.css = this.parentBox.css;
        int contentBoxHeight = this.textAscent + this.textDescent;
        if (!this.isEmpty() && this.parentBox.getType() != 1) {
            int sx = x;
            int sw = w;
            int vadj = this.css.padding_top + this.css.padding_bottom;
            if (x == 0) {
                sw -= (sx -= this.css.padding_left);
            }
            if (x + w == this.totalWidth) {
                sw += this.css.padding_right;
            }
            this.paintBackground(g, g.getClipBounds(), sx, 0 - this.css.padding_top, sw, contentBoxHeight + vadj, 0);
            if (x == 0) {
                sx -= this.css.border_left_width;
                sw += this.css.border_left_width;
            }
            if (x + w == this.totalWidth) {
                sw += this.css.border_right_width;
            }
            if (!((InlineBox)this.parentBox).hasMoreThanOneChild()) {
                this.paintBorders(g, g.getClipBounds(), sx, -this.css.padding_top - this.css.border_top_width, sw, contentBoxHeight + vadj + this.css.border_top_width + this.css.border_bottom_width, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8 && x == 0, this.css.border_right_width > 0 && this.css.border_right_style != 8 && x + w == this.totalWidth);
            }
        }
        if ((this.css.misc & 1) == 0) {
            return;
        }
        int chrStartingIdx = 0;
        int chrEndingIdx = this.textNode.text.length;
        int i = 0;
        int temp = 0;
        if (x != 0) {
            i = 0;
            while (i < this.numBreaks) {
                temp = this.breakOffsetInPixels[i];
                if (temp < 0 && temp == -x || temp >= 0 && temp == x) {
                    chrStartingIdx = this.textNode.breakOffset[i];
                    if (chrStartingIdx >= 0) break;
                    chrStartingIdx = -chrStartingIdx;
                    break;
                }
                ++i;
            }
        }
        if (i == this.numBreaks) {
            i = 0;
        }
        if (x + w != this.totalWidth) {
            while (i < this.numBreaks) {
                temp = this.breakOffsetInPixels[i];
                if (temp < 0 && temp == -(x + w) || temp >= 0 && temp == x + w) {
                    char c;
                    chrEndingIdx = this.textNode.breakOffset[i];
                    if (chrEndingIdx < 0) {
                        chrEndingIdx = -chrEndingIdx;
                    }
                    if ((c = this.textNode.text[chrEndingIdx - 1]) == ' ' || c == '\n') {
                        --chrEndingIdx;
                    }
                    break;
                }
                ++i;
            }
        } else if (this.numBreaks > 0 && this.breakOffsetInPixels[this.numBreaks - 1] == -this.totalWidth) {
            --chrEndingIdx;
        }
        if (chrStartingIdx >= chrEndingIdx) {
            return;
        }
        if (g.getFont() != this.renderingFont) {
            g.setFont(this.renderingFont);
        }
        boolean selectMode = false;
        if (this.cssLayout.isSelection() && this.cssLayout.isInSelection(this.textNode)) {
            if (this.cssLayout.getStartContainer() == this.textNode || this.cssLayout.getEndContainer() == this.textNode) {
                selectMode = true;
                g.setColor(this.css.color);
            } else {
                g.setColor(this.cssLayout.getSelectionBackground());
                g.fillRect(x, 0, w, contentBoxHeight);
                g.setColor(this.cssLayout.getSelectionColor());
            }
        } else {
            g.setColor(this.css.color);
        }
        char[] buf = this.textNode.text;
        if (this.isJavaBidi || this.textNode.doc.charsetId == 0) {
            g.drawChars(buf, chrStartingIdx, chrEndingIdx - chrStartingIdx, x, this.textAscent);
        } else {
            this.renderWithLocalBidi(g, chrStartingIdx, chrEndingIdx, x, this.textAscent);
        }
        if ((this.css.text_decoration & 1) != 0) {
            int y1 = contentBoxHeight - 2;
            g.drawLine(x, y1, x + w, y1);
        }
        if ((this.css.text_decoration & 4) != 0) {
            int y1 = 1;
            g.drawLine(x, y1, x + w, y1);
        }
        if ((this.css.text_decoration & 2) != 0) {
            int y1 = Math.round((float)contentBoxHeight * 0.5f);
            g.drawLine(x, y1, x + w, y1);
        }
        if ((this.css.misc & 2) != 0) {
            this.cssLayout.outlinePainter.addRectangle(this, x, 0, w, contentBoxHeight);
        }
        Graphics g2 = null;
        int sectionWidth = 0;
        int chrSelectionStart = chrStartingIdx;
        int chrSelectionEnd = chrEndingIdx;
        int pxBreakLocation = x;
        int pxSelectionEnd = pxBreakEnd = x + w;
        int pxSelectionStart = pxBreakLocation;
        FontMetrics fm = this.css.getFontMetrics();
        if (this.highlightRanges != null && this.highlightRanges.size() > 0) {
            HighlightRange hr = null;
            int hdx = 0;
            while (hdx < this.highlightRanges.size()) {
                hr = (HighlightRange)this.highlightRanges.elementAt(hdx);
                chrSelectionStart = hr.getHighlightStart();
                chrSelectionEnd = hr.getHighlightEnd();
                if (chrSelectionEnd >= chrStartingIdx && chrSelectionStart <= chrEndingIdx) {
                    if (chrSelectionStart > chrStartingIdx) {
                        pxSelectionStart = this.pxLocationFromChrIndex(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, chrSelectionStart, fm, this.textNode.isPre);
                    } else {
                        chrSelectionStart = chrStartingIdx;
                    }
                    if (chrSelectionEnd <= chrEndingIdx) {
                        pxSelectionEnd = this.pxLocationFromChrIndex(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, chrSelectionEnd, fm, this.textNode.isPre);
                    } else {
                        chrSelectionEnd = chrEndingIdx;
                    }
                    sectionWidth = pxSelectionEnd - pxSelectionStart;
                    if (g2 == null) {
                        g2 = g.create();
                    }
                    g2.setClip(pxSelectionStart, 0, sectionWidth, contentBoxHeight);
                    g2.setColor(this.cssLayout.getHighlightBackground());
                    g2.fillRect(pxSelectionStart, 0, sectionWidth, contentBoxHeight);
                    g2.setColor(this.cssLayout.getHighlightColor());
                    if (this.isJavaBidi || this.textNode.doc.charsetId == 0) {
                        g2.drawChars(buf, chrStartingIdx, chrEndingIdx - chrStartingIdx, x, this.textAscent);
                    } else {
                        this.renderWithLocalBidi(g2, chrStartingIdx, chrEndingIdx, x, this.textAscent);
                    }
                }
                ++hdx;
            }
        }
        if (selectMode) {
            chrSelectionStart = chrStartingIdx;
            chrSelectionEnd = chrEndingIdx;
            pxBreakLocation = x;
            pxSelectionEnd = pxBreakEnd = x + w;
            pxSelectionStart = pxBreakLocation;
            if (this.cssLayout.getStartContainer() == this.textNode && (chrSelectionStart = this.cssLayout.getSelectionStart() - this._startingCharOffset) < chrEndingIdx) {
                if (chrSelectionStart > chrStartingIdx) {
                    pxSelectionStart = this.pxLocationFromChrIndex(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, chrSelectionStart, fm, this.textNode.isPre);
                } else {
                    chrSelectionStart = chrStartingIdx;
                }
            }
            if (this.cssLayout.getEndContainer() == this.textNode && (chrSelectionEnd = this.cssLayout.getSelectionEnd() - this._startingCharOffset) > chrStartingIdx) {
                if (chrSelectionEnd < chrEndingIdx) {
                    pxSelectionEnd = this.pxLocationFromChrIndex(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, chrSelectionEnd, fm, this.textNode.isPre);
                } else {
                    chrSelectionEnd = chrEndingIdx;
                }
            }
            if (chrSelectionStart < chrSelectionEnd) {
                sectionWidth = pxSelectionEnd - pxSelectionStart;
                g2 = g.create();
                g2.setClip(pxSelectionStart, 0, sectionWidth, contentBoxHeight);
                g2.setColor(this.cssLayout.getSelectionBackground());
                g2.fillRect(pxSelectionStart, 0, sectionWidth, contentBoxHeight);
                g2.setColor(this.cssLayout.getSelectionColor());
                if (this.isJavaBidi || this.textNode.doc.charsetId == 0) {
                    g2.drawChars(buf, chrStartingIdx, chrEndingIdx - chrStartingIdx, x, this.textAscent);
                } else {
                    this.renderWithLocalBidi(g2, chrStartingIdx, chrEndingIdx, x, this.textAscent);
                }
            }
        }
        if (g2 != null) {
            g2.dispose();
        }
        if (runtimeExtension != null) {
            runtimeExtension.addonTextProcessing(g, this, w, contentBoxHeight, x);
        }
    }

    public int getRenderedLineNumber(int yPosInBox) {
        int lineNumber = 0;
        if (this.textAscent + this.textDescent > 0) {
            lineNumber = yPosInBox / (this.textAscent + this.textDescent);
        }
        return lineNumber;
    }

    int getCharacterIndex(int pixelX, boolean atStart) {
        int guess = this.findStartingBreakIdxFromArray(this.breakOffsetInPixels, pixelX);
        int returnVal = this.textNode.isPre ? this.fastChrIndexFromPx(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, guess, pixelX) : this.accurateChrIndexFromPx(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, guess, pixelX);
        if (atStart) {
            return returnVal;
        }
        return returnVal + 1;
    }

    int findStartingBreakIdxFromArray(int[] breakArray, int pixelX) {
        if (breakArray.length == 0) {
            return 0;
        }
        int lastBreak = Math.abs(breakArray[breakArray.length - 1]);
        if (pixelX < 0 || pixelX > lastBreak) {
            return 0;
        }
        if (pixelX < breakArray[0]) {
            return 0;
        }
        int bdx = 0;
        while (Math.abs(breakArray[bdx]) < pixelX) {
            ++bdx;
        }
        return bdx;
    }

    int fastChrIndexFromPx(char[] buf, int[] chrBreakArray, int[] pixelBreakArray, int breakIdx, int pixelX) {
        int spx = 0;
        int epx = 0;
        int charDx = 0;
        if (chrBreakArray.length != 0) {
            if (breakIdx == 0) {
                charDx = 0;
            } else {
                if (Math.abs(pixelBreakArray[breakIdx - 1]) == pixelX) {
                    return Math.abs(chrBreakArray[breakIdx - 1]);
                }
                charDx = Math.abs(chrBreakArray[breakIdx - 1]);
                spx = pixelBreakArray[breakIdx - 1];
            }
        }
        int[] charWidths = this.css.getFontCharWidths();
        FontMetrics fm = this.css.getFontMetrics();
        if (spx < 0) {
            spx = -spx;
        }
        epx = spx;
        while (charDx <= buf.length - 1) {
            spx = buf[charDx] >= charWidths.length ? (spx += fm.charWidth(buf[charDx])) : (buf[charDx] == '\n' ? ++spx : (spx += charWidths[buf[charDx]]));
            if (epx <= pixelX && spx >= pixelX) {
                return charDx;
            }
            epx = spx;
            ++charDx;
        }
        return 0;
    }

    private int accurateChrIndexFromPx(char[] buf, int[] chrBreakArray, int[] pixelBreakArray, int breakIdx, int pixelX) {
        FontMetrics fm = this.css.getFontMetrics();
        int spos = 0;
        int epos = 0;
        float ratio = 0.0f;
        int guess = 0;
        if (breakIdx > 0) {
            spos = Math.abs(pixelBreakArray[breakIdx - 1]);
            epos = Math.abs(pixelBreakArray[breakIdx]);
            ratio = (epos - spos) / epos;
            guess = Math.round((float)chrBreakArray[breakIdx - 1] * (1.0f + ratio));
        }
        int delta = 1;
        int cdx = guess;
        epos = spos = fm.charsWidth(buf, 0, cdx);
        if (spos > pixelX) {
            delta = -1;
        }
        while ((cdx += delta) <= buf.length) {
            spos = fm.charsWidth(buf, 0, cdx);
            if (spos <= pixelX && epos >= pixelX) {
                return cdx;
            }
            if (spos >= pixelX && epos <= pixelX) {
                return cdx - 1;
            }
            epos = spos;
        }
        return buf.length - 1;
    }

    int pxLocationFromChrIndex(char[] buf, int[] chrBreakArray, int[] pxBreakArray, int chrIndex, FontMetrics fm, boolean isPre) {
        if (chrIndex < 0) {
            return 0;
        }
        if (chrIndex > buf.length) {
            if (pxBreakArray.length > 0) {
                return pxBreakArray[pxBreakArray.length - 1];
            }
            return fm.charsWidth(buf, 0, buf.length - 1);
        }
        int guess = this.findStartingBreakIdxFromArray(chrBreakArray, chrIndex);
        int spx = 0;
        int charDx = 0;
        if (guess > 0 && pxBreakArray.length > guess) {
            charDx = Math.abs(chrBreakArray[guess - 1]);
            spx = Math.abs(pxBreakArray[guess - 1]);
        }
        if (isPre) {
            int[] charWidths = this.css.getFontCharWidths();
            while (charDx < chrIndex) {
                spx = buf[charDx] >= charWidths.length ? (spx += fm.charWidth(buf[charDx])) : (buf[charDx] == '\n' ? ++spx : (spx += charWidths[buf[charDx]]));
                ++charDx;
            }
            return spx;
        }
        return fm.charsWidth(buf, 0, chrIndex);
    }

    void findBoundingBox(Rectangle r) {
        BlockBox bb = null;
        int x = this.ox;
        CSSBox b = this.parentBox;
        while (b.parentBox != null) {
            if (b.getType() == 0) {
                x += b.css.margin_left + b.css.border_left_width + b.css.padding_left;
                x += b.ox;
            } else {
                x += b.css.text_indent;
            }
            if (b.getType() == 1) {
                bb = (BlockBox)b;
                bb.recordBoundingBoxForInline(r, x, this.totalWidth);
                if (r.width == 0) {
                    r.height = 0;
                    r.width = 0;
                    r.y = 0;
                    r.x = 0;
                    bb.findBoundingBox(r);
                    break;
                }
                if (b.css.position == 126 || b.css.position == 6) break;
                Point p = new Point();
                b = b.parentBox;
                if (b != null) {
                    b.findAbsolutePosition(p);
                }
                r.x += p.x;
                r.y += p.y;
                break;
            }
            b = b.parentBox;
        }
    }

    private void renderWithLocalBidi(Graphics g, int aChrStartingIdx, int aChrEndingIdx, int aX, int aY) {
        Bidi bidi = Bidi.createBidi(this.textNode.doc.charsetId, this.textNode.text, aChrStartingIdx, aChrEndingIdx);
        char[] arr = bidi.getChars();
        if (arr != null) {
            FontMetrics fm = g.getFontMetrics();
            int xx = aX;
            int j = 0;
            while (j < arr.length) {
                g.drawChars(arr, j, 1, xx, aY);
                xx += fm.charWidth(arr[j]);
                ++j;
            }
        }
    }

    char[] getText() {
        return this.textNode.text;
    }
}

