/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class Scroller
extends JPanel
implements AdjustmentListener,
ObjectPainter,
Movable {
    private DocView docView;
    private ObjectBox box;
    private JScrollBar hbar;
    private JScrollBar vbar;
    private View view;

    Scroller(DocView docView) {
        this.docView = docView;
        this.setLayout(new BorderLayout());
        this.hbar = new JScrollBar(0);
        this.vbar = new JScrollBar(1);
        this.view = new View(this, docView);
        this.add((Component)this.hbar, "South");
        this.add((Component)this.vbar, "East");
        this.add((Component)this.view, "Center");
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
        this.setOpaque(false);
    }

    Container getView() {
        return this.view;
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void doLayout() {
        super.doLayout();
        ScrollBox b = this.getScrollBox();
        if (b != null) {
            BoundedRangeModel vmodel;
            Dimension viewDim = this.view.getSize();
            b.layoutScrollable(viewDim.width, viewDim.height);
            int maxx = b.getScrollableWidth();
            int maxy = b.getScrollableHeight();
            boolean forceSyncView = false;
            BoundedRangeModel hmodel = this.hbar.getModel();
            if (hmodel.getExtent() == viewDim.width && hmodel.getMinimum() == 0 && hmodel.getMaximum() == maxx) {
                forceSyncView = true;
            }
            if ((vmodel = this.vbar.getModel()).getExtent() == viewDim.height && vmodel.getMinimum() == 0 && vmodel.getMaximum() == maxy) {
                forceSyncView = true;
            }
            this.hbar.setValues(this.hbar.getValue(), viewDim.width, 0, maxx);
            this.vbar.setValues(this.vbar.getValue(), viewDim.height, 0, maxy);
            if (forceSyncView) {
                this.syncView();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.syncView();
    }

    private void syncView() {
        ScrollBox sbox = this.getScrollBox();
        if (sbox != null) {
            sbox.setScrollPosition(this.getScrollX(), this.getScrollY());
        }
        this.view.syncChildren();
        this.view.repaint();
    }

    ScrollBox getScrollBox() {
        ObjectBox obox = this.getBox();
        if (obox != null) {
            return obox.getScrollBox();
        }
        return null;
    }

    int getScrollX() {
        return this.hbar.getValue();
    }

    int getScrollY() {
        return this.vbar.getValue();
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public void draw(Graphics g) {
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
    }

    public int getClientHeight() {
        int hbarWidth = this.hbar != null ? this.hbar.getHeight() : 0;
        return this.getHeight() - hbarWidth;
    }

    public int getClientWidth() {
        int vbarWidth = this.vbar != null ? this.vbar.getWidth() : 0;
        return this.getWidth() - vbarWidth;
    }

    private static class View
    extends JPanel {
        private Scroller scroller;
        private DocView docView;

        View(Scroller s, DocView docView) {
            this.scroller = s;
            this.docView = docView;
            this.setLayout(null);
            this.enableEvents(60);
            this.setOpaque(false);
        }

        public void doLayout() {
            super.doLayout();
            this.syncChildren();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void syncChildren() {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n = this.getComponentCount();
                int i = 0;
                while (i < n) {
                    Movable movable;
                    ObjectBox box;
                    Component c = this.getComponent(i);
                    if (c instanceof Movable && (box = (movable = (Movable)((Object)c)).getBox()) != null) {
                        Point p = new Point(0, 0);
                        box.findAbsolutePosition(p);
                        int x = p.x - this.scroller.getScrollX();
                        int y = p.y - this.scroller.getScrollY();
                        movable.syncDom(x, y, box.checkIfVisible());
                    }
                    ++i;
                }
            }
        }

        public void paintComponent(Graphics g) {
            ScrollBox b = this.scroller.getScrollBox();
            if (b != null) {
                int sx = this.scroller.getScrollX();
                int sy = this.scroller.getScrollY();
                g.translate(-sx, -sy);
                b.paintScrollable(g);
                g.translate(sx, sy);
            }
        }

        protected void processEvent(AWTEvent e) {
            if (this.docView.onComponentEvent(this, e)) {
                super.processEvent(e);
            }
        }
    }
}

