/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing.dnd;

import ice.debug.Debug;
import ice.pilots.html4.ICEDropClient;
import ice.pilots.html4.swing.dnd.StringTransferable;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.Reader;

public class DropTargetAgent {
    private DropTargetListener dtListener;
    private final int acceptableActions;
    private DataFlavor[] acceptableFlavors;
    private ICEDropClient listener;

    private void $init$() {
        this.acceptableActions = 1;
        this.acceptableFlavors = new DataFlavor[]{DataFlavor.plainTextFlavor, DataFlavor.stringFlavor};
    }

    public DropTargetAgent(ICEDropClient listener, Component target) {
        this.$init$();
        if (listener == null) {
            throw new IllegalArgumentException("DropListener cannot be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Drop Component cannot be null");
        }
        this.listener = listener;
        this.dtListener = new 1();
        DropTarget dt = new DropTarget(target, this.acceptableActions, this.dtListener, true);
    }

    private void publishDropEvent(String payload) {
        this.listener.packageDropped(payload);
    }

    private boolean isDragOk(DropTargetDragEvent e) {
        DataFlavor[] flavors = StringTransferable.flavors;
        DataFlavor chosen = null;
        int i = 0;
        while (i < flavors.length) {
            if (e.isDataFlavorSupported(flavors[i])) {
                chosen = flavors[i];
                break;
            }
            ++i;
        }
        if (chosen == null) {
            return false;
        }
        int sa = e.getSourceActions();
        return (sa & this.acceptableActions) != 0;
    }

    static DataFlavor[] ra$acceptableFlavors(DropTargetAgent dropTargetAgent) {
        return dropTargetAgent.acceptableFlavors;
    }

    static int ra$acceptableActions(DropTargetAgent dropTargetAgent) {
        return dropTargetAgent.acceptableActions;
    }

    static void mav$publishDropEvent(DropTargetAgent dropTargetAgent, String string) {
        dropTargetAgent.publishDropEvent(string);
    }

    static boolean mav$isDragOk(DropTargetAgent dropTargetAgent, DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetAgent.isDragOk(dropTargetDragEvent);
    }

    final class 1
    implements DropTargetListener {
        public void dragOver(DropTargetDragEvent dsde) {
            if (DropTargetAgent.mav$isDragOk(DropTargetAgent.this, dsde)) {
                dsde.acceptDrag(1);
            }
        }

        public void drop(DropTargetDropEvent e) {
            DataFlavor[] flavors = DropTargetAgent.ra$acceptableFlavors(DropTargetAgent.this);
            DataFlavor chosenFlavor = null;
            int i = 0;
            while (i < flavors.length) {
                if (e.isDataFlavorSupported(flavors[i])) {
                    chosenFlavor = flavors[i];
                    break;
                }
                ++i;
            }
            if (chosenFlavor == null) {
                e.rejectDrop();
                return;
            }
            int sa = e.getSourceActions();
            if ((sa & DropTargetAgent.ra$acceptableActions(DropTargetAgent.this)) == 0) {
                e.rejectDrop();
                return;
            }
            Transferable data = null;
            try {
                e.acceptDrop(DropTargetAgent.ra$acceptableActions(DropTargetAgent.this));
                data = e.getTransferable();
                if (data == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                e.dropComplete(false);
                return;
            }
            Reader r = null;
            StringBuffer str = null;
            if (data != null) {
                try {
                    r = chosenFlavor.getReaderForText(data);
                }
                catch (Exception ex) {
                    e.dropComplete(false);
                    return;
                }
                if (r != null) {
                    str = new StringBuffer();
                    int in = -1;
                    try {
                        while ((in = r.read()) >= 0) {
                            if (in == 0) continue;
                            str.append((char)in);
                        }
                    }
                    catch (IOException ioe) {
                        e.dropComplete(false);
                        Debug.trace("Exception reading drop payload: " + ioe);
                        return;
                    }
                }
            }
            if (str != null && str.length() != 0) {
                DropTargetAgent.mav$publishDropEvent(DropTargetAgent.this, str.toString());
            }
        }

        public void dropActionChanged(DropTargetDragEvent dsde) {
        }

        public void dragEnter(DropTargetDragEvent dsde) {
        }

        public void dragExit(DropTargetEvent dsde) {
        }
    }
}

