/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.mathml;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.LPilot;
import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import webeq.app.Handler;
import webeq.app.PEquation;
import webeq.fonts.FontBroker;
import webeq.parser.Parser;
import webeq.util.ErrorHandler;

public class ThePilot
extends LPilot {
    private PEquation eq;
    private Handler handler;
    private ErrorHandler err;
    private String macros;
    private String math_parser;
    private int font_height;
    private int eqWidth;
    private int eqHeight;

    static {
        ThePilot.testForMathEq();
        FontBroker.initialize((boolean)true);
    }

    private static final void testForMathEq() throws RuntimeException {
        String className = "webeq.app.PEquation";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Required class '" + className + "' not found. Required WebEq library jar may not be on the classpath - MathML Pilot disabled.";
            Debug.trace(msg);
            throw new RuntimeException(msg);
        }
    }

    private void $init$() {
        this.eq = null;
        this.handler = new Handler();
        this.err = new ErrorHandler();
        this.macros = null;
        this.math_parser = "mathml";
        this.font_height = 10;
        this.eqWidth = 0;
        this.eqHeight = 0;
    }

    public void parse(ContentLoader cl) throws IOException {
        this.handler.setParameters((Component)this.getViewportContainer(), null);
        this.eq = new PEquation(this.handler);
        this.eq.initBG();
        this.eq.setSize(this.handler.size().width, this.handler.size().height);
        this.font_height = 18;
        this.eq.setPointSize(this.font_height + 1);
        this.eq.use_controls = false;
        try {
            Parser p = (Parser)Class.forName("webeq.parser." + this.math_parser + "." + this.math_parser).newInstance();
            p.init(this.handler);
            p.parse(this.loadData(cl.getInputStream()), this.macros, this.eq.root, this.err);
            this.layout();
            this.getPilotViewport().getParent().getPilot().refresh();
        }
        catch (Exception e) {
            if (Debug.ex) {
                Debug.ex(e);
            }
            this.eq = null;
        }
    }

    private void layout() {
        try {
            this.eq.root.layout();
            this.eqWidth = this.eq.root.getWidth() + 2;
            this.eqHeight = this.eq.root.getHeight();
            this.eq.setSize(this.eqWidth, this.eqHeight);
            this.eq.directRedraw();
        }
        catch (Exception e) {
            if (Debug.ex) {
                Debug.ex(e);
            }
            this.eq = null;
        }
    }

    public int getWidth() {
        return this.eqWidth;
    }

    public int getHeight() {
        return this.eqHeight;
    }

    public void paint(Graphics g) {
        if (this.eq != null && this.eq.getImage() != null) {
            this.eq.paint(g);
        }
    }

    private final String loadData(InputStream inputStream) throws IOException {
        int pos = 0;
        byte[] tmp = new byte[2048];
        int r = inputStream.read(tmp, pos, tmp.length - pos);
        while (r > 0) {
            if ((pos += r) == tmp.length) {
                byte[] tt = new byte[tmp.length * 2];
                System.arraycopy(tmp, 0, tt, 0, tmp.length);
                tmp = tt;
            }
            r = inputStream.read(tmp, pos, tmp.length - pos);
        }
        inputStream.close();
        char[] buf = new char[pos];
        int i = 0;
        while (i < pos) {
            buf[i] = (char)tmp[i];
            ++i;
        }
        return new String(buf);
    }

    public ThePilot() {
        this.$init$();
    }
}

