/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.notsupported;

import ice.debug.Debug;
import ice.pilots.notsupported.LWComponent;
import ice.pilots.notsupported.MyComponent;
import ice.storm.ContentLoader;
import ice.storm.Hint;
import ice.storm.LPilot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;

public class ThePilot
extends LPilot {
    private MyComponent comp;
    private String contentType;
    private int width;
    private int height;
    private ContentLoader contentLoader;
    protected static final String noPilotMessage = "No pilot configured for";
    protected static final Color BACKGROUND_COLOR = new Color(230, 230, 230);
    protected static final Color BORDER_COLOR = Color.lightGray;
    protected static final Color MESSAGE_COLOR = Color.darkGray;
    protected static final Font MESSAGE_FONT = new Font("SanSerif", 0, 10);
    protected static FontMetrics fontMetrics;
    protected static int textHeight;
    private static Image defaultImage;
    private static final String DEFAULT_IMAGE_LOC = "res/pilot-error.gif";
    private static int defaultImageWidth;
    private static int defaultImageHeight;
    private static Image smallImage;
    private static final String SMALL_IMAGE_LOC = "res/pilot-error-small.gif";
    private static int smallImageWidth;
    private static int smallImageHeight;
    private static final Component OBSERVER;

    private void $init$() {
        this.comp = null;
        this.width = 32;
        this.height = 32;
    }

    static {
        textHeight = 12;
        defaultImageWidth = 0;
        defaultImageHeight = 0;
        smallImageWidth = 0;
        smallImageHeight = 0;
        OBSERVER = new LWComponent();
        ThePilot.init();
    }

    public void clear(String contentType) {
        this.contentType = contentType;
    }

    public void parse(ContentLoader cl) throws IOException {
        this.contentLoader = cl;
        this.contentType = this.contentLoader.getContentType();
        this.firePropertyChange("location", null, cl.getLocation());
        this.firePropertyChange("title", null, cl.getLocation());
        Hint hint = new Hint(this, cl);
        hint.setCustomDescription("No pilot configured for \"" + this.contentType + "\"");
        this.firePropertyChange("hint", null, hint);
        this.refreshViewport();
    }

    private static void init() {
        block2: {
            Toolkit kit = Toolkit.getDefaultToolkit();
            fontMetrics = kit.getFontMetrics(MESSAGE_FONT);
            textHeight = fontMetrics.getHeight();
            Class<ThePilot> pilotClass = ThePilot.class;
            URL imageURL = pilotClass.getResource(DEFAULT_IMAGE_LOC);
            defaultImage = kit.getImage(imageURL);
            imageURL = pilotClass.getResource(SMALL_IMAGE_LOC);
            smallImage = kit.getImage(imageURL);
            try {
                MediaTracker tracker = new MediaTracker(OBSERVER);
                tracker.addImage(defaultImage, 0);
                tracker.addImage(smallImage, 1);
                tracker.waitForAll();
                defaultImageWidth = defaultImage.getWidth(OBSERVER);
                defaultImageHeight = defaultImage.getHeight(OBSERVER);
                smallImageWidth = smallImage.getWidth(OBSERVER);
                smallImageHeight = smallImage.getHeight(OBSERVER);
            }
            catch (InterruptedException e) {
                if (!Debug.ex) break block2;
                Debug.ex(e);
            }
        }
    }

    public void paint(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(MESSAGE_FONT);
        g.setColor(BORDER_COLOR);
        g.fillRect(0, 0, this.width, 2);
        g.fillRect(this.width - 2, 0, 2, this.height);
        g.fillRect(0, this.height - 2, this.width, 2);
        g.fillRect(0, 0, 2, this.height);
        g.setColor(MESSAGE_COLOR);
        if (!this.tryDefaultImage(g) && !this.trySmallImage(g)) {
            g.drawString("?", 3, textHeight);
        }
    }

    private boolean trySmallImage(Graphics g) {
        if (smallImage == null) {
            return false;
        }
        int x = (this.width - smallImageWidth) / 2;
        int y = (this.height - smallImageHeight) / 2;
        g.drawImage(smallImage, x, y, OBSERVER);
        return true;
    }

    private boolean tryDefaultImage(Graphics g) {
        if (defaultImage == null) {
            return false;
        }
        int messageHeight = textHeight + defaultImageHeight;
        if (messageHeight >= this.height) {
            return false;
        }
        String ct = "'" + this.getSafeContentType() + "'";
        int noPilotMessageWidth = fontMetrics.stringWidth(noPilotMessage);
        int ctWidth = fontMetrics.stringWidth(ct);
        if (noPilotMessageWidth >= this.width || ctWidth >= this.width) {
            return false;
        }
        int x = (this.width - defaultImageWidth) / 2;
        int y = (this.height - messageHeight) / 2;
        g.drawImage(defaultImage, x, y, OBSERVER);
        x = (this.width - noPilotMessageWidth) / 2;
        y = y + defaultImageHeight + textHeight;
        g.drawString(noPilotMessage, x, y);
        x = (this.width - ctWidth) / 2;
        g.drawString(ct, x, y += textHeight);
        return true;
    }

    private String getSafeContentType() {
        if (this.contentType == null) {
            return "";
        }
        int charEnc = this.contentType.indexOf(";");
        if (charEnc < 0) {
            return this.contentType;
        }
        return this.contentType.substring(0, charEnc);
    }

    public Component createComponent() {
        if (this.comp != null) {
            return this.comp;
        }
        this.comp = new MyComponent(this);
        return this.comp;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public ThePilot() {
        this.$init$();
    }
}

