/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import ice.ri.common.dialog.SettingsDialogInterface;
import ice.ri.common.dialog.SettingsDialogPanelGroup;
import ice.ri.common.dialog.awt.AbstractSettingsDialogPanel;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractSettingsDialog
extends Dialog
implements SettingsDialogInterface,
ActionListener {
    public static final int OK_CANCEL_APPLY = 1;
    public static final int OK_CANCEL = 2;
    protected Vector panelGroups;
    protected Vector panels;
    private boolean hasChanged;
    protected int displayType;
    protected Frame parentFrame;
    protected Button okButton;
    protected Button applyButton;
    protected Button cancelButton;

    private void $init$() {
        this.displayType = 1;
    }

    public AbstractSettingsDialog(Frame parent, String title) {
        super(parent, title, true);
        this.$init$();
        this.parentFrame = parent;
        this.setupGUI();
    }

    private void setupGUI() {
        this.panelGroups = new Vector();
        this.panels = new Vector();
        this.hasChanged = false;
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new Button("Apply");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
    }

    public void showDialog() {
        this.setGui();
        this.pack();
        this.center();
        this.setVisible(true);
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setGui();
            this.pack();
            this.center();
        }
        super.setVisible(isVisible);
    }

    public void setButtonDisplay(int displayType) {
        this.displayType = displayType == 2 ? 2 : 1;
    }

    public int getButtonDisplay() {
        return this.displayType;
    }

    public abstract void setGui();

    public void setHasChanged(boolean value) {
        this.hasChanged = value;
        this.applyButton.setEnabled(value);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void add(SettingsDialogPanelGroup group) {
        this.panelGroups.addElement(group);
    }

    public void add(AbstractSettingsDialogPanel panel) {
        this.panels.addElement(panel);
    }

    public boolean save() {
        boolean isChanges = true;
        Enumeration panel = this.panels.elements();
        while (panel.hasMoreElements()) {
            AbstractSettingsDialogPanel tmp = (AbstractSettingsDialogPanel)panel.nextElement();
            if (!tmp.hasChanged()) continue;
            tmp.save();
        }
        Enumeration groups = this.panelGroups.elements();
        while (groups.hasMoreElements()) {
            SettingsDialogPanelGroup tmp = (SettingsDialogPanelGroup)groups.nextElement();
            Vector groupPanels = tmp.getPanels();
            Enumeration panels = groupPanels.elements();
            while (panels.hasMoreElements()) {
                AbstractSettingsDialogPanel tmp2 = (AbstractSettingsDialogPanel)panels.nextElement();
                if (!tmp2.hasChanged()) continue;
                tmp2.save();
            }
        }
        return isChanges;
    }

    public boolean cancel() {
        boolean isChanges = true;
        Enumeration panel = this.panels.elements();
        while (panel.hasMoreElements()) {
            AbstractSettingsDialogPanel tmp = (AbstractSettingsDialogPanel)panel.nextElement();
            if (!this.hasChanged) continue;
            tmp.cancel();
        }
        Enumeration groups = this.panelGroups.elements();
        while (groups.hasMoreElements()) {
            SettingsDialogPanelGroup tmp = (SettingsDialogPanelGroup)groups.nextElement();
            Vector groupPanels = tmp.getPanels();
            Enumeration panels = groupPanels.elements();
            while (panels.hasMoreElements()) {
                AbstractSettingsDialogPanel tmp2 = (AbstractSettingsDialogPanel)panels.nextElement();
                if (!this.hasChanged) continue;
                tmp2.cancel();
            }
        }
        return isChanges;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            if (this.hasChanged) {
                this.save();
            }
            this.setVisible(false);
            this.dispose();
        }
        if (cmd.equals("Apply") && this.hasChanged) {
            this.save();
            this.applyButton.setEnabled(false);
        }
        if (cmd.equals("Cancel")) {
            if (this.hasChanged) {
                this.cancel();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    protected void center() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.parentFrame.getSize();
        int x = this.parentFrame.getLocation().x + (frameDim.width - this.getSize().width) / 2;
        int y = this.parentFrame.getLocation().y + (frameDim.height - this.getSize().height) / 2;
        if (screenDim.width < x + this.getSize().width) {
            x = screenDim.width - this.getSize().width;
        }
        if (screenDim.height < y + this.getSize().height) {
            y = screenDim.height - this.getSize().height;
        }
        this.setLocation(x, y);
    }
}

