/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import java.awt.TextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class FormattedTextField
extends TextField {
    static final char ANYCHAR = '\u0000';
    static final char DIGIT = '\u0001';
    static final char LOWERCASE = '\u0002';
    static final char UPPERCASE = '\u0003';
    private String mask;
    private int index;
    private int len;
    private int lastIndex;
    private int startIndex;
    private boolean validate;

    public FormattedTextField(String mask, int nColumns, boolean _validate) {
        super(nColumns);
        this.validate = _validate;
        this.len = mask.length();
        StringBuffer mask2 = new StringBuffer(mask);
        int i = 0;
        while (i < this.len) {
            if (mask2.charAt(i) == 'c') {
                mask2.setCharAt(i, '\u0000');
            } else if (mask2.charAt(i) == '9') {
                mask2.setCharAt(i, '\u0001');
            } else if (mask2.charAt(i) == 'a') {
                mask2.setCharAt(i, '\u0002');
            } else if (mask2.charAt(i) == 'A') {
                mask2.setCharAt(i, '\u0003');
            }
            ++i;
        }
        mask = mask2.toString();
        boolean found = false;
        int i2 = 0;
        while (i2 < this.len) {
            if (mask.charAt(i2) == '\u0000' || mask.charAt(i2) == '\u0001' || mask.charAt(i2) == '\u0002' || mask.charAt(i2) == '\u0003' || mask.charAt(i2) == '_') {
                found = true;
                break;
            }
            ++i2;
        }
        if (!found) {
            throw new IllegalArgumentException("No mask characters found");
        }
        this.mask = mask;
        this.enableEvents(8);
        this.addFocusListener(new 1());
    }

    public void addNotify() {
        super.addNotify();
        StringBuffer mask2 = new StringBuffer(this.mask);
        int i = 0;
        while (i < this.len) {
            if (mask2.charAt(i) == '\u0000' || mask2.charAt(i) == '\u0001' || mask2.charAt(i) == '\u0002' || mask2.charAt(i) == '\u0003') {
                mask2.setCharAt(i, '_');
            }
            ++i;
        }
        String s = mask2.toString();
        this.setText(s);
        this.startIndex = this.index = s.indexOf(95);
        this.setCaretPosition(this.startIndex);
        this.lastIndex = s.lastIndexOf(95);
    }

    String getData() {
        String text = this.getText();
        if (text == null || text.length() != this.len) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.index) {
            if (this.mask.charAt(i) == '\u0000' || this.mask.charAt(i) == '\u0001' || this.mask.charAt(i) == '\u0002' || this.mask.charAt(i) == '\u0003' || this.mask.charAt(i) == '_') {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 8) {
            if (this.index == 0) {
                e.consume();
                return;
            }
            --this.index;
            StringBuffer sb = new StringBuffer(this.getText());
            do {
                if (sb.charAt(this.index) == this.mask.charAt(this.index)) {
                    --this.index;
                    continue;
                }
                sb.setCharAt(this.index, '_');
                this.setText(sb.toString());
                break;
            } while (this.index >= 0);
            if (this.index < 0) {
                this.index = this.startIndex;
            }
            this.setCaretPosition(this.index);
        }
        if (e.getID() == 401 || e.getID() == 402) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 || keyCode == 127 || keyCode == 40 || keyCode == 35 || keyCode == 36 || keyCode == 37 || keyCode == 39 || keyCode == 38) {
                e.consume();
                return;
            }
            super.processKeyEvent(e);
            return;
        }
        if (e.getID() == 400) {
            if (e.getKeyChar() == '\b' || this.index == this.len) {
                e.consume();
                return;
            }
            switch (this.mask.charAt(this.index)) {
                case '\u0001': {
                    if (Character.isDigit(e.getKeyChar())) break;
                    e.consume();
                    return;
                }
                case '\u0002': {
                    if (Character.isLowerCase(e.getKeyChar())) break;
                    e.consume();
                    return;
                }
                case '\u0003': {
                    if (Character.isUpperCase(e.getKeyChar())) break;
                    e.consume();
                    return;
                }
            }
            StringBuffer text = new StringBuffer(this.getText());
            text.setCharAt(this.index++, e.getKeyChar());
            this.setText(text.toString());
            this.setCaretPosition(this.index);
            while (this.index < this.len) {
                if (text.charAt(this.index) == '_') {
                    this.setCaretPosition(this.index);
                    break;
                }
                ++this.index;
            }
            e.consume();
        }
    }

    static boolean ra$validate(FormattedTextField formattedTextField) {
        return formattedTextField.validate;
    }

    static int ra$index(FormattedTextField formattedTextField) {
        return formattedTextField.index;
    }

    static int ra$startIndex(FormattedTextField formattedTextField) {
        return formattedTextField.startIndex;
    }

    static int ra$lastIndex(FormattedTextField formattedTextField) {
        return formattedTextField.lastIndex;
    }

    final class 1
    extends FocusAdapter {
        public void focusLost(FocusEvent e) {
            if (!FormattedTextField.ra$validate(FormattedTextField.this) || FormattedTextField.ra$index(FormattedTextField.this) == FormattedTextField.ra$startIndex(FormattedTextField.this)) {
                return;
            }
            if (FormattedTextField.ra$index(FormattedTextField.this) <= FormattedTextField.ra$lastIndex(FormattedTextField.this)) {
                FormattedTextField.this.requestFocus();
            }
        }
    }
}

