/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import java.awt.TextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class WholeNumberTextField
extends TextField {
    private int maxLength;

    public WholeNumberTextField(int value, int maxLength, int columns) {
        super(value + "", columns);
        this.maxLength = maxLength;
        this.enableEvents(8);
        this.addFocusListener(new 1());
    }

    private boolean checkValue() {
        boolean returnValue = true;
        String content = this.getText();
        if (content.length() != 0 && content.length() < this.maxLength) {
            try {
                Integer.parseInt(content);
            }
            catch (NumberFormatException e) {
                returnValue = false;
            }
        } else if (content.length() > 0) {
            this.setText(content.substring(0, this.maxLength));
        } else {
            this.setText("0");
        }
        return returnValue;
    }

    public int getValue() {
        return Integer.parseInt(this.getText());
    }

    public void setValue(int value) {
        this.setText(value + "");
    }

    protected void processKeyEvent(KeyEvent e) {
        char c = e.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' && c != '\n' && c != '\u007f') {
            this.getToolkit().beep();
            e.consume();
        }
    }

    static boolean mav$checkValue(WholeNumberTextField wholeNumberTextField) {
        return wholeNumberTextField.checkValue();
    }

    final class 1
    extends FocusAdapter {
        public void focusLost(FocusEvent e) {
            if (WholeNumberTextField.mav$checkValue(WholeNumberTextField.this)) {
                return;
            }
            WholeNumberTextField.this.requestFocus();
        }
    }
}

