/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print.swing;

import ice.debug.Debug;
import ice.pilots.text.ThePilot;
import ice.ri.common.dialog.swing.WholeNumberJTextField;
import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.PrintUtilities;
import ice.ri.common.print.swing.PageSetupDialog;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.w3c.dom.html.HTMLDocument;

public class PrintPreviewDialog
extends JDialog
implements WindowListener,
ActionListener,
ItemListener,
Runnable,
PropertyChangeListener {
    private PrintComponent printPreviewComponent;
    private JButton printButton;
    private JButton pageSetupButton;
    private JButton nextPageButton;
    private JButton prevPageButton;
    private JButton firstPageButton;
    private JButton lastPageButton;
    private JButton portraitButton;
    private JButton landscapeButton;
    private JButton closeButton;
    private JComboBox scaleComboBox;
    private JComboBox frameComboBox;
    private WholeNumberJTextField pageNumberTextField;
    private JLabel pageTotalLabel;
    private StormPrinter printer;
    private StormPageFormat stormPageFormat;
    private Vector viewports;
    private Viewport currentViewport;
    private Viewport mainViewport;
    private boolean isFrameset;
    private int zoom;
    private static final double[] scaleLevels = new double[]{0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.25, 1.5, 1.75, 2.0, 3.0};
    private JFrame parentFrame;
    private double scale;
    private double originalLayoutWidth;
    private int pageIndex;
    private JScrollPane scrollContainer;
    private int pagePadding;
    private static ResourceBundle messages = null;

    private void $init$() {
        this.scale = 1.0;
        this.originalLayoutWidth = 0.0;
        this.pageIndex = 0;
        this.pagePadding = 25;
    }

    public PrintPreviewDialog(JFrame parent, Viewport viewport, StormPageFormat storm_page_format) {
        super(parent, "", true);
        this.$init$();
        messages = parent != null ? ResourceBundle.getBundle("ice.ri.common.print.resources.MessageBundlePrint", parent.getLocale()) : ResourceBundle.getBundle("ice.ri.common.print.resources.MessageBundlePrint");
        this.stormPageFormat = (StormPageFormat)storm_page_format.clone();
        this.parentFrame = parent;
        this.mainViewport = viewport;
        this.viewports = new Vector(4, 2);
        this.mainViewport.getViewAndAllChildren(this.viewports);
        this.isFrameset = PrintUtilities.isFrameset(this.mainViewport);
        this.zoom = this.mainViewport.getZoom();
        int viewportIdx = this.getIndexOffset();
        if (viewportIdx == 0) {
            this.currentViewport = this.mainViewport;
            this.printer = this.currentViewport.getPilot().createPrinter();
        } else {
            this.currentViewport = (Viewport)this.viewports.elementAt(1);
            this.printer = this.currentViewport.getPilot().createPrinter();
            if (this.printer == null) {
                int len = this.viewports.size();
                int i = 1;
                while (i < len) {
                    this.currentViewport = (Viewport)this.viewports.elementAt(i);
                    this.printer = this.currentViewport.getPilot().createPrinter();
                    if (this.printer != null) break;
                    ++i;
                }
            }
        }
        PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
        this.setTitle(messages.getString("printPreview.title") + " " + this.getDocumentTitle(this.mainViewport));
        this.addWindowListener(this);
        if (this.printer != null) {
            this.originalLayoutWidth = this.printer.getDimension().width;
            PrintUtilities.adjustScale(this.stormPageFormat, this.originalLayoutWidth);
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.stormPageFormat.setImageableAreaChangedFlag(true);
        } else {
            Debug.trace("Pilot does not support printing !");
        }
    }

    public StormPageFormat showDialog() {
        this.setVisible(true);
        return this.stormPageFormat;
    }

    private void setGUI() {
        this.closeButton = new JButton(messages.getString("printPreview.close"));
        this.closeButton.addActionListener(this);
        this.closeButton.setMnemonic('C');
        this.nextPageButton = new JButton();
        this.nextPageButton = this.makeToolbarButton(messages.getString("printPreview.next.tooltip"), "forward");
        this.nextPageButton.addActionListener(this);
        this.prevPageButton = new JButton();
        this.prevPageButton = this.makeToolbarButton(messages.getString("printPreview.previous.tooltip"), "back");
        this.prevPageButton.addActionListener(this);
        this.firstPageButton = new JButton();
        this.firstPageButton = this.makeToolbarButton(messages.getString("printPreview.first.tooltip"), "first");
        this.firstPageButton.addActionListener(this);
        this.lastPageButton = new JButton();
        this.lastPageButton = this.makeToolbarButton(messages.getString("printPreview.last.tooltip"), "last");
        this.lastPageButton.addActionListener(this);
        this.printButton = new JButton(messages.getString("printPreview.print"));
        this.printButton.setMargin(new Insets(2, 6, 2, 6));
        this.printButton.addActionListener(this);
        this.printButton.setMnemonic('P');
        this.pageSetupButton = new JButton(messages.getString("printPreview.pageSetup"));
        this.pageSetupButton.setMargin(new Insets(2, 6, 2, 6));
        this.pageSetupButton.addActionListener(this);
        this.pageSetupButton.setMnemonic('S');
        this.portraitButton = new JButton();
        this.portraitButton.setIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/print/images/portrait.gif")));
        this.portraitButton.setToolTipText(messages.getString("printPreview.portrait"));
        this.portraitButton.setMargin(new Insets(0, 0, 0, 0));
        this.portraitButton.setRolloverEnabled(true);
        this.portraitButton.setBorderPainted(false);
        this.portraitButton.setBorder(BorderFactory.createEmptyBorder());
        this.portraitButton.setContentAreaFilled(true);
        this.portraitButton.setFocusPainted(true);
        this.portraitButton.addActionListener(this);
        this.portraitButton.setMnemonic('o');
        this.landscapeButton = new JButton();
        this.landscapeButton.setIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/print/images/landscape.gif")));
        this.landscapeButton.setToolTipText(messages.getString("printPreview.landscape"));
        this.landscapeButton.setMargin(new Insets(0, 0, 0, 0));
        this.landscapeButton.setRolloverEnabled(true);
        this.landscapeButton.setBorderPainted(false);
        this.landscapeButton.setBorder(BorderFactory.createEmptyBorder());
        this.landscapeButton.setContentAreaFilled(true);
        this.landscapeButton.setFocusPainted(true);
        this.landscapeButton.addActionListener(this);
        this.landscapeButton.setMnemonic('l');
        this.pageNumberTextField = new WholeNumberJTextField(this.pageIndex + 1, 5, 3);
        this.pageNumberTextField.addActionListener(this);
        this.pageTotalLabel = new JLabel(" " + messages.getString("printPreview.pageOfPage") + " " + this.printer.getPageCount());
        this.scaleComboBox = new JComboBox();
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.30"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.40"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.50"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.60"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.70"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.80"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.90"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.100"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.125"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.150"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.175"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.200"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scale.300"));
        this.scaleComboBox.addItem(messages.getString("printPreview.scaleToFit"));
        this.setScaleComboBoxSelection();
        this.scaleComboBox.addItemListener(this);
        this.printer.setStormPageFormat(this.stormPageFormat);
        this.stormPageFormat.setImageableAreaChangedFlag(true);
        this.frameComboBox = new JComboBox();
        this.buildAndUpdateFrameSelection();
        this.frameComboBox.addItemListener(this);
        this.printPreviewComponent = new PrintComponent(this.printer);
        JPanel tmp = new JPanel(true);
        tmp.add(this.printPreviewComponent);
        this.scrollContainer = new JScrollPane(tmp);
        this.scrollContainer.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollContainer.getHorizontalScrollBar().setUnitIncrement(20);
        this.scrollContainer.setBackground(Color.gray);
        FlowLayout flowLayout = new FlowLayout(1);
        flowLayout.setHgap(0);
        flowLayout.setVgap(2);
        JPanel previewControlPanel = new JPanel(flowLayout);
        if (this.isFrameset) {
            previewControlPanel.add(this.frameComboBox);
            previewControlPanel.add(new JLabel("  "));
        }
        previewControlPanel.setBorder(BorderFactory.createEtchedBorder(1));
        previewControlPanel.add(this.printButton);
        previewControlPanel.add(new JLabel("  "));
        previewControlPanel.add(this.pageSetupButton);
        previewControlPanel.add(this.firstPageButton);
        previewControlPanel.add(this.prevPageButton);
        previewControlPanel.add(this.pageNumberTextField);
        previewControlPanel.add(this.pageTotalLabel);
        previewControlPanel.add(this.nextPageButton);
        previewControlPanel.add(this.lastPageButton);
        previewControlPanel.add(this.scaleComboBox);
        previewControlPanel.add(this.portraitButton);
        previewControlPanel.add(this.landscapeButton);
        JPanel contentPanel = new JPanel(true);
        this.setContentPane(contentPanel);
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)previewControlPanel, "North");
        contentPanel.add((Component)this.scrollContainer, "Center");
        this.setSize(this.parentFrame.getWidth(), this.parentFrame.getHeight());
        this.setLocation(this.parentFrame.getLocation().x + 20, this.parentFrame.getLocation().y + 20);
    }

    private void buildAndUpdateFrameSelection() {
        if (this.frameComboBox.getItemCount() > 0) {
            this.frameComboBox.removeAllItems();
        }
        if (!this.isFrameset || this.stormPageFormat.getFramePrintFormat() == 3) {
            this.frameComboBox.addItem("Main frame");
            this.frameComboBox.setEnabled(false);
        } else if (this.isFrameset && this.stormPageFormat.getFramePrintFormat() == 1) {
            if (!this.frameComboBox.isEnabled()) {
                this.frameComboBox.setEnabled(true);
            }
            int n = this.viewports.size();
            int i = 1;
            while (i < n) {
                Viewport tmp = (Viewport)this.viewports.elementAt(i);
                this.frameComboBox.addItem("Frame " + tmp.getId());
                ++i;
            }
        }
    }

    private JButton makeToolbarButton(String toolTip, String imageName) {
        JButton tmp = new JButton("");
        tmp.setToolTipText(toolTip);
        tmp.setIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/print/images/" + imageName + "_n.gif")));
        tmp.setPressedIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/print/images/" + imageName + "_d.gif")));
        tmp.setRolloverIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/print/images/" + imageName + "_r.gif")));
        tmp.setDisabledIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/print/images/" + imageName + "_d.gif")));
        tmp.setMargin(new Insets(0, 0, 0, 0));
        tmp.setRolloverEnabled(true);
        tmp.setBorderPainted(false);
        tmp.setBorder(BorderFactory.createEmptyBorder());
        tmp.setContentAreaFilled(true);
        tmp.setFocusPainted(true);
        return tmp;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.printer == null) {
                this.dispose();
            } else {
                this.setGUI();
            }
        }
        if (this.printer != null) {
            super.setVisible(visible);
            this.scrollContainer.repaint();
        }
    }

    public void dispose() {
        int aZoom;
        if (this.printer != null) {
            this.printer.dispose();
        }
        this.mainViewport.setZoom((aZoom = this.zoom - 1) > 0 ? aZoom : this.zoom + 1);
        this.mainViewport.setZoom(this.zoom);
        if (super.getParent() != null) {
            super.getParent().validate();
            super.getParent().repaint();
        }
        super.dispose();
    }

    public void run() {
        RepaintManager currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(false);
        PrintHelper printHelper = PrintUtilities.getPrintHelper(this.mainViewport, this.stormPageFormat);
        printHelper.print(this.parentFrame);
        currentManager.setDoubleBufferingEnabled(true);
        PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
        if (this.printer != null) {
            this.printer.dispose();
        }
        this.printer = this.currentViewport.getPilot().createPrinter();
        if (this.printer != null) {
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.printPreviewComponent.setPrinter(this.printer);
            this.printPreviewComponent.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.nextPageButton) {
            this.pageIndex = this.printer.getPageIndex();
            ++this.pageIndex;
            this.printer.setPageIndex(this.pageIndex);
        } else if (e.getSource() == this.prevPageButton) {
            this.pageIndex = this.printer.getPageIndex();
            --this.pageIndex;
            this.printer.setPageIndex(this.pageIndex);
        } else if (e.getSource() == this.firstPageButton) {
            this.pageIndex = 0;
            this.printer.setPageIndex(this.pageIndex);
        } else if (e.getSource() == this.lastPageButton) {
            this.pageIndex = this.printer.getPageCount() - 1;
            this.printer.setPageIndex(this.pageIndex);
        } else {
            int value;
            if (e.getSource() == this.printButton) {
                Thread doSwingWork = new Thread((Runnable)this, "printer-thread");
                SwingUtilities.invokeLater(doSwingWork);
                return;
            }
            if (e.getSource() == this.pageSetupButton) {
                PageSetupDialog pageSetup = new PageSetupDialog(this.parentFrame, this.mainViewport, this.stormPageFormat);
                StormPageFormat pageFormat = pageSetup.showDialog();
                if (pageFormat.getFramePrintFormat() != this.stormPageFormat.getFramePrintFormat()) {
                    this.stormPageFormat = pageFormat;
                    this.frameComboBox.removeItemListener(this);
                    this.buildAndUpdateFrameSelection();
                    this.frameComboBox.setSelectedIndex(0);
                    this.setNewPreviewViewport(this.frameComboBox.getSelectedIndex() + this.getIndexOffset());
                    PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
                    this.frameComboBox.addItemListener(this);
                } else {
                    this.stormPageFormat = pageFormat;
                }
                this.setScaleComboBoxSelection();
                this.printer.setStormPageFormat(this.stormPageFormat);
                this.printPreviewComponent.setPrinter(this.printer);
                this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
            } else if (e.getSource() == this.portraitButton) {
                if (this.stormPageFormat.getOrientation() != 1) {
                    this.stormPageFormat.setOrientation(1);
                    this.stormPageFormat.setScale(this.getZoomComboBoxZoom(this.scaleComboBox.getSelectedIndex()));
                    this.printer.setStormPageFormat(this.stormPageFormat);
                    this.pageIndex = 0;
                    this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
                }
            } else if (e.getSource() == this.landscapeButton) {
                if (this.stormPageFormat.getOrientation() != 0) {
                    this.stormPageFormat.setOrientation(0);
                    this.stormPageFormat.setScale(this.getZoomComboBoxZoom(this.scaleComboBox.getSelectedIndex()));
                    this.printer.setStormPageFormat(this.stormPageFormat);
                    this.pageIndex = 0;
                    this.printPreviewComponent.setPrinter(this.printer);
                    this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
                }
            } else if (e.getSource() == this.pageNumberTextField && (value = this.pageNumberTextField.getValue()) >= 1 && value <= this.printer.getPageCount()) {
                this.pageIndex = value - 1;
                this.printer.setPageIndex(this.pageIndex);
            }
        }
        this.updateNavigationText();
        this.printPreviewComponent.setPageComponentDirty();
        this.scrollContainer.repaint();
    }

    private int getIndexOffset() {
        int offset = 0;
        if (this.isFrameset && this.viewports.size() > 1 && this.stormPageFormat.getFramePrintFormat() == 1) {
            offset = 1;
        }
        return offset;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.scaleComboBox) {
            this.scale = this.getZoomComboBoxZoom(this.scaleComboBox.getSelectedIndex());
            this.stormPageFormat.setScale(this.scale);
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.pageIndex = 0;
        } else if (e.getSource() == this.frameComboBox) {
            this.setNewPreviewViewport(this.frameComboBox.getSelectedIndex() + this.getIndexOffset());
            PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
        }
        this.updateNavigationText();
        this.printPreviewComponent.setPageComponentDirty();
        this.scrollContainer.repaint();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        String val = "";
        if (e.getNewValue() instanceof String) {
            val = (String)e.getNewValue();
        }
        if (name.equals("contentRendering") && val.equals("finished")) {
            this.stormPageFormat.setImageableAreaChangedFlag(true);
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.updateTotalPageText();
            this.printPreviewComponent.setPageComponentDirty();
            this.scrollContainer.validate();
            this.scrollContainer.repaint();
        }
    }

    private void setNewPreviewViewport(int viewportIndex) {
        this.pageIndex = 0;
        this.currentViewport = (Viewport)this.viewports.elementAt(viewportIndex);
        StormPrinter tmpPrinter = this.currentViewport.getPilot().createPrinter();
        if (tmpPrinter != null) {
            this.printer.dispose();
            this.printer = tmpPrinter;
            this.originalLayoutWidth = this.printer.getDimension().width;
            this.stormPageFormat.setScale(this.getZoomComboBoxZoom(this.scaleComboBox.getSelectedIndex()));
            this.stormPageFormat.setSelectedViewportIndex(viewportIndex);
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.printPreviewComponent.setPrinter(this.printer);
            this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
            this.scrollContainer.repaint();
        } else {
            Debug.trace("Pilot does not support printing !");
        }
    }

    private void setScaleComboBoxSelection() {
        if (this.stormPageFormat.isScaleToFitEnabled()) {
            this.scaleComboBox.setSelectedIndex(13);
        } else {
            double scale = (double)Math.round(this.stormPageFormat.getScale() * 100.0) / 100.0;
            boolean found = false;
            int i = 0;
            while (i < scaleLevels.length) {
                if (scale == scaleLevels[i]) {
                    this.scaleComboBox.setSelectedIndex(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.scaleComboBox.setSelectedIndex(7);
                this.stormPageFormat.setScale(1.0);
            }
        }
    }

    private double getZoomComboBoxZoom(int index) {
        if (index >= 0 && index < scaleLevels.length) {
            this.stormPageFormat.setScaleToFitEnabled(false);
            return scaleLevels[index];
        }
        this.stormPageFormat.setScaleToFitEnabled(true);
        this.scale = this.originalLayoutWidth > this.stormPageFormat.getImageableWidth() ? 1.0 / this.originalLayoutWidth * this.stormPageFormat.getImageableWidth() : 1.0;
        return this.scale;
    }

    private String getDocumentTitle(Viewport viewport) {
        Pilot tmp = viewport.getPilot();
        if (tmp instanceof ice.pilots.html4.ThePilot) {
            ice.pilots.html4.ThePilot pilot = (ice.pilots.html4.ThePilot)tmp;
            HTMLDocument doc = (HTMLDocument)pilot.getDocument();
            return doc.getTitle();
        }
        if (tmp instanceof ThePilot) {
            return "Text Pilot";
        }
        if (tmp instanceof ice.pilots.image.ThePilot) {
            return "Image Pilot";
        }
        return "";
    }

    private void updateNavigationText() {
        this.pageNumberTextField.setValue(this.printer.getPageIndex() + 1);
        this.pageTotalLabel.setText(" of " + this.printer.getPageCount());
    }

    private void updateTotalPageText() {
        this.pageTotalLabel.setText(" of " + this.printer.getPageCount());
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.printer.dispose();
        this.dispose();
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    static int ra$pageIndex(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.pageIndex;
    }

    static JScrollPane ra$scrollContainer(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.scrollContainer;
    }

    static int ra$pagePadding(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.pagePadding;
    }

    class PrintComponent
    extends JComponent {
        private StormPrinter printer;
        private StormPageFormat pageFormat;
        private Image pageImage;
        private boolean pageImageDirty;

        private void $init$() {
            this.pageImageDirty = true;
        }

        PrintComponent(StormPrinter p) {
            this.$init$();
            this.printer = p;
            this.pageFormat = p.getStormPageFormat();
            this.setSize(new Dimension((int)this.pageFormat.getPageWidth() + 25, (int)this.pageFormat.getPageHeight() + 25));
        }

        public void setPrinter(StormPrinter p) {
            this.printer = p;
            this.pageFormat = p.getStormPageFormat();
        }

        public int getWidth() {
            return (int)this.pageFormat.getPageWidth() + 25;
        }

        public int getHeight() {
            return (int)this.pageFormat.getPageHeight() + 25;
        }

        public Dimension getPreferredSize() {
            this.setPreferredSize(new Dimension((int)this.pageFormat.getPageWidth() + PrintPreviewDialog.ra$pagePadding(PrintPreviewDialog.this), (int)this.pageFormat.getPageHeight() + PrintPreviewDialog.ra$pagePadding(PrintPreviewDialog.this)));
            return super.getPreferredSize();
        }

        public Dimension getSize() {
            this.setSize(new Dimension((int)this.pageFormat.getPageWidth() + PrintPreviewDialog.ra$pagePadding(PrintPreviewDialog.this), (int)this.pageFormat.getPageHeight() + PrintPreviewDialog.ra$pagePadding(PrintPreviewDialog.this)));
            return super.getSize();
        }

        public void paintComponent(Graphics g) {
            PrintPreviewDialog.ra$scrollContainer(PrintPreviewDialog.this).repaint();
            this.paint(g);
        }

        public void setPageComponentDirty() {
            this.pageImageDirty = true;
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension componentSize = this.getSize();
            double x = 0.0;
            double y = 0.0;
            if (this.pageFormat.getPageWidth() < (double)componentSize.width) {
                x = ((double)componentSize.width - this.pageFormat.getPageWidth()) / 2.0;
            }
            if (this.pageFormat.getPageHeight() < (double)componentSize.height) {
                y = ((double)componentSize.height - this.pageFormat.getPageHeight()) / 2.0;
            }
            g2d.setColor(Color.white);
            g2d.fillRect((int)x, (int)y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            if (this.pageImageDirty) {
                this.pageImage = this.createImage((int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
                Graphics imageGraphics = this.pageImage.getGraphics();
                imageGraphics.setColor(Color.white);
                imageGraphics.fillRect(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
                this.printer.printPage(imageGraphics, PrintPreviewDialog.ra$pageIndex(PrintPreviewDialog.this));
                imageGraphics.dispose();
                this.pageImageDirty = false;
            }
            Graphics2D gg = (Graphics2D)g2d.create((int)x, (int)y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            gg.drawImage(this.pageImage, 0, 0, this);
            gg.dispose();
            g2d.setColor(Color.lightGray);
            g2d.drawRect((int)(x + this.pageFormat.getMargin(2)), (int)(y + this.pageFormat.getMargin(1)), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            int shadowsize = 3;
            g2d.setColor(Color.black);
            g2d.drawRect((int)x, (int)y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            g2d.fillRect((int)(x + this.pageFormat.getPageWidth()), (int)(y + (double)shadowsize), shadowsize, (int)this.pageFormat.getPageHeight());
            g2d.fillRect((int)(x + (double)shadowsize), (int)(y + this.pageFormat.getPageHeight()), (int)this.pageFormat.getPageWidth() - shadowsize, shadowsize);
            PrintPreviewDialog.ra$scrollContainer(PrintPreviewDialog.this).validate();
        }
    }
}

