/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.pilots.html4.ThePilot;
import ice.ri.swing.AboutDialog;
import ice.ri.swing.Bookmark;
import ice.ri.swing.BrowserWindow;
import ice.ri.swing.MouseManager;
import ice.ri.swing.SourceWindow;
import ice.storm.CallbackAdapter;
import ice.storm.Pilot;
import ice.storm.Viewport;
import java.awt.Container;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class ActionHelper
implements ActionListener,
PropertyChangeListener {
    static final int BACK = 1;
    static final int FORWARD = 2;
    static final int RELOAD = 3;
    static final int STOP = 4;
    static final int PRINT_VIEWPORT = 5;
    static final int OPEN_URL = 6;
    static final int OPEN_FILE = 7;
    static final int SET_HOME = 9;
    static final int GOTO_HOME = 10;
    static final int ENCODING = 11;
    static final int QUIT = 12;
    static final int SAVE_CURRENT = 13;
    static final int NEW_WINDOW = 14;
    static final int FONTS = 15;
    static final int SOURCE = 16;
    static final int CONSOLE = 17;
    static final int CLOSE = 18;
    static final int HELP_INDEX = 19;
    static final int ABOUT = 22;
    static final int BOOKMARK_ADD = 23;
    static final int BOOKMARK_MANAGE = 24;
    static final int L_AND_F = 25;
    static final int GOTO_LOGO = 26;
    static final int SEARCH = 28;
    static final int GOTO_SEARCH = 29;
    static final int GOTO_HELP = 30;
    static final int DOM = 31;
    static final int PRINT_PREVIEW = 32;
    static final int PRINT_SETUP = 33;
    static final int COPY = 34;
    static final int PASTE = 35;
    static final int EMULATION = 36;
    static final int BOOKMARK_ITEM = 100;
    static final int POPUP_OPEN_LINK = 200;
    static final int POPUP_SAVE_LINK = 201;
    static final int POPUP_BOOKMARK_LINK = 202;
    static final int POPUP_CLIPBOARD_LINK = 203;
    static final int POPUP_NEW_WND_LINK = 204;
    int id;
    BrowserWindow parent;
    private AbstractButton target;
    private Bookmark bookmark_elem;
    private MouseManager popup_mouseManager;

    private static void throwBadId(int id, String reason) {
        throw new IllegalArgumentException("id " + id + reason);
    }

    private ActionHelper(int id, BrowserWindow browserWindow) {
        this.id = id;
        this.parent = browserWindow;
    }

    ActionHelper(int id, AbstractButton a, BrowserWindow browserWindow) throws IllegalArgumentException {
        this(id, browserWindow);
        this.target = a;
        switch (id) {
            case 1: {
                this.parent.mainview.addPropertyChangeListener(this);
                break;
            }
            case 2: {
                this.parent.mainview.addPropertyChangeListener(this);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.parent.mainview.addPropertyChangeListener(this);
                break;
            }
            case 26: {
                this.parent.mainview.addPropertyChangeListener(this);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            default: {
                ActionHelper.throwBadId(id, " is not a valid button id");
            }
        }
        this.target.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ev) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.target != null) {
            this.target.transferFocus();
        }
        switch (this.id) {
            case 34: {
                this.parent.copy();
                break;
            }
            case 35: {
                this.parent.paste();
                break;
            }
            case 1: {
                this.parent.goBack();
                break;
            }
            case 2: {
                this.parent.goForward();
                break;
            }
            case 3: {
                this.parent.reload();
                break;
            }
            case 4: {
                this.parent.htmlInterrupt();
                break;
            }
            case 32: {
                this.parent.displayPrintPreviewDialog();
                break;
            }
            case 5: {
                this.parent.printViewport();
                break;
            }
            case 33: {
                this.parent.displayPageSetupDialog();
                break;
            }
            case 6: {
                this.parent.locationBar.cb.getEditor().getEditorComponent().requestFocus();
                break;
            }
            case 7: {
                this.parent.windowManager.getDialogs().showOpenFile(this.parent);
                break;
            }
            case 9: {
                this.parent.properties.set("home.location", this.parent.getCurrentLocation());
                break;
            }
            case 10: {
                this.gotoURL(this.parent.properties.getString("home.location"));
                break;
            }
            case 29: {
                this.gotoURL(this.parent.properties.getString("search.location"));
                break;
            }
            case 30: {
                this.gotoURL(this.parent.res.helpURL("index.html"));
                break;
            }
            case 11: {
                this.parent.windowManager.getDialogs().showEncoding(this.parent);
                break;
            }
            case 12: {
                this.parent.windowManager.quit();
                break;
            }
            case 13: {
                if (!(this.parent.mainview.getPilot() instanceof ThePilot)) break;
                this.parent.windowManager.getDialogs().showSaveAs(this.parent);
                break;
            }
            case 14: {
                this.parent.windowManager.newWindow();
                break;
            }
            case 15: {
                this.parent.windowManager.getDialogs().showFonts(this.parent);
                break;
            }
            case 16: {
                if (!(this.parent.mainview.getPilot() instanceof ThePilot)) break;
                new SourceWindow(this.parent);
                break;
            }
            case 31: {
                String targetViewport;
                if (!(this.parent.mainview.getPilot() instanceof ThePilot) || (targetViewport = this.parent.mainview.getId()) == null) break;
                String domLink = "dom:" + targetViewport;
                this.parent.windowManager.newWindow(domLink);
                break;
            }
            case 18: {
                this.parent.closeWindow();
                break;
            }
            case 17: {
                this.parent.windowManager.showJavaConsole();
                break;
            }
            case 19: {
                this.gotoURL(this.parent.res.helpURL("index.html"));
                break;
            }
            case 22: {
                new AboutDialog(this.parent.windowManager, "startmessage.body", true, 2, 0).setVisible(true);
                break;
            }
            case 23: {
                this.parent.windowManager.addBookmark(this.parent.urlTitle, this.parent.getCurrentLocation());
                break;
            }
            case 24: {
                this.parent.windowManager.getDialogs().showBookmarkManager(this.parent);
                break;
            }
            case 25: {
                this.parent.windowManager.getDialogs().showLookAndFeel(this.parent);
                break;
            }
            case 26: {
                this.gotoURL(this.parent.properties.getString("toolbar.logo.link"));
                break;
            }
            case 36: {
                this.parent.windowManager.getDialogs().showEmulation(this.parent);
                break;
            }
            case 28: {
                this.parent.searchBar.setVisible(true);
                break;
            }
            default: {
                boolean processed = false;
                if (!processed) {
                    processed = this.bookmark_actionPerformed();
                }
                if (processed) break;
                processed = this.popup_actionPerformed();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        switch (this.id) {
            case 1: {
                String newValue;
                if (!name.equals("history") || !(newValue = (String)ev.getNewValue()).equals("modified")) break;
                boolean hasHistory = this.parent.hasBackHistory();
                this.setButtonStatus(this.target, hasHistory);
                break;
            }
            case 2: {
                String newValue;
                if (!name.equals("history") || !(newValue = (String)ev.getNewValue()).equals("modified")) break;
                boolean hasHistory = this.parent.hasForwardHistory();
                this.setButtonStatus(this.target, hasHistory);
                break;
            }
            case 4: {
                String s;
                if (name.equals("contentLoading")) {
                    Viewport view;
                    Pilot pilot;
                    String s2 = (String)ev.getNewValue();
                    if (s2.equals("request")) {
                        this.setButtonStatus(this.target, true);
                        break;
                    }
                    if (s2.equals("error") || s2.equals("stop")) {
                        this.setButtonStatus(this.target, false);
                        break;
                    }
                    if (!s2.equals("end") || (pilot = (view = (Viewport)ev.getSource()).getPilot()) instanceof ThePilot) break;
                    this.setButtonStatus(this.target, false);
                    break;
                }
                if (!name.equals("contentRendering") || !(s = (String)ev.getNewValue()).equals("finished")) break;
                this.setButtonStatus(this.target, false);
                break;
            }
            case 26: {
                String s;
                if (name.equals("contentLoading")) {
                    Viewport view;
                    Pilot pilot;
                    String s3 = (String)ev.getNewValue();
                    if (s3.equals("request")) {
                        this.parent.setActivityThrobberStatus(true);
                        break;
                    }
                    if (s3.equals("error") || s3.equals("stop")) {
                        this.parent.setActivityThrobberStatus(false);
                        break;
                    }
                    if (!s3.equals("end") || (pilot = (view = (Viewport)ev.getSource()).getPilot()) instanceof ThePilot) break;
                    this.parent.setActivityThrobberStatus(false);
                    break;
                }
                if (!name.equals("contentRendering") || !(s = (String)ev.getNewValue()).equals("finished")) break;
                this.parent.setActivityThrobberStatus(false);
                break;
            }
        }
    }

    private void setButtonStatus(AbstractButton target, boolean hasHistory) {
        if (target.isEnabled() != hasHistory) {
            if (SwingUtilities.isEventDispatchThread()) {
                target.setEnabled(hasHistory);
            } else {
                1 doWorkRunnable = new 1(this, target, hasHistory);
                SwingUtilities.invokeLater(doWorkRunnable);
            }
        }
    }

    private void gotoURL(URL url) {
        if (url != null) {
            this.parent.gotoLocation(url.toString());
        }
    }

    private void gotoURL(String url) {
        if (url != null) {
            this.parent.gotoLocation(url);
        }
    }

    static ActionHelper forBookmark(int id, BrowserWindow browserWindow, JMenuItem item, Bookmark bookmark) {
        if (id != 100) {
            ActionHelper.throwBadId(id, " is not a valid bookamark-type id");
        }
        ActionHelper helper = new ActionHelper(id, browserWindow);
        helper.bookmark_elem = bookmark;
        item.addActionListener(helper);
        return helper;
    }

    private boolean bookmark_actionPerformed() {
        boolean result = true;
        if (this.id == 100) {
            this.gotoURL(this.bookmark_elem.url);
        } else {
            result = false;
        }
        return result;
    }

    static ActionHelper forPopup(int id, MouseManager mouseManager, AbstractButton item) {
        switch (id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                break;
            }
            default: {
                ActionHelper.throwBadId(id, " is not a valid popup-type id");
            }
        }
        ActionHelper helper = new ActionHelper(id, mouseManager.browserWindow);
        item.addActionListener(helper);
        helper.popup_mouseManager = mouseManager;
        return helper;
    }

    private boolean popup_actionPerformed() {
        String link = this.popup_mouseManager.popup_link;
        switch (this.id) {
            case 200: {
                if (link == null) break;
                this.parent.gotoLocation(link, this.popup_mouseManager.popup_targetFrame, this.popup_mouseManager.popup_outputString);
                break;
            }
            case 201: {
                if (link == null) break;
                this.parent.windowManager.getDialogs().showSaveURL(this.parent, link);
                break;
            }
            case 202: {
                if (link == null) break;
                this.parent.windowManager.addBookmark(link, link);
                break;
            }
            case 203: {
                if (link == null) break;
                Clipboard clipboard = this.parent.res.getToolkit().getSystemClipboard();
                StringSelection data = new StringSelection(link);
                clipboard.setContents(data, data);
                break;
            }
            case 204: {
                if (link == null) break;
                this.parent.windowManager.newWindow(link);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ AbstractButton v$target;
        private final /* synthetic */ boolean v$hasHistory;
        final /* synthetic */ ActionHelper this$0;

        public void run() {
            this.v$target.setEnabled(this.v$hasHistory);
        }

        public 1(ActionHelper actionHelper, AbstractButton abstractButton, boolean bl) {
            this.v$hasHistory = bl;
            this.v$target = abstractButton;
            this.this$0 = actionHelper;
        }
    }

    class MyCallbackView
    extends CallbackAdapter {
        private Viewport viewport;

        public Container createTopLevelContainer(Viewport viewport) {
            this.viewport = viewport;
            return new JPanel();
        }

        public void disposeTopLevelContainer(Viewport viewport) {
            viewport = null;
            this.viewport = null;
        }

        public String getViewPortName() {
            return this.viewport.getId();
        }

        public Viewport getViewPort() {
            return this.viewport;
        }

        MyCallbackView() {
        }
    }
}

