/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.BrowserWindow;
import ice.ri.swing.Net;
import ice.ri.swing.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

final class LocationBar
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final Color HTTPS_BG_COLOR = new Color(248, 206, 126);
    private static final Color HTTPS_FG_COLOR = Color.black;
    private BrowserWindow window;
    JComboBox cb;
    private JButton goButton;
    private boolean cbJustEditedFlag;
    private boolean isHttps;

    public LocationBar(BrowserWindow bw, boolean showGoButton) {
        this.window = bw;
        Resources res = bw.res;
        JLabel l = new JLabel(res.str("locationbar.location") + ": ");
        l.setAlignmentY(0.5f);
        this.cb = new JComboBox();
        this.cb.setAlignmentY(0.5f);
        this.cb.setMinimumSize(new Dimension(0, this.cb.getMinimumSize().height));
        this.cb.setEditable(true);
        this.cb.addActionListener(this);
        this.cb.getEditor().getEditorComponent().addFocusListener(new 1());
        this.cb.getEditor().getEditorComponent().addKeyListener(new 2());
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.add(l);
        this.add(this.cb);
        if (showGoButton) {
            ImageIcon i = res.imageIcon(this.getToolkit(), "ibicone16.gif");
            this.goButton = new JButton();
            this.goButton.setIcon(i);
            this.goButton.setFocusPainted(true);
            this.goButton.setBorderPainted(false);
            this.goButton.setToolTipText(res.str("tooltip.goButton").trim() + " " + res.str("locationbar.location").trim());
            this.goButton.setPreferredSize(new Dimension(i.getIconWidth() + 8, i.getIconHeight()));
            this.goButton.setAlignmentY(0.5f);
            this.goButton.addActionListener(this);
            this.add(this.goButton);
        }
        this.window.mainview.addPropertyChangeListener(this);
        this.requestFocus();
    }

    private void gotoEnteredLocation() {
        String newLoc = (String)this.cb.getEditor().getItem();
        if (newLoc != null) {
            if (!newLoc.regionMatches(true, 0, "javascript:", 0, 11)) {
                URL u = Net.checkURL(newLoc, this.window.res);
                if (u == null) {
                    return;
                }
                newLoc = u.toString();
            }
            this.cbJustEditedFlag = true;
            this.window.gotoLocation(newLoc);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.goButton) {
            this.gotoEnteredLocation();
        }
    }

    private void addItemToLocationList(String newLoc) {
        this.cb.removeItem(newLoc);
        this.cb.insertItemAt(newLoc, 0);
        int itemCount = this.cb.getItemCount();
        if (itemCount >= 100) {
            this.cb.removeItemAt(itemCount);
        }
        this.cb.setSelectedIndex(0);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        if (name.equals("location") && this.window.isTopFrameEvent(ev)) {
            String newLocation = ev.getNewValue() == null ? "" : (String)ev.getNewValue();
            if (SwingUtilities.isEventDispatchThread()) {
                this.setLocationText(newLocation);
            } else {
                3 doSwingWork = new 3(this, newLocation);
                SwingUtilities.invokeLater(doSwingWork);
            }
        }
    }

    private void setLocationText(String newLocation) {
        if (newLocation.startsWith("https:") != this.isHttps) {
            Component ec = this.cb.getEditor().getEditorComponent();
            this.isHttps ^= true;
            if (this.isHttps) {
                ec.setBackground(HTTPS_BG_COLOR);
                ec.setForeground(HTTPS_FG_COLOR);
            } else {
                Color bg = UIManager.getColor("TextField.background");
                Color fg = UIManager.getColor("TextField.foreground");
                if (bg == null) {
                    bg = Color.white;
                }
                if (fg == null) {
                    fg = Color.black;
                }
                ec.setBackground(bg);
                ec.setForeground(fg);
            }
        }
        if (this.cbJustEditedFlag) {
            this.addItemToLocationList(newLocation);
            this.cbJustEditedFlag = false;
        } else {
            this.cb.getEditor().setItem(newLocation);
        }
    }

    static void mav$setLocationText(LocationBar locationBar, String string) {
        locationBar.setLocationText(string);
    }

    static void mav$gotoEnteredLocation(LocationBar locationBar) {
        locationBar.gotoEnteredLocation();
    }

    static BrowserWindow ra$window(LocationBar locationBar) {
        return locationBar.window;
    }

    final class 1
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            LocationBar.this.cb.getEditor().selectAll();
        }

        public void focusLost(FocusEvent e) {
        }
    }

    final class 2
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 10: {
                    LocationBar.mav$gotoEnteredLocation(LocationBar.this);
                    break;
                }
                case 27: {
                    LocationBar.this.cb.getEditor().setItem(LocationBar.ra$window(LocationBar.this).getCurrentLocation());
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ String v$newLocation;
        final /* synthetic */ LocationBar this$0;

        public void run() {
            LocationBar.mav$setLocationText(this.this$0, this.v$newLocation);
        }

        public 3(LocationBar locationBar, String string) {
            this.v$newLocation = string;
            this.this$0 = locationBar;
        }
    }
}

