/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.ActionHelper;
import ice.ri.swing.BrowserWindow;
import ice.ri.swing.Resources;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

final class MouseManager {
    BrowserWindow browserWindow;
    Resources res;
    private JPopupMenu linkPopup;
    private JPopupMenu normalPopup;
    private Vector copyMenus;
    String popup_link;
    String popup_targetFrame;
    String popup_outputString;

    private void $init$() {
        this.copyMenus = new Vector(2, 1);
    }

    public MouseManager(BrowserWindow browserWindow) {
        this.$init$();
        this.browserWindow = browserWindow;
        this.res = browserWindow.res;
        this.normalPopup = this.createPopup();
        this.linkPopup = this.createOnLinkPopup();
    }

    private JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu(this.res.str("popup.title"));
        popup.setInvoker(this.browserWindow.browserContainer);
        JMenuItem backMenu = new JMenuItem(this.res.str("long.back"));
        JMenuItem forwardMenu = new JMenuItem(this.res.str("long.forward"));
        JMenuItem reloadMenu = new JMenuItem(this.res.str("long.reload"));
        JMenuItem copyMenu = new JMenuItem(this.res.str("long.copy"));
        JMenuItem bookmarkMenu = new JMenuItem(this.res.str("menu.bookmark.add"));
        JMenuItem saveMenu = new JMenuItem(this.res.str("long.save"));
        JMenuItem sourceMenu = new JMenuItem(this.res.str("long.source"));
        JMenuItem domMenu = new JMenuItem(this.res.str("long.dom"));
        this.copyMenus.add(copyMenu);
        JMenuItem pasteMenu = new JMenuItem(this.res.str("long.paste"));
        JMenuItem printMenu = new JMenuItem(this.res.str("long.printpilot"));
        popup.add(backMenu);
        popup.add(forwardMenu);
        popup.add(reloadMenu);
        popup.addSeparator();
        popup.add(copyMenu);
        popup.add(pasteMenu);
        popup.addSeparator();
        popup.add(bookmarkMenu);
        popup.add(saveMenu);
        popup.add(printMenu);
        popup.addSeparator();
        popup.add(sourceMenu);
        popup.add(domMenu);
        new ActionHelper(1, backMenu, this.browserWindow);
        new ActionHelper(2, forwardMenu, this.browserWindow);
        new ActionHelper(3, reloadMenu, this.browserWindow);
        new ActionHelper(34, copyMenu, this.browserWindow);
        new ActionHelper(35, pasteMenu, this.browserWindow);
        new ActionHelper(23, bookmarkMenu, this.browserWindow);
        new ActionHelper(13, saveMenu, this.browserWindow);
        new ActionHelper(16, sourceMenu, this.browserWindow);
        new ActionHelper(31, domMenu, this.browserWindow);
        new ActionHelper(5, printMenu, this.browserWindow);
        return popup;
    }

    private JPopupMenu createOnLinkPopup() {
        JPopupMenu popup = new JPopupMenu(this.res.str("popup.title"));
        popup.setInvoker(this.browserWindow.browserContainer);
        JMenuItem open = new JMenuItem(this.res.str("popup.open"));
        JMenuItem save = new JMenuItem(this.res.str("popup.save"));
        JMenuItem book = new JMenuItem(this.res.str("popup.bookmark"));
        JMenuItem copy = new JMenuItem(this.res.str("popup.copylink"));
        JMenuItem newwnd = new JMenuItem(this.res.str("popup.newwindow"));
        popup.add(open);
        popup.add(newwnd);
        popup.addSeparator();
        popup.add(book);
        popup.add(save);
        popup.add(copy);
        ActionHelper.forPopup(200, this, open);
        ActionHelper.forPopup(201, this, save);
        ActionHelper.forPopup(202, this, book);
        ActionHelper.forPopup(203, this, copy);
        ActionHelper.forPopup(204, this, newwnd);
        return popup;
    }

    void onContextMenu(Component c, MouseEvent event, HTMLAnchorElement anchor) {
        if (this.linkPopup.isVisible() || this.normalPopup.isVisible()) {
            return;
        }
        Enumeration anEnum = this.copyMenus.elements();
        while (anEnum.hasMoreElements()) {
            this.setCopyMenusStatus(anEnum.nextElement());
        }
        if (anchor == null) {
            this.popup_link = null;
            this.popup_targetFrame = null;
            this.popup_outputString = null;
            this.normalPopup.show(c, event.getClientX(), event.getClientY());
        } else {
            this.popup_link = anchor.getHref();
            this.popup_targetFrame = anchor.getTarget();
            this.popup_outputString = null;
            this.linkPopup.show(c, event.getClientX(), event.getClientY());
        }
    }

    private void setCopyMenusStatus(Object target) {
        boolean enableCopy = this.browserWindow.isSelectionActive();
        JMenuItem menu = (JMenuItem)target;
        if (menu.isEnabled() != enableCopy) {
            menu.setEnabled(enableCopy);
        }
    }

    void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.normalPopup);
        SwingUtilities.updateComponentTreeUI(this.linkPopup);
    }
}

