/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.common.print.swing.PageSetupDialog;
import ice.ri.swing.Bookmark;
import ice.ri.swing.Parse;
import ice.ri.swing.Resources;
import ice.ri.swing.WindowManager;
import ice.storm.print.AbstractPageDecoration;
import ice.storm.print.PageNumberPageDecoration;
import ice.storm.print.StormPageFormat;
import ice.storm.print.StringPageDecoration;
import ice.util.Defs;
import ice.util.io.DataStorage;
import ice.util.unit.PointUnit;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.KeyStroke;

class PropertiesManager {
    public static final int DEFAULT_MAX_MEMORY_CACHE_SIZE = 1024;
    public static final int DEFAULT_MAX_FILE_CACHE_SIZE = 5120;
    private static final String DEFAULT_FONT_STYLE = "plain";
    private static final String DEFAULT_FONT_SIZE = "10";
    private static final String DEFAULT_HOME_DIR = "ICEsoft/SwingRI";
    private static final String LOCK_FILE = "_syslock";
    private static final String USER_FILENAME = "swingri.properties";
    private static final String BOOKMARK_FILE_NAME = "swingri.bookmarks";
    private static final String BACKUP_FILENAME = "old_swingri.properties";
    private static final String COOKIES_FILE = "ICEcookies.system";
    private static final String FILE_CACHE_DIR = "cache";
    private static final String TRUSTED_SITE_FILE = "trustedSite.lst";
    private static final String DEFAULT_PROP_FILE = "ICEdefault.properties";
    private static Object keepInMemory = null;
    private static final String PROXY_TYPE_KEY = "document.proxy.type";
    private static final String PROXY_HTTP_HOST_KEY = "document.proxy.httpHost";
    private static final String PROXY_HTTP_PORT_KEY = "document.proxy.httpPort";
    private static final String PROXY_HTTPS_HOST_KEY = "document.proxy.httpsHost";
    private static final String PROXY_HTTPS_PORT_KEY = "document.proxy.httpsPort";
    private static final String PROXY_NON_PROXY_HOSTS_KEY = "document.proxy.nonProxyHosts";
    private static final String PROXY_NON_PROXY_PORTS_KEY = "document.proxy.nonProxyPorts";
    private static final String PROXY_PAC_URL_KEY = "document.proxy.pacUrl";
    static final int PROXY_DIRECT = 1;
    static final int PROXY_MANUAL = 2;
    static final int PROXY_AUTOMATIC = 3;
    WindowManager windowManager;
    String versionName;
    private boolean unrecoverableError;
    Properties sysProps;
    Resources res;
    File userHome;
    DataStorage storage;
    private File dataDir;
    private String dataDirStr;
    private File lockDir;
    private File propertyFile;
    private Date myLastModif;
    private Properties props;
    private Properties defaultProps;
    private File bookmarksFile;
    private final Vector bookmarks;

    private void $init$() {
        this.versionName = "v6_1_3";
        this.myLastModif = new Date();
        this.bookmarks = new Vector();
    }

    public PropertiesManager(Properties sysProps, Resources res, String homeString, String language, String region) {
        this.$init$();
        this.unrecoverableError = true;
        this.sysProps = sysProps;
        this.res = res;
        if (!this.setupDefaultProperties()) {
            return;
        }
        this.setupDefaultLanguage(language, region);
        this.setupHomeDir(homeString);
        this.recordMofifTime();
        this.setupLock();
        this.loadProperties();
        this.loadBookmarks();
        this.applyHttpProperties();
        this.unrecoverableError = false;
    }

    int getProxyType() {
        return this.getInt(PROXY_TYPE_KEY, -1);
    }

    void setProxyType(int type) {
        this.setInt(PROXY_TYPE_KEY, type);
    }

    String getHttpHost() {
        return this.getString(PROXY_HTTP_HOST_KEY, "");
    }

    void setHttpHost(String host) {
        this.set(PROXY_HTTP_HOST_KEY, host);
    }

    int getHttpPort() {
        return this.getInt(PROXY_HTTP_PORT_KEY, -1);
    }

    void setHttpPort(int port) {
        this.setInt(PROXY_HTTP_PORT_KEY, port);
    }

    String getHttpsHost() {
        return this.getString(PROXY_HTTPS_HOST_KEY, "");
    }

    void setHttpsHost(String host) {
        this.set(PROXY_HTTPS_HOST_KEY, host);
    }

    int getHttpsPort() {
        return this.getInt(PROXY_HTTPS_PORT_KEY, -1);
    }

    void setHttpsPort(int port) {
        this.setInt(PROXY_HTTPS_PORT_KEY, port);
    }

    String getNonProxyHosts() {
        return this.getString(PROXY_NON_PROXY_HOSTS_KEY, "");
    }

    void setNonProxyHosts(String nonProxyHosts) {
        this.set(PROXY_NON_PROXY_HOSTS_KEY, nonProxyHosts);
    }

    String getNonProxyPorts() {
        return this.getString(PROXY_NON_PROXY_PORTS_KEY, "");
    }

    void setNonProxyPorts(String nonProxyPorts) {
        this.set(PROXY_NON_PROXY_PORTS_KEY, nonProxyPorts);
    }

    String getPacUrl() {
        return this.getString(PROXY_PAC_URL_KEY, "");
    }

    void setPacUrl(String url) {
        this.set(PROXY_PAC_URL_KEY, url);
    }

    private void applyHttpProperties() {
        String _nonProxyPorts;
        String _nonProxyHosts;
        String _httpsProxyHost;
        boolean _manual = false;
        String _httpProxyHost = Defs.sysProperty("http.proxyHost");
        if (_httpProxyHost != null) {
            this.setHttpHost(_httpProxyHost);
            _manual = true;
        }
        if (Defs.sysProperty("http.proxyPort") != null) {
            this.setHttpPort(Defs.sysPropertyInt("http.proxyPort", 80));
            _manual = true;
        }
        if ((_httpsProxyHost = Defs.sysProperty("https.proxyHost")) != null) {
            this.setHttpsHost(_httpsProxyHost);
            _manual = true;
        }
        if (Defs.sysProperty("https.proxyPort") != null) {
            this.setHttpsPort(Defs.sysPropertyInt("https.proxyPort", 443));
            _manual = true;
        }
        if (_manual) {
            this.setProxyType(2);
        }
        if ((_nonProxyHosts = Defs.sysProperty("http.nonProxyHosts")) != null) {
            this.setNonProxyHosts(_nonProxyHosts);
        }
        if ((_nonProxyPorts = Defs.sysProperty("http.nonProxyPorts")) != null) {
            this.setNonProxyPorts(_nonProxyPorts);
        }
    }

    boolean unrecoverableError() {
        return this.unrecoverableError;
    }

    private boolean ownLock() {
        return this.lockDir != null;
    }

    public Vector bookmarks() {
        return this.bookmarks;
    }

    private boolean setupDefaultProperties() {
        this.defaultProps = new Properties();
        try {
            InputStream in = this.res.propertiesStream(DEFAULT_PROP_FILE);
            try {
                this.defaultProps.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            this.res.displayError("session.propertie_read_error", (Object)ex, false);
            boolean bl = false;
            return bl;
        }
        this.props = this.defaultProps;
        return true;
    }

    private void setupDefaultLanguage(String language, String region) {
        if (language == null && (language = (String)this.defaultProps.get("application.language")) == null && (language = this.sysProps.getProperty("user.language")) == null) {
            language = "";
        }
        if (region == null && (region = (String)this.defaultProps.get("application.region")) == null && (region = this.sysProps.getProperty("user.region")) == null) {
            region = "";
        }
        Locale locale_to_use = new Locale(language, region);
        Locale.setDefault(locale_to_use);
        this.res.setLocale(locale_to_use);
    }

    private void setupHomeDir(String homeString) {
        if (homeString == null) {
            homeString = this.sysProps.getProperty("swingri.home");
        }
        if (homeString != null) {
            this.dataDir = new File(homeString);
        } else {
            this.userHome = new File(this.sysProps.getProperty("user.home"));
            this.dataDirStr = this.props.getProperty("application.datadir", DEFAULT_HOME_DIR);
            this.dataDir = new File(this.userHome, this.dataDirStr);
        }
        if (!this.dataDir.isDirectory()) {
            String path = this.dataDir.getAbsolutePath();
            boolean create = this.getBoolean("application.showLocalStorageDialogs", true) ? this.res.displayYesOrNo("datadir.create_new", path) : true;
            if (!create) {
                this.dataDir = null;
            } else {
                this.dataDir.mkdirs();
                if (!this.dataDir.isDirectory()) {
                    this.res.displayError("datadir.failed_creation", this.dataDir.getAbsolutePath());
                    this.dataDir = null;
                }
            }
        }
    }

    private void setupLock() {
        if (this.dataDir == null) {
            this.lockDir = null;
        } else {
            File dir = new File(this.dataDir, LOCK_FILE);
            if (!dir.mkdir()) {
                String session_date = DateFormat.getDateTimeInstance().format(new Date(dir.lastModified()));
                boolean removeIt = true;
                if (removeIt) {
                    dir.delete();
                    if (!dir.mkdir()) {
                        dir = null;
                        this.res.displayError("session.nolock", (Object)this.res.str("title.error"), false);
                    }
                } else {
                    dir = null;
                }
            }
            this.lockDir = dir;
        }
    }

    private void setupFileCache() {
    }

    private void setupMemoryCache() {
    }

    public synchronized void loadProperties() {
        if (this.dataDir != null) {
            this.propertyFile = new File(this.dataDir, USER_FILENAME);
            if (this.propertyFile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(this.propertyFile);
                    try {
                        this.props.load(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ex) {
                    this.res.displayError("session.propertie_read_error", (Object)ex, false);
                }
            }
        }
    }

    private void loadBookmarks() {
        block10: {
            String title;
            block11: {
                String title2;
                this.bookmarks.removeAllElements();
                if (this.dataDir == null) break block10;
                this.bookmarksFile = new File(this.dataDir, BOOKMARK_FILE_NAME);
                if (!this.bookmarksFile.exists()) break block11;
                Properties props = new Properties();
                try {
                    FileInputStream in = new FileInputStream(this.bookmarksFile);
                    try {
                        props.load(in);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    this.res.displayError("bookmarks.load_error");
                }
                int count = 1;
                while ((title2 = props.getProperty("b" + count + ".title")) != null) {
                    String url = props.getProperty("b" + count + ".url");
                    if (url != null) {
                        this.bookmarks.addElement(new Bookmark(title2, url));
                    }
                    ++count;
                }
                break block10;
            }
            if (!this.getBoolean("bookmarkmenu.populated", false)) break block10;
            int count = 0;
            while ((title = this.defaultProps.getProperty("b" + count + ".title")) != null) {
                String url = this.props.getProperty("b" + count + ".url");
                if (url != null) {
                    this.bookmarks.addElement(new Bookmark(title, url));
                }
                ++count;
            }
        }
    }

    public synchronized void saveBookmarks() {
        if (this.ownLock()) {
            Properties props = new Properties();
            int i = 0;
            while (i < this.bookmarks.size()) {
                Bookmark b = (Bookmark)this.bookmarks.elementAt(i);
                props.put("b" + (i + 1) + ".title", b.title);
                props.put("b" + (i + 1) + ".url", b.url);
                ++i;
            }
            try {
                FileOutputStream out = new FileOutputStream(this.bookmarksFile);
                try {
                    props.save(out, "-- ICE Browser Bookmarks --\r\n# Automatically generated file: DO NOT EDIT");
                }
                finally {
                    out.close();
                }
            }
            catch (IOException ex) {
                this.res.displayError("properties.save_error", ex);
            }
        }
    }

    void appendBookmark(String title, String location) {
        this.bookmarks.addElement(new Bookmark(title, location));
        this.saveBookmarks();
    }

    public synchronized void saveAndEnd() {
        if (this.dataDir != null) {
            this.saveBookmarks();
            this.saveProperties();
            this.lockDir.delete();
        }
    }

    public synchronized void saveProperties() {
        if (this.ownLock()) {
            long lastModified = this.propertyFile.lastModified();
            boolean saveIt = true;
            if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                if (lastModified == 0L) {
                    saveIt = this.res.displayYesOrNo("properties.deleted", this.propertyFile.getAbsolutePath());
                } else if (this.myLastModif.before(new Date(lastModified))) {
                    DateFormat df = DateFormat.getDateTimeInstance();
                    saveIt = this.res.displayYesOrNo("properties.modified", df.format(this.myLastModif));
                }
            }
            if (!saveIt) {
                return;
            }
            try {
                FileOutputStream out = new FileOutputStream(this.propertyFile);
                try {
                    this.props.save(out, "-- ICEbrowser properties --");
                }
                finally {
                    out.close();
                }
                this.recordMofifTime();
            }
            catch (IOException ex) {
                this.res.displayError("properties.save_error", ex);
            }
        }
    }

    private void recordMofifTime() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(new Date());
        c.set(12, c.get(12) + 1);
        c.set(13, 0);
        this.myLastModif = new Date(c.getTime().getTime() / 1000L * 1000L);
    }

    public boolean backupProperties() {
        boolean result = false;
        if (this.ownLock()) {
            File backupFile = new File(this.dataDir, BACKUP_FILENAME);
            try {
                FileOutputStream out = new FileOutputStream(backupFile);
                try {
                    this.props.save(out, "-- ICEbrowser properties backup --");
                    result = true;
                }
                finally {
                    out.close();
                }
            }
            catch (IOException ex) {
                this.res.displayError("properties.save_error", ex);
            }
        }
        return result;
    }

    long getMemoryCacheSize() {
        return 0L;
    }

    long getFileCacheSize() {
        return 0L;
    }

    void setMemoryCacheSize(long cacheSize) {
    }

    void setFileCacheSize(long fileCacheSize) {
    }

    void clearFileCache() {
    }

    void clearMemoryCache() {
    }

    void clearAllCaches() {
    }

    public void set(String propertyName, String value) {
        this.props.put(propertyName, value);
    }

    public String getString(String propertyName, String defaultValue) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            return value.trim();
        }
        value = (String)this.defaultProps.get(propertyName);
        if (value != null) {
            return value.trim();
        }
        return defaultValue;
    }

    public String getString(String propertyName) {
        String value = this.getString(propertyName, null);
        if (value == null) {
            this.throwMissedDefault(propertyName);
        }
        return value;
    }

    public int getInt(String propertyName, int defaultValue) {
        Integer result = this.getIntImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getInt(String propertyName) {
        Integer result = this.getIntImpl(propertyName);
        if (result == null) {
            this.throwMissedDefault(propertyName);
        }
        return result;
    }

    private Integer getIntImpl(String propertyName) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            Integer result = Parse.parseInteger(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            Integer result = Parse.parseInteger(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return null;
    }

    public void setInt(String propertyName, int value) {
        this.set(propertyName, Integer.toString(value));
    }

    public double getDouble(String propertyName, double defaultValue) {
        Double result = this.getDoubleImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public double getDouble(String propertyName) {
        Double result = this.getDoubleImpl(propertyName);
        if (result == null) {
            this.throwMissedDefault(propertyName);
        }
        return result;
    }

    private Double getDoubleImpl(String propertyName) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            Double result = Parse.parseDouble(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            Double result = Parse.parseDouble(value, this.res);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return null;
    }

    public void setDouble(String propertyName, double value) {
        this.set(propertyName, Double.toString(value));
    }

    public StormPageFormat getStormPageFormat() {
        StormPageFormat pageFormat = new StormPageFormat();
        pageFormat.setMargin(new PointUnit(this.getDouble("stormpageformat.margin.left", 36.0)), 2);
        pageFormat.setMargin(new PointUnit(this.getDouble("stormpageformat.margin.right", 36.0)), 4);
        pageFormat.setMargin(new PointUnit(this.getDouble("stormpageformat.margin.top", 36.0)), 1);
        pageFormat.setMargin(new PointUnit(this.getDouble("stormpageformat.margin.bottom", 36.0)), 3);
        pageFormat.setPageSize(new PointUnit(this.getInt("stormpageformat.paper.width", 612)), new PointUnit(this.getInt("stormpageformat.paper.height", 792)));
        pageFormat.setOrientation(this.getInt("stormpageformat.orientation", 1));
        pageFormat.setScale(this.getDouble("stormpageformat.scale", 1.0));
        pageFormat.setScaleToFitEnabled(this.getBoolean("stormpageformat.scaletofit", true));
        PropertiesManager.addDecoration(pageFormat, this.getString("stormpageformat.decoration.top.left", "blank"), AbstractPageDecoration.TOP, AbstractPageDecoration.LEFT);
        PropertiesManager.addDecoration(pageFormat, this.getString("stormpageformat.decoration.top.right", "blank"), AbstractPageDecoration.TOP, AbstractPageDecoration.RIGHT);
        PropertiesManager.addDecoration(pageFormat, this.getString("stormpageformat.decoration.top.center", "blank"), AbstractPageDecoration.TOP, AbstractPageDecoration.CENTER);
        PropertiesManager.addDecoration(pageFormat, this.getString("stormpageformat.decoration.bottom.left", "blank"), AbstractPageDecoration.BOTTOM, AbstractPageDecoration.LEFT);
        PropertiesManager.addDecoration(pageFormat, this.getString("stormpageformat.decoration.bottom.right", "blank"), AbstractPageDecoration.BOTTOM, AbstractPageDecoration.RIGHT);
        PropertiesManager.addDecoration(pageFormat, this.getString("stormpageformat.decoration.bottom.center", "blank"), AbstractPageDecoration.BOTTOM, AbstractPageDecoration.CENTER);
        pageFormat.setHeaderFooterFont(this.getFont("stormpageformat.font", new Font("Sans Serif", 0, 10)));
        pageFormat.setBackgroundVisible(this.getBoolean("stormpageformat.backgrounds", true));
        pageFormat.setHtmlSmartPaging(this.getBoolean("stormpageformat.smartpaging", true));
        pageFormat.setPageSetupDialogUnit(this.getInt("stormpageformat.pagesetupdialog.unit", 0));
        pageFormat.setFramePrintFormat(this.getInt("stormpageformat.frames.print.format", 1));
        pageFormat.setSelectedViewportIndex(this.getInt("stormpageformat.frames.selectedframe", 0));
        return pageFormat;
    }

    public void saveStormPageFormat(StormPageFormat pageFormat) {
        this.setDouble("stormpageformat.margin.left", pageFormat.getMargin(2));
        this.setDouble("stormpageformat.margin.right", pageFormat.getMargin(4));
        this.setDouble("stormpageformat.margin.top", pageFormat.getMargin(1));
        this.setDouble("stormpageformat.margin.bottom", pageFormat.getMargin(3));
        this.setInt("stormpageformat.orientation", pageFormat.getOrientation());
        pageFormat.setOrientation(1);
        this.setInt("stormpageformat.paper.width", (int)pageFormat.getPageWidth());
        this.setInt("stormpageformat.paper.height", (int)pageFormat.getPageHeight());
        this.setDouble("stormpageformat.scale", pageFormat.getScale());
        this.setBoolean("stormpageformat.scaletofit", pageFormat.isScaleToFitEnabled());
        String title = this.findDecoration(pageFormat, AbstractPageDecoration.TOP, AbstractPageDecoration.LEFT);
        if (title != null) {
            this.set("stormpageformat.decoration.top.left", title);
        } else {
            this.set("stormpageformat.decoration.top.left", "blank");
        }
        title = this.findDecoration(pageFormat, AbstractPageDecoration.TOP, AbstractPageDecoration.CENTER);
        if (title != null) {
            this.set("stormpageformat.decoration.top.center", title);
        } else {
            this.set("stormpageformat.decoration.top.center", "blank");
        }
        title = this.findDecoration(pageFormat, AbstractPageDecoration.TOP, AbstractPageDecoration.RIGHT);
        if (title != null) {
            this.set("stormpageformat.decoration.top.right", title);
        } else {
            this.set("stormpageformat.decoration.top.right", "blank");
        }
        title = this.findDecoration(pageFormat, AbstractPageDecoration.BOTTOM, AbstractPageDecoration.LEFT);
        if (title != null) {
            this.set("stormpageformat.decoration.bottom.left", title);
        } else {
            this.set("stormpageformat.decoration.bottom.left", "blank");
        }
        title = this.findDecoration(pageFormat, AbstractPageDecoration.BOTTOM, AbstractPageDecoration.CENTER);
        if (title != null) {
            this.set("stormpageformat.decoration.bottom.center", title);
        } else {
            this.set("stormpageformat.decoration.bottom.center", "blank");
        }
        title = this.findDecoration(pageFormat, AbstractPageDecoration.BOTTOM, AbstractPageDecoration.RIGHT);
        if (title != null) {
            this.set("stormpageformat.decoration.bottom.right", title);
        } else {
            this.set("stormpageformat.decoration.bottom.right", "blank");
        }
        this.setFont("stormpageformat.font", pageFormat.getHeaderFooterFont());
        this.setInt("stormpageformat.pagesetupdialog.unit", pageFormat.getPageSetupDialogUnit());
        this.setBoolean("stormpageformat.backgrounds", pageFormat.isBackgroundVisible());
        this.setBoolean("stormpageformat.smartpaging", pageFormat.isHtmlSmartPagingEnabled());
        this.setInt("stormpageformat.frames.print.format", pageFormat.getFramePrintFormat());
        this.setInt("stormpageformat.frames.selectedframe", pageFormat.getSelectedViewportIndex());
    }

    private String findDecoration(StormPageFormat pageFormat, int vert, int hor) {
        String titleString = null;
        Vector decorations = pageFormat.getDecoration();
        int j = 0;
        while (j < decorations.size()) {
            AbstractPageDecoration decoration;
            Object tmp = decorations.elementAt(j);
            if (tmp instanceof AbstractPageDecoration && (decoration = (AbstractPageDecoration)decorations.elementAt(j)).getVerticalAlignment() == vert && decoration.getHorizontalAlignment() == hor && (decoration.getName().equalsIgnoreCase("title") || decoration.getName().equalsIgnoreCase("url") || decoration.getName().equalsIgnoreCase("dateTime") || decoration.getName().equalsIgnoreCase("pageNumber") || decoration.getName().equalsIgnoreCase("blank"))) {
                titleString = decoration.getName();
            }
            ++j;
        }
        return titleString;
    }

    private static void addDecoration(StormPageFormat stormPageFormat, String name, int vert, int hor) {
        if (name.equalsIgnoreCase("title")) {
            stormPageFormat.addDecoration(new StringPageDecoration("title", PageSetupDialog.getDecorationTitle("title"), vert, hor));
        } else if (name.equalsIgnoreCase("url")) {
            stormPageFormat.addDecoration(new StringPageDecoration("url", PageSetupDialog.getDecorationTitle("url"), vert, hor));
        } else if (name.equalsIgnoreCase("dateTime")) {
            stormPageFormat.addDecoration(new StringPageDecoration("dateTime", PageSetupDialog.getDecorationTitle("dateTime"), vert, hor));
        } else if (name.equalsIgnoreCase("pageNumber")) {
            stormPageFormat.addDecoration(new PageNumberPageDecoration("pageNumber", vert, hor));
        }
    }

    public long getLong(String propertyName, long defaultValue) {
        Long result = this.getLongImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public long getLong(String propertyName) {
        Long result = this.getLongImpl(propertyName);
        if (result == null) {
            this.throwMissedDefault(propertyName);
        }
        return result;
    }

    private Long getLongImpl(String propertyName) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            Long result = Parse.parseLong(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            Long result = Parse.parseLong(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return null;
    }

    public void setLong(String propertyName, long value) {
        this.set(propertyName, Long.toString(value));
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        Boolean result = this.getBooleanImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result == Boolean.TRUE;
    }

    public boolean getBoolean(String propertyName) {
        Boolean result = this.getBooleanImpl(propertyName);
        if (result == null) {
            this.throwMissedDefault(propertyName);
        }
        return result == Boolean.TRUE;
    }

    private Boolean getBooleanImpl(String propertyName) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            Boolean result = Parse.parseBoolean(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            Boolean result = Parse.parseBoolean(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return null;
    }

    public void setBoolean(String propertyName, boolean value) {
        this.set(propertyName, value ? "true" : "false");
    }

    public Color getColor(String propertyName, Color defaultValue) {
        Color color;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            color = Parse.parseColor(value, this.res);
            if (color != null) {
                return color;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            color = Parse.parseColor(value, null);
            if (color != null) {
                return color;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return defaultValue;
    }

    public Color getColor(String propertyName) {
        Color value = this.getColor(propertyName, null);
        if (value != null) {
            this.throwMissedDefault(propertyName);
        }
        return value;
    }

    public Font getFont(String propertyName, Font defaultValue) {
        Font font;
        int l = propertyName.length();
        StringBuffer sb = new StringBuffer(l + 6);
        sb.append(propertyName);
        sb.append(".name");
        String nameProp = sb.toString();
        sb.setLength(l);
        sb.append(".style");
        String styleProp = sb.toString();
        sb.setLength(l);
        sb.append(".size");
        String sizeProp = sb.toString();
        String name = (String)this.props.get(nameProp);
        if (name != null) {
            String size;
            String style = (String)this.props.get(styleProp);
            if (style == null) {
                style = DEFAULT_FONT_STYLE;
            }
            if ((size = (String)this.props.get(sizeProp)) == null) {
                size = DEFAULT_FONT_SIZE;
            }
            if ((font = Parse.parseFont(name, style, size, this.res)) != null) {
                return font;
            }
            this.props.remove(propertyName);
        }
        if ((name = (String)this.defaultProps.get(nameProp)) != null) {
            String size;
            String style = (String)this.defaultProps.get(styleProp);
            if (style == null) {
                style = DEFAULT_FONT_STYLE;
            }
            if ((size = (String)this.defaultProps.get(sizeProp)) == null) {
                size = DEFAULT_FONT_SIZE;
            }
            if ((font = Parse.parseFont(name, style, size, null)) != null) {
                return font;
            }
            this.throwBrokenDefault(propertyName, name);
        }
        return defaultValue;
    }

    public Font getFont(String propertyName) {
        Font value = this.getFont(propertyName, null);
        if (value == null) {
            this.throwMissedDefault(propertyName);
        }
        return value;
    }

    public void setFont(String propertyName, Font font) {
        int l = propertyName.length();
        StringBuffer sb = new StringBuffer(l + 6);
        sb.append(propertyName);
        sb.append(".name");
        String nameProp = sb.toString();
        sb.setLength(l);
        sb.append(".style");
        String styleProp = sb.toString();
        sb.setLength(l);
        sb.append(".size");
        String sizeProp = sb.toString();
        this.set(nameProp, font.getFamily());
        this.set(styleProp, Parse.getFontStyleName(font));
        this.set(sizeProp, "" + font.getSize());
    }

    public String getSystemEncoding() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    public String getEncoding(String propertyName) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            if ((value = Parse.parseEncoding(value, this.res)) != null) {
                return value;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            if (Parse.checkEncoding(value)) {
                return value;
            }
            this.defaultProps.remove(propertyName);
            System.err.println("Encoding '" + value + "' given in the default properties is unsupported.\n" + "Using system default");
        }
        return this.getSystemEncoding();
    }

    public String getHorizontalInfo(String propertyName, String defaultValue) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            String result = Parse.parseHorizontal(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            String result = Parse.parseHorizontal(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return defaultValue;
    }

    public String getHorizontalInfo(String propertyName) {
        String value = this.getHorizontalInfo(propertyName, null);
        if (value == null) {
            this.throwMissedDefault(propertyName);
        }
        return value;
    }

    public String getPositionInfo(String propertyName, String defaultValue) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            String result = Parse.parsePosition(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            String result = Parse.parsePosition(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return defaultValue;
    }

    public String getPositionInfo(String propertyName) {
        String value = this.getPositionInfo(propertyName, null);
        if (value == null) {
            this.throwMissedDefault(propertyName);
        }
        return value;
    }

    public KeyStroke getKeyStroke(String propertyName, KeyStroke defaultValue) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            KeyStroke result = Parse.parseKey(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            KeyStroke result = Parse.parseKey(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return defaultValue;
    }

    public KeyStroke getKey(String propertyName) {
        KeyStroke value = this.getKeyStroke(propertyName, null);
        if (value == null) {
            this.throwMissedDefault(propertyName);
        }
        return value;
    }

    public String getLookAndFeel(String propertyName, String defaultValue) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            String result = Parse.parseLookAndFeel(value, this.res);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            String result = Parse.parseLookAndFeel(value, null);
            if (result != null) {
                return result;
            }
            this.defaultProps.remove(propertyName);
            System.err.println("Look&Feel '" + value + "' given in the default properties is unsupported.\n" + "Using system default");
        }
        return defaultValue;
    }

    private void throwBrokenDefault(String propertyName, String value) {
        throw new IllegalStateException("Broken default property '" + propertyName + "' value: '" + value + "'");
    }

    private void throwMissedDefault(String propertyName) {
        throw new IllegalStateException("Missed default property '" + propertyName + "' value");
    }
}

