/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.WindowManager;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;

final class SplashWindow
extends JWindow
implements ActionListener {
    private Timer timer;
    private static final int WAIT_TIME = 3000;
    private static final String IMAGE = "splashscreen.png";

    public SplashWindow(WindowManager windowManager) {
        super(windowManager.getProperties().res.getBaseFrame());
        PropertiesManager properties = windowManager.getProperties();
        Resources res = properties.res;
        JPanel panelImage = new JPanel(new FlowLayout(0, 0, 0));
        ImageIcon icon = res.imageIcon(this.getToolkit(), IMAGE);
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder());
        panelImage.add(iconLabel);
        this.setContentPane(panelImage);
        this.pack();
        this.setSize(this.getWidth(), this.getHeight() + 1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int xCoord = (screenSize.width - this.getWidth()) / 2;
        int yCoord = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(xCoord, yCoord);
        this.timer = new Timer(3000, this);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.timer) {
            this.timer.stop();
            this.setVisible(false);
            this.dispose();
        }
    }
}

