/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.debug.Debug;
import ice.ri.swing.BrowserWindow;
import ice.ri.swing.Console;
import ice.ri.swing.ConsoleOutputStream;
import ice.ri.swing.Dialogs;
import ice.ri.swing.MultiLabel;
import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.storm.CallbackAdapter;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class WindowManager {
    private PropertiesManager properties;
    private Vector browserWindows;
    private Vector browserWindowHistory;
    private WindowListener windowListener;
    private Vector otherWindows;
    private Dialogs dialogs;
    PrintStream outSaved;
    PrintStream errSaved;
    Console console;
    ConsoleOutputStream consoleErr;
    ConsoleOutputStream consoleOut;
    private long newWindowInvokationCounter;
    private String currentUserCSS;
    StormBase storm;
    private StormPageFormat stormPageFormat;
    static final int ACTION_CLOSE = 1;
    static final int ACTION_SET_TRUE = 2;

    private void $init$() {
        this.browserWindowHistory = new Vector();
        this.windowListener = new 1();
        this.outSaved = System.out;
        this.errSaved = System.err;
        this.newWindowInvokationCounter = 0L;
    }

    public WindowManager(PropertiesManager properties) {
        this.$init$();
        this.properties = properties;
        this.properties.windowManager = this;
        this.browserWindows = new Vector();
        this.otherWindows = new Vector();
        this.stormPageFormat = this.properties.getStormPageFormat();
        this.redirectOutput();
        if (Defs.booleanProperty("ice.browser.verbose", true)) {
            System.out.println("\nICEsoft \"Swing RI\" Reference Application");
            System.out.println("Copyright ICEsoft Technologies, Inc.\n");
        }
        this.setupStorm();
        this.updateUserCSS();
    }

    BrowserWindow getActiveBrowserWindow() {
        return (BrowserWindow)this.browserWindowHistory.lastElement();
    }

    private void setupStorm() {
        this.storm = new StormBase();
        new StormObserver(null).registerWith(this.storm);
        this.storm.setComponentToolkitName("swing");
    }

    void redirectOutput() {
        this.outSaved = System.out;
        this.errSaved = System.err;
        this.consoleOut = new ConsoleOutputStream(this, this.outSaved);
        PrintStream ps = new PrintStream(this.consoleOut);
        System.setOut(ps);
        System.setErr(ps);
    }

    void restoreOutput() {
        if (this.outSaved != null) {
            System.setOut(this.outSaved);
        }
        if (this.errSaved != null) {
            System.setErr(this.errSaved);
        }
    }

    Dialogs getDialogs() {
        if (this.dialogs == null) {
            this.dialogs = new Dialogs(this);
        }
        return this.dialogs;
    }

    void showJavaConsole() {
        WindowManager thisWm = this;
        2 doSwingWork = new 2(this, thisWm);
        SwingUtilities.invokeLater(doSwingWork);
    }

    private String buildUserCSS() {
        StringBuffer sb = new StringBuffer();
        Font f = this.getProperties().getFont("document.proportionalfont");
        if (f != null) {
            sb.append("* { ");
            WindowManager.fontToCssStyle(f, sb);
            sb.append("};\n");
        }
        if ((f = this.getProperties().getFont("document.fixedfont")) != null) {
            sb.append("PRE,CODE,TT { ");
            WindowManager.fontToCssStyle(f, sb);
            sb.append("};\n");
        }
        Color c = this.getProperties().getColor("document.defaultbackground", Color.white);
        sb.append("BODY { background-color: rgb(");
        sb.append(c.getRed());
        sb.append(',');
        sb.append(c.getGreen());
        sb.append(',');
        sb.append(c.getBlue());
        sb.append(") };\n");
        return sb.toString();
    }

    static void fontToCssStyle(Font f, StringBuffer sb) {
        sb.append("font-size: ");
        sb.append(f.getSize());
        sb.append("pt; font-family: \"");
        sb.append(f.getName());
        sb.append("\";");
    }

    private void updateUserCSS() {
    }

    void gotoLocation(String loc, String targetFrame, String outputString) {
        String finalLoc = loc;
        String finalTargetFrame = targetFrame;
        3 doSwingWork = new 3(this, finalLoc, finalTargetFrame);
        SwingUtilities.invokeLater(doSwingWork);
    }

    public void goToLocation(String location, String targetFrame) {
        this.gotoLocation(location, targetFrame, null);
    }

    Container newBrowserComponent(Viewport viewport) {
        BrowserWindow bw = new BrowserWindow(this, viewport);
        bw.addWindowListener(this.windowListener);
        this.browserWindows.addElement(bw);
        return bw.browserContainer;
    }

    String[] runAuthentificationDialog(String type, String realm, URL url) {
        return this.getDialogs().showAuthentification(type, realm, url);
    }

    public void newWindow() {
        this.newWindow(this.getProperties().getString("home.location"));
    }

    public void newWindow(String location) {
        ++this.newWindowInvokationCounter;
        String internalName = "_swingri_" + this.newWindowInvokationCounter;
        this.gotoLocation(location, internalName, null);
    }

    void updateUserFonts() {
        this.updateUserCSS();
        int i = 0;
        while (i < this.browserWindows.size()) {
            BrowserWindow bw = (BrowserWindow)this.browserWindows.elementAt(i);
            bw.updateUserFonts();
            ++i;
        }
    }

    void addBookmark(String title, String location) {
        this.getProperties().appendBookmark(title, location);
        this.resetBookmarks();
    }

    void resetBookmarks() {
        int i = 0;
        while (i < this.browserWindows.size()) {
            BrowserWindow bw = (BrowserWindow)this.browserWindows.elementAt(i);
            bw.resetBookmarks();
            ++i;
        }
    }

    void updateUI() {
        if (this.dialogs != null) {
            this.dialogs.updateUI();
        }
        if (this.console != null) {
            SwingUtilities.updateComponentTreeUI(this.console);
        }
        int i = 0;
        while (i < this.browserWindows.size()) {
            BrowserWindow bw = (BrowserWindow)this.browserWindows.elementAt(i);
            bw.updateUI();
            ++i;
        }
    }

    public void register(JFrame frame) {
        this.otherWindows.addElement(frame);
    }

    public void unregister(JFrame frame) {
        this.otherWindows.removeElement(frame);
    }

    void disposeTopLevelContainer(BrowserWindow b) {
        if (this.browserWindows.size() <= 1) {
            this.quit();
            return;
        }
        BrowserWindow bw = null;
        int i = 0;
        while (i < this.browserWindows.size()) {
            bw = (BrowserWindow)this.browserWindows.elementAt(i);
            if (bw == b) {
                this.browserWindows.removeElement(bw);
                this.browserWindowHistory.removeElement(bw);
                bw.removeWindowListener(this.windowListener);
                bw.setVisible(false);
                bw.dispose();
                break;
            }
            ++i;
        }
    }

    public void quit() {
        boolean quitAnyway;
        if (!this.otherWindows.isEmpty() && !(quitAnyway = this.getProperties().res.displayYesOrNo("quit.download"))) {
            return;
        }
        Component bw = null;
        int i = 0;
        while (i < this.browserWindows.size()) {
            bw = (BrowserWindow)this.browserWindows.elementAt(i);
            if (((Window)bw).isShowing()) break;
            ++i;
        }
        if (bw != null) {
            Dimension sz = bw.getSize();
            this.getProperties().setInt("application.height", sz.height);
            this.getProperties().setInt("application.width", sz.width);
        }
        this.getProperties().saveStormPageFormat(this.stormPageFormat);
        this.getProperties().saveAndEnd();
        System.exit(0);
    }

    public void print(String longString) {
    }

    private Frame findFrame(Viewport vp) {
        Viewport topVP = vp.getTopParent();
        Container x = topVP.getTopLevelContainer();
        while (x != null && !(x instanceof Frame)) {
            x = x.getParent();
        }
        if (x == null) {
            return null;
        }
        return (Frame)x;
    }

    private JDialog createDialog(Frame top, String title) {
        JDialog dlg = new JDialog(top, title, true);
        return dlg;
    }

    private void packAndShow(JDialog d, Frame f) {
        int y;
        d.pack();
        Point p = f.getLocation();
        Dimension fd = f.getSize();
        Dimension dd = d.getSize();
        int x = p.x + (fd.width - dd.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = p.y + (fd.height - dd.height) / 2) < 0) {
            y = 0;
        }
        d.setLocation(x, y);
        d.show();
        d.dispose();
    }

    void showMessage(Viewport vp, String title, String message) {
        Resources res = this.getProperties().res;
        Frame f = this.findFrame(vp);
        JDialog dlg = this.createDialog(f, title);
        JPanel body = new JPanel();
        body.add(new MultiLabel(message, 100));
        JButton btn_ok = new JButton(res.strButtonOk());
        btn_ok.addActionListener(new Action(dlg, 1, null));
        Container content = dlg.getContentPane();
        content.add((Component)body, "North");
        content.add((Component)btn_ok, "South");
        this.packAndShow(dlg, f);
    }

    boolean showConfirmation(Viewport vp, String title, String message) {
        Resources res = this.getProperties().res;
        boolean[] result = new boolean[]{false};
        Frame f = this.findFrame(vp);
        JDialog dlg = this.createDialog(f, title);
        JPanel body = new JPanel();
        body.add(new MultiLabel(message, 100));
        JButton btn_ok = new JButton(res.strButtonOk());
        btn_ok.addActionListener(new Action(dlg, 2, result));
        JButton btn_cancel = new JButton(res.strButtonCancel());
        btn_cancel.addActionListener(new Action(dlg, 1, null));
        JPanel buttons = new JPanel();
        buttons.add(btn_ok);
        buttons.add(btn_cancel);
        Container content = dlg.getContentPane();
        content.add((Component)body, "North");
        content.add((Component)buttons, "South");
        this.packAndShow(dlg, f);
        return result[0];
    }

    String showPrompt(Viewport vp, String title, String message, String defaultValue) {
        Resources res = this.getProperties().res;
        boolean[] result = new boolean[]{false};
        Frame f = this.findFrame(vp);
        JDialog dlg = this.createDialog(f, title);
        JPanel body = new JPanel();
        body.setLayout(new GridLayout(2, 1));
        body.add(new MultiLabel(message, 100));
        JTextField text = new JTextField(defaultValue, 30);
        text.addActionListener(new Action(dlg, 2, result));
        body.add(text);
        JButton btn_ok = new JButton(res.strButtonOk());
        btn_ok.addActionListener(new Action(dlg, 2, result));
        JButton btn_cancel = new JButton(res.strButtonCancel());
        btn_cancel.addActionListener(new Action(dlg, 1, null));
        JPanel buttons = new JPanel();
        buttons.add(btn_ok);
        buttons.add(btn_cancel);
        Container content = dlg.getContentPane();
        content.add((Component)body, "North");
        content.add((Component)buttons, "South");
        this.packAndShow(dlg, f);
        return result[0] ? text.getText() : null;
    }

    public PropertiesManager getProperties() {
        return this.properties;
    }

    public StormPageFormat getStormPageFormat() {
        return this.stormPageFormat;
    }

    public void setStormPageFormat(StormPageFormat stormPageFormat) {
        this.stormPageFormat = stormPageFormat;
    }

    static Vector ra$browserWindowHistory(WindowManager windowManager) {
        return windowManager.browserWindowHistory;
    }

    final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent event) {
            BrowserWindow _browserWindow = (BrowserWindow)event.getSource();
            if (WindowManager.ra$browserWindowHistory(WindowManager.this).contains(_browserWindow)) {
                WindowManager.ra$browserWindowHistory(WindowManager.this).removeElement(_browserWindow);
            }
            WindowManager.ra$browserWindowHistory(WindowManager.this).addElement(_browserWindow);
        }
    }

    private class StormObserver
    extends CallbackAdapter {
        public Container createTopLevelContainer(Viewport viewport) {
            return WindowManager.this.newBrowserComponent(viewport);
        }

        public void disposeTopLevelContainer(Viewport viewport) {
            BrowserWindow.disposeTopLevelContainer(viewport);
        }

        public boolean allowScriptClose(Viewport vp, boolean openedByScript) {
            if (!openedByScript) {
                return WindowManager.this.showConfirmation(vp, "Script Request Conformation", "Close the window as requested by script code?");
            }
            return true;
        }

        public long getMaxScriptRunningTime() {
            return Defs.sysPropertyInt("ice.scripters.timelimit", 5000);
        }

        public boolean interruptLongRunningScript(Viewport vp, long scriptRunningTime) {
            return WindowManager.this.showConfirmation(vp, "Script Problem", "Long running script is detected (run time = " + scriptRunningTime + " ms). Terminate it?");
        }

        public void reportScriptError(Viewport vp, boolean justWarning, String errorMessage, String url, int lineNumber, String lineSource, int lineOffset) {
            String title = justWarning ? "SCRIPT WARNING" : "SCRIPT ERROR";
            StringBuffer sb = new StringBuffer();
            sb.append(url);
            sb.append(':');
            sb.append(lineNumber + 1);
            sb.append(':');
            sb.append(lineOffset);
            sb.append(": ");
            sb.append(errorMessage);
            if (lineSource != null) {
                sb.append('\n');
                sb.append(lineSource);
                sb.append('\n');
                int i = 0;
                while (i < lineOffset - 1) {
                    sb.append('.');
                    ++i;
                }
                sb.append('^');
            }
            String message = sb.toString();
            if (Debug.trace) {
                Debug.trace(title + ": " + message);
            }
            if (WindowManager.this.getProperties().getBoolean("script.reportErrors")) {
                WindowManager.this.showMessage(vp, title, message);
            }
        }

        public void scriptAlert(Viewport vp, String msg) {
            WindowManager.this.showMessage(vp, "Script Alert", msg);
        }

        public boolean scriptConfirm(Viewport vp, String msg) {
            return WindowManager.this.showConfirmation(vp, "Script Confirm", msg);
        }

        public String scriptPrompt(Viewport vp, String msg, String defVal) {
            return WindowManager.this.showPrompt(vp, "Script Prompt", msg, defVal);
        }

        public void scriptPrint(Viewport view) {
            Container c = view.getTopLevelContainer();
            if (c != null && c instanceof BrowserWindow) {
                BrowserWindow bw = (BrowserWindow)c;
                1 doSwingWork = new 1(this, bw);
                SwingUtilities.invokeLater(doSwingWork);
            }
        }

        private StormObserver() {
        }

        StormObserver(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ BrowserWindow v$bw;
            final /* synthetic */ StormObserver this$0;

            public void run() {
                this.v$bw.printViewport();
            }

            public 1(StormObserver stormObserver, BrowserWindow browserWindow) {
                this.v$bw = browserWindow;
                this.this$0 = stormObserver;
            }
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ WindowManager v$thisWm;
        final /* synthetic */ WindowManager this$0;

        public void run() {
            if (this.this$0.console == null) {
                this.this$0.console = new Console(this.v$thisWm);
            }
            if (!this.this$0.console.isVisible()) {
                this.this$0.console.setVisible(true);
            }
        }

        public 2(WindowManager windowManager, WindowManager windowManager2) {
            this.v$thisWm = windowManager2;
            this.this$0 = windowManager;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ String v$finalLoc;
        private final /* synthetic */ String v$finalTargetFrame;
        final /* synthetic */ WindowManager this$0;

        public void run() {
            this.this$0.storm.renderContent(this.v$finalLoc, null, this.v$finalTargetFrame);
        }

        public 3(WindowManager windowManager, String string, String string2) {
            this.v$finalTargetFrame = string2;
            this.v$finalLoc = string;
            this.this$0 = windowManager;
        }
    }

    private static final class Action
    implements ActionListener {
        private JDialog dialog;
        private int actionId;
        private Object result;

        Action(JDialog dialog, int actionId, Object result) {
            this.dialog = dialog;
            this.actionId = actionId;
            this.result = result;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.actionId) {
                case 1: {
                    this.dialog.setVisible(false);
                    break;
                }
                case 2: {
                    ((boolean[])this.result)[0] = true;
                    this.dialog.setVisible(false);
                    break;
                }
            }
        }
    }
}

