/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing.storage;

import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import ice.util.io.DataStorage;
import ice.util.io.IOKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirectoryStorage
extends DataStorage {
    private String userHomePath;
    private String dataSubdirPath;
    private final HashArray lockMap;
    private File rootDir;

    private void $init$() {
        this.lockMap = new HashArray();
    }

    public static DirectoryStorage inHomeDir(String subdir) {
        String home = Defs.sysProperty("user.home");
        if (home == null || !new File(home).exists()) {
            home = Defs.sysProperty("user.dir");
        }
        return new DirectoryStorage(home, subdir);
    }

    public DirectoryStorage(String userHomePath, String dataSubdirPath) {
        this.$init$();
        this.userHomePath = userHomePath;
        this.dataSubdirPath = dataSubdirPath;
    }

    private Object getDataLock(String dataName) {
        return this.lockMap.ensureEntry(dataName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String dataName) throws IOException {
        byte[] data;
        Object object = this.getDataLock(dataName);
        synchronized (object) {
            File file = this.fileForName(dataName);
            if (!file.exists()) {
                data = null;
            } else {
                FileInputStream is = new FileInputStream(file);
                try {
                    long length = file.length();
                    int bufferSize = length == 0L ? 4096 : Integer.MAX_VALUE & (int)length;
                    data = IOKit.readAll(is, bufferSize);
                }
                finally {
                    is.close();
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String dataName, byte[] array, int offset, int length) throws IOException {
        Object object = this.getDataLock(dataName);
        synchronized (object) {
            File file = this.fileForName(dataName);
            FileOutputStream os = new FileOutputStream(file);
            try {
                os.write(array, offset, length);
            }
            finally {
                os.close();
            }
        }
    }

    private File fileForName(String name) {
        File root = this.rootDir;
        if (root == null) {
            root = new File(this.userHomePath, this.dataSubdirPath);
            if (!root.exists()) {
                root.mkdirs();
            }
            this.rootDir = root;
        }
        File dir = root;
        String[] path = CharKit.split(47, name);
        int N = path.length;
        if (N > 1) {
            int i = 0;
            while (i != N - 1) {
                if (!(dir = new File(dir, path[i])).exists()) {
                    dir.mkdir();
                }
                ++i;
            }
        }
        return new File(dir, path[N - 1]);
    }
}

