/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.scripters.WindowObj;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.storm.HistoryEntry;
import ice.storm.HistoryManager;

class HistoryObj
extends DynamicList {
    private final WindowObj window;
    private static final int Method_back = -1;
    private static final int Method_forward = -2;
    private static final int Method_go = -3;

    HistoryObj(WindowObj window_arg) {
        this.window = window_arg;
    }

    public int getLength() {
        int result = 0;
        HistoryEntry[] arr = this.window.storm.getHistoryManager().getBackEntries(this.window.theView.getId());
        if (arr != null) {
            result = arr.length;
        }
        return result;
    }

    protected Object script_item(int index, DynEnv env) {
        String result = null;
        HistoryEntry[] arr = this.window.storm.getHistoryManager().getBackEntries(this.window.theView.getId());
        if (arr != null) {
            int l = arr.length;
            if (0 <= index && index < arr.length) {
                result = arr[index].getURL();
            }
        }
        return result;
    }

    protected Object script_namedItem(String name, DynEnv env) {
        return null;
    }

    private void historyGo(int how_far) {
        HistoryManager hist = this.window.storm.getHistoryManager();
        String view_id = this.window.theView.getId();
        if (how_far > 0) {
            hist.goForward(view_id, how_far);
        } else if (how_far < 0) {
            hist.goBack(view_id, -how_far);
        }
    }

    private void script_back(Object[] args, DynEnv env) {
        this.historyGo(-1);
    }

    private void script_forward(Object[] args, DynEnv env) {
        this.historyGo(1);
    }

    private void script_go(Object[] args, DynEnv env) {
        int how_far = env.toInt(args, 0);
        this.historyGo(how_far);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = HistoryObj.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = HistoryObj.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = HistoryObj.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id) {
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.script_back(args, env);
                break;
            }
            case -2: {
                this.script_forward(args, env);
                break;
            }
            case -3: {
                this.script_go(args, env);
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        int s_length = s.length();
        if (s_length == 2) {
            guess = "go";
            id = -3;
        } else if (s_length == 4) {
            guess = "back";
            id = -1;
        } else if (s_length == 7) {
            guess = "forward";
            id = -2;
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

