/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.debug.Debug;
import ice.scripters.FramesList;
import ice.scripters.HistoryObj;
import ice.scripters.LocationObj;
import ice.scripters.NavigatorObj;
import ice.scripters.ScreenObj;
import ice.scripters.XMLHttpRequestObj;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Session;
import ice.util.net.URLResolver;
import ice.util.security.SecurityKit;
import java.awt.Component;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class WindowObj
extends DynamicObject {
    private static final boolean ignore_window_decoration = Debug.extra && Defs.booleanProperty("ice.debug.ignore_window_decoration");
    private static final Object WINDOW_OPENER_PROPERTY = new Object();
    private static final Object DIALOG_ARGS_PROPERTY = new Object();
    private static final Object STORM_NAVIGATOR_KEY = new Object();
    private static final Object STORM_SCREEN_KEY = new Object();
    private static final int minimalTimeout = WindowObj.getMinimalTimeout();
    private int nextTimerID;
    Object pageTag;
    final HashArray timerMap;
    StormBase storm;
    Viewport theView;
    WindowObj theOpener;
    String _defaultStatus;
    String _currentStatus;
    final HistoryObj theHistory;
    final LocationObj theLocation;
    final FramesList theFrames;
    final Vector xmlHttpRequestList;
    private Object dialogArgs;
    private Object dialogReturnValue;
    private Object childDialogReturnValue;
    private static final int Field_closed = 1;
    private static final int Field_defaultStatus = 2;
    private static final int Field_dialogArguments = 3;
    private static final int Field_document = 4;
    private static final int Field_frames = 5;
    private static final int Field_history = 6;
    private static final int Field_id = 7;
    private static final int Field_innerHeight = 8;
    private static final int Field_innerWidth = 9;
    private static final int Field_length = 10;
    private static final int Field_location = 11;
    private static final int Field_locationbar = 12;
    private static final int Field_menubar = 13;
    private static final int Field_name = 14;
    private static final int Field_navigator = 15;
    private static final int Field_opener = 16;
    private static final int Field_outerHeight = 17;
    private static final int Field_outerWidth = 18;
    private static final int Field_pageXOffset = 19;
    private static final int Field_pageYOffset = 20;
    private static final int Field_parent = 21;
    private static final int Field_personalbar = 22;
    private static final int Field_pilot = 23;
    private static final int Field_returnValue = 24;
    private static final int Field_scrollbars = 25;
    private static final int Field_self = 26;
    private static final int Field_screen = 27;
    private static final int Field_status = 28;
    private static final int Field_statusbar = 29;
    private static final int Field_toolbar = 30;
    private static final int Field_top = 31;
    private static final int Field_window = 32;
    private static final int Method_alert = -1;
    private static final int Method_back = -2;
    private static final int Method_blur = -3;
    private static final int Method_captureEvents = -4;
    private static final int Method_clearInterval = -5;
    private static final int Method_clearTimeout = -6;
    private static final int Method_close = -7;
    private static final int Method_confirm = -8;
    private static final int Method_debug = -9;
    private static final int Method_disableExternalCapture = -10;
    private static final int Method_enableExternalCapture = -11;
    private static final int Method_execScript = -12;
    private static final int Method_find = -13;
    private static final int Method_focus = -14;
    private static final int Method_forward = -15;
    private static final int Method_handleEvent = -16;
    private static final int Method_home = -17;
    private static final int Method_moveBy = -18;
    private static final int Method_moveTo = -19;
    private static final int Method_navigate = -20;
    private static final int Method_open = -21;
    private static final int Method_openDocument = -22;
    private static final int Method_print = -23;
    private static final int Method_prompt = -24;
    private static final int Method_releaseEvents = -25;
    private static final int Method_resizeBy = -26;
    private static final int Method_resizeTo = -27;
    private static final int Method_routeEvent = -28;
    private static final int Method_scrollBy = -29;
    private static final int Method_scrollTo = -30;
    private static final int Method_setInterval = -31;
    private static final int Method_setTimeout = -32;
    private static final int Method_showModalDialog = -33;
    private static final int Method_showModelessDialog = -34;
    private static final int Method_stop = -35;
    private static final int Field_clientInformation = 15;
    private static final int Method_scroll = -30;

    private void $init$() {
        this.nextTimerID = 0;
        this.pageTag = new Object();
        this.timerMap = new HashArray();
        this._defaultStatus = "";
        this._currentStatus = "";
        this.theHistory = new HistoryObj(this);
        this.theLocation = new LocationObj(this);
        this.theFrames = new FramesList(this);
        this.xmlHttpRequestList = new Vector();
        this.dialogArgs = null;
        this.dialogReturnValue = null;
        this.childDialogReturnValue = null;
    }

    public static WindowObj create(StormBase storm, Viewport view) {
        return new WindowObj(storm, view);
    }

    public WindowObj(StormBase storm_arg, Viewport view) {
        this.$init$();
        this.storm = storm_arg;
        this.theView = view;
        this.theOpener = (WindowObj)view.getProperty(WINDOW_OPENER_PROPERTY);
        this.dialogArgs = view.getProperty(DIALOG_ARGS_PROPERTY);
    }

    public void unlinkAllSlots() {
        if (this.theOpener != null) {
            this.theOpener.childDialogReturnValue = this.dialogReturnValue;
        }
        this.pageTag = new Object();
        this.timerMap.clear();
        super.unlinkAllSlots();
        this.theHistory.unlinkAllSlots();
        this.theLocation.unlinkAllSlots();
        this.theFrames.unlinkAllSlots();
        if (!this.xmlHttpRequestList.isEmpty()) {
            Enumeration _xmlHttpRequests = this.xmlHttpRequestList.elements();
            while (_xmlHttpRequests.hasMoreElements()) {
                ((XMLHttpRequestObj)_xmlHttpRequests.nextElement()).unlinkAllSlots();
            }
            this.xmlHttpRequestList.removeAllElements();
        }
    }

    public static WindowObj getWindow(Viewport view) {
        return (WindowObj)view.getWindowObj();
    }

    private boolean script_getClosed() {
        boolean isClosed = false;
        if (this.theView == null) {
            isClosed = true;
        } else if (this.theView.getTopLevelContainer() == null) {
            isClosed = true;
        }
        return isClosed;
    }

    public DynamicObject getDocument() {
        DynamicObject result = this.theView.getDocumentObject();
        return result;
    }

    public String getName() {
        if (this.theView.isSyntheticName()) {
            return "";
        }
        return this.theView.getName();
    }

    public Viewport getViewport() {
        return this.theView;
    }

    public WindowObj getParent() {
        Viewport parent_view = this.theView.getParent();
        if (parent_view != null) {
            return WindowObj.getWindow(parent_view);
        }
        return null;
    }

    public WindowObj script_getParent() {
        WindowObj result = this.getParent();
        if (result == null) {
            result = this;
        }
        return result;
    }

    public FramesList getFrames() {
        return this.theFrames;
    }

    public WindowObj getTop() {
        Viewport parent_view;
        Viewport v = this.theView;
        while ((parent_view = v.getParent()) != null) {
            v = parent_view;
        }
        return WindowObj.getWindow(v);
    }

    public LocationObj getLocation() {
        return this.theLocation;
    }

    private int getInnerHeight() {
        Component c = this.theView.getPilotComponent();
        return c != null ? c.getSize().height : 0;
    }

    private int getInnerWidth() {
        Component c = this.theView.getPilotComponent();
        return c != null ? c.getSize().width : 0;
    }

    private DocPane getDocPane() {
        Pilot pilot = this.getPilot();
        if (pilot != null) {
            return pilot.getDocPane();
        }
        return null;
    }

    private int getPageXOffset() {
        DocPane pane = this.getDocPane();
        if (pane != null) {
            return pane.getScrollX();
        }
        return 0;
    }

    private int getPageYOffset() {
        DocPane pane = this.getDocPane();
        if (pane != null) {
            return pane.getScrollY();
        }
        return 0;
    }

    private NavigatorObj getNavigator() {
        Session session = this.storm.getSession();
        NavigatorObj x = (NavigatorObj)session.getEntry(STORM_NAVIGATOR_KEY);
        if (x == null) {
            x = new NavigatorObj(this.storm);
            x = (NavigatorObj)session.initEntry(STORM_NAVIGATOR_KEY, x);
        }
        return x;
    }

    private Pilot getPilot() {
        Pilot pilot;
        Viewport view = this.theView;
        if (view != null && (pilot = view.getPilot()) != null) {
            return pilot;
        }
        return null;
    }

    private ScreenObj getScreen() {
        Session session = this.storm.getSession();
        ScreenObj x = (ScreenObj)session.getEntry(STORM_SCREEN_KEY);
        if (x == null) {
            x = (ScreenObj)session.initEntry(STORM_SCREEN_KEY, new ScreenObj());
        }
        return x;
    }

    private String resolveScriptUrl(String uriFragment) {
        if (uriFragment != null) {
            String base = null;
            Viewport view = this.theView.getContextViewport();
            if (view != null && view != this.theView) {
                base = view.getBaseUrl();
            }
            if (base == null && (base = this.theView.getBaseUrl()) == null && this.theOpener != null) {
                base = this.theOpener.theView.getBaseUrl();
            }
            return URLResolver.resolve(base, uriFragment);
        }
        return null;
    }

    void setLocation(String loc) {
        Scripter scripter = this.storm.getScripterForCodeLocation(loc);
        if (scripter != null) {
            scripter.evalCodeLocation(this.theView, loc);
        } else {
            this.changeLocation(this.resolveScriptUrl(loc));
        }
    }

    private void changeLocation(String uri) {
        this.storm.runOnEventThreadLater(new 1(this, uri), 0L);
    }

    private void script_setStatus(String newStatus) {
        if (!this._currentStatus.equals(newStatus)) {
            this._currentStatus = newStatus;
            this.theView.getPilot().firePropertyChange("statusLine", null, newStatus);
        }
    }

    private void script_alert(String message) {
        ScripterCallback c;
        if (message == null) {
            message = "";
        }
        if ((c = this.storm.getScripterCallback()) != null) {
            SecurityKit.doPrivileged(CallbackAdapter.box_scriptAlert(c, this.theView, message));
        }
    }

    private void script_blur() {
    }

    private void script_captureEvents(Object itsEvent) {
    }

    private void script_clearInterval(int timer_id) {
        this.clearTimerEvents(timer_id);
    }

    private void script_clearTimeout(Object[] args, DynEnv env) {
        long id;
        if (args.length != 0 && (id = env.toPossibleInt(args[0])) >= 0L) {
            int timer_id = (int)id;
            this.clearTimerEvents(timer_id);
            return;
        }
    }

    private void clearTimerEvents(int timer_id) {
        this.timerMap.remove(timer_id);
    }

    private void script_close(Object[] ignoredArgs, DynEnv env) {
        boolean canClose;
        boolean bl = canClose = this.theView.getParent() == null;
        if (canClose) {
            Object ret;
            boolean openedByScript = this.theOpener != null;
            ScripterCallback c = this.storm.getScripterCallback();
            canClose = c != null ? (ret = SecurityKit.doPrivileged(CallbackAdapter.box_allowScriptClose(c, this.theView, openedByScript))) == Boolean.TRUE : openedByScript;
        }
        if (Debug.trace) {
            Debug.trace("allowed=" + canClose + " view=" + this.theView);
        }
        if (canClose) {
            if (!this.storm.isEventThread()) {
                this.storm.runOnEventThreadAndWait(new WindowCloser(this.storm, this.theView.getId()), 0L);
            } else {
                this.storm.closeViewport(this.theView.getId());
            }
        }
    }

    private boolean script_confirm(String message) {
        ScripterCallback c;
        if (message == null) {
            message = "";
        }
        if ((c = this.storm.getScripterCallback()) != null) {
            return Boolean.TRUE == SecurityKit.doPrivileged(CallbackAdapter.box_scriptConfirm(c, this.theView, message));
        }
        return false;
    }

    public XMLHttpRequestObj newXMLHttpRequest() {
        XMLHttpRequestObj _xmlHttpRequestObject = new XMLHttpRequestObj();
        _xmlHttpRequestObject.setWindowObject(this);
        this.xmlHttpRequestList.addElement(_xmlHttpRequestObject);
        return _xmlHttpRequestObject;
    }

    static void script_debug(Object[] args, DynEnv env) {
        if (Debug.trace) {
            Debug.trace(env.fuseArgsToString(args));
        }
    }

    private void script_disableExternalCapture() {
    }

    private void script_enableExternalCapture() {
    }

    private Object script_execScript(Object[] args, DynEnv env) {
        String script = env.toStr(args, 0);
        return env.getScripter().eval(this.theView, script, "<source fed to window.execScript()>", 0);
    }

    private boolean script_find(Object[] args, DynEnv env) {
        return false;
    }

    private void script_focus() {
        Pilot pilot = this.theView.getPilot();
        if (pilot == null) {
            return;
        }
        DocPane docPane = pilot.getDocPane();
        if (docPane != null) {
            docPane.reqFocus();
        }
    }

    private void script_handleEvent(Object event) {
    }

    private void script_home() {
    }

    private void script_moveBy(int horizontal, int vertical) {
    }

    private void script_moveTo(int xcoord, int ycoord) {
    }

    private void script_openDocument(Object[] args, DynEnv env) {
        if (args.length >= 3) {
            this.script_open(args, env);
        } else {
            String mimeType = null;
            String mode = null;
            if (args.length != 0) {
                Object arg_1;
                Object arg_0 = args[0];
                if (arg_0 != null) {
                    mimeType = env.toStr(arg_0);
                }
                if (args.length != 1 && (arg_1 = args[1]) != null) {
                    mode = env.toStr(arg_1);
                }
            }
            this.openDocument(mimeType, mode);
        }
    }

    private void openDocument(String mimeType, String mode) {
    }

    private Object script_open(Object[] args, DynEnv env) {
        String uri = null;
        String windowName = null;
        String params = null;
        int arg_count = args.length;
        if (arg_count >= 1) {
            uri = env.toStr(args, 0);
            if (uri != null && uri.length() == 0) {
                uri = null;
            }
            if (arg_count >= 2) {
                if (args[1] != null) {
                    windowName = env.toStr(args, 1);
                }
                if (arg_count >= 3) {
                    params = env.toStr(args, 2);
                    if (arg_count >= 4) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(params);
                        int i = 3;
                        while (i != arg_count) {
                            sb.append(',');
                            sb.append(env.toStr(args[i]));
                            ++i;
                        }
                        params = sb.toString();
                    }
                }
            }
        }
        return this.open(uri, windowName, params);
    }

    private String convert_window_name_for_open(String windowName) {
        Viewport v;
        if (windowName != null && (v = this.theView.findViewportInTreeByName(windowName)) != null) {
            windowName = v.getId();
        }
        return windowName;
    }

    private Object open(String location, String windowName, String params_string) {
        String uri = this.resolveScriptUrl(location);
        windowName = this.convert_window_name_for_open(windowName);
        Viewport v = null;
        if (windowName != null) {
            v = this.storm.findViewportByName(windowName);
        }
        if (Debug.trace) {
            Debug.trace("windowName=" + windowName + " uri=" + uri);
        }
        if (v == null) {
            ViewportGuiParams guiParams = null;
            if (params_string != null) {
                guiParams = new ViewportGuiParams();
                this.convertWindowParamsIntoProperties(guiParams, params_string);
            }
            if (ignore_window_decoration) {
                guiParams = null;
            }
            v = new Viewport(this.storm, windowName);
            if (guiParams != null) {
                if (guiParams.scrollbars) {
                    v.setProperty("scrolling", "yes");
                } else {
                    v.setProperty("scrolling", "no");
                }
                v.setGuiParams(guiParams);
            }
            v.setProperty(WINDOW_OPENER_PROPERTY, this);
            v.setLocationUrl(uri);
            if (!this.storm.configureViewport(v)) {
                return null;
            }
            this.storm.clearContent("text/html", v.getId());
        }
        if (uri != null) {
            ContentLoader cl = this.storm.getContentLoaderFactory().createContentLoader(uri, null);
            this.storm.renderContent(cl, v.getId());
        }
        return WindowObj.getWindow(v);
    }

    private Object script_showDialog(Object[] args, boolean isModal, DynEnv env) {
        String uri = null;
        String params_string = null;
        Object dialogArgs = null;
        if (args.length > 0) {
            uri = env.toStr(args, 0);
        }
        if (args.length > 1 && args[1] != null) {
            dialogArgs = args[1];
        }
        if (args.length > 2 && args[2] != null) {
            params_string = env.toStr(args, 2);
        }
        if (uri != null) {
            uri = this.resolveScriptUrl(uri);
        }
        ViewportGuiParams guiParams = new ViewportGuiParams();
        if (params_string != null) {
            this.convertDialogFeaturesIntoProperties(guiParams, params_string);
        }
        if (isModal) {
            guiParams.modal = true;
        }
        if (ignore_window_decoration) {
            guiParams = null;
        }
        Viewport v = new Viewport(this.storm);
        if (guiParams != null) {
            v.setGuiParams(guiParams);
        }
        v.setProperty(WINDOW_OPENER_PROPERTY, this);
        v.setProperty(DIALOG_ARGS_PROPERTY, dialogArgs);
        if (!this.storm.configureViewport(v)) {
            return null;
        }
        if (uri != null) {
            this.storm.renderContent(uri, null, v.getId());
        } else {
            this.storm.clearContent("text/html", v.getId());
        }
        Object result = isModal ? this.childDialogReturnValue : WindowObj.getWindow(v);
        return result;
    }

    private void convertDialogFeaturesIntoProperties(ViewportGuiParams params, String data) {
        StringTokenizer st = new StringTokenizer(data, ";");
        if (st.hasMoreTokens()) {
            params.center = true;
            params.dialogHide = false;
            params.edge = 0;
            params.help = true;
            params.scroll = true;
            params.status = true;
            params.unadorned = false;
            params.location = false;
            params.toolbar = false;
            params.menubar = false;
            params.dialog = true;
        }
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            String name = null;
            String value = null;
            int i = t.indexOf(58);
            if (i > 0) {
                name = t.substring(0, i).trim();
                value = t.substring(i + 1).trim();
            }
            if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
            params.setValue(name, value);
        }
    }

    private void convertWindowParamsIntoProperties(ViewportGuiParams params, String data) {
        StringTokenizer st = new StringTokenizer(data, ",");
        if (st.hasMoreTokens()) {
            params.location = false;
            params.menubar = false;
            params.status = false;
            params.toolbar = false;
        }
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            String name = null;
            String value = null;
            int i = t.indexOf(61);
            if (i > 0) {
                name = t.substring(0, i).trim();
                value = t.substring(i + 1).trim();
            } else {
                name = t.trim();
                value = "yes";
            }
            if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
            params.setValue(name.toLowerCase(), value);
        }
    }

    private Object script_getDialogArguments() {
        return this.dialogArgs;
    }

    private Object script_getReturnValue() {
        return this.dialogReturnValue;
    }

    private void script_setReturnValue(Object rv) {
        this.dialogReturnValue = rv;
    }

    private void script_print() {
        ScripterCallback c = this.storm.getScripterCallback();
        if (c != null) {
            SecurityKit.doPrivileged(CallbackAdapter.box_scriptPrint(c, this.theView));
        }
    }

    private String script_prompt(String message, String defaultValue) {
        ScripterCallback c;
        if (message == null) {
            message = "";
        }
        if ((c = this.storm.getScripterCallback()) != null) {
            return (String)SecurityKit.doPrivileged(CallbackAdapter.box_scriptPrompt(c, this.theView, message, defaultValue));
        }
        return defaultValue;
    }

    private void script_releaseEvents(Object event) {
    }

    private void script_resizeBy(int horizontal, int vertical) {
    }

    private void script_resizeTo(int outerWidth, int outerHeight) {
    }

    private void script_routeEvent(Object event) {
    }

    private void script_scrollBy(int dx, int dy) {
        DocPane pane = this.getDocPane();
        if (pane != null) {
            int x = pane.getScrollX() + dx;
            int y = pane.getScrollY() + dy;
            pane.setScrollPosition(x, y);
        }
    }

    private void script_scrollTo(int x, int y) {
        DocPane pane = this.getDocPane();
        if (pane != null) {
            pane.setScrollPosition(x, y);
        }
    }

    private int script_setInterval(Object[] args, DynEnv env) {
        return this.setTimer(args, env, true);
    }

    private int script_setTimeout(Object[] args, DynEnv env) {
        return this.setTimer(args, env, false);
    }

    private int setTimer(Object[] args, DynEnv env, boolean shouldRepeat) {
        int N;
        Object function = env.getRawObject(args, 0);
        int msec = env.toInt(args, 1);
        if (msec < minimalTimeout) {
            msec = minimalTimeout;
        }
        if ((N = args.length - 2) <= 0) {
            args = Defs.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] tmp = new Object[N];
            System.arraycopy(args, 2, tmp, 0, N);
            args = tmp;
        }
        ScriptTimer t = new ScriptTimer(this);
        t.timer_id = this.nextTimerID++;
        this.timerMap.put(t.timer_id, (Object)t);
        if (this.nextTimerID < 0) {
            this.nextTimerID = 0;
        }
        t.shouldRepeat = shouldRepeat;
        t.function = function;
        t.delay = msec;
        t.args = args;
        t.env = env;
        this.storm.runOnEventThreadLater(t, msec);
        return t.timer_id;
    }

    private static int getMinimalTimeout() {
        return Defs.sysPropertyInt("ice.scripters.minTimeout", 5);
    }

    private void script_stop() {
        this.storm.stopLoading(this.theView.getId());
    }

    public String toString() {
        return "[Window " + this.getName() + "]";
    }

    public Object getDynamicValue(String name, DynEnv env) {
        Object ret;
        Pilot pilot = this.getPilot();
        if (pilot != null && (ret = pilot.getDynamicValueOnWindow(this, name, env)) != DynamicObject.NOT_FOUND) {
            return ret;
        }
        int id = WindowObj.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int ret;
        Pilot pilot = this.getPilot();
        if (pilot != null && (ret = pilot.setDynamicValueOnWindow(this, name, value, env)) != 0) {
            return ret;
        }
        int id = WindowObj.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        Object ret;
        Pilot pilot = this.getPilot();
        if (pilot != null && (ret = pilot.execDynamicMethodOnWindow(this, name, args, env)) != DynamicObject.NOT_FOUND) {
            return ret;
        }
        int id = WindowObj.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return env.wrapBoolean(this.script_getClosed());
            }
            case 2: {
                return this._defaultStatus;
            }
            case 3: {
                return this.script_getDialogArguments();
            }
            case 4: {
                return this.getDocument();
            }
            case 5: {
                return this.getFrames();
            }
            case 6: {
                return this.theHistory;
            }
            case 7: {
                return this.theView.getId();
            }
            case 8: 
            case 17: {
                return env.wrapInt(this.getInnerHeight());
            }
            case 9: 
            case 18: {
                return env.wrapInt(this.getInnerWidth());
            }
            case 10: {
                return env.wrapInt(this.getFrames().getLength());
            }
            case 11: {
                return this.getLocation();
            }
            case 12: {
                return null;
            }
            case 13: {
                return env.onNotImplemented();
            }
            case 14: {
                return this.getName();
            }
            case 15: {
                return this.getNavigator();
            }
            case 16: {
                return this.theOpener;
            }
            case 19: {
                return env.wrapInt(this.getPageXOffset());
            }
            case 20: {
                return env.wrapInt(this.getPageYOffset());
            }
            case 21: {
                return this.script_getParent();
            }
            case 22: {
                return env.onNotImplemented();
            }
            case 24: {
                return this.script_getReturnValue();
            }
            case 27: {
                return this.getScreen();
            }
            case 25: {
                return env.onNotImplemented();
            }
            case 26: {
                return this;
            }
            case 28: {
                return this._currentStatus;
            }
            case 29: {
                return env.onNotImplemented();
            }
            case 30: {
                return env.onNotImplemented();
            }
            case 31: {
                return this.getTop();
            }
            case 32: {
                return this;
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 2: {
                this._defaultStatus = env.toStr(value);
                return 1;
            }
            case 4: {
                return 1;
            }
            case 11: {
                this.setLocation(env.toStr(value));
                return 1;
            }
            case 14: {
                this.theView.setName(env.toStr(value));
                return 1;
            }
            case 21: {
                return 1;
            }
            case 24: {
                this.script_setReturnValue(value);
                return 1;
            }
            case 26: {
                return 1;
            }
            case 28: {
                this.script_setStatus(env.toStr(value));
                return 1;
            }
            case 31: {
                return 1;
            }
            case 32: {
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.script_alert(env.toStr(args, 0));
                break;
            }
            case -2: {
                return this.theHistory.execDynamicMethod("back", args, env);
            }
            case -3: {
                this.script_blur();
                break;
            }
            case -4: {
                this.script_captureEvents(env.toNative(args, 0));
                break;
            }
            case -5: {
                this.script_clearInterval(env.toInt(args, 0));
                break;
            }
            case -6: {
                this.script_clearTimeout(args, env);
                break;
            }
            case -7: {
                this.script_close(args, env);
                break;
            }
            case -8: {
                return env.wrapBoolean(this.script_confirm(env.toStr(args, 0)));
            }
            case -9: {
                WindowObj.script_debug(args, env);
                break;
            }
            case -10: {
                this.script_disableExternalCapture();
                break;
            }
            case -11: {
                this.script_enableExternalCapture();
                break;
            }
            case -12: {
                return this.script_execScript(args, env);
            }
            case -13: {
                return env.wrapBoolean(this.script_find(args, env));
            }
            case -14: {
                this.script_focus();
                break;
            }
            case -15: {
                return this.theHistory.execDynamicMethod("forward", args, env);
            }
            case -16: {
                this.script_handleEvent(env.toNative(args, 0));
                break;
            }
            case -17: {
                this.script_home();
                break;
            }
            case -18: {
                int x = env.toInt(args, 0);
                int y = env.toInt(args, 1);
                this.script_moveBy(x, y);
                break;
            }
            case -19: {
                int x = env.toInt(args, 0);
                int y = env.toInt(args, 1);
                this.script_moveTo(x, y);
                break;
            }
            case -20: {
                this.setLocation(env.toStr(args, 0));
                break;
            }
            case -21: {
                return this.script_open(args, env);
            }
            case -22: {
                this.script_openDocument(args, env);
                break;
            }
            case -23: {
                this.script_print();
                break;
            }
            case -24: {
                return this.script_prompt(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -25: {
                this.script_releaseEvents(env.toNative(args, 0));
                break;
            }
            case -26: {
                int x = env.toInt(args, 0);
                int y = env.toInt(args, 1);
                this.script_resizeBy(x, y);
                break;
            }
            case -27: {
                int x = env.toInt(args, 0);
                int y = env.toInt(args, 1);
                this.script_resizeTo(x, y);
                break;
            }
            case -28: {
                this.script_routeEvent(env.toNative(args, 0));
                break;
            }
            case -29: {
                int x = env.toInt(args, 0);
                int y = env.toInt(args, 1);
                this.script_scrollBy(x, y);
                break;
            }
            case -30: {
                int x = env.toInt(args, 0);
                int y = env.toInt(args, 1);
                this.script_scrollTo(x, y);
                break;
            }
            case -31: {
                return env.wrapInt(this.script_setInterval(args, env));
            }
            case -32: {
                return env.wrapInt(this.script_setTimeout(args, env));
            }
            case -33: {
                return this.script_showDialog(args, true, env);
            }
            case -34: {
                return this.script_showDialog(args, false, env);
            }
            case -35: {
                this.script_stop();
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                X = "id";
                id = 7;
                break;
            }
            case 3: {
                X = "top";
                id = 31;
                break;
            }
            case 4: {
                switch (s.charAt(1)) {
                    case 'a': {
                        char c = s.charAt(0);
                        if (c == 'b') {
                            X = "back";
                            id = -2;
                            break block0;
                        }
                        if (c != 'n') break block0;
                        X = "name";
                        id = 14;
                        break block0;
                    }
                    case 'e': {
                        X = "self";
                        id = 26;
                        break block0;
                    }
                    case 'i': {
                        X = "find";
                        id = -13;
                        break block0;
                    }
                    case 'l': {
                        X = "blur";
                        id = -3;
                        break block0;
                    }
                    case 'o': {
                        X = "home";
                        id = -17;
                        break block0;
                    }
                    case 'p': {
                        X = "open";
                        id = -21;
                        break block0;
                    }
                    case 't': {
                        X = "stop";
                        id = -35;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(2)) {
                    case 'b': {
                        X = "debug";
                        id = -9;
                        break block0;
                    }
                    case 'c': {
                        X = "focus";
                        id = -14;
                        break block0;
                    }
                    case 'e': {
                        X = "alert";
                        id = -1;
                        break block0;
                    }
                    case 'i': {
                        X = "print";
                        id = -23;
                        break block0;
                    }
                    case 'l': {
                        X = "pilot";
                        id = 23;
                        break block0;
                    }
                    case 'o': {
                        X = "close";
                        id = -7;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(5)) {
                    case 'd': {
                        X = "closed";
                        id = 1;
                        break block0;
                    }
                    case 'h': {
                        X = "length";
                        id = 10;
                        break block0;
                    }
                    case 'l': {
                        X = "scroll";
                        id = -30;
                        break block0;
                    }
                    case 'n': {
                        X = "screen";
                        id = 27;
                        break block0;
                    }
                    case 'o': {
                        X = "moveTo";
                        id = -19;
                        break block0;
                    }
                    case 'r': {
                        X = "opener";
                        id = 16;
                        break block0;
                    }
                    case 's': {
                        char c = s.charAt(0);
                        if (c == 'f') {
                            X = "frames";
                            id = 5;
                            break block0;
                        }
                        if (c != 's') break block0;
                        X = "status";
                        id = 28;
                        break block0;
                    }
                    case 't': {
                        char c = s.charAt(1);
                        if (c == 'a') {
                            X = "parent";
                            id = 21;
                            break block0;
                        }
                        if (c != 'r') break block0;
                        X = "prompt";
                        id = -24;
                        break block0;
                    }
                    case 'w': {
                        X = "window";
                        id = 32;
                        break block0;
                    }
                    case 'y': {
                        X = "moveBy";
                        id = -18;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(0)) {
                    case 'c': {
                        X = "confirm";
                        id = -8;
                        break block0;
                    }
                    case 'f': {
                        X = "forward";
                        id = -15;
                        break block0;
                    }
                    case 'h': {
                        X = "history";
                        id = 6;
                        break block0;
                    }
                    case 'm': {
                        X = "menubar";
                        id = 13;
                        break block0;
                    }
                    case 't': {
                        X = "toolbar";
                        id = 30;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(0)) {
                    case 'd': {
                        X = "document";
                        id = 4;
                        break block0;
                    }
                    case 'l': {
                        X = "location";
                        id = 11;
                        break block0;
                    }
                    case 'n': {
                        X = "navigate";
                        id = -20;
                        break block0;
                    }
                    case 'r': {
                        char c = s.charAt(7);
                        if (c == 'o') {
                            X = "resizeTo";
                            id = -27;
                            break block0;
                        }
                        if (c != 'y') break block0;
                        X = "resizeBy";
                        id = -26;
                        break block0;
                    }
                    case 's': {
                        char c = s.charAt(7);
                        if (c == 'o') {
                            X = "scrollTo";
                            id = -30;
                            break block0;
                        }
                        if (c != 'y') break block0;
                        X = "scrollBy";
                        id = -29;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'n') {
                    X = "navigator";
                    id = 15;
                    break;
                }
                if (c != 's') break;
                X = "statusbar";
                id = 29;
                break;
            }
            case 10: {
                switch (s.charAt(1)) {
                    case 'c': {
                        X = "scrollbars";
                        id = 25;
                        break block0;
                    }
                    case 'e': {
                        X = "setTimeout";
                        id = -32;
                        break block0;
                    }
                    case 'n': {
                        X = "innerWidth";
                        id = 9;
                        break block0;
                    }
                    case 'o': {
                        X = "routeEvent";
                        id = -28;
                        break block0;
                    }
                    case 'u': {
                        X = "outerWidth";
                        id = 18;
                        break block0;
                    }
                    case 'x': {
                        X = "execScript";
                        id = -12;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (s.charAt(0)) {
                    case 'h': {
                        X = "handleEvent";
                        id = -16;
                        break block0;
                    }
                    case 'i': {
                        X = "innerHeight";
                        id = 8;
                        break block0;
                    }
                    case 'l': {
                        X = "locationbar";
                        id = 12;
                        break block0;
                    }
                    case 'o': {
                        X = "outerHeight";
                        id = 17;
                        break block0;
                    }
                    case 'p': {
                        char c = s.charAt(4);
                        if (c == 'X') {
                            X = "pageXOffset";
                            id = 19;
                            break block0;
                        }
                        if (c == 'Y') {
                            X = "pageYOffset";
                            id = 20;
                            break block0;
                        }
                        if (c != 'o') break block0;
                        X = "personalbar";
                        id = 22;
                        break block0;
                    }
                    case 'r': {
                        X = "returnValue";
                        id = 24;
                        break block0;
                    }
                    case 's': {
                        X = "setInterval";
                        id = -31;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "clearTimeout";
                    id = -6;
                    break;
                }
                if (c != 'o') break;
                X = "openDocument";
                id = -22;
                break;
            }
            case 13: {
                switch (s.charAt(5)) {
                    case 'I': {
                        X = "clearInterval";
                        id = -5;
                        break block0;
                    }
                    case 'l': {
                        X = "defaultStatus";
                        id = 2;
                        break block0;
                    }
                    case 'r': {
                        X = "captureEvents";
                        id = -4;
                        break block0;
                    }
                    case 's': {
                        X = "releaseEvents";
                        id = -25;
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                char c = s.charAt(0);
                if (c == 'd') {
                    X = "dialogArguments";
                    id = 3;
                    break;
                }
                if (c != 's') break;
                X = "showModalDialog";
                id = -33;
                break;
            }
            case 17: {
                X = "clientInformation";
                id = 15;
                break;
            }
            case 18: {
                X = "showModelessDialog";
                id = -34;
                break;
            }
            case 21: {
                X = "enableExternalCapture";
                id = -11;
                break;
            }
            case 22: {
                X = "disableExternalCapture";
                id = -10;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    private static final class ScriptTimer
    implements Runnable {
        final WindowObj window;
        int timer_id;
        boolean shouldRepeat;
        Object function;
        long delay;
        Object[] args;
        DynEnv env;

        ScriptTimer(WindowObj window_arg) {
            this.window = window_arg;
        }

        public void run() {
            Viewport view;
            HashArray timerMap = this.window.timerMap;
            if (this == timerMap.get(this.timer_id) && (view = this.window.theView) != null) {
                boolean ret = this.env.getScripter().evalCallback(view, this.function, this.args);
                if (ret && this.shouldRepeat) {
                    this.window.storm.runOnEventThreadLater(this, this.delay);
                } else {
                    timerMap.remove(this.timer_id);
                }
            }
        }
    }

    private static final class WindowCloser
    implements Runnable {
        private StormBase _storm;
        private String _viewId;

        WindowCloser(StormBase storm, String viewId) {
            this._storm = storm;
            this._viewId = viewId;
        }

        public void run() {
            this._storm.closeViewport(this._viewId);
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ String v$uri;
        final /* synthetic */ WindowObj this$0;

        public void run() {
            Viewport view = this.this$0.theView;
            if (view != null) {
                this.this$0.storm.renderContent(this.v$uri, null, this.this$0.theView.getId());
            }
        }

        public 1(WindowObj windowObj, String string) {
            this.v$uri = string;
            this.this$0 = windowObj;
        }
    }
}

