/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.debug.Debug;
import ice.mozilla.javascript.Function;
import ice.pilots.html4.DocumentBuilderFactoryImpl;
import ice.scripters.WindowObj;
import ice.scripters.js.TheScripter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.net.HeaderMap;
import ice.util.net.URLResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.SAXException;

public class XMLHttpRequestObj
extends DynamicObject
implements EventTarget {
    public static final short UNINITIALISED = 0;
    public static final short OPEN = 1;
    public static final short SENT = 2;
    public static final short RECEIVING = 3;
    public static final short LOADED = 4;
    private static final String CLASS_NAME = "XMLHttpRequest";
    private static final int BUFFER_SIZE = 4096;
    private static final byte[] CHAR = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    private static final byte[] CTL = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 127};
    private static final byte SP = 32;
    private static final byte HT = 9;
    private static final byte[] separators = new byte[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9};
    private static final byte[] token = new byte[CHAR.length - CTL.length - separators.length + 1];
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int FIELD_ON_READY_STATE_CHANGE = 1;
    private static final int FIELD_READY_STATE = 2;
    private static final int FIELD_RESPONSE_TEXT = 3;
    private static final int FIELD_RESPONSE_XML = 4;
    private static final int FIELD_STATUS = 5;
    private static final int FIELD_STATUS_TEXT = 6;
    private static final int METHOD_ABORT = -1;
    private static final int METHOD_GET_ALL_RESPONSE_HEADERS = -2;
    private static final int METHOD_GET_RESPONSE_HEADER = -3;
    private static final int METHOD_OPEN = -4;
    private static final int METHOD_SEND = -5;
    private static final int METHOD_SET_REQUEST_HEADER = -6;
    private static final int GETRESPONSEHEADER_ARGUMENT_HEADER = 0;
    private static final int OPEN_ARGUMENT_METHOD = 0;
    private static final int OPEN_ARGUMENT_URL = 1;
    private static final int OPEN_ARGUMENT_ASYNC = 2;
    private static final int OPEN_ARGUMENT_USER = 3;
    private static final int OPEN_ARGUMENT_PASSWORD = 4;
    private static final int SEND_ARGUMENT_DATA = 0;
    private static final int SETREQUESTHEADER_ARGUMENT_HEADER = 0;
    private static final int SETREQUESTHEADER_ARGUMENT_VALUE = 1;
    private static final Function INITIAL_VALUE_ONREADYSTATECHANGE;
    private static final short INITIAL_VALUE_READYSTATE = 0;
    private static final String INITIAL_VALUE_RESPONSETEXT;
    private static final Document INITIAL_VALUE_RESPONSEXML;
    private static final short INITIAL_VALUE_STATUS = 0;
    private static final String INITIAL_VALUE_STATUSTEXT = "";
    private String method;
    private URL url;
    private boolean async;
    private String user;
    private String password;
    private HeaderMap requestHeaderMap;
    private HeaderMap responseHeaderMap;
    private Function onReadyStateChange;
    private short readyState;
    private String responseText;
    private Document responseXML;
    private short status;
    private String statusText;
    private Thread asynchronousRequesterThread;
    private BufferedReader bufferedReader;
    private WindowObj windowObject;

    static {
        int _index = 0;
        int i = 0;
        while (i < CHAR.length) {
            if (!XMLHttpRequestObj.isControlCharacter(CHAR[i]) && !XMLHttpRequestObj.isSeparator(CHAR[i])) {
                XMLHttpRequestObj.token[_index++] = CHAR[i];
            }
            ++i;
        }
        INITIAL_VALUE_ONREADYSTATECHANGE = null;
        INITIAL_VALUE_RESPONSETEXT = null;
        INITIAL_VALUE_RESPONSEXML = null;
    }

    private void $init$() {
        this.requestHeaderMap = new HeaderMap();
        this.responseHeaderMap = new HeaderMap();
    }

    public XMLHttpRequestObj() {
        this.$init$();
        this.initialize();
    }

    public void addEventListener(String type, EventListener eventListener, boolean useCapture) {
    }

    public void close() {
        if (this.bufferedReader != null) {
            try {
                try {
                    this.bufferedReader.close();
                }
                catch (IOException exception) {
                    if (Debug.ex) {
                        Debug.ex(exception);
                    }
                }
            }
            finally {
                this.bufferedReader = null;
            }
        }
    }

    public boolean dispatchEvent(Event event) throws EventException {
        return false;
    }

    public Object execDynamicMethod(String name, Object[] arguments, DynEnv dynamicEnvironment) {
        int _dynamicId = XMLHttpRequestObj.toDynamicId(name);
        if (_dynamicId < 0) {
            return this.executeDynamicMethod(_dynamicId, arguments, dynamicEnvironment);
        }
        return super.execDynamicMethod(name, arguments, dynamicEnvironment);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public Object getDynamicValue(String name, DynEnv dynamicEnvironment) {
        int _dynamicId = XMLHttpRequestObj.toDynamicId(name);
        if (_dynamicId < 0) {
            return dynamicEnvironment.wrapMethod(this, name);
        }
        if (_dynamicId > 0) {
            return this.getDynamicValue(_dynamicId, dynamicEnvironment);
        }
        return super.getDynamicValue(name, dynamicEnvironment);
    }

    public void removeEventListener(String type, EventListener eventListener, boolean useCapture) {
    }

    public int setDynamicValue(String name, Object value, DynEnv dynamicEnvironment) {
        int _dynamicId = XMLHttpRequestObj.toDynamicId(name);
        if (_dynamicId < 0) {
            return 2;
        }
        if (_dynamicId > 0) {
            return this.setDynamicValue(_dynamicId, value, dynamicEnvironment);
        }
        return super.setDynamicValue(name, value, dynamicEnvironment);
    }

    public void setWindowObject(WindowObj windowObject) {
        this.windowObject = windowObject;
    }

    private Object executeDynamicMethod(int dynamicId, Object[] arguments, DynEnv dynamicEnvironment) {
        switch (dynamicId) {
            case -1: {
                this.script_abort();
                return dynamicEnvironment.wrapVoid();
            }
            case -2: {
                try {
                    Object object = this.script_getAllResponseHeaders();
                    return object;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case -3: {
                try {
                    Object object = this.script_getResponseHeader(arguments, dynamicEnvironment);
                    return object;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
                catch (SyntaxErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case -4: {
                try {
                    this.script_open(arguments, dynamicEnvironment);
                    Object object = dynamicEnvironment.wrapVoid();
                    return object;
                }
                catch (SecurityErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
                catch (SyntaxErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case -5: {
                try {
                    this.script_send(arguments, dynamicEnvironment);
                    Object object = dynamicEnvironment.wrapVoid();
                    return object;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case -6: {
                try {
                    this.script_setRequestHeader(arguments, dynamicEnvironment);
                    Object object = dynamicEnvironment.wrapVoid();
                    return object;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
                catch (SyntaxErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
        }
        return dynamicEnvironment.wrapVoid();
    }

    private Object getDynamicValue(int dynamicId, DynEnv dynamicEnvironment) {
        switch (dynamicId) {
            case 1: {
                return this.script_onreadystatechange();
            }
            case 2: {
                return dynamicEnvironment.wrapInt(this.script_readyState());
            }
            case 3: {
                try {
                    String string = this.script_responseText();
                    return string;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case 4: {
                try {
                    Document document = this.script_responseXML();
                    return document;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case 5: {
                try {
                    Integer n = dynamicEnvironment.wrapInt(this.script_status());
                    return n;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
            case 6: {
                try {
                    String string = this.script_statusText();
                    return string;
                }
                catch (InvalidStateErrorException exception) {
                    throw dynamicEnvironment.wrapException(exception);
                }
            }
        }
        return null;
    }

    private void initialize() {
        this.onReadyStateChange = INITIAL_VALUE_ONREADYSTATECHANGE;
        this.readyState = 0;
        this.responseText = INITIAL_VALUE_RESPONSETEXT;
        this.responseXML = INITIAL_VALUE_RESPONSEXML;
        this.status = 0;
        this.statusText = INITIAL_VALUE_STATUSTEXT;
        this.async = true;
        this.method = null;
        this.password = null;
        this.url = null;
        this.user = null;
        this.requestHeaderMap.clear();
        this.responseHeaderMap.clear();
    }

    private static boolean isCharacter(byte octet) {
        int i = 0;
        while (i < CHAR.length) {
            if (octet == CHAR[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isControlCharacter(byte octet) {
        int i = 0;
        while (i < CTL.length) {
            if (octet == CTL[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isEndOfLine(byte[] bytes, int position) {
        return bytes[position] == 13 && position + 1 < bytes.length && bytes[position + 1] == 10;
    }

    private static boolean isFieldName(String fieldName) {
        return XMLHttpRequestObj.isToken(fieldName.getBytes());
    }

    private static boolean isFieldValue(String fieldValue) {
        byte[] _bytes = fieldValue.getBytes();
        if (_bytes.length == 0) {
            return true;
        }
        int i = 0;
        while (i < _bytes.length) {
            if (!XMLHttpRequestObj.isToken(_bytes[i]) && !XMLHttpRequestObj.isSeparator(_bytes[i])) {
                if (_bytes[i] == 34) {
                    int j = ++i;
                    while (j < _bytes.length) {
                        if (_bytes[j] == 34) {
                            // empty if block
                        }
                        ++j;
                    }
                } else if (XMLHttpRequestObj.isLinearWhiteSpace(_bytes, i)) {
                    i = XMLHttpRequestObj.skipLinearWhiteSpace(_bytes, i);
                }
            }
            ++i;
        }
        if (!XMLHttpRequestObj.isText(_bytes)) {
            // empty if block
        }
        return true;
    }

    private static boolean isLinearWhiteSpace(byte[] bytes, int position) {
        return XMLHttpRequestObj.isEndOfLine(bytes, position) && position + 1 < bytes.length && (bytes[position + 1] == 32 || bytes[position + 1] == 9) || bytes[position] == 32 || bytes[position] == 9;
    }

    private static boolean isSeparator(byte octet) {
        int i = 0;
        while (i < separators.length) {
            if (octet == separators[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isText(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            if (XMLHttpRequestObj.isLinearWhiteSpace(bytes, i)) {
                i = XMLHttpRequestObj.skipLinearWhiteSpace(bytes, i);
            } else if (XMLHttpRequestObj.isControlCharacter(bytes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isToken(byte octet) {
        int i = 0;
        while (i < token.length) {
            if (octet == token[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isToken(byte[] bytes) {
        if (bytes.length == 0) {
            return false;
        }
        int i = 0;
        while (i < bytes.length) {
            if (!XMLHttpRequestObj.isToken(bytes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidMethod(String method) {
        return XMLHttpRequestObj.isToken(method.getBytes());
    }

    private static boolean isValidQuotedString(String quotedString) {
        byte[] _bytes = quotedString.getBytes();
        int i = 0;
        while (i < _bytes.length) {
            switch (_bytes[i]) {
                case 13: {
                    if (i + 1 >= _bytes.length || _bytes[i + 1] != 10) break;
                    ++i;
                    break;
                }
                case 9: 
                case 32: {
                    break;
                }
                case 34: {
                    return false;
                }
                case 92: {
                    if (i + 1 >= _bytes.length || !XMLHttpRequestObj.isCharacter(_bytes[i + 1])) break;
                    ++i;
                    break;
                }
                default: {
                    if (!XMLHttpRequestObj.isControlCharacter(_bytes[i])) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidUsername(String username) {
        return XMLHttpRequestObj.isValidQuotedString(username);
    }

    private void script_abort() {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.abort()");
        }
        this.close();
        this.initialize();
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.abort() : void");
        }
    }

    private Object script_getAllResponseHeaders() throws InvalidStateErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.getAllResponseHeaders()");
        }
        try {
            if (this.readyState != 3 && this.readyState != 4) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 3 (Receiving) or 4 (Loaded): " + this.readyState, null);
            }
            StringBuffer _allResponseHeaders = new StringBuffer();
            int _size = this.responseHeaderMap.getSize();
            int i = 0;
            while (i < _size) {
                if (i != 0) {
                    _allResponseHeaders.append('\r');
                    _allResponseHeaders.append('\n');
                }
                _allResponseHeaders.append(this.responseHeaderMap.get(i).toString());
                ++i;
            }
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.getAllResponseHeaders() : " + _allResponseHeaders.toString());
            }
            String string = _allResponseHeaders.toString();
            return string;
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.getAllResponseHeaders() : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
    }

    private Object script_getResponseHeader(Object[] arguments, DynEnv dynamicEnvironment) throws InvalidStateErrorException, SyntaxErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.getResponseHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "])");
        }
        try {
            String _returnValue;
            String _fieldName = dynamicEnvironment.toStr(arguments[0]);
            if (!XMLHttpRequestObj.isFieldName(_fieldName)) {
                throw new SyntaxErrorException("The header argument doesn't match the field-name production, as defined by section 4.2 of RFC 2616: " + _fieldName, null);
            }
            if (this.readyState != 3 && this.readyState != 4) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 3 (Receiving) or 4 (Loaded): " + this.readyState, null);
            }
            String[] _fieldValues = this.responseHeaderMap.getFieldValues(_fieldName);
            switch (_fieldValues.length) {
                case 0: {
                    _returnValue = null;
                    break;
                }
                case 1: {
                    _returnValue = _fieldValues[0];
                    break;
                }
                default: {
                    StringBuffer _values = new StringBuffer();
                    int i = 0;
                    while (i < _fieldValues.length) {
                        if (i != 0) {
                            _values.append(76);
                        }
                        _values.append(_fieldValues[i]);
                        ++i;
                    }
                    _returnValue = _values.toString();
                }
            }
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.getResponseHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "]) : " + _returnValue);
            }
            String string = _returnValue;
            return string;
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.getResponseHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "]) : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
        catch (SyntaxErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.getResponseHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "]) : raised a SYNTAX_ERR exception");
            }
            throw exception;
        }
    }

    private Function script_onreadystatechange() {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.onreadystatechange");
        }
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.onreadystatechange : [" + this.onReadyStateChange + "]");
        }
        return this.onReadyStateChange;
    }

    private void script_onreadystatechange(Object value) {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.onreadystatechange");
        }
        this.onReadyStateChange = (Function)value;
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.onreadystatechange = [" + this.onReadyStateChange + "]");
        }
    }

    private void script_open(Object[] arguments, DynEnv dynamicEnvironment) throws SecurityErrorException, SyntaxErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            StringBuffer _string = new StringBuffer("XMLHttpRequest.open(method: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "url: [" + dynamicEnvironment.toStr(arguments[1]) + "]");
            if (arguments.length > 2) {
                _string.append(", async: [");
                _string.append(dynamicEnvironment.toBoolean(arguments[2]));
                _string.append("]");
            }
            if (arguments.length > 3) {
                _string.append(", user: [");
                _string.append(dynamicEnvironment.toStr(arguments[3]));
                _string.append("]");
            }
            if (arguments.length > 4) {
                _string.append(", password: [");
                _string.append(dynamicEnvironment.toStr(arguments[4]));
                _string.append("]");
            }
            _string.append(")");
            Debug.trace(_string.toString());
        }
        try {
            String _method = dynamicEnvironment.toStr(arguments[0]);
            if (!XMLHttpRequestObj.isValidMethod(_method)) {
                throw new SyntaxErrorException("The method argument doesn't match the method production, as defined by section 5.1.1 of RFC 2616: " + _method, null);
            }
            if (arguments.length >= 2) {
                this.method = _method.equalsIgnoreCase("GET") || _method.equalsIgnoreCase("POST") || _method.equalsIgnoreCase("HEAD") || _method.equalsIgnoreCase("PUT") || _method.equalsIgnoreCase("DELETE") ? _method.toUpperCase() : _method;
                String _originUrl = this.windowObject.getViewport().getBaseUrl();
                String _url = dynamicEnvironment.toStr(arguments[1]);
                String _targetUrl = URLResolver.resolve(_originUrl, _url);
                int _beginIndex = _originUrl.indexOf("//") + 2;
                int _endIndex = _originUrl.indexOf("/", _beginIndex);
                String _originHost = _originUrl.substring(_beginIndex, _endIndex);
                if ((_beginIndex = _originHost.indexOf("@")) != -1) {
                    _originHost = _originHost.substring(_beginIndex + 1);
                }
                if ((_endIndex = _originHost.indexOf(":")) != -1) {
                    _originHost = _originHost.substring(0, _endIndex);
                }
                _beginIndex = _targetUrl.indexOf("//") + 2;
                _endIndex = _targetUrl.indexOf("/", _beginIndex);
                String _targetHost = _targetUrl.substring(_beginIndex, _endIndex);
                if ((_beginIndex = _targetHost.indexOf("@")) != -1) {
                    _targetHost = _targetHost.substring(_beginIndex + 1);
                }
                if ((_endIndex = _targetHost.indexOf(":")) != -1) {
                    _targetHost = _targetHost.substring(0, _endIndex);
                }
                if (!_targetHost.equalsIgnoreCase(_originHost)) {
                    throw new SecurityErrorException("The url argument is a non same-origin url: " + _url, null);
                }
                try {
                    this.url = new URL(_targetUrl);
                }
                catch (MalformedURLException exception) {
                    throw new SyntaxErrorException("The url parameter doesn't match the syntax, as defined in section 3.2.2 of RFC 2616: " + _url, null);
                }
                switch (arguments.length) {
                    case 5: {
                        this.password = dynamicEnvironment.toStr(arguments[4]);
                    }
                    case 4: {
                        String _user = dynamicEnvironment.toStr(arguments[3]);
                        if (!XMLHttpRequestObj.isValidUsername(_user)) {
                            throw new SyntaxErrorException("The user argument doesn't match the username-value production, as defined in section 3.2.2 of RFC 2617: " + _user, null);
                        }
                        this.user = _user;
                    }
                    case 3: {
                        this.async = dynamicEnvironment.toBoolean(arguments[2]);
                        break;
                    }
                }
                String _userInfo = this.url.getUserInfo();
                if (_userInfo != null) {
                    int _index = _userInfo.indexOf(58);
                    if (_index != -1) {
                        throw new SyntaxErrorException("The \"user:password\" format in the userinfo production, as defined in section 3.2.1 of RFC 3986, is not supported.", null);
                    }
                    if (arguments.length <= 3) {
                        this.user = _userInfo;
                    }
                }
            }
            this.setReadyState((short)1);
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                StringBuffer _string = new StringBuffer("XMLHttpRequest.open(method: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "url: [" + dynamicEnvironment.toStr(arguments[1]) + "]");
                if (arguments.length > 2) {
                    _string.append(", async: [");
                    _string.append(dynamicEnvironment.toBoolean(arguments[2]));
                    _string.append("]");
                }
                if (arguments.length > 3) {
                    _string.append(", user: [");
                    _string.append(dynamicEnvironment.toStr(arguments[3]));
                    _string.append("]");
                }
                if (arguments.length > 4) {
                    _string.append(", password: [");
                    _string.append(dynamicEnvironment.toStr(arguments[4]));
                    _string.append("]");
                }
                _string.append(") : void");
                Debug.trace(_string.toString());
            }
        }
        catch (SecurityException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                StringBuffer _string = new StringBuffer("XMLHttpRequest.open(method: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "url: [" + dynamicEnvironment.toStr(arguments[1]) + "]");
                if (arguments.length > 2) {
                    _string.append(", async: [");
                    _string.append(dynamicEnvironment.toBoolean(arguments[2]));
                    _string.append("]");
                }
                if (arguments.length > 3) {
                    _string.append(", user: [");
                    _string.append(dynamicEnvironment.toStr(arguments[3]));
                    _string.append("]");
                }
                if (arguments.length > 4) {
                    _string.append(", password: [");
                    _string.append(dynamicEnvironment.toStr(arguments[4]));
                    _string.append("]");
                }
                _string.append(") : raised a SECURITY_ERR exception");
                Debug.trace(_string.toString());
            }
            throw exception;
        }
        catch (SyntaxErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                StringBuffer _string = new StringBuffer("XMLHttpRequest.open(method: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "url: [" + dynamicEnvironment.toStr(arguments[1]) + "]");
                if (arguments.length > 2) {
                    _string.append(", async: [");
                    _string.append(dynamicEnvironment.toBoolean(arguments[2]));
                    _string.append("]");
                }
                if (arguments.length > 3) {
                    _string.append(", user: [");
                    _string.append(dynamicEnvironment.toStr(arguments[3]));
                    _string.append("]");
                }
                if (arguments.length > 4) {
                    _string.append(", password: [");
                    _string.append(dynamicEnvironment.toStr(arguments[4]));
                    _string.append("]");
                }
                _string.append(") : raised a SYNTAX_ERR exception");
                Debug.trace(_string.toString());
            }
            throw exception;
        }
    }

    private short script_readyState() {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.readyState");
        }
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.readyState : [" + this.readyState + "]");
        }
        return this.readyState;
    }

    private String script_responseText() throws InvalidStateErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.responseText");
        }
        try {
            if (this.readyState != 3 && this.readyState != 4) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 3 (Receiving) or 4 (Loaded): " + this.readyState, null);
            }
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.responseText : [" + this.responseText + "]");
            }
            String string = this.responseText;
            return string;
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.responseText : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
    }

    private Document script_responseXML() throws InvalidStateErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.responseXML");
        }
        try {
            if (this.readyState != 4) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 4 (Loaded): " + this.readyState, null);
            }
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.responseXML : [" + this.responseXML + "]");
            }
            Document document = this.responseXML;
            return document;
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.responseXML : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
    }

    private void script_send(Object[] arguments, DynEnv dynamicEnvironment) throws InvalidStateErrorException {
        if (this.readyState != 1) {
            throw new InvalidStateErrorException("The readyState attribute has a value other than 1 (Open): " + this.readyState, null);
        }
        if (this.async) {
            this.asynchronousRequesterThread = new Thread((Runnable)new AsynchronousRequester(arguments, null), "Asynchronous Requester Thread");
            this.asynchronousRequesterThread.start();
        } else {
            this.send(arguments);
        }
    }

    private void script_setRequestHeader(Object[] arguments, DynEnv dynamicEnvironment) throws InvalidStateErrorException, SyntaxErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.setRequestHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "value: [" + dynamicEnvironment.toStr(arguments[1]) + "])");
        }
        try {
            if (this.readyState != 1) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 1 (Open): " + this.readyState, null);
            }
            String _fieldName = dynamicEnvironment.toStr(arguments[0]);
            if (!XMLHttpRequestObj.isFieldName(_fieldName)) {
                throw new SyntaxErrorException("The header argument doesn't match the field-name production, as defined by section 4.2 of RFC 2616: " + _fieldName, null);
            }
            String _fieldValue = dynamicEnvironment.toStr(arguments[1]);
            if (!XMLHttpRequestObj.isFieldValue(_fieldValue)) {
                throw new SyntaxErrorException("The value argument doesn't match the field-value production, as defined by section 4.2 of RFC 2616: " + _fieldValue, null);
            }
            if (_fieldName.equalsIgnoreCase("Accept-Charset") || _fieldName.equalsIgnoreCase("Accept-Encoding") || _fieldName.equalsIgnoreCase("Content-Lenght") || _fieldName.equalsIgnoreCase("Date") || _fieldName.equalsIgnoreCase("Expect") || _fieldName.equalsIgnoreCase("Host") || _fieldName.equalsIgnoreCase("Keep-Alive") || _fieldName.equalsIgnoreCase("Referer") || _fieldName.equalsIgnoreCase("TE") || _fieldName.equalsIgnoreCase("Trailer") || _fieldName.equalsIgnoreCase("Transfer-Encoding") || _fieldName.equalsIgnoreCase("Upgrade")) {
                return;
            }
            if (_fieldName.equalsIgnoreCase("Authorization") || _fieldName.equalsIgnoreCase("Content-Base") || _fieldName.equalsIgnoreCase("Content-Location") || _fieldName.equalsIgnoreCase("Content-MD5") || _fieldName.equalsIgnoreCase("Content-Range") || _fieldName.equalsIgnoreCase("Content-Type") || _fieldName.equalsIgnoreCase("Content-Version") || _fieldName.equalsIgnoreCase("Delta-Base") || _fieldName.equalsIgnoreCase("Depth") || _fieldName.equalsIgnoreCase("Destination") || _fieldName.equalsIgnoreCase("ETag") || _fieldName.equalsIgnoreCase("Expect") || _fieldName.equalsIgnoreCase("From") || _fieldName.equalsIgnoreCase("If-Modified-Since") || _fieldName.equalsIgnoreCase("If-Range") || _fieldName.equalsIgnoreCase("If-Unmodified-Since") || _fieldName.equalsIgnoreCase("Max-Forwards") || _fieldName.equalsIgnoreCase("MIME-Version") || _fieldName.equalsIgnoreCase("Overwrite") || _fieldName.equalsIgnoreCase("Proxy-Authorization") || _fieldName.equalsIgnoreCase("SOAPAction") || _fieldName.equalsIgnoreCase("Timeout")) {
                this.requestHeaderMap.putHeader(_fieldName, dynamicEnvironment.toStr(arguments[1]), true);
            } else if (this.requestHeaderMap.containsFieldName(_fieldName)) {
                this.requestHeaderMap.putHeader(_fieldName, this.requestHeaderMap.getFieldValues(_fieldName)[0] + ',' + ' ' + dynamicEnvironment.toStr(arguments[1]), true);
            } else {
                this.requestHeaderMap.putHeader(_fieldName, dynamicEnvironment.toStr(arguments[1]), true);
            }
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.setRequestHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "value: [" + dynamicEnvironment.toStr(arguments[1]) + "]) : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
        catch (SyntaxErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.setRequestHeader(header: [" + dynamicEnvironment.toStr(arguments[0]) + "], " + "value: [" + dynamicEnvironment.toStr(arguments[1]) + "]) : raised an SYNTAX_ERR exception");
            }
            throw exception;
        }
    }

    private short script_status() throws InvalidStateErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.status");
        }
        try {
            if (this.readyState != 3 && this.readyState != 4) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 3 (Receiving) or 4 (Loaded): " + this.readyState, null);
            }
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.status : [" + this.status + "]");
            }
            short s = this.status;
            return s;
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.status : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
    }

    private String script_statusText() throws InvalidStateErrorException {
        if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
            Debug.trace("XMLHttpRequest.statusText");
        }
        try {
            if (this.readyState != 3 && this.readyState != 4) {
                throw new InvalidStateErrorException("The readyState attribute has a value other than 3 (Receiving) or 4 (Loaded): " + this.readyState, null);
            }
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.statusText : [" + this.statusText + "]");
            }
            String string = this.statusText;
            return string;
        }
        catch (InvalidStateErrorException exception) {
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.statusText : raised an INVALID_STATE_ERR exception");
            }
            throw exception;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void send(Object[] arguments) {
        try {
            _contentLoader = this.windowObject.storm.getContentLoaderFactory().createContentLoader(this.url, null);
            _httpUrlConnection = (HttpURLConnection)_contentLoader.getURLConnection();
            _httpUrlConnection.setRequestMethod(this.method);
            _size = this.requestHeaderMap.getSize();
            i = 0;
            while (i < _size) {
                _header = this.requestHeaderMap.get(i);
                _fieldName = _header.getFieldName();
                if (_fieldName.equalsIgnoreCase("Cookie") || _fieldName.equalsIgnoreCase("Cookie2") || _fieldName.equalsIgnoreCase("User-Agent")) {
                    _fieldValue = _httpUrlConnection.getRequestProperty(_fieldName);
                    if (_fieldValue != null) {
                        _httpUrlConnection.setRequestProperty(_fieldName, _fieldValue + ',' + ' ' + _header.getFieldValue());
                    } else {
                        _httpUrlConnection.setRequestProperty(_fieldName, _header.getFieldValue());
                    }
                } else {
                    _httpUrlConnection.setRequestProperty(_fieldName, _header.getFieldValue());
                }
                ++i;
            }
            if (arguments != null && arguments.length == 1) {
                if (this.method.equalsIgnoreCase("post")) {
                    _httpUrlConnection.setDoOutput(true);
                    if (arguments[0] instanceof String) {
                        _httpUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                        _outputStream = null;
                        try {
                            try {
                                _outputStream = _httpUrlConnection.getOutputStream();
                                _outputStream.write(((String)arguments[0]).getBytes("UTF-8"));
                            }
                            catch (IOException exception) {
                                if (!Debug.ex) ** GOTO lbl70
                                Debug.ex(exception);
                            }
                        }
                        finally {
                            block47: {
                                if (_outputStream != null) {
                                    try {
                                        _outputStream.close();
                                    }
                                    catch (IOException exception) {
                                        if (!Debug.ex) break block47;
                                        Debug.ex(exception);
                                    }
                                }
                            }
                        }
                    } else if (!(arguments[0] instanceof Document)) {
                        _httpUrlConnection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                        _outputStream = null;
                        try {
                            try {
                                _outputStream = _httpUrlConnection.getOutputStream();
                                _outputStream.write(arguments[0].toString().getBytes("UTF-8"));
                            }
                            catch (IOException exception) {
                                if (!Debug.ex) ** GOTO lbl70
                                Debug.ex(exception);
                            }
                        }
                        finally {
                            block48: {
                                if (_outputStream != null) {
                                    try {
                                        _outputStream.close();
                                    }
                                    catch (IOException exception) {
                                        if (!Debug.ex) break block48;
                                        Debug.ex(exception);
                                    }
                                }
                            }
                        }
                    }
                } else if (this.method.equalsIgnoreCase("get")) {
                    // empty if block
                }
            }
lbl70:
            // 12 sources

            this.setReadyState((short)2);
            _index = 0;
            _tokens = new StringTokenizer(_contentLoader.getHeaderField(_index++));
            _tokens.nextToken();
            this.status = Short.parseShort(_tokens.nextToken());
            this.statusText = _tokens.nextToken();
            while ((_fieldName = _contentLoader.getHeaderFieldKey(_index)) != null) {
                this.responseHeaderMap.putHeader(_fieldName, _contentLoader.getHeaderField(_index++));
            }
            this.setReadyState((short)3);
            if (this.responseHeaderMap.containsFieldName("Content-Type")) {
                _contentTypeFieldValue = this.responseHeaderMap.getFieldValues("Content-Type")[0];
                _index = _contentTypeFieldValue.indexOf(59);
                if (_index != -1) {
                    _contentType = _contentTypeFieldValue.substring(0, _index).trim();
                    _index = _contentTypeFieldValue.indexOf(61, _index);
                    _charset = _contentTypeFieldValue.substring(_index + 1).trim();
                } else {
                    _contentType = _contentTypeFieldValue;
                    _charset = "UTF-8";
                }
            } else {
                _contentType = null;
                _charset = "UTF-8";
            }
            this.bufferedReader = new BufferedReader(new InputStreamReader(_contentLoader.getInputStream(), _charset));
            _entityBody = new StringBuffer();
            _charBuffer = new char[4096];
            while ((_numberOfBytes = this.bufferedReader.read(_charBuffer)) != -1) {
                _entityBody.append(_charBuffer, 0, _numberOfBytes);
                this.responseText = _entityBody.toString();
            }
            if (_contentType != null && (_contentType.equals("text/xml") || _contentType.equals("application/xml") || _contentType.endsWith("+xml")) && this.responseText != null && this.responseText.length() != 0) {
                try {
                    _documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
                    this.responseXML = _documentBuilder.parse(new ByteArrayInputStream(this.responseText.toString().getBytes()));
                }
                catch (ParserConfigurationException exception) {
                    Debug.ex(exception);
                }
                catch (SAXException exception) {
                    Debug.ex(exception);
                }
            }
            this.close();
            this.windowObject.xmlHttpRequestList.removeElement(this);
            this.setReadyState((short)4);
        }
        catch (ProtocolException exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
        }
        catch (IOException exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            this.close();
        }
    }

    private int setDynamicValue(int dynamicId, Object value, DynEnv dynamicEnvironment) {
        switch (dynamicId) {
            case 1: {
                this.script_onreadystatechange(value);
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
        }
        return 2;
    }

    private void setReadyState(short readyState) {
        if (this.readyState != readyState) {
            Viewport _viewport;
            Pilot _pilot;
            this.readyState = readyState;
            if (Defs.sysPropertyBoolean("ice.scripters.debug.xmlhttprequest", false) && Debug.trace) {
                Debug.trace("XMLHttpRequest.readyState = [" + this.readyState + "]");
            }
            if (this.onReadyStateChange != null && !Thread.currentThread().isInterrupted() && (_pilot = (_viewport = this.windowObject.getViewport()).getPilot()) != null) {
                ((TheScripter)_pilot.getStorm().getScripter("ECMAScript")).evalFunction(_viewport, this.onReadyStateChange, new Object[0]);
            }
        }
    }

    private static int skipLinearWhiteSpace(byte[] bytes, int position) {
        int _index = position + 1;
        while (_index < bytes.length && (bytes[_index] == 32 || bytes[_index] == 9)) {
            ++_index;
        }
        return _index;
    }

    private static int toDynamicId(String string) {
        int _dynamicId = 0;
        String _string = null;
        block0 : switch (string.length()) {
            case 4: {
                switch (string.charAt(0)) {
                    case 'o': {
                        _string = "open";
                        _dynamicId = -4;
                        break block0;
                    }
                    case 's': {
                        _string = "send";
                        _dynamicId = -5;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                _string = "abort";
                _dynamicId = -1;
                break;
            }
            case 6: {
                _string = "status";
                _dynamicId = 5;
                break;
            }
            case 10: {
                switch (string.charAt(0)) {
                    case 'r': {
                        _string = "readyState";
                        _dynamicId = 2;
                        break block0;
                    }
                    case 's': {
                        _string = "statusText";
                        _dynamicId = 6;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                _string = "responseXML";
                _dynamicId = 4;
                break;
            }
            case 12: {
                _string = "responseText";
                _dynamicId = 3;
                break;
            }
            case 16: {
                _string = "setRequestHeader";
                _dynamicId = -6;
                break;
            }
            case 17: {
                _string = "getResponseHeader";
                _dynamicId = -3;
                break;
            }
            case 18: {
                _string = "onreadystatechange";
                _dynamicId = 1;
                break;
            }
            case 21: {
                _string = "getAllResponseHeaders";
                _dynamicId = -2;
                break;
            }
        }
        if (_string != null && _string != string && !_string.equals(string)) {
            _dynamicId = 0;
        }
        return _dynamicId;
    }

    public void unlinkAllSlots() {
        super.unlinkAllSlots();
        if (this.asynchronousRequesterThread != null) {
            this.asynchronousRequesterThread.interrupt();
        }
    }

    static void mav$send(XMLHttpRequestObj xMLHttpRequestObj, Object[] objectArray) {
        xMLHttpRequestObj.send(objectArray);
    }

    private final class AsynchronousRequester
    implements Runnable {
        private Object[] arguments;

        private AsynchronousRequester(Object[] arguments) {
            this.arguments = arguments;
        }

        public void run() {
            XMLHttpRequestObj.mav$send(XMLHttpRequestObj.this, this.arguments);
        }

        AsynchronousRequester(Object[] objectArray, 1 var3_3) {
            this(objectArray);
        }

        public final class 1 {
        }
    }

    private class InvalidStateErrorException
    extends Exception {
        private static final String NAME = "INVALID_STATE_ERR";

        private InvalidStateErrorException() {
        }

        private InvalidStateErrorException(String message) {
            super("INVALID_STATE_ERR: " + message);
        }

        public final String getName() {
            return NAME;
        }

        InvalidStateErrorException(String string, 1 var3_3) {
            this(string);
        }

        public final class 1 {
        }
    }

    private class SecurityErrorException
    extends Exception {
        private static final String NAME = "SECURITY_ERR";

        private SecurityErrorException() {
        }

        private SecurityErrorException(String message) {
            super("SECURITY_ERR: " + message);
        }

        public final String getName() {
            return NAME;
        }

        SecurityErrorException(String string, 1 var3_3) {
            this(string);
        }

        public final class 1 {
        }
    }

    private class SyntaxErrorException
    extends Exception {
        private static final String NAME = "SYNTAX_ERR";

        private SyntaxErrorException() {
        }

        private SyntaxErrorException(String message) {
            super("SYNTAX_ERR: " + message);
        }

        public final String getName() {
            return NAME;
        }

        SyntaxErrorException(String string, 1 var3_3) {
            this(string);
        }

        public final class 1 {
        }
    }
}

