/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.debug.Debug;
import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Wrapper;
import ice.scripters.js.TheScripter;
import ice.storm.DynamicObject;
import ice.util.Defs;

class DynamicMethodWrap
implements Scriptable,
Function {
    private static final int Id_arity = 1;
    private static final int Id_length = 2;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private final DynamicObject master;
    private final String methodName;
    private final TheScripter scripter;
    private final int argCount;

    private static int mapNameToId(String s) {
        int id = -1;
        String guess = null;
        switch (s.length()) {
            case 4: {
                id = 3;
                guess = "name";
                break;
            }
            case 5: {
                id = 1;
                guess = "arity";
                break;
            }
            case 6: {
                id = 2;
                guess = "length";
                break;
            }
        }
        return guess != null && guess.equals(s) ? id : -1;
    }

    private void $init$() {
        this.argCount = 1;
    }

    DynamicMethodWrap(DynamicObject master_arg, String methodName_arg, TheScripter scripter_arg) {
        this.$init$();
        this.master = master_arg;
        this.methodName = methodName_arg;
        this.scripter = scripter_arg;
    }

    public String getClassName() {
        return "Function";
    }

    public boolean has(String name, Scriptable start) {
        return this.get(name, start) != Scriptable.NOT_FOUND;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public Object get(String name, Scriptable start) {
        DynamicObject add_source;
        int id = DynamicMethodWrap.mapNameToId(name);
        Object result = 0 <= id ? this.get(id) : ((add_source = this.master.getMethodPropertySource(this.methodName, this.scripter.env)) == null ? Scriptable.NOT_FOUND : this.scripter.queryField(this, add_source, name));
        return result;
    }

    public Object get(int index, Scriptable start) {
        return Scriptable.NOT_FOUND;
    }

    public void put(String name, Scriptable start, Object value) {
        DynamicObject add_source;
        int id;
        if (start != this && !this.has(name, start)) {
            start.put(name, start, value);
        }
        if ((id = DynamicMethodWrap.mapNameToId(name)) < 0 && (add_source = this.master.getMethodPropertySource(this.methodName, this.scripter.env)) != null) {
            add_source.setDynamicValue(name, value, this.scripter.env);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        if (start != this && !this.has(index, start)) {
            start.put(index, start, value);
        }
    }

    public void delete(String name) {
    }

    public void delete(int index) {
    }

    public Object[] getIds() {
        return Defs.EMPTY_OBJECT_ARRAY;
    }

    public Scriptable getPrototype() {
        return this.scripter.functionPrototype;
    }

    public void setPrototype(Scriptable prototype) {
    }

    public Scriptable getParentScope() {
        return null;
    }

    public void setParentScope(Scriptable parent) {
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == Scriptable.class || typeHint == Function.class) {
            return this;
        }
        return this.toString();
    }

    private Object do_call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, boolean as_constructor) throws JavaScriptException {
        Object result;
        try {
            result = this.master.execDynamicMethod(this.methodName, args, this.scripter.env);
        }
        catch (RuntimeException ex) {
            Object obj;
            if (Debug.ex) {
                Debug.ex(ex);
            }
            Throwable exObj = ex;
            if (ex instanceof Wrapper && (obj = ((Wrapper)((Object)ex)).unwrap()) instanceof Throwable) {
                exObj = (Throwable)obj;
            }
            throw this.scripter.wrapException(scope, exObj);
        }
        if (result != DynamicObject.NOT_FOUND) {
            return this.scripter.wrapDynamicResult(scope, result);
        }
        throw TheScripter.notAFunction(this);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return this.do_call(cx, scope, thisObj, args, false);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        Object result = this.do_call(cx, scope, scope, args, true);
        if (result instanceof Scriptable) {
            return (Scriptable)result;
        }
        throw TheScripter.notAFunction(this);
    }

    private Object get(int key_id) {
        switch (key_id) {
            case 1: 
            case 2: {
                return this.scripter.env.wrapInt(1);
            }
            case 3: {
                return this.methodName;
            }
        }
        return null;
    }

    public String toString() {
        return "function " + this.methodName + "() { [native code] }";
    }
}

