/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.Wrapper;
import ice.scripters.FramesList;
import ice.scripters.WindowObj;
import ice.scripters.js.JS_Dynamic;
import ice.scripters.js.TheScripter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.util.Defs;

public class JS_Window
implements Scriptable,
Wrapper {
    private WindowObj _window;
    private TheScripter _scripter;
    private Scriptable _parentWindowWrap;

    private void $init$() {
        this._parentWindowWrap = Undefined.instance;
    }

    public JS_Window(WindowObj window_arg, TheScripter scripter) {
        this.$init$();
        this._window = window_arg;
        this._scripter = scripter;
    }

    private DynamicObject getDocument() {
        DynamicObject result = null;
        Object obj = this._window.getDynamicValue("document", (DynEnv)this._scripter.env);
        if (obj instanceof DynamicObject) {
            result = (DynamicObject)obj;
        }
        return result;
    }

    private Scriptable getDocumentWrap() {
        Scriptable result = null;
        DynamicObject document = this.getDocument();
        if (document != null) {
            result = this._scripter.wrapDynamicObject(document);
        }
        return result;
    }

    private Object getOnFrameList(String name) {
        FramesList frames = this._window.getFrames();
        Object result = this._scripter.queryField(this, frames, name);
        if (result == Scriptable.NOT_FOUND) {
            result = frames.getFrameByName(name);
            result = result == null ? Scriptable.NOT_FOUND : this._scripter.wrapDynamicResult(this, result);
        }
        return result;
    }

    private Object getOnDocument(String name) {
        Object result = Scriptable.NOT_FOUND;
        Scriptable document = this.getDocumentWrap();
        if (document != null) {
            result = document.get(name, document);
        }
        return result;
    }

    private boolean hasInWindow(String name) {
        if (this._window.hasSlot(name, (DynEnv)this._scripter.env) || Defs.NOT_FOUND != this._window.getDynamicValue(name, (DynEnv)this._scripter.env)) {
            return true;
        }
        Scriptable top = this._scripter.getTop();
        return top.has(name, top);
    }

    public boolean has(String name, Scriptable start) {
        return this.hasInWindow(name);
    }

    public boolean has(int index, Scriptable start) {
        boolean result = this._window.hasSlot(index, (DynEnv)this._scripter.env);
        return result;
    }

    public Object get(String name, Scriptable start) {
        Scriptable top;
        Object result = JS_Dynamic.shouldAbsent(name) ? Scriptable.NOT_FOUND : this._scripter.querySlot((Scriptable)this, (DynamicObject)this._window, name);
        if (result == Scriptable.NOT_FOUND && (result = (top = this._scripter.getTop()).get(name, top)) == Scriptable.NOT_FOUND && (result = this._scripter.queryField(this, this._window, name)) == Scriptable.NOT_FOUND && (result = this.getOnFrameList(name)) == Scriptable.NOT_FOUND) {
            result = this.getOnDocument(name);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        Object result = this._scripter.querySlot((Scriptable)this, (DynamicObject)this._window, index);
        if (result == Scriptable.NOT_FOUND) {
            result = this._scripter.querySlot((Scriptable)this, (DynamicObject)this._window.getFrames(), index);
        }
        return result;
    }

    public void put(String name, Scriptable start, Object value) {
        int set_status;
        boolean done = false;
        if (this != start && (start instanceof JS_Window || !this.hasInWindow(name))) {
            start.put(name, start, value);
            done = true;
        }
        if (!done && (set_status = this._window.setDynamicValue(name, value, (DynEnv)this._scripter.env)) != 1) {
            this._window.setSlot(name, value, (DynEnv)this._scripter.env);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        boolean done = false;
        if (this != start && (start instanceof JS_Window || !this._window.hasSlot(index, (DynEnv)this._scripter.env))) {
            start.put(index, start, value);
            done = true;
        }
        if (!done) {
            this._window.setSlot(index, value, (DynEnv)this._scripter.env);
        }
    }

    public boolean hasInstance(Scriptable value) {
        return false;
    }

    public void delete(String name) {
        this._window.setDynamicValue(name, null, (DynEnv)this._scripter.env);
        this._window.deleteSlot(name);
    }

    public void delete(int index) {
        this._window.deleteSlot(index);
    }

    public Scriptable getPrototype() {
        if (this._parentWindowWrap == Undefined.instance) {
            WindowObj parent = this._window.getParent();
            this._parentWindowWrap = parent == null ? null : this._scripter.getWindowWrap(parent);
        }
        return this._parentWindowWrap;
    }

    public void setPrototype(Scriptable m) {
    }

    public Scriptable getParentScope() {
        return null;
    }

    public void setParentScope(Scriptable m) {
    }

    public Object[] getIds() {
        return Defs.EMPTY_OBJECT_ARRAY;
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this._window.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        return "";
    }

    public String getClassName() {
        return "Window";
    }

    public Object unwrap() {
        return this._window;
    }

    public String toString() {
        return this._window.toString();
    }
}

