/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.debug.Debug;
import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.EcmaError;
import ice.mozilla.javascript.ErrorReporter;
import ice.mozilla.javascript.EvaluatorException;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeJavaObject;
import ice.mozilla.javascript.NativeObject;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.Undefined;
import ice.scripters.WindowObj;
import ice.scripters.js.CustomContext;
import ice.scripters.js.DynamicMethodWrap;
import ice.scripters.js.DynamicWithReflection;
import ice.scripters.js.DynamicWrapFactory;
import ice.scripters.js.EcmaEnv;
import ice.scripters.js.JS_Dynamic;
import ice.scripters.js.JS_Window;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.net.URL;

public class TheScripter
extends Scripter
implements ErrorReporter {
    private final String secureObj;
    StormBase storm;
    boolean suspended;
    private NativeObject top;
    Scriptable functionPrototype;
    final EcmaEnv env;
    final DynamicWrapFactory wrapFactory;
    private static String evilString = "window.eval";
    private static String niceString = "/*FCK*/eval";

    private void $init$() {
        this.secureObj = "SOMETHING";
        this.env = new EcmaEnv(this);
        this.wrapFactory = new DynamicWrapFactory(this);
    }

    public TheScripter() {
        this.$init$();
    }

    public String scripterName() {
        return "ECMAScript";
    }

    protected Viewport contextViewport() {
        return super.contextViewport();
    }

    Object queryField(Scriptable wrapper, DynamicObject dynamic, String name) {
        Object result = dynamic.getDynamicValue(name, this.env);
        result = this.wrapDynamicResult(wrapper, result);
        return result;
    }

    Object querySlot(Scriptable wrapper, DynamicObject dynamic, String name) {
        Object result = dynamic.getSlot(name, (DynEnv)this.env);
        result = this.wrapDynamicResult(wrapper, result);
        return result;
    }

    Object querySlot(Scriptable wrapper, DynamicObject dynamic, int index) {
        Object result = dynamic.getSlot(index, (DynEnv)this.env);
        result = this.wrapDynamicResult(wrapper, result);
        return result;
    }

    DynamicMethodWrap wrapDynamicMethod(DynamicObject dynamic, String methodName) {
        return new DynamicMethodWrap(dynamic, methodName, this);
    }

    Object wrapDynamicResult(Scriptable scope, Object obj) {
        Object result;
        if (obj == null) {
            result = null;
        } else if (obj == Defs.NOT_FOUND) {
            result = Scriptable.NOT_FOUND;
        } else {
            result = this.applyCustomWrap(obj);
            if (result == null) {
                result = this.wrapFactory.defaultWrap(scope, obj);
            }
        }
        return result;
    }

    Object applyCustomWrap(Object obj) {
        if (obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Scriptable) {
            return obj;
        }
        if (obj instanceof DynamicObject) {
            return this.wrapDynamicObject((DynamicObject)obj);
        }
        if (obj instanceof URL) {
            return obj.toString();
        }
        if (obj instanceof Character) {
            return this.env.wrapInt(((Character)obj).charValue());
        }
        return null;
    }

    Scriptable findScopeObject(DynamicObject dynamic) {
        if (dynamic instanceof WindowObj) {
            return null;
        }
        Object scopeObj = dynamic.getDynamicScopeParent();
        if (scopeObj instanceof DynamicObject) {
            return this.wrapDynamicObject((DynamicObject)scopeObj);
        }
        if (scopeObj instanceof Viewport) {
            return this.getViewportWrapper((Viewport)scopeObj);
        }
        return this.top;
    }

    Scriptable wrapDynamicObject(DynamicObject dynamic) {
        Object reflection_target;
        Scriptable wrap = dynamic instanceof WindowObj ? this.getWindowWrap((WindowObj)dynamic) : ((reflection_target = dynamic.javaReflectionTarget()) == null ? new JS_Dynamic(dynamic, this) : (reflection_target == Defs.NOT_FOUND ? Undefined.instance : new DynamicWithReflection(this.top, reflection_target, dynamic, this)));
        return wrap;
    }

    JavaScriptException wrapException(Scriptable scope, Throwable ex) {
        return new JavaScriptException(new NativeJavaObject(scope, ex, null));
    }

    JS_Window getWindowWrap(WindowObj window) {
        return new JS_Window(window, this);
    }

    public Scriptable getViewportWrapper(Viewport view) {
        return this.getWindowWrap(WindowObj.getWindow(view));
    }

    Object wrapEventHandler(DynamicObject target, Object handler) {
        Object result;
        if (handler instanceof Function) {
            result = handler;
        } else {
            Function f;
            Viewport view = this.contextViewport();
            Scriptable targetWrap = this.wrapDynamicObject(target);
            CustomContext cx = this.enterContext();
            try {
                f = this.compileEventHandler(view, cx, targetWrap, handler);
            }
            finally {
                Context.exit();
            }
            result = f != null ? f : handler;
        }
        return result;
    }

    public void init(StormBase base) {
        this.storm = base;
        CustomContext cx = this.enterContext();
        try {
            try {
                this.top = new NativeObject();
                cx.initStandardObjects(this.top);
                this.functionPrototype = ScriptableObject.getClassPrototype(this.top, "Function");
                String cmd = "function Image() {this.src=\"\"; this.width=0; this.height=0; this.complete=true;}";
                cx.evaluateString(this.top, cmd, null, 0, "SOMETHING");
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
            }
        }
        finally {
            Context.exit();
        }
    }

    public void dispose() {
        this.suspended = true;
    }

    public void addViewport(Viewport v) {
    }

    private final String cleanScript(String theScript) {
        int ind = theScript.indexOf(evilString);
        if (ind == -1) {
            return theScript;
        }
        String retval = "";
        StringBuffer buf = new StringBuffer(theScript);
        int i = 0;
        while (i < evilString.length()) {
            buf.setCharAt(i + ind, niceString.charAt(i));
            ++i;
        }
        retval = new String(buf);
        return retval;
    }

    private Object runChecked(Viewport view, BoxedCode code) {
        Object result;
        try {
            result = SecurityKit.doUntrusted(code);
        }
        catch (EcmaError ee) {
            result = ee;
            ScripterCallback c = this.storm.getScripterCallback();
            if (c != null) {
                SecurityKit.doPrivileged(new 1(this, c, view, ee));
            }
        }
        catch (RuntimeException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            result = ex;
        }
        catch (Interruptor ex) {
            if (Debug.trace) {
                Debug.trace("Interrupted");
            }
            result = null;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(Viewport view, String script, String url, int line) {
        if (this.suspended) {
            return null;
        }
        Object parentExecution = this.enterExecutionFrame(view);
        try {
            Object result;
            WindowObj wnd = WindowObj.getWindow(view);
            CustomContext cx = this.enterContext();
            script = this.cleanScript(script);
            Object object = result = this.callEvaluateString(view, cx, this.getWindowWrap(wnd), script, url, line);
            return object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.exitExecutionFrame(parentExecution);
        }
    }

    private Object callEvaluateString(Viewport view, Context cx, Scriptable scope, String script, String url, int line) {
        Object result = this.runChecked(view, new 2(this, cx, scope, script, url, line));
        return result;
    }

    public boolean evalEventHandler(Viewport view, DynamicObject handlerThis, Object handler, DynamicObject event) {
        if (this.suspended) {
            return true;
        }
        Object resultObj = null;
        WindowObj wnd = WindowObj.getWindow(view);
        Object parentExecution = this.enterExecutionFrame(wnd);
        try {
            CustomContext cx = this.enterContext();
            try {
                Scriptable scope;
                Function function;
                JS_Window wndWrap = this.getWindowWrap(wnd);
                Scriptable thisWrap = handlerThis == null ? wndWrap : this.wrapDynamicObject(handlerThis);
                Scriptable eventWrap = this.wrapDynamicObject(event);
                Object[] args = new Object[]{eventWrap};
                if (handler instanceof Function) {
                    function = (Function)handler;
                    scope = function.getParentScope();
                } else {
                    scope = thisWrap;
                    function = this.compileEventHandler(view, cx, thisWrap, handler);
                }
                if (function != null) {
                    resultObj = this.callFunction(view, function, cx, scope, thisWrap, args);
                }
            }
            finally {
                Context.exit();
            }
        }
        finally {
            this.exitExecutionFrame(parentExecution);
        }
        boolean result = true;
        if (resultObj instanceof Boolean) {
            result = (Boolean)resultObj;
        }
        return result;
    }

    private Function compileEventHandler(Viewport view, Context cx, Scriptable targetWrap, Object handlerScript) {
        Scriptable scope = targetWrap;
        String script = "function(event) {\n" + ScriptRuntime.toString(handlerScript) + ";\n}";
        Object compiled = this.callCompileFunction(view, cx, scope, script, "inline function", 0);
        Function f = compiled instanceof Function ? (Function)compiled : null;
        return f;
    }

    private Object callCompileFunction(Viewport view, Context cx, Scriptable scope, String script, String url, int line) {
        return this.runChecked(view, new 3(this, cx, scope, script, url, line));
    }

    private Object callFunction(Viewport view, Function f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object result = this.runChecked(view, new 4(this, f, cx, scope, thisObj, args));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object evalFunction(Viewport view, Function f, Object[] args) {
        WindowObj wnd = WindowObj.getWindow(view);
        Object parentExecution = this.enterExecutionFrame(wnd);
        try {
            CustomContext cx = this.enterContext();
            JS_Window windowWrap = this.getWindowWrap(wnd);
            Object object = this.callFunction(view, f, cx, f.getParentScope(), windowWrap, args);
            return object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.exitExecutionFrame(parentExecution);
        }
    }

    public boolean evalCallback(Viewport view, Object functionObj, Object[] args) {
        if (this.suspended) {
            return false;
        }
        if (functionObj instanceof Function) {
            Object result = this.evalFunction(view, (Function)functionObj, args);
        } else {
            String text = ScriptRuntime.toString(functionObj);
            if (args.length > 0) {
                int name_end = text.indexOf(40);
                if (name_end < 0) {
                    name_end = text.length();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(text);
                sb.setLength(name_end);
                sb.append('(');
                int i = 0;
                while (i != args.length) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.env.toStr(args[i]));
                    ++i;
                }
                sb.append(')');
                text = sb.toString();
            }
            Object result = this.eval(view, text, "<timer>", 0);
        }
        return true;
    }

    public Object _unwrap(Object scriptObject) {
        return this.env.toNative(scriptObject);
    }

    public void addPersistentJavaObject(Object javaObject, Class clazz, String name, int attributes) {
        NativeJavaObject tmpObj = new NativeJavaObject(this.top, javaObject, clazz);
        this.top.defineProperty(name, tmpObj, attributes);
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    Scriptable getTop() {
        return this.top;
    }

    private Object enterExecutionFrame(WindowObj invocationWindow) {
        Viewport viewport = null;
        if (invocationWindow != null) {
            viewport = invocationWindow.getViewport();
        }
        return this.enterExecutionFrame(viewport);
    }

    public CustomContext enterContext() {
        CustomContext cx = new CustomContext(this);
        cx = (CustomContext)Context.enter(cx);
        cx.prepareForExec();
        return cx;
    }

    static RuntimeException ecmaError(String strId, Object arg1) {
        Object[] args = new Object[]{arg1};
        String errorMessage = ScriptRuntime.getMessage(strId, args);
        return Context.reportRuntimeError(errorMessage);
    }

    static RuntimeException ecmaError(String strId, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        String errorMessage = ScriptRuntime.getMessage(strId, args);
        return Context.reportRuntimeError(errorMessage);
    }

    static RuntimeException notAFunction(Object functionPretender) {
        return TheScripter.ecmaError("msg.isnt.function", functionPretender);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        ScripterCallback c = this.storm.getScripterCallback();
        if (c != null) {
            c.reportScriptError(this.contextViewport(), false, message, sourceName, line, lineSource, lineOffset);
        }
        return new EvaluatorException(message);
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        ScripterCallback c = this.storm.getScripterCallback();
        if (c != null) {
            c.reportScriptError(this.contextViewport(), false, message, sourceName, line, lineSource, lineOffset);
        }
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        ScripterCallback c = this.storm.getScripterCallback();
        if (c != null) {
            c.reportScriptError(this.contextViewport(), true, message, sourceName, line, lineSource, lineOffset);
        }
    }

    static class Interruptor
    extends Error {
        Interruptor() {
        }
    }

    final class 1
    implements BoxedCode {
        private final /* synthetic */ ScripterCallback v$c;
        private final /* synthetic */ Viewport v$view;
        private final /* synthetic */ EcmaError v$ee;
        final /* synthetic */ TheScripter this$0;

        public Object run() {
            this.v$c.reportScriptError(this.v$view, false, this.v$ee.getMessage(), this.v$ee.getSourceName(), this.v$ee.getLineNumber(), this.v$ee.getLineSource(), this.v$ee.getColumnNumber());
            return null;
        }

        public 1(TheScripter theScripter, ScripterCallback scripterCallback, Viewport viewport, EcmaError ecmaError) {
            this.v$ee = ecmaError;
            this.v$view = viewport;
            this.v$c = scripterCallback;
            this.this$0 = theScripter;
        }
    }

    final class 2
    implements BoxedCode {
        private final /* synthetic */ Context v$cx;
        private final /* synthetic */ Scriptable v$scope;
        private final /* synthetic */ String v$script;
        private final /* synthetic */ String v$url;
        private final /* synthetic */ int v$line;
        final /* synthetic */ TheScripter this$0;

        public Object run() {
            try {
                Object object = this.v$cx.evaluateString(this.v$scope, this.v$script, this.v$url, this.v$line, "SOMETHING");
                return object;
            }
            catch (JavaScriptException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                JavaScriptException javaScriptException = ex;
                return javaScriptException;
            }
        }

        public 2(TheScripter theScripter, Context context, Scriptable scriptable, String string, String string2, int n) {
            this.v$line = n;
            this.v$url = string2;
            this.v$script = string;
            this.v$scope = scriptable;
            this.v$cx = context;
            this.this$0 = theScripter;
        }
    }

    final class 3
    implements BoxedCode {
        private final /* synthetic */ Context v$cx;
        private final /* synthetic */ Scriptable v$scope;
        private final /* synthetic */ String v$script;
        private final /* synthetic */ String v$url;
        private final /* synthetic */ int v$line;
        final /* synthetic */ TheScripter this$0;

        public Object run() {
            return this.v$cx.compileFunction(this.v$scope, this.v$script, this.v$url, this.v$line, "SOMETHING");
        }

        public 3(TheScripter theScripter, Context context, Scriptable scriptable, String string, String string2, int n) {
            this.v$line = n;
            this.v$url = string2;
            this.v$script = string;
            this.v$scope = scriptable;
            this.v$cx = context;
            this.this$0 = theScripter;
        }
    }

    final class 4
    implements BoxedCode {
        private final /* synthetic */ Function v$f;
        private final /* synthetic */ Context v$cx;
        private final /* synthetic */ Scriptable v$scope;
        private final /* synthetic */ Scriptable v$thisObj;
        private final /* synthetic */ Object[] v$args;
        final /* synthetic */ TheScripter this$0;

        public Object run() {
            try {
                Object object = this.v$f.call(this.v$cx, this.v$scope, this.v$thisObj, this.v$args);
                return object;
            }
            catch (JavaScriptException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                JavaScriptException javaScriptException = ex;
                return javaScriptException;
            }
        }

        public 4(TheScripter theScripter, Function function, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            this.v$args = objectArray;
            this.v$thisObj = scriptable2;
            this.v$scope = scriptable;
            this.v$cx = context;
            this.v$f = function;
            this.this$0 = theScripter;
        }
    }
}

