/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.pilots.html4.DNode;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.CurrentRecord;
import ice.storm.HistoryEntry;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class PseudoHistoryManager
implements HistoryManager {
    private final int LIMIT;
    private int backHistorySize;
    private int forwardHistorySize;
    protected StormBase base;
    private Hashtable backhash;
    private Hashtable fwdhash;
    private Hashtable currentPseudo;
    private Hashtable currentLocation;
    private Hashtable applyPVqueue;
    private Hashtable snapshotqueue;
    private Hashtable hacklocs;

    private void $init$() {
        this.LIMIT = 50;
        this.backHistorySize = 50;
        this.forwardHistorySize = 50;
        this.backhash = new Hashtable();
        this.fwdhash = new Hashtable();
        this.currentPseudo = new Hashtable();
        this.currentLocation = new Hashtable();
        this.applyPVqueue = new Hashtable();
        this.snapshotqueue = new Hashtable();
        this.hacklocs = new Hashtable();
    }

    public PseudoHistoryManager(StormBase sb) {
        this.$init$();
        this.base = sb;
    }

    public void setBackHistorySize(int limit) {
        this.backHistorySize = limit;
    }

    public void setForwardHistorySize(int limit) {
        this.forwardHistorySize = limit;
    }

    public int getBackHistorySize() {
        return this.backHistorySize;
    }

    public int getForwardHistorySize() {
        return this.forwardHistorySize;
    }

    public HistoryEntry[] do_getEntries(String viewportId, Hashtable hash) {
        HistoryEntry[] rtrn = null;
        Viewport v = this.base.findViewportByName(viewportId);
        Stack stack = this.getStackForViewport(v, hash);
        if (stack != null) {
            int sz = stack.size();
            rtrn = new HistoryEntry[sz];
            int i = 0;
            while (i < sz) {
                rtrn[i] = (PseudoViewport)stack.elementAt(i);
                ++i;
            }
        }
        return rtrn;
    }

    public HistoryEntry[] getBackEntries(String viewportId) {
        return this.do_getEntries(viewportId, this.backhash);
    }

    public HistoryEntry[] getForwardEntries(String viewportId) {
        return this.do_getEntries(viewportId, this.fwdhash);
    }

    private String[] do_getHistory(String viewportId, Hashtable hash) {
        String[] rtrn = null;
        Viewport v = this.base.findViewportByName(viewportId);
        Stack stack = this.getStackForViewport(v, hash);
        if (stack != null) {
            int sz = stack.size();
            rtrn = new String[sz];
            int i = 0;
            while (i < sz) {
                rtrn[i] = ((PseudoViewport)stack.elementAt((int)i)).url;
                ++i;
            }
        }
        return rtrn;
    }

    public String[] getForwardHistory(String viewportId) {
        return this.do_getHistory(viewportId, this.fwdhash);
    }

    public String[] getBackHistory(String viewportId) {
        return this.do_getHistory(viewportId, this.backhash);
    }

    private HistoryEntry do_addToHistory(String viewportId, String url, int index, Hashtable hash) {
        PseudoViewport entry = null;
        Viewport v = this.base.findViewportByName(viewportId);
        String hid = v.getHistoryId();
        Stack stack = this.getStackForViewport(v, hash);
        if (stack != null) {
            int sz = stack.size();
            index = Math.min(index, sz);
            entry = new PseudoViewport(hid, url);
            stack.insertElementAt(entry, index);
        }
        return entry;
    }

    public HistoryEntry addToBackHistory(String viewportId, String url, int index) {
        return this.do_addToHistory(viewportId, url, index, this.backhash);
    }

    public HistoryEntry addToForwardHistory(String viewportId, String url, int index) {
        return this.do_addToHistory(viewportId, url, index, this.fwdhash);
    }

    public void clearAllHistories() {
        Enumeration anEnum = this.backhash.elements();
        while (anEnum.hasMoreElements()) {
            Stack s = (Stack)anEnum.nextElement();
            this.do_clear(s);
        }
        anEnum = this.fwdhash.elements();
        while (anEnum.hasMoreElements()) {
            Stack s = (Stack)anEnum.nextElement();
            this.do_clear(s);
        }
        this.backhash.clear();
        this.fwdhash.clear();
        this.hacklocs.clear();
        this.applyPVqueue.clear();
        this.snapshotqueue.clear();
    }

    public void clearHistoryForViewport(Viewport v) {
        String hid = v.getHistoryId();
        Stack b = (Stack)this.backhash.get(hid);
        Stack f = (Stack)this.fwdhash.get(hid);
        this.do_clear(b);
        this.do_clear(f);
        this.backhash.remove(hid);
        this.fwdhash.remove(hid);
        this.currentPseudo.remove(hid);
        this.currentLocation.remove(v.getId());
        this.hacklocs.remove(hid);
        this.applyPVqueue.remove(hid);
        this.snapshotqueue.remove(hid);
    }

    /*
     * Unable to fully structure code
     */
    private void do_clear(Stack stack) {
        if (stack != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            p = (PseudoViewport)stack.pop();
            if (p == null) continue;
            p.dispose();
lbl6:
            // 3 sources

            ** while (!stack.isEmpty())
        }
lbl7:
        // 1 sources

    }

    public String getCurrentLocation(String viewportId) {
        CurrentRecord cr = (CurrentRecord)this.currentLocation.get(viewportId);
        if (cr == null) {
            return null;
        }
        return cr.loc;
    }

    private byte[] getCurrentPostData(String viewportId) {
        CurrentRecord cr = (CurrentRecord)this.currentLocation.get(viewportId);
        if (cr == null) {
            return null;
        }
        return cr.postData;
    }

    public void reload(String viewportId) {
        Viewport _viewport = this.base.findViewportByName(viewportId);
        PseudoViewport _pseudoViewport = (PseudoViewport)this.currentPseudo.get(_viewport.getHistoryId());
        if (_pseudoViewport == null) {
            return;
        }
        this.recordSnapshots(_pseudoViewport);
        this.reloadPV(_pseudoViewport);
        this.applySnapshots(_pseudoViewport);
    }

    private boolean putcurrent(String hid, String url) {
        Viewport v;
        Viewport parent = null;
        Viewport top = v = this.base.findViewportByHistoryId(hid);
        boolean isTop = true;
        while (top.getParent() != null) {
            top = top.getParent();
            if (isTop) {
                parent = top;
            }
            isTop = false;
        }
        PseudoViewport curr = new PseudoViewport(hid, url);
        byte[] pdata = this.getCurrentPostData(v.getId());
        String curloc = this.getCurrentLocation(v.getId());
        if (curloc != null && curloc.equals(url) && this.getCurrentPostData(v.getId()) != null && pdata == null) {
            return false;
        }
        if (pdata != null) {
            curr.postData = pdata;
        }
        if (isTop) {
            this.currentPseudo.put(hid, curr);
        } else {
            PseudoViewport old;
            PseudoViewport parentPV;
            PseudoViewport topPV = this.getCurrentPseudoViewport(top.getHistoryId());
            if (topPV == null) {
                this.putcurrent(top.getHistoryId(), this.getCurrentLocation(top.getId()));
                topPV = this.getCurrentPseudoViewport(top.getHistoryId());
            }
            if ((parentPV = this.findPV(topPV, parent.getHistoryId(), true)) == null) {
                this.putcurrent(parent.getHistoryId(), this.getCurrentLocation(parent.getId()));
                parentPV = this.findPV(topPV, parent.getHistoryId(), true);
            }
            if ((old = this.findPV(parentPV, hid, true)) != null) {
                PseudoViewport newTop = this.clonePV(topPV);
                parentPV = this.findPV(newTop, parent.getHistoryId(), true);
                old = this.findPV(parentPV, hid, true);
                this.replacePVChild(parentPV, old, curr);
                this.currentPseudo.put(top.getHistoryId(), newTop);
            } else {
                this.addPVChild(parentPV, curr);
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Stack getStackForViewport(Viewport v, Hashtable hash) {
        if (v != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            v = v.getParent();
lbl4:
            // 2 sources

            ** while (v.getParent() != null)
        }
lbl5:
        // 1 sources

        hid = v.getHistoryId();
        rtrn = (Stack<E>)hash.get(hid);
        if (rtrn == null) {
            rtrn = new Stack<E>();
            hash.put(hid, rtrn);
        } else {
            v0 = size = hash == this.backhash ? this.backHistorySize : this.forwardHistorySize;
            if (rtrn.size() > size) {
                pv = (PseudoViewport)rtrn.elementAt(0);
                if (pv != null) {
                    pv.dispose();
                }
                rtrn.removeElementAt(0);
            }
        }
        return rtrn;
    }

    public void goBack(String viewportId, int leap) {
        this.do_go(viewportId, this.backhash, this.fwdhash, leap);
    }

    public void goBack(String viewportId) {
        this.goBack(viewportId, 1);
    }

    private void do_go(String viewportId, Hashtable hash, Hashtable other, int leap) {
        Viewport v = this.base.findViewportByName(viewportId);
        Stack stack = this.getStackForViewport(v, hash);
        if (stack == null) {
            return;
        }
        PseudoViewport pv = this.getCurrentPseudoViewport(v.getHistoryId());
        int i = 0;
        while (i < leap && !stack.isEmpty()) {
            PseudoViewport tmp = pv;
            pv = (PseudoViewport)stack.pop();
            if ((pv = this.getApplicablePV(pv)) == null) {
                return;
            }
            if (tmp != null) {
                this.getStackForViewport(v, other).push(tmp);
            }
            ++i;
        }
        if (i > 0) {
            this.applyPV(pv);
        }
    }

    public void goForward(String viewportId) {
        this.goForward(viewportId, 1);
    }

    public void goForward(String viewportId, int leap) {
        this.do_go(viewportId, this.fwdhash, this.backhash, leap);
    }

    public void goingSomewhere(ContentLoader cl, String viewportId) {
        if (cl.getRedirected()) {
            return;
        }
        String loc = cl.getLocation();
        if (loc == null) {
            return;
        }
        String curr = this.getCurrentLocation(viewportId);
        this.currentLocation.put(viewportId, new CurrentRecord(loc, cl.getPostData()));
        Viewport v = this.base.findViewportByName(viewportId);
        if (v == null) {
            return;
        }
        String hid = v.getHistoryId();
        PseudoViewport pvcurr = this.getCurrentPseudoViewport(hid);
        if (!this.putcurrent(hid, loc)) {
            return;
        }
        String hackloc = (String)this.hacklocs.get(viewportId);
        if (hackloc == null || !hackloc.equals(loc)) {
            if (curr != null) {
                boolean reload = false;
                if (curr.equals(loc) && cl.getPostData() == pvcurr.postData) {
                    reload = true;
                }
                if (!reload) {
                    this.getStackForViewport(v, this.backhash).push(pvcurr);
                    Enumeration anEnum = this.fwdhash.elements();
                    while (anEnum.hasMoreElements()) {
                        Stack stack = (Stack)anEnum.nextElement();
                        while (!stack.isEmpty()) {
                            PseudoViewport p = (PseudoViewport)stack.pop();
                            p.dispose();
                        }
                    }
                    this.fwdhash.clear();
                }
            }
            this.hacklocs.clear();
        }
        this.base.sendViewportMessage(v, "history", null, "modified");
    }

    public boolean canGoBack(String viewportId) {
        Stack stack = this.getStackForViewport(this.base.findViewportByName(viewportId), this.backhash);
        if (stack == null) {
            return false;
        }
        return stack.isEmpty() ^ true;
    }

    public boolean canGoForward(String viewportId) {
        Stack stack = this.getStackForViewport(this.base.findViewportByName(viewportId), this.fwdhash);
        if (stack == null) {
            return false;
        }
        return stack.isEmpty() ^ true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String _newValue;
        Viewport _viewport = (Viewport)event.getSource();
        Pilot _pilot = _viewport.getPilot();
        if (_pilot == null) {
            return;
        }
        String _viewportId = _viewport.getId();
        String _historyId = _viewport.getHistoryId();
        String _currentLocation = this.getCurrentLocation(_viewportId);
        String _propertyName = event.getPropertyName();
        String string = _newValue = event.getNewValue() instanceof String ? (String)event.getNewValue() : "";
        if (_propertyName.startsWith("vi") && _newValue.startsWith("ch")) {
            PseudoViewport _pseudoViewport = (PseudoViewport)this.applyPVqueue.get(_historyId);
            if (_pseudoViewport != null) {
                this.applyPVChildren(_pseudoViewport);
                this.applyPVqueue.remove(_historyId);
            }
        } else if (_propertyName.equals("contentLoading")) {
            PseudoViewport _pseudoViewport;
            if (_newValue.equals("request")) {
                if (_viewport.getLocation() == null || event.getOldValue() == null) {
                    return;
                }
                PseudoViewport _pseudoViewport2 = this.getCurrentPseudoViewport(_historyId);
                if (_pseudoViewport2 != null) {
                    this.recordSnapshots(_pseudoViewport2);
                }
            } else if (_newValue.equals("end") && (_pseudoViewport = (PseudoViewport)this.snapshotqueue.get(_historyId)) != null) {
                this.applySnapshots(_pseudoViewport);
                this.snapshotqueue.remove(_historyId);
            }
        } else if (_propertyName.equals("goToAnchor")) {
            PseudoViewport _pseudoViewport;
            if (_newValue.equals("begin")) {
                if (_viewport.getLocation() == null || event.getOldValue() == null) {
                    return;
                }
                PseudoViewport _pseudoViewport3 = this.getCurrentPseudoViewport(_historyId);
                if (_pseudoViewport3 != null) {
                    this.recordSnapshots(_pseudoViewport3);
                }
            } else if (_newValue.equals("end") && (_pseudoViewport = (PseudoViewport)this.snapshotqueue.get(_historyId)) != null) {
                this.applySnapshots(_pseudoViewport);
                this.snapshotqueue.remove(_historyId);
            }
        }
    }

    private void applySnapshots(PseudoViewport pseudoViewport) {
        PseudoViewport _child = pseudoViewport.first;
        while (_child != null) {
            this.applySnapshots(_child);
            _child = _child.next;
        }
        Viewport _viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId);
        if (_viewport != null && _viewport.getPilot() != null) {
            _viewport.getPilot().applySnapshot(pseudoViewport.snapshot);
        }
    }

    private void recordSnapshots(PseudoViewport pseudoViewport) {
        Object _snapshot;
        Viewport _viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId);
        if (_viewport != null && _viewport.getPilot() != null && (_snapshot = _viewport.getPilot().getSnapshot()) != null) {
            pseudoViewport.snapshot = _snapshot;
        }
        PseudoViewport _child = pseudoViewport.first;
        while (_child != null) {
            this.recordSnapshots(_child);
            _child = _child.next;
        }
    }

    private PseudoViewport getApplicablePV(PseudoViewport pv) {
        if (pv == null) {
            return null;
        }
        PseudoViewport rtrn = null;
        Viewport v = this.base.findViewportByHistoryId(pv.historyId);
        if (v != null) {
            String curr = this.getCurrentLocation(v.getId());
            if (curr != null && curr.equals(pv.url)) {
                if (this.getCurrentPostData(v.getId()) != pv.postData) {
                    return pv;
                }
                PseudoViewport p = pv.first;
                while (p != null) {
                    rtrn = this.getApplicablePV(p);
                    if (rtrn == null) {
                        p = p.next;
                        continue;
                    }
                    break;
                }
            } else {
                rtrn = pv;
            }
        }
        return rtrn;
    }

    private void applyPV(PseudoViewport pv) {
        Viewport v = this.base.findViewportByHistoryId(pv.historyId);
        if (v != null) {
            boolean loaded;
            if (pv.snapshot != null) {
                this.snapshotqueue.put(pv.historyId, pv);
            }
            this.hacklocs.put(v.getId(), pv.url);
            String curr = this.getCurrentLocation(v.getId());
            boolean bl = loaded = curr != null && curr.equals(pv.url) && this.getCurrentPostData(v.getId()) == pv.postData;
            if (pv.first != null) {
                if (loaded) {
                    this.applyPVChildren(pv);
                    return;
                }
                this.applyPVqueue.put(pv.historyId, pv);
            }
            if (!loaded) {
                ContentLoader cl = this.base.getContentLoaderFactory().createContentLoader(pv.url, null);
                cl.setFromHistoryFlag(pv.first != null);
                if (pv.postData != null) {
                    cl.setPostData(null, pv.postData);
                }
                this.base.renderContent(cl, v.getId());
            }
        }
    }

    private void applyPVChildren(PseudoViewport pv) {
        PseudoViewport p = pv.first;
        while (p != null) {
            this.applyPV(p);
            p = p.next;
        }
        this.applyPVqueue.remove(pv.historyId);
    }

    private boolean reloadPV(PseudoViewport pseudoViewport) {
        boolean _contentReloaded = false;
        Viewport _viewport = this.base.findViewportByHistoryId(pseudoViewport.historyId);
        if (_viewport != null) {
            if (this.containsFrameset(_viewport)) {
                PseudoViewport _child = pseudoViewport.first;
                while (_child != null) {
                    _contentReloaded |= this.reloadPV(_child);
                    _child = _child.next;
                }
                if (!_contentReloaded) {
                    this.hacklocs.put(_viewport.getId(), pseudoViewport.url);
                    this.base.renderContent(pseudoViewport.url, null, _viewport.getId());
                    _contentReloaded = true;
                }
            } else {
                this.hacklocs.put(_viewport.getId(), pseudoViewport.url);
                this.base.renderContent(pseudoViewport.url, null, _viewport.getId());
                _contentReloaded = true;
            }
        }
        return _contentReloaded;
    }

    private boolean containsFrameset(Viewport viewport) {
        DNode _currentElement;
        Pilot _pilot;
        if (viewport != null && (_pilot = viewport.getPilot()) instanceof ThePilot && (_currentElement = ((ThePilot)_pilot).getDDocument().getDocumentDElement()) != null) {
            _currentElement = (DNode)_currentElement.getFirstChild();
            while (_currentElement != null) {
                switch (_currentElement.getNameId()) {
                    case 13: {
                        return false;
                    }
                    case 34: {
                        return true;
                    }
                }
                _currentElement = (DNode)_currentElement.getNextSibling();
            }
        }
        return false;
    }

    private PseudoViewport clonePV(PseudoViewport pv) {
        PseudoViewport rtrn = new PseudoViewport(pv.historyId, pv.url);
        PseudoViewport p = pv.first;
        while (p != null) {
            this.addPVChild(rtrn, this.clonePV(p));
            p = p.next;
        }
        return rtrn;
    }

    private void addPVChild(PseudoViewport pv, PseudoViewport child) {
        if (pv == null || child == null) {
            return;
        }
        PseudoViewport old = this.findPV(pv, child.historyId, false);
        if (old != null) {
            this.replacePVChild(pv, old, child);
            return;
        }
        pv.addChild(child);
    }

    private void replacePVChild(PseudoViewport pv, PseudoViewport oldChild, PseudoViewport newChild) {
        pv.replaceChild(oldChild, newChild);
        if (oldChild != null) {
            oldChild.dispose();
        }
    }

    private PseudoViewport findPV(PseudoViewport pv, String idToFind, boolean deep) {
        PseudoViewport rtrn = null;
        if (pv == null) {
            return null;
        }
        if (idToFind.equals(pv.historyId)) {
            rtrn = pv;
        } else {
            PseudoViewport p = pv.first;
            while (p != null) {
                if (deep) {
                    rtrn = this.findPV(p, idToFind, true);
                    if (rtrn != null) {
                        break;
                    }
                } else if (idToFind.equals(p.historyId)) {
                    rtrn = p;
                    break;
                }
                p = p.next;
            }
        }
        return rtrn;
    }

    private PseudoViewport getCurrentPseudoViewport(String historyId) {
        Viewport _viewport = this.base.findViewportByHistoryId(historyId);
        if (_viewport == null) {
            return null;
        }
        PseudoViewport _pseudoViewport = (PseudoViewport)this.currentPseudo.get(historyId);
        if (_pseudoViewport == null) {
            while (_viewport.getParent() != null) {
                _viewport = _viewport.getParent();
            }
            _pseudoViewport = (PseudoViewport)this.currentPseudo.get(_viewport.getHistoryId());
        }
        return _pseudoViewport;
    }

    private static class PseudoViewport
    implements HistoryEntry {
        String historyId;
        String url;
        Object snapshot;
        byte[] postData;
        PseudoViewport first;
        PseudoViewport parent;
        PseudoViewport last;
        PseudoViewport next;

        PseudoViewport(String hid, String url) {
            this.url = url;
            this.historyId = hid;
        }

        public String getURL() {
            return this.url;
        }

        public void setURL(String url) {
            this.url = url;
        }

        public void setPostData(byte[] postData) {
            this.postData = postData;
        }

        void dispose() {
            PseudoViewport p = this.first;
            while (p != null) {
                p.dispose();
                p = p.next;
            }
            this.snapshot = null;
            this.postData = null;
            this.parent = null;
            this.next = null;
            this.first = null;
            this.last = null;
            this.url = null;
        }

        void replaceChild(PseudoViewport oldChild, PseudoViewport newChild) {
            if (oldChild == null || newChild == null || this.first == null) {
                return;
            }
            newChild.parent = this;
            if (this.first == oldChild) {
                newChild.next = oldChild.next;
                this.first = newChild;
            } else {
                PseudoViewport p = this.first;
                PseudoViewport pp = p.next;
                while (pp != null) {
                    if (oldChild == pp) {
                        newChild.next = oldChild.next;
                        p.next = newChild;
                        break;
                    }
                    p = pp;
                    pp = p.next;
                }
            }
            if (this.last == oldChild) {
                this.last = newChild;
            }
        }

        void addChild(PseudoViewport pv) {
            pv.parent = this;
            if (this.first == null) {
                pv.next = null;
                this.first = this.last = pv;
            } else {
                pv.next = null;
                this.last.next = pv;
                this.last = pv;
            }
        }

        public String toString() {
            String s = super.toString() + " " + this.historyId + " " + this.url;
            return s;
        }
    }
}

