/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.ContentLoaderFactory;
import ice.storm.DefaultContentLoaderFactory;
import ice.storm.DefaultFactory;
import ice.storm.DocPane;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.PseudoHistoryManager;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.ScripterFactory;
import ice.storm.ScripterInfo;
import ice.storm.StormCallback;
import ice.storm.URLClassLoaderFactory;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.storm.ViewportLayoutManager;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.alg.Listeners;
import ice.util.alg.Session;
import ice.util.awt.TimedAWTExecutor;
import ice.util.net.URLResolver;
import ice.util.security.SecurityKit;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StormBase {
    public static final String VERSION = "v6_1_3";
    public static final String EXPIRES_STRING = "EXPIRY_DATE_TEXT";
    public static final String EXPIRES_LONG = "988668001910L";
    private static final Object _noScripter = new Object();
    private static final boolean disable_pilot_reuse;
    private final Object viewportTreeLock;
    private HistoryManager historyManager;
    private PilotFactory pilotFactory;
    private URLClassLoaderFactory classLoaderFactory;
    private String componentToolkitName;
    private Container container;
    private ViewportCallback viewportCallback;
    private ScripterCallback scripterCallback;
    private Hashtable scripters;
    private Hashtable missingScripters;
    private Vector viewports;
    String initialViewportName;
    private Viewport activeViewport;
    private Object globalListeners;
    private Hashtable disabledMimeTypes;
    private TimedAWTExecutor timedAWTExecutor;
    private UrlMaster urlMaster;
    private final long[] recursiveTimestamp;
    private final boolean trace_viewport_messages;
    private Session session;
    private ContentLoaderFactory contentLoaderFactory;

    static {
        if (Debug.trace) {
            Debug.traceAsIs("ICEbrowser v6_1_3");
        } else if (Defs.booleanProperty("ice.browser.verbose", false)) {
            System.out.println("ICEbrowser v6_1_3");
            System.out.println("(c) ICEsoft Technologies, Inc.");
        }
        String agentName = Defs.property("http.agent");
        if (agentName == null) {
            agentName = Emulation.getEmulatedUserAgent();
            Defs.setSystemProperty("http.agent", agentName);
        }
        disable_pilot_reuse = Defs.booleanProperty("ice.storm.disable_pilot_reuse");
    }

    private void $init$() {
        this.viewportTreeLock = new Object();
        this.componentToolkitName = "awt";
        this.scripters = new Hashtable();
        this.missingScripters = new Hashtable();
        this.viewports = new Vector();
        this.disabledMimeTypes = new Hashtable();
        this.recursiveTimestamp = new long[1];
        this.trace_viewport_messages = Debug.trace && Defs.booleanProperty("ice.storm.trace_viewport_messages");
    }

    public StormBase() {
        this(new Session());
    }

    public StormBase(Session session) {
        this.$init$();
        this.session = session;
        DefaultFactory f = new DefaultFactory();
        f.loadDefaultResources();
        this.pilotFactory = f;
        this.classLoaderFactory = f;
        this.contentLoaderFactory = new DefaultContentLoaderFactory();
        this.setHistoryManager(new PseudoHistoryManager(this));
        this.addPropertyChangeListener(this.getHistoryManager(), null);
    }

    public final Session getSession() {
        return this.session;
    }

    public final void setHistoryManager(HistoryManager hm) {
        this.historyManager = hm;
    }

    public final HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public final ScripterFactory getScripterFactory() {
        return this.getPilotFactory();
    }

    public final void setPilotFactory(PilotFactory f) {
        this.pilotFactory = f;
    }

    public final PilotFactory getPilotFactory() {
        return this.pilotFactory;
    }

    public final void setURLClassLoaderFactory(URLClassLoaderFactory f) {
        this.classLoaderFactory = f;
    }

    public final URLClassLoaderFactory getURLClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public final void setComponentToolkitName(String name) {
        this.componentToolkitName = name;
    }

    public final String getComponentToolkitName() {
        return this.componentToolkitName;
    }

    public final void setContainer(Container c, String viewportName) {
        if (this.viewportCallback != null || this.container != null) {
            return;
        }
        this.container = c;
        this.configureViewport(new Viewport(this, viewportName));
    }

    public final Container getContainer(Container c) {
        return this.container;
    }

    public final void setCallback(StormCallback c) {
        CallbackAdapter.OldCallbackWrap wrap = new CallbackAdapter.OldCallbackWrap(c);
        wrap.registerWith(this);
    }

    public final StormCallback getCallback() {
        if (this.viewportCallback instanceof CallbackAdapter) {
            return ((CallbackAdapter.OldCallbackWrap)this.viewportCallback).oldCallback;
        }
        return null;
    }

    public final ViewportCallback getViewportCallback() {
        return this.viewportCallback;
    }

    public final void setViewportCallback(ViewportCallback c) {
        if (this.container != null) {
            return;
        }
        this.viewportCallback = c;
        this.viewportCallback.init(this);
    }

    public final ScripterCallback getScripterCallback() {
        return this.scripterCallback;
    }

    public final void setScripterCallback(ScripterCallback c) {
        this.scripterCallback = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveViewport(Viewport view) {
        if (view == this.activeViewport) {
            return;
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            String id;
            Viewport cachedVP = this.activeViewport;
            this.activeViewport = view;
            if (cachedVP != null) {
                DocPane dp;
                Pilot p = cachedVP.getPilot();
                if (p != null && (dp = p.getDocPane()) != null) {
                    dp.reqRepaint();
                }
                this.sendViewportMessage(cachedVP, "viewport", null, "deactivated");
            }
            String string = id = this.activeViewport == null ? "none" : this.activeViewport.getId();
            if (view != null) {
                DocPane dp;
                Pilot p = view.getPilot();
                if (p != null && (dp = p.getDocPane()) != null) {
                    dp.reqRepaint();
                }
                this.sendViewportMessage(view, "viewport", id, "activated");
            }
        }
        if (this.container != null) {
            this.container.repaint();
        }
    }

    public Viewport getActiveViewport() {
        return this.activeViewport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l, String viewportId) {
        if (viewportId == null) {
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.globalListeners = Listeners.add(this.globalListeners, l);
            }
        } else {
            Viewport view = this.findViewportByName(viewportId);
            if (view != null) {
                view.addPropertyChangeListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l, String viewportId) {
        if (viewportId == null) {
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.globalListeners = Listeners.remove(this.globalListeners, l);
            }
        } else {
            Viewport view = this.findViewportByName(viewportId);
            if (view != null) {
                view.removePropertyChangeListener(l);
            }
        }
    }

    boolean sendViewportMessage(Viewport view, String propName, Object addArg, Object newValue) {
        if (view == null) {
            Debug.bug();
        }
        if (this.trace_viewport_messages && Debug.trace) {
            Debug.trace(view + ", " + propName + ", " + addArg + ", " + newValue);
        }
        if (this.viewportCallback != null) {
            try {
                this.viewportCallback.processViewportMessage(view, propName, addArg, newValue);
            }
            catch (OutOfMemoryError ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                boolean bl = false;
                return bl;
            }
            catch (RuntimeException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                boolean bl = false;
                return bl;
            }
        }
        boolean flag = true;
        PropertyChangeEvent ev = null;
        Viewport current = view;
        while (true) {
            Object listeners;
            if ((listeners = current == null ? this.globalListeners : current.getPropertyListeners()) != null) {
                if (ev == null) {
                    ev = new PropertyChangeEvent(view, propName, addArg, newValue);
                }
                flag &= StormBase.firePropertyChangeEvent(listeners, ev);
            }
            if (current == null) break;
            current = current.getParent();
        }
        return flag;
    }

    private static boolean firePropertyChangeEvent(Object listeners, PropertyChangeEvent ev) {
        PropertyChangeListener l;
        if (listeners == null) {
            Defs.badArg();
        }
        boolean flag = true;
        int i = 0;
        while ((l = (PropertyChangeListener)Listeners.get(listeners, i)) != null) {
            try {
                l.propertyChange(ev);
            }
            catch (OutOfMemoryError ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                boolean bl = false;
                return bl;
            }
            catch (RuntimeException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                flag = false;
            }
            ++i;
        }
        return flag;
    }

    public boolean isMimeTypeEnabled(String mimeType) {
        Enumeration e;
        PilotFactory pf;
        boolean result = false;
        if (!this.disabledMimeTypes.containsKey(mimeType) && (pf = this.getPilotFactory()) != null && (e = pf.getAllPilotInfos()) != null) {
            while (e.hasMoreElements()) {
                PilotInfo pi = (PilotInfo)e.nextElement();
                if (!pi.isSupportedContentType(mimeType)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void setMimeTypeEnabled(String mimeType, boolean enabled) {
        Object o = this.disabledMimeTypes.get(mimeType);
        if (o != null && enabled) {
            this.disabledMimeTypes.remove(mimeType);
        } else if (o == null && !enabled) {
            this.disabledMimeTypes.put(mimeType, mimeType);
        }
    }

    public UrlMaster getUrlMaster() {
        if (this.urlMaster == null) {
            this.urlMaster = UrlMaster.get(this.session);
        }
        return this.urlMaster;
    }

    public void renderContent(String loc, String contentType, String viewportName) {
        this.renderContent(loc, contentType, this.prepare_viewport(viewportName, loc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderContent(String location, String contentType, Viewport viewport) {
        if (viewport == null) {
            Debug.bug();
        }
        location = URLResolver.resolve(viewport.getBaseUrl(), location);
        Debug.trace(location + " in " + viewport);
        Scripter scripter = this.getScripterForCodeLocation(location);
        if (scripter != null) {
            scripter.evalCodeLocation(viewport, location);
            return;
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ContentLoader cl = this.contentLoaderFactory.createContentLoader(location, contentType);
            cl.setReferer(viewport.getBaseUrl());
            if (this.anchorsHandled(cl, viewport) && cl.getPostData() == null) {
                this.goToAnchor(cl, viewport);
                return;
            }
            try {
                this.stopLoading(viewport.getName());
            }
            catch (RuntimeException exception) {
                Debug.ex(exception);
            }
            viewport.queueRenderContent(cl);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void renderStringContent(String content, String contentType, String viewportName) {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        ContentLoader cl = this.contentLoaderFactory.createContentLoader(null, in, contentType);
        this.renderContent(cl, viewportName);
    }

    public void renderStringContentFully(String content, String contentType, String viewportName) {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        ContentLoader cl = this.contentLoaderFactory.createContentLoader(null, in, contentType);
        this.renderContentFully(cl, viewportName);
    }

    public void renderStringContent(String content, String contentType, Viewport viewport) {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        ContentLoader cl = this.contentLoaderFactory.createContentLoader(null, in, contentType);
        this.renderViewportContent(cl, viewport);
    }

    public void renderStringContentFully(String content, String contentType, Viewport viewport) {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        ContentLoader cl = this.contentLoaderFactory.createContentLoader(null, in, contentType);
        this.renderViewportContentFully(cl, viewport);
    }

    private boolean anchorsHandled(ContentLoader contentLoader, Viewport viewport) {
        String prev_uri;
        String _anchor;
        URL _url = contentLoader.getURL();
        if (_url != null && (_anchor = _url.getRef()) != null && (prev_uri = viewport.getLocation()) != null) {
            Pilot pilot;
            String new_uri;
            int sharp = prev_uri.lastIndexOf(35);
            if (sharp >= 0) {
                prev_uri = prev_uri.substring(0, sharp);
            }
            if ((sharp = (new_uri = _url.toExternalForm()).lastIndexOf(35)) >= 0) {
                new_uri = new_uri.substring(0, sharp);
            }
            if (prev_uri.equals(new_uri) && (pilot = viewport.getPilot()) != null) {
                return true;
            }
        }
        return false;
    }

    private void goToAnchor(ContentLoader contentLoader, Viewport viewport) {
        Pilot _pilot;
        String _anchor;
        URL _url;
        if (contentLoader != null && (_url = contentLoader.getURL()) != null && (_anchor = _url.getRef()) != null && (_pilot = viewport.getPilot()) != null && _pilot.refExists(_anchor) && this.sendViewportMessage(viewport, "goToAnchor", contentLoader, "begin")) {
            try {
                this.historyManager.goingSomewhere(contentLoader, viewport.getId());
                _pilot.gotoRef(_anchor);
            }
            catch (RuntimeException exception) {
                Debug.ex(exception);
            }
            this.sendViewportMessage(viewport, "goToAnchor", contentLoader, "end");
        }
    }

    public void renderContent(ContentLoader cl, String viewportName) {
        Viewport view = this.prepare_viewport(viewportName, cl.getLocation());
        if (view == null) {
            if (Debug.trace) {
                Debug.trace("Failed: no view for " + viewportName);
            }
            return;
        }
        this.renderViewportContent(cl, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderViewportContent(ContentLoader cl, Viewport view) {
        Debug.trace("loader=" + cl + " view=" + view);
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (this.anchorsHandled(cl, view) && cl.getPostData() == null) {
                this.goToAnchor(cl, view);
                return;
            }
            this.stopViewportLoading(view);
            view.queueRenderContent(cl);
        }
        this.sendViewportMessage(view, "viewport", null, "ready");
    }

    public void renderContentFully(ContentLoader contentLoader, String viewportName) {
        Viewport _viewport = this.prepare_viewport(viewportName, contentLoader.getLocation());
        if (_viewport == null) {
            Debug.trace("Failed: no viewport for " + viewportName + " to render " + contentLoader);
            return;
        }
        this.renderViewportContentFully(contentLoader, _viewport);
    }

    public void renderVieportContentFully(ContentLoader contentLoader, Viewport viewport) {
        this.renderViewportContentFully(contentLoader, viewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderViewportContentFully(ContentLoader contentLoader, Viewport viewport) {
        Debug.trace("contentLoader=" + contentLoader + ", viewport=" + viewport);
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (this.anchorsHandled(contentLoader, viewport) && contentLoader.getPostData() == null) {
                this.goToAnchor(contentLoader, viewport);
                return;
            }
            this.stopViewportLoading(viewport);
            this.do_render_content(contentLoader, viewport);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void clearContent(String contentType, String viewportName) {
        Viewport view = this.prepare_viewport(viewportName, null);
        if (view == null) {
            return;
        }
        if (Debug.trace) {
            Debug.trace("contentType=" + contentType + " viewport=" + view);
        }
        this.stopViewportLoading(view);
        this.do_clear_content(null, contentType, view);
        this.sendViewportMessage(view, "viewport", null, "ready");
    }

    public void clearVieportContent(String contentType, Viewport viewport) {
        this.clearViewportContent(contentType, viewport);
    }

    public void clearViewportContent(String contentType, Viewport viewport) {
        Debug.trace("contentType=" + contentType + ", viewport=" + viewport);
        this.stopViewportLoading(viewport);
        this.do_clear_content(null, contentType, viewport);
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public Viewport newTopLevelViewport(String viewportName) {
        return this.newTopLevelViewport(viewportName, null);
    }

    public Viewport newTopLevelViewport(String viewportName, String location) {
        Viewport view = new Viewport(this, viewportName);
        view.setLocationUrl(location);
        if (!this.configureViewport(view)) {
            view = null;
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Viewport prepare_viewport(String viewportName, String location) {
        if ("_blank".equals(viewportName)) {
            viewportName = null;
        }
        Viewport view = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (viewportName != null) {
                if (this.viewports.size() == 0) {
                    this.initialViewportName = viewportName = new String(viewportName);
                } else {
                    view = this.findViewportByName(viewportName);
                }
            } else if (this.container != null && this.viewports.size() == 1) {
                view = (Viewport)this.viewports.elementAt(0);
            }
        }
        if (view == null) {
            view = this.newTopLevelViewport(viewportName, location);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_clear_content(ContentLoader loader, String contentType, Viewport view) {
        if (contentType == null) {
            contentType = "text/html";
        }
        if (view.isStopRequested()) {
            return;
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ViewportUnloader unloader = new ViewportUnloader();
            view.iterate(unloader);
        }
        if (disable_pilot_reuse) {
            Object object2 = this.viewportTreeLock;
            synchronized (object2) {
                view.clearContent();
            }
            Pilot pilot = view.getPilot();
            if (pilot != null) {
                view.removePilot();
            }
            Object object3 = this.viewportTreeLock;
            synchronized (object3) {
                view.removeWindowVariables();
            }
            this.loadNewPilot(loader, contentType, view);
        } else {
            Object object4 = this.viewportTreeLock;
            synchronized (object4) {
                view.clearContent();
            }
            Pilot pilot = view.getPilot();
            if (pilot != null) {
                boolean can_show = this.getPilotFactory().isContentTypeSupported(pilot, loader, contentType);
                if (!can_show) {
                    if (view.isStopRequested()) {
                        return;
                    }
                    view.removePilot();
                    pilot = null;
                } else {
                    if (loader != null) {
                        contentType = loader.getContentType();
                    }
                    view.setLocationUrl(null);
                    pilot.clear(contentType);
                }
            }
            Object object5 = this.viewportTreeLock;
            synchronized (object5) {
                view.removeWindowVariables();
            }
            if (pilot == null) {
                this.loadNewPilot(loader, contentType, view);
            }
        }
    }

    private void loadNewPilot(ContentLoader loader, String contentType, Viewport view) {
        Pilot pilot;
        this.sendViewportMessage(view, "pilotLoading", null, "begin");
        if (this.disabledMimeTypes.containsKey(contentType)) {
            pilot = this.getPilotFactory().createPilot("application/disabled");
        } else if (loader != null) {
            pilot = this.getPilotFactory().createPilot(loader);
            contentType = loader.getContentType();
        } else {
            pilot = this.getPilotFactory().createPilot(contentType);
        }
        if (pilot == null) {
            this.sendViewportMessage(view, "pilotLoading", null, "error");
            return;
        }
        if (view.isStopRequested()) {
            return;
        }
        pilot.base = this;
        pilot.viewport = view;
        pilot.init(this.componentToolkitName);
        view.setPilot(pilot);
        view.setLocationUrl(null);
        pilot.clear(contentType);
        this.sendViewportMessage(view, "pilotLoading", null, "end");
    }

    void do_render_content(ContentLoader loader, Viewport view) {
        IOException loadException;
        if (!this.sendViewportMessage(view, "contentLoading", loader, "request")) {
            return;
        }
        this.sendViewportMessage(view, "contentLoading", loader, "connect");
        if (!loader.hasReply() && loader.getContentType() == null) {
            loader.make();
        }
        if ((loadException = loader.getException()) == null) {
            if (loader.getContentType().equals("application/external")) {
                return;
            }
            if (view.isStopRequested()) {
                return;
            }
            this.do_clear_content(loader, loader.getContentType(), view);
            view.setLocationUrl(loader.getLocation());
            if (view.isStopRequested()) {
                return;
            }
            Pilot pilot = view.getPilot();
            this.getHistoryManager().goingSomewhere(loader, view.getId());
            if (view.isStopRequested()) {
                return;
            }
            this.sendViewportMessage(view, "contentLoading", loader, "begin");
            if (!this.isRecursiveLoading(view, loader)) {
                try {
                    pilot.parse(loader);
                }
                catch (IOException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                    loadException = ex;
                    loader.setException(loadException);
                }
            }
            if (view.isStopRequested()) {
                return;
            }
            if (loadException == null) {
                this.sendViewportMessage(view, "contentLoading", loader, "end");
                pilot.parsingDone();
            }
        }
        if (loadException != null && !view.isStopRequested()) {
            if (Debug.trace) {
                Debug.trace("Failed to load: " + loader);
            }
            this.sendViewportMessage(view, "contentLoading", loader, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isRecursiveLoading(Viewport v, ContentLoader c) {
        int instanceCounter = 0;
        String loc1 = c.getLocation();
        if (loc1 == null) {
            return false;
        }
        v = v.getParent();
        while (v != null) {
            String loc2 = v.getLocation();
            if (loc2 != null && loc1.equals(loc2) && ++instanceCounter > 1) {
                long[] lArray = this.recursiveTimestamp;
                synchronized (this.recursiveTimestamp) {
                    if (this.recursiveTimestamp[0] == 0L) {
                        this.recursiveTimestamp[0] = System.currentTimeMillis();
                        boolean bl = false;
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return bl;
                    }
                    if (System.currentTimeMillis() - this.recursiveTimestamp[0] > 2000L) {
                        this.recursiveTimestamp[0] = System.currentTimeMillis();
                        boolean bl = false;
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return bl;
                    }
                    this.recursiveTimestamp[0] = System.currentTimeMillis();
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return true;
                }
            }
            v = v.getParent();
        }
        return false;
    }

    public void reload(String viewportId) {
        this.getHistoryManager().reload(viewportId);
    }

    public void goBack(String viewportId) {
        this.getHistoryManager().goBack(viewportId);
    }

    public boolean canGoBack(String viewportId) {
        return this.getHistoryManager().canGoBack(viewportId);
    }

    public void goForward(String viewportId) {
        this.getHistoryManager().goForward(viewportId);
    }

    public boolean canGoForward(String viewportId) {
        return this.getHistoryManager().canGoForward(viewportId);
    }

    public boolean configureViewport(Viewport view, String oldViewId) {
        return this.configureViewport(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configureViewport(Viewport view) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
        }
        if (this.viewportCallback != null) {
            Object object2 = this.viewportTreeLock;
            synchronized (object2) {
                this.viewports.addElement(view);
            }
            Container c = (Container)SecurityKit.doPrivileged(CallbackAdapter.box_createTopLevelContainer(this.viewportCallback, view));
            if (c == null && !"none".equalsIgnoreCase(this.componentToolkitName)) {
                if (Debug.trace) {
                    Debug.trace("Failed to create AWT container for " + view);
                }
                Object object3 = this.viewportTreeLock;
                synchronized (object3) {
                    this.viewports.removeElement(view);
                }
                return false;
            }
            if (Debug.trace) {
                Viewport sameContainerView = null;
                Object object4 = this.viewportTreeLock;
                synchronized (object4) {
                    Vector vect = this.viewports;
                    int i = vect.size();
                    while (i-- != 0) {
                        Viewport v = (Viewport)vect.elementAt(i);
                        if (view == v || v.getContainer() != c) continue;
                        sameContainerView = v;
                        break;
                    }
                }
                if (sameContainerView != null) {
                    Debug.trace("ERROR: got same AWT container for " + sameContainerView + " and " + view);
                }
            }
            view.setContainer(c);
            if (c != null) {
                c.setLayout(new ViewportLayoutManager(view));
            }
        } else if (this.container != null) {
            if (this.viewports.size() > 0) {
                return false;
            }
            view.setContainer(this.container);
            if (this.container != null) {
                this.container.setLayout(new ViewportLayoutManager(view));
            }
            Object object5 = this.viewportTreeLock;
            synchronized (object5) {
                this.viewports.addElement(view);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Viewport findViewportByName(String viewportName) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Viewport v = null;
            int i = 0;
            while (i < this.viewports.size() && v == null) {
                v = (Viewport)this.viewports.elementAt(i);
                v = v.findViewportByName(viewportName);
                ++i;
            }
            Viewport viewport = v;
            return viewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getAllPilotInstances(Class pilotClass, Vector result) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int i = 0;
            while (i != this.viewports.size()) {
                Viewport v = (Viewport)this.viewports.elementAt(i);
                this.getAllPilotInstances_r(v, pilotClass, result);
                ++i;
            }
        }
    }

    private void getAllPilotInstances_r(Viewport v, Class pilotClass, Vector result) {
        Pilot p = v.getPilot();
        if (pilotClass.isInstance(p)) {
            result.addElement(p);
        }
        Viewport vv = v.getFirstChild();
        while (vv != null) {
            this.getAllPilotInstances_r(vv, pilotClass, result);
            vv = vv.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTopLevelViewport(Viewport view) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int i = 0;
            int N = this.viewports.size();
            while (i != N) {
                if (view == this.viewports.elementAt(i)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        return false;
    }

    boolean isKnownViewport(Viewport view) {
        view = view.getTopParent();
        return this.isTopLevelViewport(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Viewport findViewportByHistoryId(String historyId) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Viewport v = null;
            int i = 0;
            while (i < this.viewports.size() && v == null) {
                v = (Viewport)this.viewports.elementAt(i);
                v = v.findViewportByHistoryId(historyId);
                ++i;
            }
            Viewport viewport = v;
            return viewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllViewports(Vector buffer) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int i = 0;
            int N = this.viewports.size();
            while (i != N) {
                Viewport v = (Viewport)this.viewports.elementAt(i);
                v.getViewAndAllChildren(buffer);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeViewport(String viewportName) {
        Viewport view = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
            int i = 0;
            while (i < this.viewports.size()) {
                Viewport v = (Viewport)this.viewports.elementAt(i);
                if (v.getId().equals(viewportName) || v.getName().equals(viewportName)) {
                    view = v;
                    break;
                }
                ++i;
            }
            if (view == null) {
                if (Debug.trace) {
                    Debug.trace("No top view: " + viewportName);
                }
                return;
            }
            this.viewports.removeElementAt(i);
        }
        if (Debug.trace) {
            Debug.trace("view=" + view);
        }
        view.stopLoading();
        view.dispose();
        if (this.viewportCallback != null) {
            this.viewportCallback.disposeTopLevelContainer(view);
        }
    }

    public String getViewportState(String viewportName) {
        Viewport view = this.findViewportByName(viewportName);
        if (view == null) {
            return null;
        }
        return view.stateString;
    }

    public void stopLoading(String viewportName) {
        Viewport v = this.findViewportByName(viewportName);
        if (v != null) {
            this.stopViewportLoading(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopViewportLoading(Viewport view) {
        this.sendViewportMessage(view, "contentLoading", null, "stop");
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.process_stop_loading(view);
        }
    }

    void process_stop_loading(Viewport v) {
        v.stopLoading();
        Viewport vv = v.getFirstChild();
        while (vv != null) {
            this.process_stop_loading(vv);
            vv = vv.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Enumeration<Object> e = this.scripters.elements();
        while (e.hasMoreElements()) {
            Scripter s = (Scripter)e.nextElement();
            s.dispose();
        }
        this.scripters.clear();
        this.missingScripters.clear();
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
            e = this.viewports.elements();
            while (e.hasMoreElements()) {
                Viewport v = (Viewport)e.nextElement();
                v.dispose();
            }
            this.viewports.removeAllElements();
            this.initialViewportName = null;
        }
        if (this.timedAWTExecutor != null) {
            this.timedAWTExecutor.shutdown();
        }
        this.session.disposeResources();
    }

    public static void unload() {
    }

    public void suspend() {
        Enumeration<Object> e = this.scripters.elements();
        while (e.hasMoreElements()) {
            Scripter s = (Scripter)e.nextElement();
            s.suspend();
        }
        e = this.viewports.elements();
        while (e.hasMoreElements()) {
            Viewport v = (Viewport)e.nextElement();
            Pilot p = v.getPilot();
            if (p == null) continue;
            p.suspend();
        }
    }

    public void resume() {
        Enumeration<Object> e = this.scripters.elements();
        while (e.hasMoreElements()) {
            Scripter s = (Scripter)e.nextElement();
            s.resume();
        }
        e = this.viewports.elements();
        while (e.hasMoreElements()) {
            Viewport v = (Viewport)e.nextElement();
            Pilot p = v.getPilot();
            if (p == null) continue;
            p.resume();
        }
    }

    public Scripter getScripterForCodeLocation(String location) {
        int colon_pos = location.indexOf(58);
        if (colon_pos > 0) {
            String protocol = location.substring(0, colon_pos);
            return this.getScripter(protocol);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scripter getScripter(String scriptName) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ScripterInfo si = this.getPilotFactory().getScripterInfo(scriptName);
            if (si == null) {
                Scripter scripter = null;
                return scripter;
            }
            Scripter s = (Scripter)this.scripters.get(si);
            if (s != null) {
                Scripter scripter = s;
                return scripter;
            }
            if (this.missingScripters.get(si) != null) {
                Scripter scripter = null;
                return scripter;
            }
            s = this.getPilotFactory().createScripter(scriptName);
            if (s == null) {
                this.missingScripters.put(si, _noScripter);
                Scripter scripter = null;
                return scripter;
            }
            this.scripters.put(si, s);
            s.init(this);
            Scripter scripter = s;
            return scripter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAllScripters() {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Enumeration e = this.getPilotFactory().getAllScripterInfos();
            while (e.hasMoreElements()) {
                ScripterInfo si = (ScripterInfo)e.nextElement();
                si.setEnabled(false);
            }
            e = this.scripters.elements();
            while (e.hasMoreElements()) {
                Scripter s = (Scripter)e.nextElement();
                s.dispose();
            }
            this.scripters.clear();
            Vector vect = this.viewports;
            int i = vect.size();
            while (i-- != 0) {
                Viewport v = (Viewport)vect.elementAt(i);
                this.clear_viewport_dynwrapper_r(v);
            }
        }
    }

    private void clear_viewport_dynwrapper_r(Viewport v) {
        v.clearWindowObj();
        v = v.getFirstChild();
        while (v != null) {
            this.clear_viewport_dynwrapper_r(v);
            v = v.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedAWTExecutor getTimedAWTExecutor() {
        TimedAWTExecutor x = this.timedAWTExecutor;
        if (x == null) {
            StormBase stormBase = this;
            synchronized (stormBase) {
                x = this.timedAWTExecutor;
                if (x == null) {
                    this.timedAWTExecutor = x = new TimedAWTExecutor();
                }
            }
        }
        return x;
    }

    public void runOnEventThreadAndWait(Runnable code, long delay) {
        try {
            this.getTimedAWTExecutor().invokeAndWait(code, delay);
        }
        catch (InterruptedException exception) {
            Debug.ex(exception);
        }
        catch (InvocationTargetException exception) {
            Debug.ex(exception);
        }
    }

    public void runOnEventThreadLater(Runnable code, long delay) {
        this.getTimedAWTExecutor().invokeLater(code, delay);
    }

    public boolean isEventThread() {
        return this.getTimedAWTExecutor().isEventThread();
    }

    public ContentLoaderFactory getContentLoaderFactory() {
        return this.contentLoaderFactory;
    }

    public void setContentLoaderFactory(ContentLoaderFactory contentLoaderFactory) {
        this.contentLoaderFactory = contentLoaderFactory;
    }

    final class ViewportUnloader
    implements ViewportVisitor {
        public final void visit(Viewport v) {
            Pilot pilot = v.getPilot();
            if (pilot != null) {
                pilot.beforeUnload();
            }
        }

        ViewportUnloader() {
        }
    }
}

