/*
 * Decompiled with CFR 0.152.
 */
package ice.util.encoding;

import ice.util.encoding.CharIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderLatin1
extends Reader {
    private InputStream is;
    private byte[] buffer;
    private int cursor;
    private int bufferEnd;
    private boolean win1252Mode;

    public ReaderLatin1(InputStream is) {
        this(is, 4096);
    }

    public ReaderLatin1(InputStream is, int decodingBufferSize) {
        this.is = is;
        this.buffer = new byte[decodingBufferSize];
    }

    public final void setWin1252Mode() {
        this.win1252Mode = true;
    }

    public boolean ready() throws IOException {
        return this.cursor != this.bufferEnd || this.is.available() > 0;
    }

    public int read() throws IOException {
        if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
            return -1;
        }
        int c = 0xFF & this.buffer[this.cursor++];
        if (this.win1252Mode && 128 <= c && c <= 159) {
            c = CharIO.mapWin1252_128_159_toUnicode(c);
        }
        return c;
    }

    public int read(char[] array, int offset, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
            return -1;
        }
        byte[] b = this.buffer;
        int in_buffer = this.bufferEnd - this.cursor;
        if (length > in_buffer) {
            length = in_buffer;
        }
        int n = length;
        int i = this.cursor;
        do {
            int c = 0xFF & b[i++];
            if (this.win1252Mode && 128 <= c && c <= 159) {
                c = CharIO.mapWin1252_128_159_toUnicode(c);
            }
            array[offset++] = (char)c;
        } while (--n != 0);
        this.cursor = i;
        return length;
    }

    public long skip(long length) throws IOException {
        if (length <= 0L) {
            return 0L;
        }
        if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
            return -1;
        }
        int in_buffer = this.bufferEnd - this.cursor;
        if (length > (long)in_buffer) {
            length = in_buffer;
            this.cursor = this.bufferEnd;
        } else {
            this.cursor += (int)length;
        }
        return length;
    }

    public void close() throws IOException {
        this.is.close();
    }

    private boolean fillBuffer() throws IOException {
        int n = this.is.read(this.buffer, 0, this.buffer.length);
        if (n < 0) {
            return false;
        }
        this.cursor = 0;
        this.bufferEnd = n;
        return true;
    }
}

