/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import java.io.Serializable;
import java.util.Vector;

public class HeaderMap
implements Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private Header[] headerData;
    private int size;

    private void $init$() {
        this.size = 0;
    }

    public HeaderMap() {
        this(10);
    }

    public HeaderMap(int initialCapacity) throws IllegalArgumentException {
        this.$init$();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal capacity: " + initialCapacity);
        }
        this.headerData = new Header[initialCapacity];
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            this.headerData[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public Object clone() {
        try {
            HeaderMap _headerMap = (HeaderMap)super.clone();
            _headerMap.headerData = new Header[this.size];
            System.arraycopy(this.headerData, 0, _headerMap.headerData, 0, this.size);
            HeaderMap headerMap = _headerMap;
            return headerMap;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError();
        }
    }

    public boolean containsFieldName(String fieldName) {
        return this.getFieldValues(fieldName).length > 0;
    }

    public void ensureCapacity(int minimumCapacity) {
        int _oldCapacity = this.headerData.length;
        if (minimumCapacity > _oldCapacity) {
            Header[] _oldHeaderData = this.headerData;
            int _newCapacity = _oldCapacity * 3 / 2 + 1;
            if (_newCapacity < minimumCapacity) {
                _newCapacity = minimumCapacity;
            }
            this.headerData = new Header[_newCapacity];
            System.arraycopy(_oldHeaderData, 0, this.headerData, 0, this.size);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HeaderMap && this.size == ((HeaderMap)object).size) {
            int i = 0;
            while (i < this.size) {
                if (!Header.ra$fieldName(this.headerData[i]).equalsIgnoreCase(Header.ra$fieldName(((HeaderMap)object).headerData[i])) || !Header.ra$fieldValue(this.headerData[i]).equals(Header.ra$fieldValue(((HeaderMap)object).headerData[i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Header get(int index) {
        if (index >= 0 && index < this.size) {
            return this.headerData[index];
        }
        return null;
    }

    public String getFieldName(int index) {
        if (index >= 0 && index < this.size) {
            return Header.ra$fieldName(this.headerData[index]);
        }
        return null;
    }

    public String getFieldValue(int index) {
        if (index >= 0 && index < this.size) {
            return Header.ra$fieldValue(this.headerData[index]);
        }
        return null;
    }

    public String[] getFieldValues(String fieldName) {
        Vector<String> _fieldValueList = new Vector<String>();
        int _index = 0;
        while ((_index = this.getIndex(fieldName, _index)) != -1) {
            _fieldValueList.addElement(Header.ra$fieldValue(this.headerData[_index]));
            ++_index;
        }
        String[] _fieldValues = new String[_fieldValueList.size()];
        int i = 0;
        while (i < _fieldValues.length) {
            _fieldValues[i] = (String)_fieldValueList.elementAt(i);
            ++i;
        }
        return _fieldValues;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void putHeader(String fieldName, String fieldValue) {
        if (fieldName != null && fieldName.trim().length() != 0 && fieldValue != null) {
            if (this.containsFieldName(fieldName)) {
                String[] _fieldValues = this.getFieldValues(fieldName);
                int i = 0;
                while (i < _fieldValues.length) {
                    if (fieldValue.equals(_fieldValues[i])) {
                        return;
                    }
                    ++i;
                }
            }
            this.ensureCapacity(this.size + 1);
            this.headerData[this.size++] = new Header(fieldName, fieldValue);
        }
    }

    public void putHeader(String fieldName, String fieldValue, boolean replace) {
        if (replace && this.containsFieldName(fieldName)) {
            this.removeHeaders(fieldName);
        }
        this.putHeader(fieldName, fieldValue);
    }

    public void removeHeader(int index) {
        if (index >= 0 && index < this.size) {
            int _toBeMoved = this.size - index - 1;
            if (_toBeMoved > 0) {
                System.arraycopy(this.headerData, index + 1, this.headerData, index, _toBeMoved);
            }
            this.headerData[--this.size] = null;
        }
    }

    public void removeHeaders(String fieldName) {
        int _index = 0;
        while ((_index = this.getIndex(fieldName, _index)) != -1) {
            this.removeHeader(_index);
        }
    }

    public String toString() {
        StringBuffer _stringBuffer = new StringBuffer();
        _stringBuffer.append("HeaderMap [");
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                _stringBuffer.append(",");
            }
            _stringBuffer.append("\r\n    " + this.headerData[i]);
            ++i;
        }
        _stringBuffer.append("]");
        return _stringBuffer.toString();
    }

    private int getIndex(String fieldName, int fromIndex) {
        if (fromIndex >= 0 && fromIndex < this.size) {
            int i = fromIndex;
            while (i < this.size) {
                if (Header.ra$fieldName(this.headerData[i]).equalsIgnoreCase(fieldName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static class Header
    implements Serializable {
        private String fieldName;
        private String fieldValue;

        public Header(String fieldName, String fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public boolean equals(Object object) {
            return object instanceof Header && this.fieldName.equals(((Header)object).fieldName) && this.fieldValue.equals(((Header)object).fieldValue) && super.equals(object);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public String toString() {
            return this.fieldName + ": " + this.fieldValue;
        }

        static String ra$fieldName(Header header) {
            return header.fieldName;
        }

        static String ra$fieldValue(Header header) {
            return header.fieldValue;
        }
    }
}

