/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.alg.CharKit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class URLResolver {
    protected static final int SLASH_URL_RESOLVE = 0;
    protected static final int REPLACE_URL_RESOLVE = 1;
    protected static final int JAVA_URL_RESOLVE = 2;

    public static String resolve(String base, String fragment) {
        String url;
        if (fragment == null) {
            Debug.bug();
        }
        String _fragment = fragment.trim();
        if (base == null || URLResolver.getProtocolEnd(_fragment) >= 0) {
            url = _fragment;
        } else if (_fragment.length() == 0 || _fragment.charAt(0) == '#') {
            int _index = base.indexOf(35);
            url = _index < 0 ? base + _fragment : base.substring(0, _index) + _fragment;
        } else {
            int _baseProtocolEnd = URLResolver.getProtocolEnd(base);
            if (_baseProtocolEnd < 0) {
                return _fragment;
            }
            switch (URLResolver.getResolveType(base, _baseProtocolEnd)) {
                case 0: {
                    url = URLResolver.doSlashResolve(base, _baseProtocolEnd, _fragment);
                    break;
                }
                case 1: {
                    int _length = _fragment.length();
                    char[] _characters = new char[_baseProtocolEnd + _length];
                    base.getChars(0, _baseProtocolEnd, _characters, 0);
                    _fragment.getChars(0, _length, _characters, _baseProtocolEnd);
                    url = new String(_characters);
                    break;
                }
                case 2: {
                    url = URLResolver.doJavaResolve(base, _fragment);
                    break;
                }
                default: {
                    Debug.bug();
                    url = null;
                }
            }
        }
        return URLResolver.compactUrl(url);
    }

    private static String compactUrl(String url) {
        String protocol;
        URL _url;
        String _originalUrl = url;
        try {
            _url = new URL(_originalUrl);
        }
        catch (MalformedURLException exception) {
            String string = _originalUrl;
            return string;
        }
        String _fileString = _url.getFile();
        if (_url.getProtocol().equals("file")) {
            _originalUrl = URLResolver.convertURLBackslashes(_originalUrl);
            File _file = new File(_fileString = URLResolver.convertURLBackslashes(_fileString));
            if (_file.isAbsolute()) {
                if (!JavaVersion.isV12orGreater()) {
                    _fileString = _originalUrl.substring(5);
                }
                try {
                    String _canonicalPath = new File(_fileString).getCanonicalPath();
                    _canonicalPath = URLResolver.convertURLBackslashes(_canonicalPath);
                    if (!_canonicalPath.startsWith("/")) {
                        _canonicalPath = "/" + _canonicalPath;
                    }
                    if (_originalUrl.endsWith("/") && !_canonicalPath.endsWith("/")) {
                        _canonicalPath = _canonicalPath + "/";
                    }
                    int _index = _originalUrl.indexOf(_fileString);
                    String string = _originalUrl.substring(0, _index) + _canonicalPath + _originalUrl.substring(_index + _fileString.length());
                    return string;
                }
                catch (IOException exception) {
                    // empty catch block
                }
            }
            return _originalUrl;
        }
        if (Defs.booleanProperty("ice.util.net.convertURLBackslashes") && ((protocol = _url.getProtocol()).equals("http") || protocol.equals("https"))) {
            _originalUrl = URLResolver.convertURLBackslashes(_originalUrl);
        }
        if (_fileString.indexOf("/./") == -1 && _fileString.indexOf("/../") == -1) {
            return _originalUrl;
        }
        StringTokenizer _stringTokenizer = new StringTokenizer(_fileString, "/", true);
        Vector<String> _vector = new Vector<String>();
        int _numberOfTokens = _stringTokenizer.countTokens();
        int i = 0;
        while (i < _numberOfTokens) {
            String _token = _stringTokenizer.nextToken();
            if (_token.equals(".")) {
                _vector.removeElementAt(_vector.size() - 1);
            } else if (_token.equals("..")) {
                if (_vector.size() < 3) {
                    _vector.removeElementAt(_vector.size() - 1);
                } else {
                    _vector.removeElementAt(_vector.size() - 1);
                    _vector.removeElementAt(_vector.size() - 1);
                    _vector.removeElementAt(_vector.size() - 1);
                }
            } else {
                _vector.addElement(_token);
            }
            ++i;
        }
        StringBuffer _stringBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < _vector.size()) {
            _stringBuffer.append((String)_vector.elementAt(i2));
            ++i2;
        }
        int _index = _originalUrl.indexOf(_fileString);
        return _originalUrl.substring(0, _index) + _stringBuffer.toString() + _originalUrl.substring(_index + _fileString.length());
    }

    private static String convertURLBackslashes(String url) {
        if (url.indexOf(92) != -1) {
            url = url.replace('\\', '/');
        }
        return url;
    }

    protected static int getResolveType(String base, int protocolLength) {
        switch (protocolLength) {
            case 3: {
                if (!"ftp".regionMatches(true, 0, base, 0, 3)) break;
                return 0;
            }
            case 4: {
                char c = base.charAt(0);
                if (!(c == 'h' || c == 'H' ? "http".regionMatches(true, 0, base, 0, 4) : (c == 'f' || c == 'F') && "file".regionMatches(true, 0, base, 0, 4))) break;
                return 0;
            }
            case 5: {
                char c = base.charAt(0);
                if (!(c == 'h' || c == 'H' ? "https".regionMatches(true, 0, base, 0, 5) : (c == 'a' || c == 'A') && "about".regionMatches(true, 0, base, 0, 5))) break;
                return 0;
            }
            case 10: {
                char c = base.charAt(0);
                if (!(c == 'j' || c == 'J' ? "javascript".regionMatches(true, 0, base, 0, 10) : (c == 'e' || c == 'E') && "ecmascript".regionMatches(true, 0, base, 0, 10))) break;
                return 1;
            }
        }
        return 2;
    }

    private static String doSlashResolve(String base, int baseProtocolEnd, String fragment) {
        int fragmentPos;
        int addSlashes;
        int fragmentLength;
        block21: {
            int stopPos;
            int i;
            int cursor;
            int fragmentSlashes;
            block26: {
                int baseEnd;
                block22: {
                    int nextSlash;
                    int baseStart;
                    block25: {
                        block24: {
                            block23: {
                                if (base.charAt(baseProtocolEnd) != ':') {
                                    Debug.bug();
                                }
                                fragmentLength = fragment.length();
                                baseStart = baseProtocolEnd + 1;
                                baseEnd = base.length();
                                int hashPos = base.indexOf(35, baseStart);
                                if (baseStart <= hashPos) {
                                    baseEnd = hashPos;
                                }
                                int questionPos = base.indexOf(63, baseStart);
                                int fragmentQuestionPos = fragment.indexOf(63);
                                if (fragmentQuestionPos == 0) {
                                    if (questionPos == -1) {
                                        return base + fragment;
                                    }
                                    if (questionPos != -1) {
                                        return base.substring(0, questionPos) + fragment;
                                    }
                                }
                                if (baseStart <= questionPos && questionPos < baseEnd) {
                                    baseEnd = questionPos;
                                }
                                fragmentSlashes = 0;
                                while (fragmentSlashes != fragmentLength && '/' == fragment.charAt(fragmentSlashes)) {
                                    ++fragmentSlashes;
                                }
                                addSlashes = 0;
                                if (fragmentSlashes != 0) break block23;
                                int lastSlash = base.lastIndexOf(47, baseEnd - 1);
                                if (lastSlash < baseStart) {
                                    fragmentPos = baseStart;
                                } else if (base.charAt(lastSlash - 1) != '/') {
                                    fragmentPos = lastSlash + 1;
                                } else {
                                    fragmentPos = baseEnd;
                                    if (lastSlash != baseEnd - 1) {
                                        addSlashes = 1;
                                    }
                                }
                                break block21;
                            }
                            if (fragmentSlashes != 1) break block24;
                            if (!base.regionMatches(baseStart, "//", 0, 2)) {
                                fragmentPos = baseStart;
                            } else {
                                int slashCount = 2;
                                int offset = baseStart + 2;
                                while (true) {
                                    int nextSlash2;
                                    if (offset != baseEnd && '/' == base.charAt(offset)) {
                                        ++offset;
                                        ++slashCount;
                                        continue;
                                    }
                                    if (slashCount == 1 || (nextSlash2 = base.indexOf(47, offset)) < 0 || nextSlash2 >= baseEnd) break;
                                    slashCount = 1;
                                    offset = nextSlash2 + 1;
                                }
                                fragmentPos = slashCount == 1 ? offset - 1 : (offset == baseEnd ? baseEnd - 1 : baseEnd);
                            }
                            break block21;
                        }
                        if (base.regionMatches(baseProtocolEnd + 1, fragment, 0, fragmentSlashes)) break block25;
                        fragmentPos = baseStart;
                        break block21;
                    }
                    cursor = baseStart;
                    i = cursor + fragmentSlashes;
                    while (i != baseEnd && '/' == base.charAt(i)) {
                        ++i;
                    }
                    while (true) {
                        if (i == baseEnd) {
                            fragmentPos = i - cursor == fragmentSlashes ? cursor : i;
                            break block21;
                        }
                        nextSlash = base.indexOf(47, i + 1);
                        if (0 > nextSlash || nextSlash >= baseEnd) break block22;
                        int j = nextSlash + 1;
                        while (j != baseEnd && '/' == base.charAt(j)) {
                            ++j;
                        }
                        if (j - nextSlash < fragmentSlashes) break;
                        cursor = nextSlash;
                        i = j;
                    }
                    stopPos = nextSlash;
                    break block26;
                }
                stopPos = baseEnd;
            }
            fragmentPos = i - cursor == fragmentSlashes ? cursor : stopPos;
        }
        char[] buf = new char[fragmentPos + addSlashes + fragmentLength];
        base.getChars(0, fragmentPos, buf, 0);
        int i = 0;
        while (i != addSlashes) {
            buf[fragmentPos + i] = 47;
            ++i;
        }
        fragment.getChars(0, fragmentLength, buf, fragmentPos + addSlashes);
        return new String(buf);
    }

    private static String doJavaResolve(String base, String fragment) {
        String url;
        URL baseURL = URLResolver.newURL(base);
        if (baseURL == null) {
            url = fragment;
        } else {
            URL urlObj;
            URL tmp;
            int questionPos;
            if (0 <= baseURL.getFile().indexOf(63) && 0 <= (questionPos = base.indexOf(63)) && (tmp = URLResolver.newURL(base.substring(0, questionPos))) != null) {
                baseURL = tmp;
            }
            url = (urlObj = URLResolver.newURL(baseURL, fragment)) != null ? urlObj.toExternalForm() : fragment;
        }
        return url;
    }

    private static int getProtocolEnd(String urlFragment) {
        int L = urlFragment.length();
        int i = 0;
        while (i != L) {
            boolean isProtocolChar;
            char c = urlFragment.charAt(i);
            if (c == ':') {
                if (i == 0) break;
                return i;
            }
            boolean bl = isProtocolChar = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '-';
            if (!isProtocolChar) break;
            ++i;
        }
        return -1;
    }

    private static int getPathStart(String url, int protocolEnd) {
        int nextSlash;
        if (url.charAt(protocolEnd) != ':') {
            Debug.bug();
        }
        int start = protocolEnd + 1;
        int end = url.indexOf(35);
        if (end < 0) {
            end = url.length();
        }
        if (start + 4 <= end && url.charAt(start) == '/' && url.charAt(start + 1) == '/' && url.charAt(start + 2) != '/' && 0 <= (nextSlash = url.indexOf(47, start + 3)) && nextSlash < end) {
            start = nextSlash;
        }
        return start;
    }

    public static String getProtocol(String url) {
        int protocolEnd;
        if (url == null) {
            Debug.bug();
        }
        if ((protocolEnd = URLResolver.getProtocolEnd(url)) >= 0) {
            return url.substring(0, protocolEnd);
        }
        return null;
    }

    public static String getHost(String url) {
        String host;
        URL urlObj;
        if (url == null) {
            Debug.bug();
        }
        if ((urlObj = URLResolver.newURL(url)) != null) {
            host = urlObj.getHost();
            if (host == null) {
                host = "";
            }
        } else {
            host = URLResolver.noURL_getHost(url);
        }
        return host;
    }

    public static int getPort(String url) {
        URL urlObj;
        if (url == null) {
            Debug.bug();
        }
        if ((urlObj = URLResolver.newURL(url)) != null) {
            return urlObj.getPort();
        }
        return URLResolver.noURL_getPort(url);
    }

    public static String getPath(String url) {
        String path;
        URL urlObj;
        if (url == null) {
            Debug.bug();
        }
        if ((urlObj = URLResolver.newURL(url)) != null) {
            path = urlObj.getFile();
            if (path == null) {
                path = "";
            }
        } else {
            path = URLResolver.noURL_getPath(url);
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private static String noURL_getHost(String url) {
        block3: {
            block2: {
                protocolEnd = URLResolver.getProtocolEnd(url);
                if (protocolEnd < 0) break block2;
                hostStart = protocolEnd + 1;
                pathStart = URLResolver.getPathStart(url, protocolEnd);
                if (hostStart != pathStart) ** GOTO lbl9
                host = "";
                break block3;
lbl-1000:
                // 1 sources

                {
                    ++hostStart;
lbl9:
                    // 2 sources

                    ** while (url.charAt((int)hostStart) == '/')
                }
lbl10:
                // 1 sources

                hostEnd = pathStart;
                colon = url.lastIndexOf(58, hostEnd - 1);
                if (colon >= hostStart && (port = URLResolver.parsePort(url, colon + 1, hostEnd)) != -1) {
                    hostEnd = colon;
                }
                host = url.substring(hostStart, hostEnd);
                break block3;
            }
            host = null;
        }
        return host;
    }

    private static int noURL_getPort(String url) {
        int pathStart;
        int hostStart;
        int protocolEnd = URLResolver.getProtocolEnd(url);
        if (protocolEnd >= 0 && (hostStart = protocolEnd + 1) != (pathStart = URLResolver.getPathStart(url, protocolEnd))) {
            while (url.charAt(hostStart) == '/') {
                ++hostStart;
            }
            int hostEnd = pathStart;
            int colon = url.lastIndexOf(58, hostEnd - 1);
            if (colon >= hostStart) {
                return URLResolver.parsePort(url, colon + 1, hostEnd);
            }
        }
        return -1;
    }

    private static int parsePort(String url, int portStart, int portEnd) {
        int port;
        long value = CharKit.parseInt(url, portStart, portEnd);
        if (value >= 0L && (port = (int)value) == (char)port) {
            return port;
        }
        return -1;
    }

    private static String noURL_getPath(String url) {
        int protocolEnd = URLResolver.getProtocolEnd(url);
        if (protocolEnd >= 0) {
            int start = URLResolver.getPathStart(url, protocolEnd);
            int end = url.indexOf(35, start);
            if (end < 0) {
                end = url.length();
            }
            return url.substring(start, end);
        }
        return null;
    }

    public static URL newURL(String url) {
        try {
            URL uRL = new URL(url);
            return uRL;
        }
        catch (MalformedURLException exception) {
            Debug.trace("Cannot construct url from " + url);
            URL uRL = null;
            return uRL;
        }
    }

    public static URL newURL(URL base, String urlFragment) {
        try {
            URL uRL = new URL(base, urlFragment);
            return uRL;
        }
        catch (MalformedURLException exception) {
            Debug.trace("Cannot construct url from " + base + " and " + urlFragment);
            URL uRL = null;
            return uRL;
        }
    }
}

