/*
 * Decompiled with CFR 0.152.
 */
package ice.xslt;

import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.Transformer;
import ice.util.ICEException;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Node;

public class XalanTransformer
implements Transformer {
    protected XalanTransformer() {
    }

    public boolean transform(Node src, Node template, Node result) throws IOException {
        this.doTransform(src, template, result);
        return true;
    }

    public boolean transform(Node src, Node template, Writer writer) throws IOException {
        DNode dsrc = (DNode)src;
        DDocument parent = dsrc.getOwnerDDocument();
        DDocument doc = parent.getDom().createDDocument(parent.getPilot(), false);
        this.doTransform(src, template, doc);
        this.doSerialize(doc, writer);
        return true;
    }

    private void doTransform(Node src, Node template, Node destination) throws IOException {
        1 boxed = new 1(this, src, template, destination);
        try {
            SecurityKit.doPrivileged(boxed);
        }
        catch (ProxyException ex) {
            throw new ICEException(1, 4, 17);
        }
    }

    void doTransformImpl(Node src, Node template, Node destination) throws TransformerException {
        TransformerFactory f = TransformerFactory.newInstance();
        javax.xml.transform.Transformer transformer = f.newTransformer(new DOMSource(template));
        DOMSource domSource = new DOMSource(src);
        DOMResult domDestination = new DOMResult(destination);
        transformer.transform(domSource, domDestination);
    }

    private void doSerialize(Node node, Writer writer) throws IOException {
        2 boxed = new 2(this, node, writer);
        try {
            SecurityKit.doPrivileged(boxed);
        }
        catch (ProxyException ex) {
            throw (IOException)ex.getTarget();
        }
    }

    void doSerializeImpl(Node node, Writer writer) throws IOException {
        Serializer serializer = null;
        Properties props = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        serializer = SerializerFactory.getSerializer((Properties)props);
        serializer.setWriter(writer);
        serializer.asDOMSerializer().serialize(node);
        serializer.reset();
    }

    final class 1
    implements BoxedCode {
        private final /* synthetic */ Node v$src;
        private final /* synthetic */ Node v$template;
        private final /* synthetic */ Node v$destination;
        final /* synthetic */ XalanTransformer this$0;

        public Object run() {
            try {
                this.this$0.doTransformImpl(this.v$src, this.v$template, this.v$destination);
                Object var2_1 = null;
                return var2_1;
            }
            catch (TransformerException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                throw new ProxyException(ex);
            }
        }

        public 1(XalanTransformer xalanTransformer, Node node, Node node2, Node node3) {
            this.v$destination = node3;
            this.v$template = node2;
            this.v$src = node;
            this.this$0 = xalanTransformer;
        }
    }

    final class 2
    implements BoxedCode {
        private final /* synthetic */ Node v$node;
        private final /* synthetic */ Writer v$writer;
        final /* synthetic */ XalanTransformer this$0;

        public Object run() {
            try {
                this.this$0.doSerializeImpl(this.v$node, this.v$writer);
                Object var2_1 = null;
                return var2_1;
            }
            catch (IOException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                throw new ProxyException(ex);
            }
        }

        public 2(XalanTransformer xalanTransformer, Node node, Writer writer) {
            this.v$writer = writer;
            this.v$node = node;
            this.this$0 = xalanTransformer;
        }
    }
}

