/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.RaptorMessageDialog;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class SQLErrorDialog
extends JPanel
implements ActionListener {
    private BorderLayout layMain = new BorderLayout();
    private JMultiLineLabel lblMsg = new JMultiLineLabel();
    private JButton btnBack = new JButton();
    private JButton btnForward = new JButton();
    private JPanel pnlBottom = new JPanel();
    private GridBagLayout layBottom = new GridBagLayout();
    private JPanel pnlButtons = new JPanel();
    private GridLayout layButtons = new GridLayout();
    private Component glue = Box.createGlue();
    private String _sql;
    private int _errOffset;
    private int _col = -1;
    private int _line = -1;
    protected List _errs;
    private int _idx;
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";

    protected SQLErrorDialog() {
    }

    public void setCol(int n) {
        this._col = n;
    }

    public void setLine(int n) {
        this._line = n;
    }

    public void setSql(String string) {
        this._sql = string;
    }

    public void setOffset(int n) {
        this._errOffset = n;
    }

    private void setError(SQLException sQLException) {
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        while (sQLException != null) {
            arrayList.add(sQLException);
            sQLException = sQLException.getNextException();
        }
        this.setErrors(arrayList);
    }

    public static void showErrorDialog(Component component, String string, SQLException sQLException, String string2, int n) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog();
        sQLErrorDialog.setSql(string2);
        sQLErrorDialog.setOffset(n);
        sQLErrorDialog.setError(sQLException);
        sQLErrorDialog.runErrorDialog(component, string, null);
    }

    public static void showErrorDialog(Component component, String string, SQLException sQLException, String string2, int n, int n2, int n3) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog();
        sQLErrorDialog.setSql(string2);
        sQLErrorDialog.setOffset(n);
        sQLErrorDialog.setLine(n2);
        sQLErrorDialog.setCol(n3);
        sQLErrorDialog.setError(sQLException);
        sQLErrorDialog.runErrorDialog(component, string, null);
    }

    public static void showErrorDialog(Component component, String string, SQLException sQLException) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog();
        sQLErrorDialog.setError(sQLException);
        string = DialogResources.getString(4);
        sQLErrorDialog.runErrorDialog(component, string, null);
    }

    public static boolean showErrorWithActionsDialog(Component component, String string, SQLException sQLException, String string2, String string3) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog();
        sQLErrorDialog.setError(sQLException);
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return sQLErrorDialog.runErrorWithActionDialog(component, string, null, string2, string3);
    }

    protected void runErrorDialog(Component component, String string, String string2) {
        MessageDialog.error((Component)component, (Object)this, (String)string, (String)string2);
    }

    protected boolean runConfirmDialog(Component component, String string, String string2) {
        return MessageDialog.confirm((Component)component, (Object)this, (String)string, (String)string2, (boolean)false, (String)"OK", (String)"Cancel");
    }

    protected boolean runErrorWithActionDialog(Component component, String string, String string2, String string3, String string4) {
        return RaptorMessageDialog.errorAction(component, this, string, null, string3, string4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BACK_CMD.equals(string)) {
            --this._idx;
            this._update();
        } else if (FWD_CMD.equals(string)) {
            ++this._idx;
            this._update();
        }
    }

    protected void setErrors(List list) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this._errs = list;
        this._idx = this._errs.size() > 0 ? 0 : -1;
        this.pnlBottom.setVisible(this._errs.size() > 1);
        this._update();
    }

    private void _update() {
        this.btnBack.setEnabled(this._idx > 0);
        this.btnForward.setEnabled(this._idx < this._errs.size() - 1);
        Exception exception = this._idx != -1 ? (Exception)this._errs.get(this._idx) : null;
        this.updateExceptionComponent(exception);
    }

    protected void updateExceptionComponent(Exception exception) {
        Object object;
        SQLException sQLException = (SQLException)exception;
        String string = sQLException.getLocalizedMessage();
        if (string != null && !string.endsWith("\n")) {
            string = string + '\n';
        }
        if (string != null && string.indexOf("ORA") > -1) {
            object = new Oerr();
            try {
                string = string + ((Oerr)object).oerr(string);
            }
            catch (OerrException oerrException) {
                // empty catch block
            }
        }
        object = null;
        if (this._sql != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DialogResources.format(2, string, Integer.toString(sQLException.getErrorCode())));
            stringBuilder.setLength(stringBuilder.indexOf("Vendor") - 1);
            stringBuilder.append("\n");
            if (this._errOffset > 0) {
                String[] stringArray = this._sql.substring(0, this._errOffset).split("\n");
                int n = stringArray[stringArray.length - 1].length();
                int n2 = stringArray.length;
                if (this._line >= 0 && this._col >= 0 && n2 == 1) {
                    n = n + this._col - 1;
                }
                if (this._line >= 0) {
                    n2 = n2 + this._line - 1;
                }
                stringBuilder.append("Error at Line:" + n2 + " Column:" + n);
            } else if (this._line >= 0) {
                stringBuilder.append("Error at Line:" + this._line);
            }
            object = stringBuilder.toString();
        } else {
            object = sQLException != null ? DialogResources.format(2, string, Integer.toString(sQLException.getErrorCode())) : DialogResources.getString(3);
        }
        this.lblMsg.setText((String)object);
        this.lblMsg.setMaximumRows(8);
    }

    protected Component getExceptionComponent() {
        this.lblMsg.setPreferredAspectRatio(5.0f);
        return this.lblMsg;
    }

    private void jbInit() {
        this.setLayout(this.layMain);
        ResourceUtils.resButton((AbstractButton)this.btnBack, (String)DialogResources.getString(0));
        this.btnBack.setActionCommand(BACK_CMD);
        this.btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnForward, (String)DialogResources.getString(1));
        this.btnForward.setActionCommand(FWD_CMD);
        this.btnForward.addActionListener(this);
        this.pnlBottom.setLayout(this.layBottom);
        this.pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(2);
        this.layButtons.setHgap(5);
        this.add(this.getExceptionComponent(), "Center");
        this.pnlButtons.add((Component)this.btnBack, null);
        this.pnlButtons.add((Component)this.btnForward, null);
        this.pnlBottom.add(this.glue, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlBottom, "South");
    }
}

