/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

public class CSVFormatter
extends ResultsFormatter {
    public static final String DEFAULT_DELIMITER = ",";
    private static String s_delim = ",";

    public static void setDelimiter(String string) {
        s_delim = string;
    }

    public CSVFormatter() {
        super("CSV", Translate.translate("Comma Seperated File"), "csv");
    }

    public void start() throws IOException {
        int n = this.getColumnCount();
        for (int i = 1; i < n; ++i) {
            String string = this.getColumnName(i);
            if (i > 0 && i < n - 1) {
                this.write("\"" + string + "\"" + s_delim);
                continue;
            }
            this.write("\"" + string + "\"");
        }
        this.write("\n");
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        string = object != null ? s_delim + "\"" + this.getValue(object).toString().replaceAll("\"", "\"\"") + "\"" : s_delim + "\"\"";
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.write("\"" + string.substring(2));
        } else {
            this.write(string);
        }
    }

    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    public void end() throws IOException {
    }

    public void setTableName(String string) {
    }
}

