/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.sql.DATE;

public abstract class ResultsFormatter
implements IResultFormatter {
    private ResultsFormatterWrapper m_wrapper;
    protected int _format;
    protected OutputStreamWriter _out;
    protected IProgressFeedback _feedback;
    protected String _type;
    protected String _filter;
    protected String _ext;
    protected Boolean _prompt = false;
    private int _max_rows_allowed = -1;
    protected String _nullValue = "";
    private boolean _interrupt = false;
    private OutputStream _outStream;
    private String _enc;
    private String _EOLChars;

    public ResultsFormatter(String string, String string2, String string3) {
        this._type = string;
        this._ext = string3;
        this._filter = string2;
    }

    public String getEncode() {
        return this._enc;
    }

    public void setEncode(String string) {
        this._enc = string;
    }

    public Boolean getPromptForTable() {
        return this._prompt;
    }

    public void setPromptForTable(Boolean bl) {
        this._prompt = bl;
    }

    public String getType() {
        return this._type;
    }

    public String getExt() {
        return this._ext;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setDataProvider(ResultsFormatterWrapper resultsFormatterWrapper) {
        this.m_wrapper = resultsFormatterWrapper;
        resultsFormatterWrapper.setParent(this);
    }

    protected ResultsFormatterWrapper getWrapper() {
        return this.m_wrapper;
    }

    protected String getColumnName(int n) {
        return this.m_wrapper.getColumnName(n);
    }

    protected int getColumnSize(int n) {
        return this.m_wrapper.getColumnSize(n);
    }

    protected int getColumnCount() {
        return this.m_wrapper.getColumnCount();
    }

    public void print(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
        this.print();
    }

    public void printWithDialog() {
        final ResultsFormatter resultsFormatter = this;
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            protected void doCancel() {
                super.doCancel();
                resultsFormatter.interrupt();
            }

            protected Object doWork() throws Exception {
                resultsFormatter.print();
                ResultsFormatter.this._out.close();
                return null;
            }
        };
        IProgressFeedback iProgressFeedback = new IProgressFeedback(){

            public void feedback(String string) {
                Log.status(string);
            }
        };
        resultsFormatter.setFeedback(iProgressFeedback);
        progressRunnable.setTitle(Translate.translate("Exporting..."));
        progressRunnable.setCancelable(true);
        try {
            progressRunnable.start(true);
        }
        catch (ProgressException progressException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
        }
    }

    public int print() {
        int n = 0;
        try {
            this.m_wrapper.print();
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
        }
        return n;
    }

    protected void write(String string) throws IOException {
        if (string != null) {
            this._out.write(string);
        }
    }

    public void log(String string) {
        if (this._feedback != null) {
            this._feedback.feedback(string);
        }
    }

    public OutputStreamWriter getOutWriter() {
        return this._out;
    }

    public void setOutWriter(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
    }

    public OutputStream getOutputStream() {
        return this._outStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._outStream = outputStream;
        if (this._enc != null) {
            try {
                this._out = new OutputStreamWriter(outputStream, this._enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._out = new OutputStreamWriter(outputStream);
            }
        }
    }

    public IProgressFeedback getFeedback() {
        return this._feedback;
    }

    public void setFeedback(IProgressFeedback iProgressFeedback) {
        this._feedback = iProgressFeedback;
    }

    public void interrupt() {
        this._interrupt = true;
    }

    protected Object getValue(Object object) {
        return this.m_wrapper.getValue(object);
    }

    public int getDataType(int n) {
        int n2 = -1;
        try {
            n2 = this.m_wrapper.getDataType(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n2;
    }

    public String getTimeStampFormat() {
        return NLSUtils.getTimeStampFormat(this.m_wrapper.getConnection());
    }

    public String getTimeStampTZFormat() {
        return NLSUtils.getTimeStampWithTimeZoneFormat(this.m_wrapper.getConnection());
    }

    public String getDateFormat() {
        return NLSUtils.getDateFormat(this.m_wrapper.getConnection());
    }

    public String getFormattedDATE(Object object) {
        return NLSUtils.format(this.m_wrapper.getConnection(), (DATE)object);
    }

    public Connection getConnection() {
        return this.m_wrapper.getConnection();
    }

    public String getLineTerminator() {
        if (this._EOLChars == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOLChars = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOLChars;
    }
}

