/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultsFormatterWrapper {
    private List<String> m_colNames;
    private int[] m_sizes;
    private transient boolean m_interrupted;
    protected IResultFormatter m_formatter;

    protected ResultsFormatterWrapper() {
    }

    void setParent(IResultFormatter iResultFormatter) {
        this.m_formatter = iResultFormatter;
    }

    protected void setColumnNames(List<String> list) {
        this.m_colNames = list;
    }

    protected void setColumnSizes(int[] nArray) {
        this.m_sizes = nArray;
    }

    public abstract Connection getConnection();

    public abstract int getDataType(int var1) throws SQLException;

    public abstract int print() throws IOException;

    public String getColumnName(int n) {
        try {
            return this.m_colNames.get(n);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getColumnSize(int n) {
        return this.m_sizes[n];
    }

    public int getColumnCount() {
        return this.m_colNames.size();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.m_colNames);
    }

    public void interrupt() {
        this.m_interrupted = true;
    }

    protected boolean isInterrupted() {
        return this.m_interrupted;
    }

    public Object getValue(Object object) {
        try {
            return DataTypesUtil.stringValue(object, this.getConnection());
        }
        catch (Exception exception) {
            return object;
        }
    }

    public abstract String getSQL();
}

