/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

public class TxtFormatter
extends ResultsFormatter {
    public TxtFormatter() {
        super("TEXT", Translate.translate("Text File"), "txt");
    }

    public void start() throws IOException {
        int n = this.getColumnCount();
        for (int i = 1; i < n; ++i) {
            String string = this.getColumnName(i);
            if (i > 0 && i < n - 1) {
                this.write("\"" + string + "\"\t");
                continue;
            }
            this.write("\"" + string + "\"");
        }
        this.write(this.getLineTerminator());
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        if (n == 0) {
            return;
        }
        if (object != null && n == 1) {
            string = "\"" + this.cleanString(this.getValue(object).toString()) + "\"";
        } else if (object == null && n == 1) {
            string = "\"\"";
        } else if (object != null && n > 1) {
            string = "\t\"" + this.cleanString(this.getValue(object).toString()) + "\"";
        } else if (object == null && n > 1) {
            string = "\t\"\"";
        }
        this.write(string);
    }

    public String cleanString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            string2 = string2 + c;
        }
        return string2;
    }

    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    public void end() throws IOException {
    }

    public void setTableName(String string) {
    }
}

