/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;

public class OraTIMESTAMPTZFormat
extends OraSimpleDateFormat {
    private static final int SIZE_TIMESTAMPTZ = 13;
    private static final int BYTE_YEAR1 = 0;
    private static final int BYTE_YEAR2 = 1;
    private static final int BYTE_MONTH = 2;
    private static final int BYTE_DAY = 3;
    private static final int BYTE_HOUR = 4;
    private static final int BYTE_MINUTE = 5;
    private static final int BYTE_SECOND = 6;
    private static final int BYTE_NANOS1 = 7;
    private static final int BYTE_NANOS2 = 8;
    private static final int BYTE_NANOS3 = 9;
    private static final int BYTE_NANOS4 = 10;
    private static final int BYTE_TIMEZONE1 = 11;
    private static final int BYTE_TIMEZONE2 = 12;
    private static final int REGIONIDBIT = 128;
    private static final byte OFFSET_HOUR = 20;
    private static final byte OFFSET_MINUTE = 60;
    private static final String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private TimeZone UTC = TimeZone.getTimeZone("UTC");
    private OraLocaleInfo localeInfo = null;

    public OraTIMESTAMPTZFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        super(string, oraLocaleInfo);
        this.localeInfo = oraLocaleInfo;
        this.applyPattern(string);
    }

    public void applyPattern(String string) throws ParseException {
        if (this.localeInfo != null) {
            int n;
            int n2;
            boolean bl = false;
            String string2 = string.toUpperCase(Locale.US);
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = -1;
            while ((n3 = string2.indexOf("X", n3 + 1)) >= 0) {
                if (n3 > 0 && string2.charAt(n3 - 1) == 'F') continue;
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                stringBuffer.setCharAt(n3, this.localeInfo.getOraTerritory().getDecimalCharacter().charAt(0));
            }
            n3 = -1;
            while ((n3 = string2.indexOf("SP", n3 + 1)) >= 0) {
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                stringBuffer.setCharAt(n3, '\uffff');
                stringBuffer.setCharAt(n3 + 1, '\uffff');
                bl = true;
            }
            n3 = -1;
            while ((n3 = string2.indexOf("TH", n3 + 1)) >= 0) {
                if (n3 > 2 && string2.substring(n3 - 3, n3 + 2).equals("MONTH")) continue;
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                stringBuffer.setCharAt(n3, '\uffff');
                stringBuffer.setCharAt(n3 + 1, '\uffff');
                bl = true;
            }
            super.applyPattern(bl ? stringBuffer.toString().replace("\uffff", "") : stringBuffer.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPTZFormat && super.equals(object);
    }

    public String format(TIMESTAMPTZ tIMESTAMPTZ) {
        return this.format(tIMESTAMPTZ, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMPTZ tIMESTAMPTZ, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        byte[] byArray = tIMESTAMPTZ.shareBytes();
        if (byArray.length != 13) {
            throw new IllegalArgumentException("TIMESTAMPTZ to be formatted is of wrong length");
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.clear();
        calendar.setTimeZone(this.UTC);
        int n = ((byArray[0] & 0xFF) - 100) * 100 + ((byArray[1] & 0xFF) - 100);
        calendar.set(1, n);
        calendar.set(2, byArray[2] - 1);
        calendar.set(5, byArray[3]);
        calendar.set(11, byArray[4] - 1);
        calendar.set(12, byArray[5] - 1);
        calendar.set(13, byArray[6] - 1);
        calendar.set(14, 0);
        String string = this.getTimeZoneID(byArray);
        int n2 = ((byArray[7] & 0xFF) << 24) + ((byArray[8] & 0xFF) << 16) + ((byArray[9] & 0xFF) << 8) + (byArray[10] & 0xFF);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n2);
        this.calendar.setTimeZone(string == null ? this.UTC : TimeZone.getTimeZone(string));
        StringBuffer stringBuffer2 = super.format((Date)timestamp, stringBuffer, fieldPosition);
        int n3 = stringBuffer2.indexOf("GMT");
        if (n3 >= 0 && stringBuffer2.length() - n3 >= 9 && (stringBuffer2.charAt(n3 + 3) == '+' || stringBuffer2.charAt(n3 + 3) == '-') && stringBuffer2.charAt(n3 + 4) >= '0' && stringBuffer2.charAt(n3 + 4) <= '9' && stringBuffer2.charAt(n3 + 5) >= '0' && stringBuffer2.charAt(n3 + 5) <= '9' && stringBuffer2.charAt(n3 + 6) == ':' && stringBuffer2.charAt(n3 + 7) >= '0' && stringBuffer2.charAt(n3 + 7) <= '9' && stringBuffer2.charAt(n3 + 8) >= '0' && stringBuffer2.charAt(n3 + 8) <= '9') {
            stringBuffer2.delete(n3, n3 + 3);
        }
        return stringBuffer2;
    }

    public TIMESTAMPTZ parseTIMESTAMPTZ(String string, ParsePosition parsePosition, TimeZone timeZone) {
        int n;
        byte[] byArray = new byte[13];
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(string, parsePosition);
        long l = date.getTime();
        int n2 = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
        Calendar calendar = Calendar.getInstance(this.UTC, Locale.US);
        calendar.setTimeInMillis(l);
        int n3 = calendar.get(1);
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = (byte)(n2 >> 24 & 0xFF);
        byArray[8] = (byte)(n2 >> 16 & 0xFF);
        byArray[9] = (byte)(n2 >> 8 & 0xFF);
        byArray[10] = (byte)(n2 & 0xFF);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if ((n = ZONEIDMAP.getID((String)timeZone.getID())) > 0) {
            byArray[11] = (byte)((n & 0x1FC0) >> 6 | 0x80);
            byArray[12] = (byte)((n & 0x3F) << 2);
        } else {
            int n4 = timeZone.getOffset(l) / 60000;
            byArray[11] = (byte)(n4 / 60 + 20);
            byArray[12] = (byte)(n4 % 60 + 60);
        }
        return new TIMESTAMPTZ(byArray);
    }

    private String getTimeZoneID(byte[] byArray) {
        boolean bl;
        if (byArray.length < 13) {
            return null;
        }
        if ((byArray[11] & 0x80) != 0) {
            int n = ((byArray[11] & 0x7F) << 6) + ((byArray[12] & 0xFC) >> 2);
            return ZONEIDMAP.getRegion((int)n);
        }
        int n = byArray[11] - 20;
        int n2 = byArray[12] - 60;
        boolean bl2 = bl = n < 0 || n2 < 0;
        if (bl) {
            n = -n;
            n2 = -n2;
        }
        return "GMT" + (bl ? "-" : "+") + digit[n / 10] + digit[n % 10] + ":" + digit[n2 / 10] + digit[n2 % 10];
    }
}

