/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryXMLSupport {
    private static Map<String, QueryXMLSupport> s_sql = new HashMap<String, QueryXMLSupport>();
    private Map<String, ObjectQueries> m_queryMap;

    public static QueryXMLSupport getQueryXMLSupport(String string) {
        URL uRL;
        QueryXMLSupport queryXMLSupport = s_sql.get(string);
        if (queryXMLSupport == null && (uRL = QueryXMLSupport.class.getResource(string)) != null) {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            try {
                dOMParser.parse(uRL.openStream());
                XMLDocument xMLDocument = dOMParser.getDocument();
                Node node = XMLHelper.getChildNode((Node)xMLDocument, "/source");
                if (node != null) {
                    HashMap<String, ObjectQueries> hashMap = new HashMap<String, ObjectQueries>();
                    for (XMLNode xMLNode : XMLHelper.getChildNodes(node, "queryType")) {
                        String string2 = XMLHelper.getAttributeNode((Node)xMLNode, "id");
                        ObjectQueries objectQueries = new ObjectQueries((XMLNode)XMLHelper.getChildNode((Node)xMLNode, "queries"));
                        hashMap.put(string2, objectQueries);
                    }
                    queryXMLSupport = new QueryXMLSupport(hashMap);
                    s_sql.put(string, queryXMLSupport);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(QueryXMLSupport.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return queryXMLSupport;
    }

    private QueryXMLSupport(Map<String, ObjectQueries> map) {
        this.m_queryMap = map;
    }

    public Query getQuery(String string, String string2) {
        ObjectQueries objectQueries = this.m_queryMap.get(string);
        return objectQueries != null ? objectQueries.getQuery(string2) : null;
    }

    public Query getQuery(String string, Connection connection) {
        ObjectQueries objectQueries = this.m_queryMap.get(string);
        return objectQueries != null ? objectQueries.getQuery(connection) : null;
    }
}

