/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.jdbc.OracleConnection;

public class SQL
extends SQLCommandRunner {
    public SQL(SQLCommand sQLCommand, BufferedOutputStream bufferedOutputStream) {
        super(sQLCommand, bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
        if (!this.lockConnection()) {
            return;
        }
        try {
            block26: {
                try {
                    Debug.debug(this.cmd);
                    if (this.cmd.getResultsType() == null) {
                        this.execute(true);
                        break block26;
                    }
                    if (this.cmd.getResultsType().equals("2")) {
                        this.reportDML(this.cmd.getStmtId(), this.processDML());
                        break block26;
                    }
                    if (this.cmd.getResultsType().equals("1")) {
                        this.executeQuery();
                        break block26;
                    }
                    if (this.cmd.getStmtId().equals("21")) {
                        this.conn.commit();
                        if (this.getScriptRunnerContext().getFeedback() != -2) {
                            this.report(Translate.translate("commited"));
                        }
                        break block26;
                    }
                    if (this.cmd.getStmtId().equals("68")) {
                        this.conn.rollback();
                        if (this.getScriptRunnerContext().getFeedback() != -2) {
                            this.report(Translate.translate("rolledback"));
                        }
                        break block26;
                    }
                    if (this.cmd.getResultsType().equals("3")) {
                        this.execute(false);
                        this.reportThreeWord();
                        break block26;
                    }
                    this.execute(true);
                }
                catch (SQLException sQLException) {
                    String[] stringArray;
                    int n;
                    if (scriptRunnerContext != null) {
                        scriptRunnerContext.putProperty("sqldev.error", Boolean.TRUE);
                    }
                    boolean bl = true;
                    StringBuffer stringBuffer = new StringBuffer();
                    if ((this.cmd.getResultsType() != null && this.cmd.getResultsType().equals("1") || this.cmd.getStmtId().equals("48") || this.cmd.getStmtId().equals("26") || this.cmd.getStmtId().equals("48") || this.cmd.getStmtId().equals("88") || this.cmd.getStmtId().equals("31") || this.cmd.getStmtId().equals("72") || this.cmd.getStmtId().equals("51") || this.cmd.getStmtId().equals("92")) && !this.cmd.getSQLOrig().toUpperCase().startsWith("DESC") && (n = DBUtil.getInstance().getErrorOffset(this.conn, this.cmd.getSql())) >= 0) {
                        stringArray = this.cmd.getSql().substring(0, n).split("\n");
                        int n2 = stringArray[stringArray.length - 1].length();
                        int n3 = stringArray.length;
                        Oerr oerr = new Oerr();
                        String string = sQLException.getMessage();
                        try {
                            string = string + oerr.oerr(string);
                        }
                        catch (OerrException oerrException) {
                            // empty catch block
                        }
                        Object[] objectArray = new Object[]{new Integer(this.cmd.startLine + 1), this.cmd.getSql(), new Integer(this.cmd.startLine + n3), new Integer(n2), ScriptRunnerDbArb.format(23, string)};
                        this.report(ScriptRunnerDbArb.format(42, objectArray));
                        if (scriptRunnerContext != null) {
                            scriptRunnerContext.putProperty("sqldev.last.err.message", ScriptRunnerDbArb.format(42, objectArray));
                        }
                        bl = false;
                    }
                    if (bl) {
                        String string = sQLException.getMessage();
                        if (this.conn instanceof OracleConnection) {
                            stringArray = new Oerr();
                            try {
                                string = string + stringArray.oerr(string);
                            }
                            catch (OerrException oerrException) {
                                // empty catch block
                            }
                        }
                        this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(23, string)));
                        if (scriptRunnerContext != null) {
                            scriptRunnerContext.putProperty("sqldev.last.err.message", ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(23, string)));
                        }
                    }
                    this.doWhenever(true);
                    Object var13_3 = null;
                    this.unlockConnection();
                    return;
                }
                catch (IOException iOException) {
                    if (scriptRunnerContext != null) {
                        scriptRunnerContext.putProperty("sqldev.error", Boolean.TRUE);
                    }
                    this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(15, iOException.getMessage())));
                    if (scriptRunnerContext != null) {
                        scriptRunnerContext.putProperty("sqldev.last.err.message", ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(15, iOException.getMessage())));
                    }
                    this.doWhenever(false);
                    Object var13_4 = null;
                    this.unlockConnection();
                    return;
                }
            }
            Object var13_2 = null;
            this.unlockConnection();
            return;
        }
        catch (Throwable throwable) {
            Object var13_5 = null;
            this.unlockConnection();
            throw throwable;
        }
    }

    public void reportDML(String string, int n) throws IOException {
        String string2 = null;
        if (this.getScriptRunnerContext().getFeedback() == -1 || this.getScriptRunnerContext().getFeedback() <= n) {
            if (string.equals("48")) {
                string2 = Translate.translate("inserted");
            } else if (string.equals("88")) {
                string2 = Translate.translate("updated");
            } else if (string.equals("31")) {
                string2 = Translate.translate("deleted");
            } else if (string.equals("51")) {
                string2 = Translate.translate("merged");
            }
            string2 = n + " " + Translate.translate("rows") + " " + string2;
            this.report(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processDML() throws SQLException {
        int n = 0;
        try {
            block6: {
                try {
                    this.stmt = this.conn.prepareStatement(this.cmd.getSql());
                    this.stmt.setEscapeProcessing(false);
                    if (this.cmd.getBinds() != null && this.cmd.getBinds().size() > 0) {
                        if (this.setBinds(this.stmt)) {
                            n = this.stmt.executeUpdate();
                        }
                        break block6;
                    }
                    n = this.stmt.executeUpdate();
                }
                catch (SQLException sQLException) {
                    if (this.stmt == null) throw sQLException;
                    this.stmt.close();
                    throw sQLException;
                }
            }
            Object var4_2 = null;
            if (this.stmt == null) return n;
            this.stmt.close();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.stmt == null) throw throwable;
            this.stmt.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery() throws SQLException, IOException {
        Exception exception3;
        block20: {
            ResultSet resultSet = null;
            boolean bl = true;
            try {
                this.stmt = this.conn.prepareStatement(this.cmd.getSql());
                this.stmt.setEscapeProcessing(false);
                if (DBUtil.getBinds(this.cmd.getSql(), true) != null && DBUtil.getBinds(this.cmd.getSql(), true).size() > 0 && !this.setBinds(this.stmt)) {
                    bl = false;
                }
                if (bl) {
                    resultSet = this.stmt.executeQuery();
                    ResultSetFormatter resultSetFormatter = new ResultSetFormatter();
                    int n = 0;
                    Properties properties = this.getConnectionInfo();
                    Integer n2 = (Integer)properties.get("PreferfedFetchSize");
                    if (n2 != null) {
                        resultSet.setFetchSize(n2);
                    }
                    if (this.getScriptRunnerContext().isOutputSupressed()) {
                        while (resultSet.next()) {
                            ++n;
                        }
                    } else {
                        List<String> list = FormatRegistry.getTypes();
                        boolean bl2 = false;
                        for (String string : list) {
                            if (this.cmd.getSql().indexOf("/*" + string + "*/") <= 0) continue;
                            IResultFormatter iResultFormatter = FormatRegistry.getFormatter(string);
                            iResultFormatter.setDataProvider(new ResultSetFormatterWrapper(resultSet));
                            iResultFormatter.setEncode("UTF8");
                            iResultFormatter.setOutputStream(this.out);
                            iResultFormatter.print();
                            bl2 = true;
                        }
                        if (!bl2) {
                            n = this.cmd.getSql().indexOf("/*html*/") > 0 ? resultSetFormatter.rset2html(resultSet, this.out) : (this.cmd.getSql().indexOf("/*csv*/") > 0 ? resultSetFormatter.rset2csv(resultSet, this.out) : (this.cmd.getSql().indexOf("/*xml*/") > 0 ? resultSetFormatter.rset2xml(resultSet, this.out) : resultSetFormatter.rset2sqlplus(resultSet, this.conn, this.out)));
                        }
                    }
                    int n3 = this.getScriptRunnerContext().getFeedback();
                    if (this.getScriptRunnerContext().getFeedback() == -1 || this.getScriptRunnerContext().getFeedback() <= n && this.getScriptRunnerContext().getFeedback() != -2) {
                        this.report("\n" + n + " " + Translate.translate("rows_selected") + "\n");
                    }
                }
                Object var13_13 = null;
                if (resultSet == null) break block20;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var13_14 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (Exception exception3) {}
        }
    }

    private String firstTwo(String string) {
        String string2 = "";
        String[] stringArray = string.trim().split("[ \t\n\r]");
        if (stringArray != null) {
            if (stringArray.length > 0) {
                string2 = stringArray[0];
            }
            if (stringArray.length > 1) {
                string2 = stringArray[1].equalsIgnoreCase("or") && stringArray[2].equalsIgnoreCase("replace") ? string2 + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3] : (stringArray.length > 2 && stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("database") && stringArray[2].equalsIgnoreCase("link") ? string2 + " " + stringArray[1] + " " + stringArray[2] : string2 + " " + stringArray[1]);
            }
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(boolean bl) throws SQLException, IOException {
        try {
            block11: {
                try {
                    SQLWarning sQLWarning;
                    this.st = this.conn.createStatement();
                    this.st.setEscapeProcessing(false);
                    boolean bl2 = this.st.execute(this.cmd.getSql().trim());
                    if (this.cmd.getSql().toLowerCase().indexOf(" set nls") > 0) {
                        NLSUtils.populateNLS(this.conn);
                    }
                    if ((sQLWarning = this.st.getWarnings()) == null && bl) {
                        if (this.getScriptRunnerContext().getFeedback() != -2) {
                            this.report(ScriptRunnerDbArb.format(24, this.firstTwo(this.cmd.getSql())));
                        }
                        break block11;
                    }
                    if (sQLWarning == null) break block11;
                    String string = ScriptRunnerDbArb.format(22, this.firstTwo(this.cmd.getSql()));
                    String string2 = sQLWarning.getMessage();
                    if (this.conn instanceof OracleConnection) {
                        Oerr oerr = new Oerr();
                        try {
                            string2 = string2 + oerr.oerr(string2);
                        }
                        catch (OerrException oerrException) {
                            // empty catch block
                        }
                    }
                    while (sQLWarning != null) {
                        string = string + "\n" + ScriptRunnerDbArb.format(12, string2);
                        sQLWarning = sQLWarning.getNextWarning();
                    }
                    this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), string));
                }
                catch (SQLException sQLException) {
                    if (this.st == null) throw sQLException;
                    this.st.close();
                    throw sQLException;
                }
            }
            Object var9_9 = null;
            if (this.st == null) return;
            this.st.close();
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.st == null) throw throwable;
            this.st.close();
            throw throwable;
        }
    }

    public void reportObjectAction() {
    }

    public void reportThreeWord() {
        String[] stringArray = null;
        stringArray = this.cmd.getSql().split("[ \n\r\t]");
        if (this.getScriptRunnerContext().getFeedback() != -2) {
            this.report(ScriptRunnerDbArb.format(24, stringArray[0] + " " + stringArray[1] + " " + stringArray[2]));
        }
    }
}

