/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;

public class ScriptParser {
    private static final Logger s_logger = Logger.getLogger(ScriptParser.class.getName());
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private Connection conn;
    private ArrayList sqlArray = new ArrayList();
    private String rawSQL;
    private BufferedReader reader = null;
    private int readerLineCnt = 0;
    private int startReaderLineCnt = 0;
    private int state = 0;
    private String quoteString = "";

    public ScriptParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public ScriptParser(Reader reader) {
        this(reader, null);
    }

    public ScriptParser(InputStream inputStream, Connection connection) {
        this(new InputStreamReader(inputStream), connection);
    }

    public ScriptParser(Reader reader, Connection connection) {
        this.scriptParserInit(reader, connection);
    }

    private void scriptParserInit(Reader reader, Connection connection) {
        this.conn = connection;
        this.reader = new BufferedReader(reader);
    }

    public ScriptParser(String string) {
        this(string, null);
    }

    public ScriptParser(String string, Connection connection) {
        this(new StringReader(string), connection);
        this.rawSQL = string;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        ScriptParser scriptParser = new ScriptParser(fileInputStream);
        scriptParser.parse();
    }

    public void parse() {
        StringBuffer stringBuffer = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray = null;
        String string6 = null;
        int n = 0;
        this.readerLineCnt = 0;
        this.startReaderLineCnt = 0;
        try {
            while (true) {
                Object object;
                int n2;
                int n3;
                int n4;
                this.state = 0;
                int n5 = 0;
                String string7 = "";
                this.startReaderLineCnt = this.readerLineCnt;
                n = 1;
                stringBuffer = new StringBuffer();
                string3 = null;
                if (string6 != null) {
                    string3 = string6;
                    string6 = null;
                }
                if ((string3 = this.getTop(string3)) == null) break;
                string = null;
                string2 = null;
                string4 = null;
                string5 = null;
                int n6 = SQLStatementTypes.stmts.length;
                for (n4 = 0; n4 < n6 && string == null; ++n4) {
                    if (string3.trim().indexOf(SQLStatementTypes.stmts[n4][0]) != 0 && (n4 != 0 || string3 != null && !string3.equals(""))) continue;
                    string = SQLStatementTypes.stmts[n4][1];
                    string2 = SQLStatementTypes.stmts[n4][2];
                    string4 = SQLStatementTypes.stmts[n4][3];
                    if (SQLStatementTypes.stmts[n4].length < 5) continue;
                    string5 = SQLStatementTypes.stmts[n4][4];
                }
                if (string == null) {
                    stringArray = string3.trim().split("[ \n\r\t]");
                    if (stringArray[0] != null && stringArray[0].length() > 0 && stringArray[0].charAt(stringArray[0].length() - 1) == ';') {
                        stringArray[0] = stringArray[0].replaceAll(";", "");
                    }
                    String string8 = stringArray[0].toLowerCase(Locale.ENGLISH);
                    n3 = SQLStatementTypes.tokenStmts.length;
                    for (n2 = 0; n2 < n3 && string == null; ++n2) {
                        String string9 = SQLStatementTypes.tokenStmts[n2][0];
                        if (!string8.equals(string9)) continue;
                        string = SQLStatementTypes.tokenStmts[n2][1];
                        string2 = SQLStatementTypes.tokenStmts[n2][2];
                        string4 = SQLStatementTypes.tokenStmts[n2][3];
                        if (SQLStatementTypes.tokenStmts[n2].length < 5) continue;
                        string5 = SQLStatementTypes.tokenStmts[n2][4];
                    }
                    if (string == null) {
                        string = "4";
                        string2 = "1";
                        string4 = "N";
                    }
                    String string10 = this.stripLine(string3);
                    if (string.equals("10")) {
                        if (this.checkCreateType(string10).equals("plsql")) {
                            string = "3";
                            string2 = "27";
                            string4 = "Y";
                        } else {
                            string = "2";
                            string2 = "26";
                            string4 = "Y";
                        }
                    } else if (string.equals("9")) {
                        if (this.checkSetType(string10).equals("sql")) {
                            string = "2";
                            string2 = "74";
                            string4 = "Y";
                        } else {
                            string = "4";
                            string2 = "73";
                            string4 = "N";
                        }
                    }
                }
                n4 = 1;
                n2 = 0;
                if (string.equals("2")) {
                    while (n4 != 0) {
                        n3 = -1;
                        if (string3 == null) {
                            n6 = 0;
                        } else {
                            object = this.numberOfQuotes(string3, true, true);
                            n6 = object[0];
                            n5 = object[1];
                            n3 = object[2];
                        }
                        if (n6 % 2 != 0) {
                            int n7 = n2 = n2 == 0 ? 1 : 0;
                        }
                        if (string3 != null && n2 == 0) {
                            if (n3 != -1) {
                                string6 = string3.length() != n3 + 1 ? string3.substring(n3 + 1) : null;
                                string3 = string3.substring(0, n3);
                                n4 = 0;
                            } else if (string3.trim().endsWith(";") && n5 == 0) {
                                n4 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf(";"));
                            } else if (string3.trim().endsWith("\n/") || string3.trim().equals("/")) {
                                n4 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("/"));
                            } else if (string3.trim().equals(".")) {
                                n4 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("."));
                            }
                            stringBuffer.append(string3 + "\n");
                            if (n4 != 0) {
                                string3 = this.reader.readLine();
                                ++n;
                                ++this.readerLineCnt;
                            }
                        } else {
                            stringBuffer.append(string3 + "\n");
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                        }
                        if (string3 != null) continue;
                        n4 = 0;
                    }
                } else if (string.equals("3")) {
                    while (n4 != 0) {
                        if (string3 == null) {
                            n6 = 0;
                        } else {
                            int[] nArray = this.numberOfQuotes(string3, false, false);
                            n6 = nArray[0];
                            n5 = nArray[1];
                        }
                        if (string3 != null && (n6 == 0 || n6 % 2 == 1)) {
                            if (string3.trim().endsWith("\n/") || string3.trim().equals("/")) {
                                n4 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("/"));
                            } else if (string3.trim().equals(".")) {
                                n4 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("."));
                            }
                        }
                        stringBuffer.append(string3 + "\n");
                        if (n4 != 0) {
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                        }
                        if (string3 != null) continue;
                        n4 = 0;
                    }
                } else if (string.equals("4")) {
                    while (n4 != 0) {
                        if (string3.trim().endsWith("-")) {
                            n4 = 1;
                            stringBuffer.append(string3 + "\n");
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                            if (string3 != null) continue;
                            n4 = 0;
                            continue;
                        }
                        n4 = 0;
                        stringBuffer.append(string3 + "\n");
                    }
                } else if (string.equals("5")) {
                    stringBuffer.append(string3 + "\n");
                } else if (!string.equals("6") && !string.equals("8")) {
                    if (string.equals("1")) {
                        s_logger.severe(ScriptRunnerDbArb.format(33, string3));
                    } else if (string.equals("7")) {
                        while (n4 != 0) {
                            n3 = string3.indexOf("*/");
                            if (n3 >= 0) {
                                n4 = 0;
                                if (n3 + 2 == string3.length()) {
                                    string6 = "";
                                } else {
                                    string6 = string3.substring(n3 + 2);
                                    string3 = string3.substring(0, n3 + 2);
                                }
                                stringBuffer.append(string3 + "\n");
                                continue;
                            }
                            stringBuffer.append(string3 + "\n");
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                            if (string3 != null) continue;
                            n4 = 0;
                            stringBuffer.append("*/");
                        }
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                while (stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || stringBuffer.charAt(stringBuffer.length() - 1) == '\r') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                String string11 = stringBuffer.toString();
                if (string5 != null && (string5.equals("1") || string5.equals("2")) && !this.isWrapped(stringBuffer.toString())) {
                    string11 = this.checkInLineComments(stringBuffer.toString());
                    string11 = this.checkforContinuationChars(string11);
                }
                object = new SQLCommand(string11);
                ((SQLCommand)object).setRunnable(string4);
                ((SQLCommand)object).setStmtClass(string);
                ((SQLCommand)object).setStmtId(string2);
                ((SQLCommand)object).setLines(n);
                ((SQLCommand)object).setResultsType(string5);
                ((SQLCommand)object).startLine = this.startReaderLineCnt;
                ((SQLCommand)object).endLine = this.readerLineCnt - 1;
                ((SQLCommand)object).setSQLOrig(stringBuffer.toString());
                this.sqlArray.add(object);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private boolean isWrapped(String string) {
        String string2 = string.toLowerCase();
        if (string2.indexOf("wrapped") == -1) {
            return false;
        }
        boolean bl = false;
        String string3 = this.checkInLineComments(string2);
        int n = string3.indexOf("wrapped");
        if (n > 2 && string3.length() > n + 8) {
            char c = string3.charAt(n - 1);
            char c2 = string3.charAt(n + 7);
            if (Character.isWhitespace(c) && Character.isWhitespace(c2)) {
                bl = true;
            }
        }
        return bl;
    }

    private String checkInLineComments(String string) {
        if (string.contains("-")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String string2 = "";
            if (stringTokenizer.hasMoreTokens()) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = "";
                    int n = 0;
                    int n2 = 0;
                    block1: while ((n2 = string3.indexOf("--", n)) != -1) {
                        boolean bl = false;
                        bl = n2 == 0 ? this.amIInitial(string2 + "", true) : this.amIInitial(string2 + string3.substring(0, n2), true);
                        if (bl) {
                            string4 = n2 == 0 ? "" : string3.substring(0, n2);
                            boolean bl2 = string3.replaceAll("\\s+$", "").endsWith("-");
                            while (bl2) {
                                String string5 = "";
                                if (!stringTokenizer.hasMoreTokens()) break block1;
                                string5 = stringTokenizer.nextToken();
                                string4 = string4 + " \n";
                                boolean bl3 = string5.replaceAll("\\s+$", "").endsWith("-");
                                if (bl3) continue;
                                break block1;
                            }
                            break;
                        }
                        n = n2 + 2;
                        if (n2 < string3.length()) continue;
                        string4 = string3;
                        break;
                    }
                    if (n2 == -1) {
                        string4 = string3;
                    }
                    string2 = string2 + string4 + " \n";
                }
            } else {
                string2 = string;
            }
            if (string2.length() > 2) {
                if (string2.endsWith("\r\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(13));
                } else if (string2.endsWith("\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(10));
                }
            }
            return string2;
        }
        return string;
    }

    private String checkforContinuationChars(String string) {
        if (string.contains("-")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String string2 = "";
            if (stringTokenizer.hasMoreTokens()) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = "";
                    if (string3.replaceAll("\\s+$", "").endsWith("-")) {
                        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string3);
                        boolean bl = false;
                        char c = stringCharacterIterator.last();
                        while (c != '\uffff') {
                            if (c == '-' && !bl) {
                                string4 = ' ' + string4;
                                bl = true;
                            } else {
                                string4 = c + string4;
                            }
                            c = stringCharacterIterator.previous();
                        }
                    } else {
                        string4 = string3;
                    }
                    string2 = string2 + string4 + " \n";
                }
            } else {
                string2 = string;
            }
            if (string2.length() > 2) {
                if (string2.endsWith("\r\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(13));
                } else if (string2.endsWith("\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(10));
                }
            }
            return string2;
        }
        return string;
    }

    public String stripLine(String string) {
        String string2 = string;
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replaceAll("\n", "");
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\t", "");
        string2 = string2.toLowerCase();
        return string2;
    }

    public String checkCreateType(String string) {
        String string2 = "sql";
        int n = SQLStatementTypes.sqlCreate.length;
        for (int i = 0; i < n; ++i) {
            if (string.indexOf(SQLStatementTypes.sqlCreate[i]) != 0) continue;
            string2 = "plsql";
        }
        return string2;
    }

    public String checkSetType(String string) {
        String string2 = "sqlplus";
        int n = SQLStatementTypes.setCmds.length;
        for (int i = 0; i < n && !string2.equals("sql"); ++i) {
            if (string.indexOf(SQLStatementTypes.setCmds[i]) != 0) continue;
            string2 = "sql";
        }
        return string2;
    }

    private String getTop(String string) {
        String string2 = null;
        try {
            if (string == null) {
                string2 = this.reader.readLine();
                ++this.readerLineCnt;
            } else {
                string2 = string;
            }
            if (string2 == null) {
                return null;
            }
            while (string2.trim().equals("")) {
                string2 = this.reader.readLine();
                ++this.readerLineCnt;
                if (string2 != null) continue;
                return null;
            }
            if (string2 != null) {
                string2 = string2.replaceAll("^\\s+", "");
            }
            this.startReaderLineCnt = this.readerLineCnt - 1;
            if (string2.trim().toLowerCase().startsWith("create") || string2.trim().toLowerCase().startsWith("drop") || string2.trim().toLowerCase().startsWith("alter")) {
                String string3 = "";
                while (string2.indexOf(";") == -1 && string2.indexOf("/") == -1 && string2.toLowerCase().indexOf("begin") == -1 && string3 != null) {
                    string3 = this.reader.readLine();
                    if (string3 != null) {
                        string2 = string2 + "\n" + string3;
                    }
                    ++this.readerLineCnt;
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return string2;
    }

    public String getRawSQL() {
        return this.rawSQL;
    }

    public void setRawSQL(String string) {
        this.rawSQL = string;
    }

    public SQLCommand[] getSqlStatements() {
        return this.sqlArray.toArray(new SQLCommand[this.sqlArray.size()]);
    }

    private boolean amIInitial(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        String string2 = "";
        while (true) {
            int n4;
            int n5;
            if (n3 == 0) {
                int n6;
                int n7 = 100000;
                n5 = 0;
                n4 = 1;
                for (n4 = 1; n4 < startAndEnd.length; ++n4) {
                    n6 = string.indexOf(startAndEnd[n4][0], n2);
                    if (n6 == -1 || n6 >= n7 || n4 == 5 && n6 + 2 == string.length()) continue;
                    n7 = n6;
                    n5 = n4;
                }
                n4 = 5;
                n6 = string.indexOf("Q'", n2);
                if (n6 != -1 && n6 < n7 && (n4 != 5 || n6 + 2 != string.length())) {
                    n7 = n6;
                    n5 = n4;
                }
                if (n5 == 5) {
                    string2 = string.substring(n7 + 2, n7 + 3);
                    string2 = this.getEndQuoteString(string2);
                }
                if (n5 == 5) {
                    ++n;
                    n3 = 5;
                    n2 = n7 + 3;
                    continue;
                }
                if (n5 == 4) {
                    ++n;
                    n3 = 4;
                    n2 = n7 + 1;
                    continue;
                }
                if (n5 == 0) {
                    int[] nArray = new int[]{n, 0};
                    return true;
                }
                n3 = n5;
                n2 = n7 + startAndEnd[n5][0].length();
                continue;
            }
            String string3 = startAndEnd[n3][1];
            if (n3 == 5) {
                string3 = string2 + string3;
            }
            n5 = string.indexOf(string3, n2);
            if (bl && this.state == 1) {
                while (n5 != -1 && (n4 = (int)(string.substring(n2, n5).replaceAll("\\s+$", "").endsWith("-") ? 1 : 0)) != 0) {
                    if (n5 + 1 <= string.length()) {
                        n5 = string.indexOf(string3, n5 + 1);
                        continue;
                    }
                    n5 = -1;
                }
            }
            if (n5 == -1) {
                return n3 == 0;
            }
            n2 = n5 + string3.length();
            if (n3 == 4 || n3 == 5) {
                ++n;
                string2 = "";
            }
            n3 = 0;
        }
    }

    private int[] numberOfQuotes(String string, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        while (true) {
            int n5;
            int n6;
            int n7;
            if (this.state == 0) {
                int n8 = 100000;
                n7 = 0;
                n6 = 1;
                for (n6 = 1; n6 < startAndEnd.length; ++n6) {
                    n5 = string.indexOf(startAndEnd[n6][0], n2);
                    if (n5 == -1 || n5 >= n8 || n6 == 5 && n5 + 2 == string.length()) continue;
                    n8 = n5;
                    n7 = n6;
                }
                n6 = 5;
                n5 = string.indexOf("Q'", n2);
                if (n5 != -1 && n5 < n8 && (n6 != 5 || n5 + 2 != string.length())) {
                    n8 = n5;
                    n7 = n6;
                }
                if (bl && (n5 = string.indexOf(";", n2)) != -1 && n5 < n8) {
                    n4 = n5;
                    int[] nArray = new int[]{n, 0, n4};
                    return nArray;
                }
                if (n7 == 5) {
                    this.quoteString = string.substring(n8 + 2, n8 + 3);
                    this.quoteString = this.getEndQuoteString(this.quoteString);
                }
                if (n7 == 5) {
                    ++n;
                    this.state = 5;
                    n2 = n8 + 3;
                    continue;
                }
                if (n7 == 4) {
                    ++n;
                    this.state = 4;
                    n2 = n8 + 1;
                    continue;
                }
                if (n7 == 0) {
                    int[] nArray = new int[]{n, 0, n4};
                    return nArray;
                }
                this.state = n7;
                n2 = n8 + startAndEnd[n7][0].length();
                continue;
            }
            String string2 = startAndEnd[this.state][1];
            if (this.state == 5) {
                string2 = this.quoteString + string2;
            }
            n7 = 0;
            n6 = string.indexOf(string2, n2);
            if (bl2 && this.state == 1 && n6 == -1 && string.replaceAll("\\s+$", "").endsWith("-")) {
                n7 = 1;
            }
            if (bl2 && this.state == 1) {
                while (n6 != -1 && (n5 = (int)(string.substring(n2, n6).replaceAll("\\s+$", "").endsWith("-") ? 1 : 0)) != 0) {
                    if (n6 + 1 <= string.length()) {
                        n6 = string.indexOf(string2, n6 + 1);
                        continue;
                    }
                    n7 = 1;
                    n6 = -1;
                }
            }
            if (n6 == -1) {
                if (this.state == 1) {
                    if (n7 == 0) {
                        this.state = 0;
                    }
                    if (string.trim().endsWith(";")) {
                        n3 = 1;
                    }
                } else if (this.state != 0 && string.trim().endsWith(";")) {
                    n3 = 1;
                }
                int[] nArray = new int[]{n, n3, n4};
                return nArray;
            }
            n2 = n6 + string2.length();
            if (this.state == 4 || this.state == 5) {
                ++n;
                this.quoteString = "";
            }
            this.state = 0;
        }
    }

    boolean isQuoteStringValid(String string) {
        boolean bl = true;
        if (string.equals("\t") || string.equals("\r") || string.equals("\n") || string.equals(" ")) {
            bl = false;
        }
        return bl;
    }

    String getEndQuoteString(String string) {
        String string2 = string;
        if (string2.equals("[")) {
            string2 = "]";
        } else if (string2.equals("{")) {
            string2 = "}";
        } else if (string2.equals("<")) {
            string2 = ">";
        } else if (string2.equals("(")) {
            string2 = ")";
        }
        return string2;
    }
}

