/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.editor.BasicEditorPane;

public class ScriptRunnerContext {
    public static final String TOTAL_CMD_COUNT = "total_cmd_count";
    public static final String CURRENT_CMD_COUNT = "current_cmd_count";
    public static final String OUT_STREAM = "output_stream";
    public static final int FEEDBACK_ON = -1;
    public static final int FEEDBACK_OFF = -2;
    public static final String LAST_ERR_TYPE = "sqldev.last.err.type";
    public static final String LAST_ERR_NAME = "sqldev.last.err.name";
    public static final String ERR_ENCOUNTERED = "sqldev.error";
    public static final String ERR_MESSAGE = "sqldev.last.err.message";
    public static final String BASE_URL = "script.runner.base.url";
    public static final String SYSTEM_OUT = "script.runner.using.systemout";
    public static final String DBCONFIG_GLOGIN = "DBConfig.GLOGIN";
    public static final String DBCONFIG_GLOGIN_FILE = "DBConfig.GLOGIN_FILE";
    public static final int VERIFY_OFF = -3;
    public static final int VERIFY_ON = -4;
    public static final int AUTOPRINT_OFF = -5;
    public static final int AUTOPRINT_ON = -6;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Connection baseConnection = null;
    private boolean closeConnection = false;
    private boolean topLevel = false;
    private Map map = null;
    private boolean exited = false;
    private boolean returnExited = false;
    private int osError = 0;
    private int sqlError = 0;
    private boolean escape = false;
    private char escapeChar = (char)92;
    private char substitutionChar = (char)38;
    private boolean substitutionOn = true;
    private boolean scanOn = true;
    private char terminateChar = (char)46;
    private URL _lastUrl = null;
    private HashMap _props = new HashMap();
    private boolean supressOutput = false;
    private int feedback = -1;
    private Object _outputComp;
    private BasicEditorPane _editor;
    private boolean _verify = false;
    private int _autoprint = -5;
    private Map varMap = null;
    private PrintWriter _errWriter;

    public ScriptRunnerContext() {
        this.reInitOnExit();
    }

    public void reInitOnExit() {
        this.closeConnection = false;
        this.topLevel = false;
        this.map = Collections.synchronizedMap(new HashMap());
        this.varMap = Collections.synchronizedMap(new HashMap());
        this.returnExited = this.exited;
        this.exited = false;
        this.osError = 0;
        this.sqlError = 0;
        this.escape = false;
        this.substitutionChar = (char)38;
        this.substitutionOn = true;
        this.scanOn = true;
        this._errWriter = null;
    }

    public void reInitNoExit() {
        this.closeConnection = false;
        this.topLevel = false;
        this._errWriter = null;
        this.exited = false;
    }

    public PrintWriter getErrWriter() {
        return this._errWriter;
    }

    public void setErrWriter(PrintWriter printWriter) {
        this._errWriter = printWriter;
    }

    public Connection getBaseConnection() {
        return this.baseConnection;
    }

    public void setBaseConnection(Connection connection) {
        this.baseConnection = connection;
    }

    public boolean getExited() {
        return this.exited;
    }

    public void setExited(boolean bl) {
        this.exited = bl;
    }

    public boolean getReturnExited() {
        return this.returnExited;
    }

    public void setReturnExited(boolean bl) {
        this.returnExited = bl;
    }

    public boolean getEscape() {
        return this.escape;
    }

    public void setEscape(boolean bl) {
        this.escape = bl;
    }

    public boolean getCloseConnection() {
        return this.closeConnection;
    }

    public void setCloseConnection(boolean bl) {
        this.closeConnection = bl;
    }

    public boolean getTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean bl) {
        this.topLevel = bl;
    }

    public int getOsError() {
        return this.osError;
    }

    public void setOsError(int n) {
        this.osError = n;
    }

    public int getSqlError() {
        return this.sqlError;
    }

    public void setSqlError(int n) {
        this.sqlError = n;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public char getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void setSubstitutionChar(char c) {
        this.substitutionChar = c;
    }

    public boolean getSubstitutionOn() {
        return this.substitutionOn;
    }

    public void setSubstitutionOn(boolean bl) {
        this.substitutionOn = bl;
    }

    public boolean getScanOn() {
        return this.scanOn;
    }

    public void setScanOn(boolean bl) {
        this.scanOn = bl;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c) {
        this.escapeChar = c;
    }

    public char getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(char c) {
        this.terminateChar = c;
    }

    public String getLastDirName() throws IOException {
        if (this._lastUrl == null) {
            throw new IOException("_lastUrl==null");
        }
        File file = new File(this._lastUrl.getFile());
        String string = file.getCanonicalPath();
        try {
            if (!file.isDirectory()) {
                if (string.indexOf(File.separator) == -1) {
                    throw new IOException("No directory in" + string);
                }
                string = string.substring(0, string.lastIndexOf(File.separator));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return string;
    }

    public URL getLastUrl() {
        return this._lastUrl;
    }

    public void setLastUrl(URL uRL) {
        this._lastUrl = uRL;
    }

    public void putProperty(String string, Object object) {
        this._props.put(string, object);
    }

    public Object getProperty(String string) {
        return this._props.get(string);
    }

    public BufferedOutputStream getOutputStream() {
        return (BufferedOutputStream)this._props.get(OUT_STREAM);
    }

    public void setOutputStream(BufferedOutputStream bufferedOutputStream) {
        this._props.put(OUT_STREAM, bufferedOutputStream);
    }

    public boolean isOutputSupressed() {
        return this.supressOutput;
    }

    public void setSupressOutput(boolean bl) {
        this.supressOutput = bl;
    }

    public void setFeedback(int n) {
        this.feedback = n;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public void setOutputComponenet(Object object) {
        this._outputComp = object;
    }

    public Object getOutputComponent() {
        return this._outputComp;
    }

    public void setEditorComponenet(BasicEditorPane basicEditorPane) {
        this._editor = basicEditorPane;
    }

    public BasicEditorPane getEditorComponenet() {
        return this._editor;
    }

    public void write(String string) {
        try {
            this.getOutputStream().write(string.getBytes());
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Could not write", iOException);
        }
    }

    public void setVerify(boolean bl) {
        this._verify = bl;
    }

    public boolean isVerifyOn() {
        return this._verify;
    }

    public Map getVarMap() {
        return this.varMap;
    }

    public int get_autoprint() {
        return this._autoprint;
    }

    public void set_autoprint(int n) {
        this._autoprint = n;
    }
}

