/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.templates;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.Ide;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeTemplateUtil {
    private static final char VARIABLE_ESCAPE_CHAR = '\\';
    private static final String VM_ARG_KEY = "raptor.user.codeTemplates";
    private static final String ROWS_NODE = "rows";
    private static final String ROW_NODE = "row";
    private static final String VALUE_NODE = "value";
    private static final String KEY_NODE = "key";
    private static final String TEMPLATE_FILE = Ide.getUserSettingsDirectory() + "CodeTemplate.xml";
    private static Map<String, String> _templateModel;
    private static String s_templateString;
    private static Pattern _tmpVariablePattern;

    public static void registerTemplate(String string) {
        s_templateString = string;
    }

    public static void insertTemplate(String string, BasicEditorPane basicEditorPane) {
        CodeTemplateUtil.registerTemplate(string);
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        int n = 0;
        int n2 = 0;
        String string2 = "";
        if (basicEditorPane.getSelectedText() != null) {
            n = basicEditorPane.getSelectionStart();
            n2 = basicEditorPane.getSelectionEnd();
            string2 = "#for#";
        } else {
            char c;
            n2 = basicEditorPane.getCaretPosition();
            for (n = n2 - 1; n >= 0 && (c = textBuffer.getChar(n)) != '(' && c != ' ' && c != '\n'; --n) {
            }
            string2 = textBuffer.getString(++n, n2 - n);
        }
        if (n2 == 0) {
            return;
        }
        String string3 = string2;
        if (CodeTemplateUtil.isVariable(string2)) {
            string3 = CodeTemplateUtil.computeVariable(basicEditorPane, string2);
        } else {
            String string4;
            string3 = CodeTemplateUtil.getTemplate(string2);
            StringBuffer stringBuffer = new StringBuffer(string3);
            Matcher matcher = _tmpVariablePattern.matcher(string3);
            int n3 = 0;
            while (matcher.find() && (n3 = stringBuffer.indexOf(string4 = matcher.group(), n3)) >= 0) {
                if (n3 > 0 && stringBuffer.charAt(n3 - 1) == '\\') {
                    stringBuffer.deleteCharAt(n3 - 1);
                    continue;
                }
                String string5 = CodeTemplateUtil.computeVariable(basicEditorPane, string4);
                if (string5 == null || string5.equals(string4)) continue;
                stringBuffer.replace(n3, n3 + string4.length(), string5);
                n3 += string5.length();
            }
            string3 = stringBuffer.toString();
        }
        if (string2 != null && !string2.equals(string3)) {
            textBuffer.remove(n, n2 - n);
            textBuffer.insert(n, string3.toCharArray());
            basicEditorPane.setCaretPosition(n + string3.length());
        }
    }

    private static String computeVariable(BasicEditorPane basicEditorPane, String string) {
        String string2 = string;
        try {
            TemplateVariableHandler templateVariableHandler = TemplateVariableHandler.getHandler(string);
            if (templateVariableHandler != null) {
                string2 = templateVariableHandler.computeVariable(basicEditorPane);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(CodeTemplateUtil.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string2;
    }

    private static boolean isVariable(String string) {
        String string2 = String.valueOf('#');
        if (string.startsWith(string2) && string.endsWith(string2)) {
            return TemplateVariableHandler.getHandler(string) != null;
        }
        return false;
    }

    public static String getTemplate(String string) {
        Map<String, String> map = CodeTemplateUtil.getModel();
        String string2 = map.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static Map<String, String> getModel() {
        if (_templateModel == null) {
            _templateModel = CodeTemplateUtil.loadFiles();
        }
        return _templateModel;
    }

    private static Map<String, String> loadFile(File file) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName(ROW_NODE);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals(ROW_NODE)) continue;
                Node node2 = XMLHelper.getChildNode(node, KEY_NODE);
                Node node3 = XMLHelper.getChildNode(node, VALUE_NODE);
                linkedHashMap.put(node2.getTextContent(), node3.getTextContent());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(CodeTemplateUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return linkedHashMap;
    }

    public static Map<String, String> loadFiles() {
        File file = new File(TEMPLATE_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Logger.getLogger(CodeTemplateUtil.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                return new HashMap<String, String>();
            }
        }
        Map<String, String> map = CodeTemplateUtil.loadFile(new File(TEMPLATE_FILE));
        if (System.getProperty(VM_ARG_KEY) != null) {
            char c = ':';
            if (System.getProperty("os.name").startsWith("Windows")) {
                c = ';';
            }
            String[] stringArray = System.getProperty(VM_ARG_KEY).split("[" + c + "]");
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(stringArray[i]);
                if (!file2.exists()) continue;
                map.putAll(CodeTemplateUtil.loadFile(file2));
            }
        }
        return map;
    }

    public static void save(TableModel tableModel) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            Object object2;
            Object object3;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, null, null);
            Element element = document.createElement(ROWS_NODE);
            document.appendChild(element);
            Map<String, String> map = CodeTemplateUtil.getModel();
            map.clear();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                object3 = (String)tableModel.getValueAt(i, 0);
                object2 = (String)tableModel.getValueAt(i, 1);
                if (object3 == null || ((String)object3).trim().length() == 0) continue;
                map.put((String)object3, (String)object2);
                object = document.createElement(ROW_NODE);
                Element element2 = document.createElement(KEY_NODE);
                element2.setTextContent((String)object3);
                object.appendChild(element2);
                Element element3 = document.createElement(VALUE_NODE);
                element3.setTextContent((String)object2);
                object.appendChild(element3);
                element.appendChild((Node)object);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            object3 = new BufferedWriter(new FileWriter(TEMPLATE_FILE));
            object2 = new StreamResult((Writer)object3);
            object = new DOMSource(document);
            transformer.transform((Source)object, (Result)object2);
            ((BufferedWriter)object3).flush();
            ((BufferedWriter)object3).close();
        }
        catch (Exception exception) {
            Logger.getLogger(CodeTemplateUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    static {
        _tmpVariablePattern = Pattern.compile("#[^#]+#");
    }
}

