/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.awt.Window;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.SwingUtils;

public class ExceptionHandler {
    private static Exception hitException = null;
    private static String title = DialogResources.getString(4);

    public static Exception wasException() {
        return hitException;
    }

    public static void reset() {
        hitException = null;
    }

    public static void handleException(final Exception exception) {
        hitException = exception;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (exception instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(SwingUtils.getMainWindow(), title, (SQLException)exception);
                } else {
                    if (exception instanceof ConnectionCanceledException) {
                        return;
                    }
                    ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
                }
            }
        });
    }

    public static void handleException(Exception exception, String string, int n) {
        hitException = exception;
        if (exception instanceof SQLException) {
            SQLErrorDialog.showErrorDialog(SwingUtils.getMainWindow(), title, (SQLException)exception, string, n);
        } else {
            ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
        }
    }

    public static void handleException(Exception exception, String string, int n, int n2, int n3) {
        hitException = exception;
        if (exception instanceof SQLException) {
            SQLErrorDialog.showErrorDialog(SwingUtils.getMainWindow(), title, (SQLException)exception, string, n, n2, n3);
        } else {
            ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
        }
    }

    public static boolean handleExceptionWithAction(Exception exception, String string, String string2, String string3) {
        hitException = exception;
        if (string3 == null || string3.length() <= 0) {
            string3 = "Cancel";
        }
        if (string2 == null || string2.length() <= 0) {
            string2 = "OK";
        }
        return SQLErrorDialog.showErrorWithActionsDialog((Component)Ide.getMainWindow(), string, (SQLException)exception, "Reconnect", "Cancel");
    }

    public static void handleException(Exception exception, String string, String string2, int n, int n2, int n3) {
        hitException = exception;
        if (!SQLExceptionListenerRegistry.listenForError(string, string2, exception)) {
            if (string2 != null && string2.length() > 0) {
                ExceptionHandler.handleException(exception, string2, n, n2, n3);
            } else {
                ExceptionHandler.handleException(exception);
            }
        }
    }

    public static void handleException(SQLException sQLException, String string, String string2, int n) {
        if (!SQLExceptionListenerRegistry.listenForError(string, string2, sQLException)) {
            if (string2 != null && string2.length() > 0) {
                ExceptionHandler.handleException(sQLException, string2, n);
            } else {
                ExceptionHandler.handleException(sQLException);
            }
        }
    }

    public static void handleException(Exception exception, String string) {
        if (exception instanceof SQLException) {
            ExceptionHandler.handleException((SQLException)exception, string, null, 0);
        } else {
            ExceptionHandler.handleException(exception);
        }
    }

    public static void handleException(Exception exception, String string, boolean bl, boolean bl2) {
        if (!bl) {
            ExceptionHandler.handleException(exception, string);
        } else {
            SQLExceptionListenerRegistry.listenForError(string, null, exception);
            if (bl2) {
                Logger.getLogger("").log(Level.SEVERE, exception.getMessage());
            }
        }
    }
}

