/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.javatools.util.EnvironmentVariables;
import oracle.javatools.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPHelper {
    private static final String NETWORK_ADMIN_PATH = File.separator + "network" + File.separator + "admin";
    private static FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.equalsIgnoreCase(".ldap") || string.toLowerCase().startsWith("ldap.");
        }
    };
    private static final String LDAP_DB_FILTER = "(&(|(objectClass=orclNetService)(objectClass=orclService)(objectClass=orclDBServer))(objectClass=*))";
    private static final String LDAP_CONTEXT_FILTER = "(objectClass=orclContext)";
    private static Map<String, TCPTNSEntry> dbServices = null;
    private static Map<String, String> context = null;

    public static ArrayList<String> getOrclServiceEntries(String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.authentication", "simple");
            String string3 = LDAPHelper.stripLdapHost(string);
            String string4 = LDAPHelper.stripLdapPort(string);
            String string5 = new String("ldap://" + string3 + ":" + string4);
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", string5);
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String[] stringArray = new String[]{"cn", "orclsid", "orcldbglobalname", "orclnetdescstring"};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string2, LDAP_DB_FILTER, searchControls);
            if (namingEnumeration != null) {
                dbServices = new HashMap<String, TCPTNSEntry>();
                while (namingEnumeration.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                    Attribute attribute = searchResult.getAttributes().get("cn");
                    Attribute attribute2 = searchResult.getAttributes().get("orclnetdescstring");
                    TCPTNSEntry tCPTNSEntry = new TCPTNSEntry(attribute.get().toString(), attribute2.get().toString());
                    dbServices.put(attribute.get().toString(), tCPTNSEntry);
                    arrayList.add(attribute.get().toString());
                }
            }
        }
        catch (NamingException namingException) {
            throw new Exception(namingException.getMessage());
        }
        return arrayList;
    }

    public static ArrayList<String> getLDAPContexts(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.authentication", "simple");
            String string2 = LDAPHelper.stripLdapHost(string);
            String string3 = LDAPHelper.stripLdapPort(string);
            String string4 = new String("ldap://" + string2 + ":" + string3);
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", string4);
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String[] stringArray = new String[]{"cn", "DN"};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(initialDirContext.getNameInNamespace(), LDAP_CONTEXT_FILTER, searchControls);
            if (namingEnumeration != null) {
                while (namingEnumeration.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                    Attribute attribute = searchResult.getAttributes().get("cn");
                    String string5 = searchResult.getNameInNamespace();
                    if (string5 == null) continue;
                    arrayList.add(string5);
                }
            }
        }
        catch (NamingException namingException) {
            throw new Exception(namingException.getMessage());
        }
        return arrayList;
    }

    public static ArrayList<String> getLDAPServers() {
        ArrayList<String> arrayList = null;
        try {
            File file = LDAPHelper.getLDAPFile();
            if (file != null) {
                arrayList = LDAPHelper.getLDAPServerEntries(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private static File getLDAPFile() {
        boolean bl;
        String string = EnvironmentVariables.getVariable((String)"ORACLE_HOME");
        String string2 = System.getProperty("jdbc.driver.home");
        String string3 = System.getProperty("user.home");
        String string4 = null;
        if (LDAPHelper.checkForLDAP(string3)) {
            string4 = string3;
        }
        if (!(bl = PlatformUtils.isWindows()) && string4 == null && LDAPHelper.checkForLDAP("/etc")) {
            string4 = "/etc";
        }
        if (string2 != null && string4 == null && LDAPHelper.checkForLDAP(string2 + NETWORK_ADMIN_PATH)) {
            string4 = string2 + NETWORK_ADMIN_PATH;
        }
        if (string != null && string4 == null && LDAPHelper.checkForLDAP(string + NETWORK_ADMIN_PATH)) {
            string4 = string + NETWORK_ADMIN_PATH;
        }
        if (string4 == null && bl) {
            string = null;
            try {
                RegistryKey registryKey;
                String string5 = "SOFTWARE\\ORACLE";
                String string6 = null;
                NativeHandler nativeHandler = new NativeHandler();
                nativeHandler.initialize();
                RegistryKey registryKey2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(string5, 131097L);
                Iterator iterator = registryKey2.iterateSubKeys();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    e.toString();
                    try {
                        String string7 = string5 + "\\" + e.toString();
                        registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string7, 131097L);
                        string6 = registryKey.getStringValue("ORACLE_HOME_KEY");
                    }
                    catch (RegistryException registryException) {}
                }
                if (string6 != null) {
                    registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string6, 131097L);
                    string = registryKey.getStringValue("ORACLE_HOME");
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                Logger.getLogger(LDAPHelper.class.getClass().getName()).log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
            if (string != null) {
                string4 = string + NETWORK_ADMIN_PATH;
            }
        }
        return new File(string4);
    }

    private static ArrayList<String> getLDAPServerEntries(File file) {
        ArrayList<String> arrayList;
        block7: {
            block6: {
                arrayList = new ArrayList<String>();
                if (file == null || !file.exists() || !file.isDirectory()) break block6;
                for (File file2 : file.listFiles(filter)) {
                    arrayList.addAll(LDAPHelper.getLDAPServerEntries(file2));
                }
                break block7;
            }
            if (file == null || !file.exists()) break block7;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("DIRECTORY_SERVERS")) continue;
                    string = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static boolean checkForLDAP(String string) {
        boolean bl = false;
        File file = new File(string);
        Object var3_3 = null;
        if (file.exists() && file.listFiles(filter).length > 0) {
            bl = true;
        }
        return bl;
    }

    public static TCPTNSEntry getEntry(String string) {
        return dbServices.get(string);
    }

    public static String stripLdapHost(String string) {
        String string2 = string.substring(0, string.indexOf(":"));
        return string2;
    }

    public static String stripLdapPort(String string) {
        String string2 = string.substring(string.indexOf(":") + 1);
        String string3 = string2.substring(0, string2.indexOf(":"));
        return string3;
    }
}

