/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java;

import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.LocatorWrapper;

public class JavaModel
implements JavaFileProvider {
    protected CachedFileProvider _fileProvider;
    protected JavaClassLocator _classLocator;
    protected CacheSupport _cacheSupport;

    public static JavaModel getInstance(URLPath sourcepath, URLPath classpath) {
        JavaModelFactory factory = JavaModelFactory.getInstance();
        return factory.newInstance(sourcepath, classpath);
    }

    protected JavaModel(CachedFileProvider provider) {
        this._fileProvider = provider;
    }

    protected void finalize() {
        this._fileProvider.beginCacheUse();
        this._fileProvider.endCacheUse();
    }

    public ClassLoader getClassLoader(ClassLoader parentLoader) {
        return this._fileProvider.getClassLoader(parentLoader);
    }

    public ClassLoader getClassLoader() {
        return this._fileProvider.getClassLoader();
    }

    public JavaClassLocator getJavaClassLocator() {
        if (this._classLocator == null) {
            this._classLocator = new LocatorWrapper(this._fileProvider);
        }
        return this._classLocator;
    }

    public CacheSupport getCacheSupport() {
        if (this._cacheSupport == null) {
            this._cacheSupport = new CacheTracker();
        }
        return this._cacheSupport;
    }

    public JavaFile getFile(URL url) {
        return this._fileProvider.getFile(url);
    }

    public SourceFile getSourceFile(URL sourceURL) {
        try {
            SourceFile sourceFile = this._fileProvider.getSourceFile(sourceURL);
            return sourceFile;
        }
        catch (IllegalArgumentException e) {
            SourceFile sourceFile = null;
            return sourceFile;
        }
    }

    public SourceFile createSourceFile(URL sourceURL) throws IOException, IllegalArgumentException {
        return this._fileProvider.createSourceFile(sourceURL);
    }

    public SourceFile getSourceFile(TextBuffer textBuffer) {
        return this._fileProvider.getSourceFile(textBuffer);
    }

    public JavaClass getClass(String fqName) {
        return this._fileProvider.getClass(fqName);
    }

    public JavaClass getClass(String fqPrefix, String name) {
        return this._fileProvider.getClass(fqPrefix, name);
    }

    public JavaClass getClassByVMName(String fqVMName) {
        return this._fileProvider.getClassByVMName(fqVMName);
    }

    public SourceClass getSourceClass(String fqName) {
        return this._fileProvider.getSourceClass(fqName);
    }

    public JavaType getArrayType(JavaType javaType, int dimensions) {
        return this._fileProvider.getArrayType(javaType, dimensions);
    }

    public JavaPackage getPackage(String fqName) {
        return this._fileProvider.getPackage(fqName);
    }

    public TextBuffer getTextBuffer(URL url) {
        return this._fileProvider.getTextBuffer(url);
    }

    protected class CacheTracker
    implements CacheSupport {
        private int refCount;
        private RuntimeException createdLocation;

        private void $init$() {
            this.refCount = 0;
            this.createdLocation = new RuntimeException("Wrapper creation location");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginCacheUse() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                ++this.refCount;
                JavaModel.this._fileProvider.beginCacheUse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                if (this.refCount > 0) {
                    Assert.println((String)"Warning, cache use not ended");
                    Assert.printStackTrace((Throwable)this.createdLocation);
                }
                while (this.refCount-- > 0) {
                    JavaModel.this._fileProvider.endCacheUse();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCacheUse() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                if (this.refCount > 0) {
                    --this.refCount;
                    JavaModel.this._fileProvider.endCacheUse();
                } else {
                    Assert.println((String)"Warning, negative cache ref count");
                    Assert.printStackTrace((Throwable)this.createdLocation);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                JavaModel.this._fileProvider.flushCache();
            }
        }

        protected CacheTracker() {
            this.$init$();
        }
    }
}

