/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayClassLocator
extends BaseClassLocator {
    private BaseClassLocator[] _locators;

    public ArrayClassLocator(BaseClassLocator[] locators) {
        this._locators = locators;
    }

    @Override
    public void buildIndex() {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            this._locators[i].buildIndex();
            ++i;
        }
    }

    @Override
    protected void getPackages(String packagePrefix, Collection out) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            locator.getPackages(packagePrefix, out);
            ++i;
        }
    }

    @Override
    protected void getClassesInPackage(String packagePrefix, Collection out) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            locator.getClassesInPackage(packagePrefix, out);
            ++i;
        }
    }

    @Override
    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            locator.getAllClasses(out, filter);
            ++i;
        }
    }

    @Override
    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            locator.getAllPackages(out, filter);
            ++i;
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            URL url = locator.getURL(fqClassName);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            URL url = locator.getSourceURL(fqClassName);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            URL url = locator.getClassURL(fqClassName);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            URL url = locator.getResourceURL(resourceName);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Collection<URL> getResourceURLs(String resourceName) {
        LinkedList<URL> urls = new LinkedList<URL>();
        int count = this._locators.length;
        int i = 0;
        while (i < count) {
            BaseClassLocator locator = this._locators[i];
            urls.addAll(locator.getResourceURLs(resourceName));
            ++i;
        }
        return urls;
    }
}

