/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.filter.SimpleNameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassLocator
implements JavaClassLocator,
JavaResourceLocator {
    public static final BaseClassLocator EMPTY_LOCATOR = new NOPClassLocator(null);
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Collection EMPTY_COLLECTION = Arrays.asList(EMPTY_STRING_ARRAY);
    private static SimpleCache _splitNameCache = new SimpleCache(25, null);

    @Override
    public Collection<URL> getResourceURLs(String resourceName) {
        URL url = this.getResourceURL(resourceName);
        if (url == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> ret = new ArrayList<URL>(1);
        ret.add(url);
        return ret;
    }

    @Override
    public Collection getPackages(String packagePrefix) {
        ArraySortedSet packageSet = new ArraySortedSet(20);
        this.getPackages(packagePrefix, (Collection)packageSet);
        return packageSet;
    }

    protected abstract void getPackages(String var1, Collection var2);

    @Override
    public Collection getClassesInPackage(String packagePrefix) {
        ArraySortedSet classSet = new ArraySortedSet(100);
        this.getClassesInPackage(packagePrefix, (Collection)classSet);
        return classSet;
    }

    protected abstract void getClassesInPackage(String var1, Collection var2);

    @Override
    public Collection getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public Collection getAllClasses(ClassNameFilter filter) {
        HashSet hashSet = new HashSet(10000);
        this.getAllClasses(hashSet, filter);
        return hashSet;
    }

    protected abstract void getAllClasses(Collection var1, ClassNameFilter var2);

    @Override
    public Collection getAllPackages() {
        return this.getAllPackages(null);
    }

    @Override
    public Collection getAllPackages(PackageNameFilter filter) {
        ArraySortedSet packageSet = new ArraySortedSet(200);
        this.getAllPackages((Collection)packageSet, filter);
        return packageSet;
    }

    protected abstract void getAllPackages(Collection var1, PackageNameFilter var2);

    @Override
    public Collection getClassesByName(String name, boolean matchCase) {
        SimpleNameFilter wholeNameFilter = new SimpleNameFilter(name, matchCase, 1);
        return this.getAllClasses(wholeNameFilter);
    }

    @Override
    public Collection getClassesByPrefix(String prefix, boolean matchCase) {
        SimpleNameFilter prefixFilter = new SimpleNameFilter(prefix, matchCase, 2);
        return this.getAllClasses(prefixFilter);
    }

    protected static BaseClassLocator ensureValid(BaseClassLocator locator) {
        if (locator != null) {
            return locator;
        }
        return EMPTY_LOCATOR;
    }

    public static void addToCollection(Object[] array, Collection collection) {
        collection.addAll(Arrays.asList(array));
    }

    public static String[] getStringArray(Collection collection) {
        int size = collection == null ? 0 : collection.size();
        String[] results = size == 0 ? EMPTY_STRING_ARRAY : collection.toArray(new String[size]);
        return results;
    }

    public static String buildFQName(String packagePrefix, String className) {
        String fullName = packagePrefix.length() > 0 ? packagePrefix + "." + className : className;
        return fullName;
    }

    protected static String[] getNameParts(String fqName) {
        SplitName splitName = BaseClassLocator.getSplitName(fqName);
        return SplitName.ra$_nameParts(splitName);
    }

    protected static String[] getNameCascades(String fqName) {
        SplitName splitName = BaseClassLocator.getSplitName(fqName);
        return SplitName.ra$_nameCascades(splitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SplitName getSplitName(String fqName) {
        SimpleCache simpleCache = _splitNameCache;
        synchronized (simpleCache) {
            SplitName splitName = (SplitName)SimpleCache.mav$get(_splitNameCache, fqName);
            if (splitName == null) {
                splitName = new SplitName(fqName, null);
                SimpleCache.mav$put(_splitNameCache, fqName, splitName);
            }
            SplitName splitName2 = splitName;
            return splitName2;
        }
    }

    private static class SimpleCache {
        private int _maxSize;
        private ArrayList _entryList;
        private HashMap _entryMap;

        private SimpleCache(int maxSize) {
            this._maxSize = maxSize;
            this._entryList = new ArrayList(maxSize + 1);
            this._entryMap = new HashMap(maxSize + 1);
        }

        private Object get(String key) {
            return this._entryMap.get(key);
        }

        private void put(String key, Object value) {
            this._entryMap.put(key, value);
            this._entryList.add(key);
            if (this._entryList.size() > this._maxSize) {
                String oldestKey = (String)this._entryList.remove(0);
                this._entryMap.remove(oldestKey);
            }
        }

        SimpleCache(int n, 1 var2_2) {
            this(n);
        }

        static Object mav$get(SimpleCache simpleCache, String string) {
            return simpleCache.get(string);
        }

        static void mav$put(SimpleCache simpleCache, String string, Object object) {
            simpleCache.put(string, object);
        }

        public final class 1 {
        }
    }

    private static class SplitName {
        private String[] _nameParts;
        private String[] _nameCascades;

        private SplitName(String fqName) {
            int numDots = 0;
            int nameLength = fqName.length();
            int i = 0;
            while (i < nameLength) {
                if (fqName.charAt(i) == '.') {
                    ++numDots;
                }
                ++i;
            }
            this._nameParts = new String[numDots + 1];
            this._nameCascades = new String[numDots + 1];
            this._nameCascades[numDots] = fqName;
            int i2 = numDots - 1;
            while (i2 >= 0) {
                String longerCascade = this._nameCascades[i2 + 1];
                int lastDot = longerCascade.lastIndexOf(46);
                this._nameCascades[i2] = longerCascade.substring(0, lastDot);
                --i2;
            }
            int i3 = 0;
            while (i3 <= numDots) {
                String cascade = this._nameCascades[i3];
                int lastDot = cascade.lastIndexOf(46);
                this._nameParts[i3] = lastDot == -1 ? cascade : cascade.substring(lastDot + 1);
                ++i3;
            }
        }

        SplitName(String string, 1 var2_2) {
            this(string);
        }

        static String[] ra$_nameCascades(SplitName splitName) {
            return splitName._nameCascades;
        }

        static String[] ra$_nameParts(SplitName splitName) {
            return splitName._nameParts;
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NOPClassLocator
    extends BaseClassLocator {
        @Override
        public void buildIndex() {
        }

        @Override
        protected void getPackages(String packagePrefix, Collection out) {
        }

        @Override
        protected void getClassesInPackage(String packagePrefix, Collection out) {
        }

        @Override
        protected void getAllClasses(Collection out, ClassNameFilter filter) {
        }

        @Override
        protected void getAllPackages(Collection out, PackageNameFilter filter) {
        }

        @Override
        public URL getURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getSourceURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getClassURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getResourceURL(String resourceName) {
            return null;
        }

        @Override
        public Collection<URL> getResourceURLs(String resourceName) {
            return Collections.emptyList();
        }

        private NOPClassLocator() {
        }

        NOPClassLocator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

